/*      error.h -- handles assertions (faults) in code
	This file is part of Paperboy, an offline mail/newsreader for Windows
	Copyright (C) 1994  Michael H. Vartanian
		vart@clark.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#ifndef HERROR
#define HERROR

#ifdef NDEBUG
#undef assert
#define assert(EX) ((void)0)
#else
extern void logassert(const char *, const char *,const int);
#define assert(EX) (void)((EX) || (logassert(#EX, __FILE__, __LINE__), 0))
#endif  /* DEBUG */

#define LOGFILE "\\PBFAULT.LOG"

#endif
