/*      post.c -- mechanisms for posting mail/news
	This file is part of Paperboy, an offline mail/newsreader for Windows
	Copyright (C) 1994  Michael H. Vartanian
		vart@clark.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
#include <stdio.h>
#include <string.h>
#include <time.h>
#include <stdlib.h>
#include <ctype.h>
/*
#include <direct.h>
*/
#include <sys\types.h>
#include <sys\timeb.h>
#include "soup.h"
#include "error.h"
#include "areas.h"
#include "msgs.h"

static char datebuf[128];

char *  DLLFUNC UnixDate (void)
{
    time_t ltime;
    struct tm *gmt;

    /* Get UNIX-style time and display as number and string. */
    time( &ltime );
    
    gmt = gmtime( &ltime );
    
    
    /* strftime (datebuf, 128, "%a, %d %b %y %H:%M:%D GMT", gmt); */
    
    return datebuf;
}

int DLLFUNC SaveMsgToFolder (char * fname)
{
	FILE * fout;
	unsigned long startlength, startpos, endpos, length;
	int n,result;
	unsigned char c;

	assert(fname!=NULL);

	fout=fopen(fname,"ab"); /* Append to file */
	if (fout==NULL) return ERRIO;
	result=fseek(fout,0,SEEK_END);  /* Goto EOF, just to be sure */
	if (result) return ERRIO;

	startlength=ftell(fout);
	fputc(0xFA,fout);       /* Write dummy length */
	fputc(0xCE,fout);
	fputc(0xDE,fout);
	fputc(0xAD,fout);

	startpos=ftell(fout);
	for (n=1; n<=GetNumLines(); n++)
	{
		fprintf(fout,"%s",GetLine(n));
		fputc(LFCHAR,fout);     /* Add LF */
	}
	result=fseek(fout,0,SEEK_END);  /* Goto EOF, just to be sure */
	if (result) return ERRIO;
	endpos=ftell(fout);
	result=fclose(fout);
	if (result) return ERRIO;

	length=endpos-startpos; /* Calculate length of message */
	
	/* Write new length */
	assert(length>0);
	fout=fopen(fname,"r+b");        /* Random access mode */
	if (fout==NULL) return ERRIO;

	result=fseek(fout,0,SEEK_SET);  /* rewind */
	if (result) return ERRIO;
	
	result=fseek(fout,startlength,SEEK_SET);
	if (result) return ERRIO;
	
	c=(unsigned char)(length >> 24);
	fputc(c,fout);
	c=(unsigned char)(length >> 16);
	fputc(c,fout);
	c=(unsigned char)(length >> 8);
	fputc(c,fout);
	c=(unsigned char)(length >> 0);
	fputc(c,fout);
	result=fclose(fout);
	if (result==EOF) return ERRIO;
	return 0;
}

int DLLFUNC Post (char * fname,  int type)
/* fname should be FNAME.MSG */
{
	FILE * fin, * fout;
	int result;
	unsigned long length;
	unsigned long startpos;
	unsigned char c;
	char basefilename[_MAX_FNAME];
	
	/* Rename fname to TMPFILE, recopy onto fname sans CR */

	assert (fname!=NULL);
	assert (type==POSTMAIL || type==POSTNEWS);

	result=rename(fname,TMPFILE);
	if (result!=0) return ERRIO;

	fin=fopen(TMPFILE,"rb");
	if (fin==NULL) return ERRIO;

	fout=fopen(fname,"wb"); 
	if (fout==NULL) return ERRIO;

	fseek(fout,0,SEEK_END); /* Go to EOF and remember position */
	startpos=ftell(fout);

	fputc(00,fout); /* Temporary write 0x00000000 as length */
	fputc(00,fout);
	fputc(00,fout);
	fputc(00,fout);

	/* Put in decorative headers */
	if (type==POSTMAIL) 
		fprintf(fout,"X-Mailer: Paperboy Version 2.00 (%s)",fname);
	if (type==POSTNEWS) 
		fprintf(fout,"X-Newsreader: Paperboy Version 2.00 (%s)",fname);
	fputc(LFCHAR,fout);

	/* Recopy file, stripping Carriage-return characters for Unix */
	while (!feof(fin))
	{
		result=getc(fin);
		if (result!=CRCHAR && result!=EOF) fputc(result,fout);
	}

	fclose(fin);
	remove(TMPFILE);                /* Nuke the temporary file */
	length=ftell(fout)-4;   /* Correct for four length bytes at beginning */

	/* Write new length */
	assert(length>0);
	fseek(fout,startpos,SEEK_SET);
	c=(unsigned char)(length  / (256L*256L*256L));
	fputc(c,fout);
	c=(unsigned char)(length / (256L*256L));
	fputc(c,fout);
	c=(unsigned char)(length / 256L);
	fputc(c,fout);
	c=(unsigned char)length;
	fputc(c,fout);

	fclose(fout);

	/* Append to REPLIES */
	fout=fopen(REPLYFILE,"ab");
    
    _splitpath(fname,NULL,NULL,basefilename,NULL);
	/* Strip off directory and .MSG to make a prefix */
	
	fprintf(fout,"%s\t",basefilename);
	if (type==POSTMAIL)
		fprintf(fout,"mail\tBn");
	if (type==POSTNEWS)
		fprintf(fout,"news\tbn");
	fputc(LFCHAR,fout);

	fclose (fout);
}

char * DLLFUNC GetGMTime (void)
{
static char timebuf[40];
struct tm * now;
time_t zulu;
	
	time(&zulu);
	now=gmtime(&zulu);
	
	wsprintf (timebuf,"%s, %d %s %04d %02d:%02d:%02d GMT",
		dayofweek[now->tm_wday], now->tm_mday, months[now->tm_mon], now->tm_year+1900,
		now->tm_hour, now->tm_min, now->tm_sec);
		
	return timebuf;
}
