/*      reclaim.c -- Data structure memory reclaimer 
	This file is part of Paperboy, an offline mail/newsreader for Windows
	Copyright (C) 1994  Michael H. Vartanian
		vart@clark.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>
#include "soup.h"
#include "error.h"
#include "reclaim.h"
#include "structs.h"

void reclaimgroup (struct llareas * cur)
{
	cur->magic=0;
	reclaimmsg(cur->head);
	free(cur->name);
	free(cur->prefix);
	free(cur->desc);
}

void reclaimareas(struct llareas * cur)
/* Blows away entire data structure, should contain most every
 * memory leak within the linked lists.
 */
{
	struct llareas * prev;

	while (cur!=NULL)
	{
		reclaimgroup(cur);
		prev=cur;
		cur=cur->next;
		free(prev);
	}
}

void sanity(struct llmsg * cur)
{
	while (cur!=NULL)
	{
		assert(cur->magic==MSGMAGIC);
		cur=cur->next;
	}
}

void reclaimmsg(struct llmsg * cur)
{
	struct llmsg * prev;

	sanity(cur);

	while (cur!=NULL)
	{
		assert(cur->magic==MSGMAGIC);
		cur->magic=0;
		free(cur->subject);
		free(cur->author);
		free(cur->date);
		prev=cur;
		cur=cur->next;
		free(prev);
	}
}
