/* SOUP (Simple Offline USENET Packet) Format Specification

	The SOUP format is (C) 1992-1993, Rhys Weatherley
									rhys@cs.uq.oz.au
									
	This file is part of Paperboy, an offline mail/newsreader for Windows
	Copyright (C) 1994  Michael H. Vartanian
		vart@clark.net

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


#ifndef HSOUP
#define HSOUP

#include <windows.h>

#define DLLFUNC __export __pascal __far

#define PBOYDLLMAJVERSION 2     /* Paperboy for Windows DLL version 2.0 */
#define PBOYDLLMINVERSION 0

#define SOUPMAJVERSION 1        /* 1.2, as of August 14, 1993 */
#define SOUPMINVERSION 2

#define SOUPSEP "\t"            /* <TAB> seperated values */

#define MAXLINE 1000                    /* Maximum line length per son-of-rfc1036*/

#define ERRMEM  10                      /* Out of memory */
#define ERRIO   20                      /* File I/O error */
#define ERRPARSE 30                     /* Corrupted File Format */

#define PATH_SEP        '\\'             /* Directory seperator, /=UNIX, \=MSDOS */

#define LFCHAR 10                       /* Line-feed (EOL) character */
#define CRCHAR 13                       /* Carriage-return (CR) character */

#define RNEWSHEAD       "#! rnews"      /* #! rnews n */
#define MAILHEAD        "From "

#define MSGEXT  ".MSG"          /* Message filename extension */

#define MAILTYPE        'm'
#define MAILMMDF        'M'
#define BINMAIL         'b'
#define NEWSTYPE        'n'
#define BINNEWS         'B'
#define RNEWSTYPE       'u'
#define INDEXONLY       'i'

#define UNKTYPE         'u'

#define REPLYSTR		"Re: "
#define SUBJSTR         "Subject"
#define FROMSTR         "From"
#define DATESTR         "Date"

#define INFOFNAME       "INFO"

#define POSTMAIL        1
#define POSTNEWS        2

#define TMPFILE         "TEMP"
#define REPLYFILE       "REPLIES"

static char * months [] =
	{"Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec"};
static char * dayofweek [] =
	{"Sun","Mon","Tue","Wed","Thu","Fri","Sat"};

#endif
