; This is example program number 1
;
;
; This does lots of simple things with the extender.

.386
CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME  CS:CODE32,DS:CODE32,ES:CODE32,FS:CODE32,GS:CODE32,SS:CODE32

INCLUDE  DOS32.INC                              ; define all the externals


memory_pointer  dd 0
File_handle     dw 0
File_Name       db 'EXAMPLE1.EXE',0
message1        db      ' Reading file into some allocated memory.',10,13
                db      ' Also hooking IRQ 0 ( the timer ) and altering the VGA color 0',10,13
                db      'register.     Press any key to stop',10,13,36

message2        db      10,10,'Everything was successful $'
message3        db      10,10,'Something went wrong $'
Old_IRQ0_vector dd 0,0

Start32:                                        ; Start of the program

;********************************************************************
;               DISPLAY A MESSAGE

        mov     edx,offset message1        ; Note: only DX is used here.
        mov     Real_DS,Seg message1       ; set the real mode DS register
        mov     ah,9
        Dosint  21h                        ; call a DOS interrupt service




;********************************************************************
;               ALLOCATE  SOME MEMORY

     mov   edx,4000h                  ; allocate 16K
     call  Allocate_Memory            ; returns EDX = offset of block
     jc   exit_unsucsessfuly          ; jump if not enough memory
     mov   memory_pointer,edx        ; save the block pointer





;********************************************************************
;               LOAD  FILE INTO MEMORY

     mov  edx,offset File_name        ; DS:EDX points to file name
     mov  ah,3Dh                      ; Open the file
     mov  al,00h                      ; opening flags
     int  21h                         ; call the protected mode file service
     jc exit_unsucsessfuly            ; exit if error
     mov  File_handle,ax              ; save the file handle


     mov  ecx,100000h              ;try to read 1MB form file
     mov  edx,memory_pointer       ;DS:EDX points to buffer to receive data
     mov  bx,File_handle
     mov  ah,3Fh
     int  21h                      ; Read file

     mov  bx,file_handle           ; Close the file
     mov  ah,3Eh
     int  21h



;********************************************************************
;               HOOK  IRQ 0  ( TIMER INTERRUPT )

       ;------ get origonal interrupt vector ------------
       mov     bl,0                          ; BL = IRQ number.
       call    GetIRQvector                  ; Call the service.
       mov     Old_IRQ0_vector,edx              ; Must save the old interrupt
       mov     word ptr Old_IRQ0_vector+4,cx    ;  vector as a 48 bit far
                                                ;  pointer.


       ;------ set the new interrupt vector --------------
       mov     BL,0                          ; BL = IRQ number
       mov     EDX,offset IRQ0_ISR           ; EDX = offset of int vector
       mov     cx,cs                         ; CX = selector value 
       call    SetIRQvector                  ; Call the service

         ;( see below for the hadrware interrupt handler )




;********************************************************************
;               WAIT FOR A KEY TO BE PRESSED

                mov     ah,0                    ; use the BIOS services
                dosint  16h




;********************************************************************
;                      RESTORE THE VGA COLOR 0 REGISTER TO BLACK
                mov     dx,3c8h
                mov     al,0
                out     dx,al
                inc     dl
                out     dx,al
                out     dx,al
                out     dx,al




;********************************************************************
;               DISPLAY A SUCCESSFUL MESSAGE

        mov     edx,offset message2        ; Note: only DX is used here.
        mov     Real_DS,Seg message2       ; set the real mode DS register
        mov     ah,9
        Dosint  21h                        ; call a dos interrupt service

        jmp exit_program


;********************************************************************
;               DISPLAY A UNSUCCESSFUL MESSAGE
exit_unsucsessfuly:

        mov     edx,offset message3        ; Note: only DX is used here.
        mov     Real_DS,Seg message3       ; set the real mode DS register
        mov     ah,9
        Dosint  21h                        ; call a dos interrupt service



;********************************************************************
;                      TERMINATE THIS WONDERFUL PROGRAM
exit_program:

	        mov   ah,4ch
                int   21h


;********************************************************************
;               OUR  HARDWARE INTERRUPT HANDLER

IRQ0_ISR:
        push    ds                              ; Save segemnt registers
        mov     ds,CS:[DATA32_SEL]              ; Must load segment registers

     ;lets do something so we know this interrupt handler is working.

        push    edx                   ; must save all registers used.
        push    eax
        mov     dx,3C8h                 ; Set color register number 0
        mov     al,0
        out     dx,al
        inc     dl
        mov     al,color0_red
        out     dx,al
        mov     al,color0_green
        out     dx,al
        mov     al,color0_blue
        out     dx,al

        inc     color0_blue               ; Update blue
        add     color0_red,2                ; Update red
        add     color0_green,3              ; Update green
        and     color0_blue,1fh
        and     color0_green,1fh
        and     color0_red,1fh


        pop     eax                       ; restore the saved registers
        pop     edx
        pop     ds
        jmp     fword ptr CS:Old_IRQ0_vector    ; Note we must use CS:
                                                ; because DS can equal
                                                ; anything.

color0_green    db 0
color0_blue     db 0
color0_red      db 0




CODE32 ENDS
END
