;--------------------------------------------------------------------------;
;        DOS32    32BIT  DOS  EXTENDER     Example program number 3        ;
;                                                                          ;
; Written by Adam Seychell                                                 ;
;--------------------------------------------------------------------------;
;
;
;  This program displays the environment varaibles
;

.386
CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME	CS:CODE32,DS:CODE32,ES:CODE32,FS:CODE32,GS:CODE32,SS:CODE32

INCLUDE  DOS32.INC              ; define all the external varibles and macros

Start32:                        ; Program starts execution here


domore:
        mov     gs,Zero_SEL            ; Load FS with base zero data segment

        mov     ah,62h                  ; First get PSP segment .
        dosint  21h
        movzx   ebx,bx
        shl     ebx,4
        movzx  edi,word ptr gs:[ebx+2Ch]    ; Get Environment segment value.
        shl     edi,4                  ; ( EDI now equals linear address
                                       ;   of the  Environment )
        mov     ah,0eh                 ; Set AH to video service func
        mov     bh,0


;
;  Display the environment.
;

Plot_char_loop:
        mov     al,gs:[edi]          ; read char from environment
        inc     edi
        cmp     al, 0
        jz string_ended               ; If char zero the string has ended.

          Dosint 10h                   ; else Plot the character.
          jmp Plot_char_loop           ; and continue loop.

      string_ended:

                cmp     byte ptr gs:[edi+1],0  ; If the next char is zero then
                jz     Envir_Ended             ; evnironmet has ended.
                mov     al,10                  ; Else only string has ended
                dosint  10h                    ; and do a carrage return.
                mov     al,13
                dosint  10h
                jmp Plot_char_loop

Envir_Ended:


    mov  ah,4ch                         ; stop the program
    int  21h


CODE32 ENDS
END
