;--------------------------------------------------------------------------;
;        DOS32    32BIT  DOS  EXTENDER     Example program number 4        ;
;                                                                          ;
; Written by Adam Seychell                                                 ;
;--------------------------------------------------------------------------;
;
;  This example program will display the current directory
;



.386
CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME	CS:CODE32,DS:CODE32,FS:CODE32,GS:CODE32,SS:CODE32

INCLUDE  DOS32.INC              ; define all the external varibles and macros

ASCIIZ_path     db  '*.*',0         ; String for search path


Start32:                        ; first intruction executed here

  ;
  ;  Call the DOS's "Find first" service
  ;
        mov     edx,offset ASCIIZ_path
        mov     cx,00000b
        mov     ah,4Eh
        int     21h
        jc exit
              ; The file info is put in the DTA buffer which is initally set
              ; to offset 80h in the PSP segment



Find_next_loop:
        movzx   edi,PSP_Segment           ; Get linear address of PSP.
        shl     edi,4
        add     edi,80h+1Eh
        mov     gs,Zero_SEL          ; Load GS with a zero base data segment

         ;
	 ; Print ASCIIZ string that was stored in the DTA buffer.
	 ;
        str_loop:
                mov     al,gs:[edi]           ; get char from DTA
                cmp     al,0                  ; if zero the string has ended
	        jz string_end
                call Print_Char               ; plot it
                inc edi                       ; get next char
                jmp str_loop                  ; loop around

string_end:
 ;
 ; Finished printing the ASCIIZ file name.   Now to carrage return
 ;
       mov al,10
       call Print_Char
       mov al,13
       call Print_Char

;
;    Loop around and keep on calling DOS's "Find Next" service until there
; are no more files left.
;
       mov  ah,4Fh
       int  21h
       jnc Find_next_loop

exit:
        mov     ah,4ch
        int     21h




 ;
 ; A procedure to send character to the screen.
 ;
Print_Char PROC
        mov     bh,0
        mov     ah,0Eh
        dosint  10h
        ret
Print_Char ENDP


CODE32 ENDS
END
