;--------------------------------------------------------------------------;
;        DOS32    32BIT  DOS  EXTENDER     Example program number 6        ;
;                                                                          ;
; Written by Adam Seychell                                                 ;
;--------------------------------------------------------------------------;
;
;  This example program does sends some stuff to/from the GUS via DMA.
;  Please note that this program requires part of the library
;


.386
CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME	CS:CODE32,DS:CODE32,ES:CODE32,FS:CODE32,GS:CODE32,SS:CODE32

INCLUDE  DOS32.INC              ; define all the external varibles and macros
include  macros.386
include  dma.inc
include  gus.inc
include  text.inc


DMA_buffer_phys         dd 0
DMA_buffer_addr         dd 0
DMA_DRAM_Address        dd 0
DMAPlay_TC              db 0
GUS_MEMORY              dd 0

GF1_clock               equ 617400

DMAplay_Chan        db 0
DMASamp_Chan        db 0

Start32:            ;**************** ENTRY POINT OF THE PROGRAM ************

;********* Allocate a 16KB DMA buffer  ***************
        call    AllocDMAregion
        jc exit
        mov     DMA_buffer_addr,edx
        mov     DMA_buffer_phys,ebx




;********* Get the Default GUS settings from the "ULTRASND=" string *********

        Call    GetUltraConfig
        jnc Got_EnvString
          Writeln ' invalid ULTRASND environment string'
         mov     cl,1           ; DRAM   DMA channel
         mov     ch,3           ; Record DMA channel
         mov     bl,11          ; GF1  IRQ number
         mov     bh,07           ; MIDI  IRQ number
Got_EnvString:
        mov     DMAplay_Chan,CL                     ; save DMA channels
        mov     DMASamp_Chan,CH



;************  Fully reset the Ultraosund *************************
         call    Ultrasound_Reset
         jnc  got_GUS
                writeln 'Could not detect an Ultrasound in this computer'
                jmp exit
got_GUS:


        call    Ultrasound_Detect              ; Get memory installed
        mov     GUS_MEMORY,EDI

        write 'Your Gravis Ultrasound has '
        shr     EDI,10
        Dec_word  DI
        write  ' Kbytes of DRAM and base port = '
        Hex_Word  DX
        write <10,10,13,'filling DRAM  using DMA channel '>
        Dec_byte   DMAPlay_chan
        write     ', IRQ number '
        Dec_byte   BL
        writeln  <'   ( # = 16KB )',10,10,13>





;************** Set the Ultrasounds IRQ vevctor *****************
        mov     edx,offset GUS_ISR
        mov     cx,cs                           ; CX:EDX = selectro:offset
        call    SetIRQVector                    ; BL = IRQ number






; ****** program the 8237 DMA contoller  *************
        mov     al,01011000b             ; DMA mode register
        mov     ah,DMAPlay_Chan          ; Channel number ( 0..7 )
        mov     ecx,04000h                ; Bytes to transfer
        mov     ebx,DMA_buffer_PHYS     ; Physical base address
        call    DMA_setup                ; Do it ( see DMA.ASM )

; Note: Mode reg bit 4 is set for DMA auto initalizing mode.
; This means that the Address and Count registers don't have to be
;reprogramed after the DMA has finished transfering.



FILL_GUS_LOOP:
       ;********* Set the GUS's DMA DRAM staring address register *****

        mov     edi,DMA_DRAM_address
        test    DMAPlay_chan,100b
        jz _8bitDMA
           ; ---- do 16 bit DMA address translation ( see the SDK ) -----
          mov     eax,edi
          shr     edi,1
          and     edi,01ffffh     ; zero out bit 17..19
          and     eax,0c0000h     ; get bits 18 and 19
          or      edi,eax
_8bitDMA:
        shr     edi,4
        mov     al,042h                       ; DMA Start Address
        mov     ecx,edi
        call    GF1_W


  ;********* Set the GUS's DMA Control Register  ****************

        mov     al,041h                ;DRAM  DMA Control Register
        mov     ah,DMAPlay_chan
        and     ah,100b
        mov     cl,00100001b       ;Read, 650KB/s, 16bit data, 16/8bit DMA
        or      cl,ah
        call    GF1_B               ; The DMA cycle will now start



;********************** Wait around for the DMA to finish **************
               	mov     ecx,500000h
waitTC:        	test    DMAPlay_TC,1
                loopz  waitTC
                jz   timoutERROR
                mov     DMAPlay_TC,0


        mov     al,'#'
        call    Print_Char

        add     DMA_DRAM_address,4000h
        mov     eax,GUS_MEMORY
        cmp     eax,DMA_DRAM_address
        ja FILL_GUS_LOOP

;************************* Stop DRAM  DMA cycle ********************
        mov     al,041h                ; DRAM DMA Control Register
        mov     cl,00000000b          ;stop IRQ's
        call    GF1_B

exit:

; ****** program the 8237 DMA contollers  *************
        ; Must turn of auto initalizing
        mov     al,00001000b             ; DMA mode register
        mov     ah,DMAPlay_Chan          ; Channel number ( 0..7 )
        call    DMA_setup

        mov     ah,4ch
        int     21h

timoutERROR:
        writeln 'ERROR:  got no IRQ form GUS'
        jmp exit







   ;******************** Gravis ultrasound IRQ handler ********************
GUS_ISR:
        push    es
        push    ds
        mov     ds,cs:data32_sel
        mov     es,cs:data32_sel
        pushad

 ;
 ; First determine if IRQ was form DMA Terminal Count or it was
 ; from one of the Voices
 ;
        mov     dx,GF1_IRQ_status
        in      al,dx
        test    al,10000000b             ;look for a DMA TC IRQ
        jnz was_DMA_TC

     ;
     ; Must read the IRQ source register to clear the FIFO interrupts
     ;
   	     mov     dx,GF1_REG_Select
             mov     al,08fh
             out     dx,al
             mov     dx,GF1_DATA_High
             in      al,dx
             jmp  exit_ISR



was_DMA_TC:
    ;
    ;  Read DRAM DMA controll register to allow more DRAM DMA IRQs.
    ;
        mov     dx,GF1_REG_Select
        mov     al,041h         ;DRAM  DMA Control Register
        out     dx,al
        mov     dx,GF1_DATA_High    ; read
        in      al,dx
        or      DMAPlay_TC,1


exit_ISR:
        mov     al,020h                 ; EOI to PICs
	out	20h,al
        out     0A0h,al
        popad
        pop     ds
        pop     es
	iretd


; Some little procedures that are used by the Ultrasound services

GF1_b proc
        mov     edx,dword ptr GF1_Reg_Select
        out     dx,al
        add     dl,2
        mov     al,cl
        out     dx,al
        ret
GF1_b endp

GF1_w proc
        mov     edx,dword ptr GF1_Reg_Select
        out     dx,al
        inc     dl
        mov     eax,ecx
        out     dx,ax
        ret
GF1_w endp
DisplayLoc proc
        mov     dx,GF1_Reg_Select
        mov     al,08Ah                    ;Current location HIGH
        out     dx,al
        mov     dx,GF1_Data_low
        in      ax,dx
        and     eax,0fffh
        shr     eax,2
        add     eax,_0b8000h
        inc     byte ptr [eax+1]
        ret
DisplayLoc endp


CODE32 ENDS
END
