;-------------------------------------------------------------------------
;       DOS32  DOS   EXTENDER                   By Adam Seychell
;
;    Example program demonstrating the Debugger.
;
;
;  Don't forget to link in DEBUG.OBJ
;
;-------------------------------------------------------------------------
.386
CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME  CS:CODE32,DS:CODE32,ES:CODE32,FS:CODE32,GS:CODE32,SS:CODE32

INCLUDE  DOS32.INC                      	; define all the external


_48bit_pointer  df   00


My_varible      db 0


Start32:                                        ; Start of program




;
;  Must start the debugger with a call.
;

        call    Debug





;
;       Some instrucions just to show off the debugger.
;


        xor     eax,eax
        mov     edi,_0a0000h
        xor     eax,eax
        mov     ecx,30
        cld
        rep     stosd


        mov     eax,1
        mov     ebp,2
        mov     ecx,3
        mov     edx,4

        mov     edi,5
        mov     esi,6
        mov     ebp,7

        mov     ecx,10
        loop $

        push    00000000h
        push    11111111h
        push    22222222h
        push    33333333h

        mov     eax,ds:[1]
        int    3                        ; put in a breakpoint
        mov     eax,ds:[2]

        call    test_proc
        sub     edx,edx
        mov     fs,dx
        mov     es,dx
        stc
        std
        clc
        sti
        nop
        mov     edx,-1
        mov     ebp,1
        movzx     eax,word ptr gs:[edx+2*ebp+00000004ah]
        mov     edx,eax

        lea     eax,fs:[edx+ebp*8+333]
        mov     ax,cs:[bx+di]
        imul    eax,ebx,12345678h

        mov     dword ptr _48bit_pointer,offset  far_jump
        mov     word ptr _48bit_pointer+4,cs


        jmp     fword ptr cs:[_48bit_pointer]



test_proc       proc
        stc
        std
        clc
        sti
        nop
        smsw  dx
        ret
test_proc       endp





far_jump:





;
;  Load in the debug registers and set breakpoint registers 0 and 2.
;


    ;
    ;  Load DR0 with breakpoint address
    ;
        mov     eax,offset My_varible  ; first get offset and add the
        add     eax,code32_ADDR       ; segment base to give linear address.
        mov     DR0,eax               ; Load 32bit Linear address

   ;
   ;  Load DR2 with breakpoint address
   ;

        mov     eax,offset  brkpt2    ; first get offset and add the
        add     eax,code32_ADDR        ; segment base to give linear address
        mov     DR2,eax                ; Load 32bit Linear address


    ;
    ; Load   DR7      (See Intel docs for register description)
    ;

;                W0 = 1                W2 = 0
;                R0 = 1                R2 = 0
;                LEN0 = 0              LEN2 = 0
;                G0 = 1                G2 = 1
;                GE = 1
;                all other fields are zero

        mov     eax,000030222h
        mov     DR7,eax



;
;  Do some instrucions that should invoke the breakpoint registers.
;

        mov     ebp,2
        mov     ecx,3
        mov     edx,4
        mov     edi,5
brkpt2: mov     ebp,0          ;<- this instrucion will cause breakpoint 2
        mov     ecx,3
        mov     edx,4
        mov     edi,5
        mov     al,[My_varible]   ;<- this data read will cause breakpoint 0
        mov     esi,6
        mov     ebp,7


        mov     ah,4ch          ; Terminate  Program
        int     21h




CODE32 ENDS
END
