;--------------------------------------------------------------------------;
;        DOS32    32BIT  DOS  EXTENDER     Ultrasound example program      ;
;                                                                          ;
; Written by Adam Seychell                                                 ;
;--------------------------------------------------------------------------;
;
;      This program will play 23 voices on a Ultrasound and allow the 
;   user to modify the volume, panning, frequency and type of wave trough 
;   the keyboard.
;

Voices_used_equ         equ     23

Frequency_on    EQU  0
Volume_on       EQU  1
Panning_on      EQU  2
Waveform_on     EQU  3
Phase_on        EQU  4

Sine_waveStart          equ   0000h
Pulse_waveStart         equ 0400h
Triangle_waveStart      equ 0800h
Sawtooth_waveStart      equ 0C00h
Noise_waveStart         equ 1000h
Noise1_waveStart        equ 5000h
Noise2_waveStart        equ 8000h

Sine_waveSize           equ 400h
Pulse_waveSize  	equ 400h
Triangle_waveSize       equ 400h
Sawtooth_waveSize       equ 400h
Noise_waveSize          equ 4000h
Noise1_waveSize         equ 3000h
Noise2_waveSize         equ 0f80000h

nothing_on       equ 0
Sine_on         equ 1
Pulse_on        equ 2
Triangle_on     equ 3
Sawtooth_on     equ 4
Noise_on        equ 5
Noise1_on       equ 6
Noise2_on       equ 7

Number_of_waves  equ 7

.386
CODE32 SEGMENT PUBLIC PARA 'CODE' USE32
ASSUME	CS:CODE32,DS:CODE32,FS:CODE32,GS:CODE32,SS:CODE32

INCLUDE  DOS32.INC              ; define all the external varibles and macros
INCLUDE         macros.386
include         text.inc
include         gus.inc
include         random.inc


sine label word
include sin.tab

Ssize           equ       70
Poles           equ       36
FeadBack        dword     507

B               dword Poles dup (0)
Z_1             dword Poles dup (0)
Volume                  word  Voices_used_equ dup (0e00h)
Frequency               dword Voices_used_equ dup (  00h)
Panning                 sbyte Voices_used_equ dup (8)
Phase                   sword Voices_used_equ dup (0)
WaveType                sbyte Voices_used_equ dup (nothing_on)



Voice_select            db 0
current_voice           db 0
key     	        db 0
Voices_used_equ         equ     23
controlling             db 0
 color                  dd 0fh
noisewave_ptr               dd 0
flat_cnt        dword   0
old_samp        dword   0
Start32:

        mov     ax,0700h
        call    clrscr
   mov cursor_y,10
   writeln 'This program will let you alter the registers of the Gravis Ultrasound',3
   writeln 'There is no special sound proccessing. It is just using the Ultrasound''s',3
   writeln ' hardware. The sounds are all 16bit pre generated waves',3

        mov  cursor_x,30
        add cursor_y,4
        writeln ' Instrctions '
        writeln 'Use UP & DOWN arrow keys to select voice. Use LEFT & RIGHT arrow keys',0ah
        writeln  'to swap between controls and holding CTRL will alter the setting.',0ah
        writeln ' Holding down the SHIFT key will use lager steps rates',0ah


   writeln ' Press any key to continue. ',9

        mov  ah,0
        dosint  16h

        call GetUltraConfig
        jnc @f
         mov cl,5
         mov ch,6
         mov  bl,11
         mov  bh,7
@@:      call Ultrasound_Reset
         jnc Ggus
           writeln 'Can not find a Gravis Ultrasound card',0bh
           jmp exit
Ggus:                           ;- DX has port address


        mov    edx,1000
@@:     mov     cl,32
        call    Random
        dec   edx
        jnz @b


        outp    GF1_reg_select,0Eh
        outp    GF1_data_high,(Voices_used_equ-1) or 0C0h


;
;       ; Transfer the SIN WAVE TO THE GUS'S DRAM .
;
        mov     edi,Sine_waveStart
        xor     esi,esi
fill_ram_loop_1:
        mov     ax,sine[esi*2]
        call    Send_word_to_DRAM
        inc     edi
        inc     esi
        cmp     edi,Sine_waveStart + Sine_waveSize
        jb     fill_ram_loop_1



;
;       ; Transfer the PULSE wave to the GUS's DRAM
;
        mov     edi,Pulse_waveStart
fill_ram_loop_2a:
        mov     ax,06000h
        call    Send_word_to_DRAM
        inc     edi
        cmp     edi,Pulse_waveStart + (Pulse_waveSize/2)
        jb     fill_ram_loop_2a
fill_ram_loop_2b:
        mov     ax,-6000h
        call    Send_word_to_DRAM
        inc     edi
        cmp     edi,Pulse_waveStart + Pulse_waveSize
        jb     fill_ram_loop_2b



;
;       ; Transfer the Triangle wave to the GUS's DRAM
;
        mov     edi,Triangle_waveStart
        mov     ax,-7f00h
fill_ram_loop_3a:
        call    Send_word_to_DRAM
        add     ax,  0f000h/(Triangle_waveSize/2)
        inc     edi
        cmp     edi,Triangle_waveStart + (Triangle_waveSize/2)
        jb     fill_ram_loop_3a
fill_ram_loop_3b:
        call    Send_word_to_DRAM
        sub     ax,  0f000h/(Triangle_waveSize/2)
        inc     edi
        cmp     edi,Triangle_waveStart + Triangle_waveSize
        jb     fill_ram_loop_3b


;
;       ; Transfer the SAWTOOTH wave to the GUS's DRAM
;
        mov     edi,Sawtooth_waveStart
        mov     ax,-7f00h
fill_ram_loop_4:
        call    Send_word_to_DRAM
        add     ax,  0f000h/Sawtooth_waveSize
        inc     edi
        cmp     edi,Sawtooth_waveStart + Sawtooth_waveSize
        jb     fill_ram_loop_4





;
;       ; Transfer the NOISE wave to the GUS's DRAM
;

      write 'Generating filtered Noise wave.  samples left ',15

      mov     edi,Noise_waveStart

; FILTER THE NOISE WAVE

fill_ram_loop_5:

        CMP  flat_cnt,Ssize
        jb skip_newSamp
        mov  flat_cnt,0
        mov     cl,16
        call    Random             ; get random number
        cmp   edi,Noise_waveStart
        jnz @f
          mov  eax,0
   @@:  cmp  edi,Noise_waveStart + Noise_waveSize - Ssize*2
        jb @f
          mov  eax,0
   @@:  sal     eax,4
     	mov   old_samp,eax
skip_newSamp:

     inc     flat_cnt
     mov   ecx,old_samp
     mov ebx,0
LPFpole_int:

    mov eax,[ Z_1 +ebx*4 ]      ; get Z-1 output
    imul    FeadBack            ; get B1's output
    sar eax,10
    mov [ B + ebx*4],eax

    mov eax,ecx             ; get sample

    add eax,[ B +ebx*4]         ; Sum with Bn's output

    mov [ Z_1 +ebx*4],eax           ; uptade Zn-1

    mov    ecx,[ B +ebx*4 ]                   ; store sample

   inc ebx
   cmp ebx,Poles
   jb  LPFpole_int

     sar     ecx,4
     mov     eax,ecx
     call    Send_word_to_DRAM
     inc     edi
     mov    cl,cursor_x
     mov     eax,Noise_waveSize+Noise_waveStart
     sub     eax,edi
     dec_dword  eax,14
     mov    cursor_x,cl
     cmp     edi,Noise_waveStart + Noise_waveSize
    jb     fill_ram_loop_5





;
;       ; Transfer the NOISE wave to the GUS's DRAM
;

      mov     edi,Noise1_waveStart

fill_ram_loop_6:

        mov     cl,16
        call    Random             ; get random number
     call    Send_word_to_DRAM
     inc     edi
     cmp     edi,Noise1_waveStart + Noise1_waveSize
     jb     fill_ram_loop_6








;
;  DISPLAY SCREEN INFO
;
        mov     ax,0700h
        call    clrscr

        mov cursor_x,0
        mov cursor_y,0
        write 'Voice #   Frequency    Volume   Pan Posion                       waveform',14

        mov cursor_x,0
        mov cursor_y,0

        mov     controlling,0
Setema:
        mov     current_voice,0
Setem:
        mov     color,0ch
        xor     ebx,ebx
        call    Set_control
        inc current_voice
        cmp current_voice,Voices_used_equ
        jb Setem
        inc   controlling
        cmp   controlling,4
        jb Setema


        xor     ebx,ebx
        mov     color,0fh
        mov     controlling,0
        mov     current_voice,0
        call    Set_control


update_Voice_frequency_loop:

          mov ah,10h
          dosint 16h

        mov cursor_y,24
        mov cursor_x,70
        hex_word  ax,9

      .IF  ax == 74E0h      ; arrow right with CTRL
                mov    eBX,1
                call    set_control

      .ELSEIF  ax == 73E0h      ; arrow left with CTRL
                mov    eBX,-1
                call    set_control

      .ELSEIF  ah == 50h                ; arrow down
          jmp @f
       .ELSEIF    ax == 91e0h;                 ; arrow down with ctrl
          @@:
           mov   color,0ch
           xor     ebx,ebx
           call    set_control
           inc  current_voice
           cmp current_voice,Voices_used_equ
           jl @f
            mov current_voice,Voices_used_equ-1
         @@:
           mov   color,0fh
           xor     ebx,ebx
           call    set_control

       .ELSEIF    ah == 48h                 ; arrow up
          jmp @f
       .ELSEIF    ax == 8de0h                 ; arrow up with ctrl
          @@:
                   mov     color,0ch
	           xor     ebx,ebx
	           call    set_control
                   dec  current_voice
	           cmp current_voice,0
	               jge @f
	            mov current_voice,0
	          @@:
	           mov   color,0fh
	           xor     ebx,ebx
	          call    set_control

      .ELSEIF  ax == 4DE0h     ; arrow right    ( increase )
                   mov   color,0ch
	           xor     ebx,ebx
	           call    set_control
	           inc   controlling
                   cmp  controlling, 3
                   jbe @f
                    mov controlling,3
               @@: mov   color,0fh
	           xor     ebx,ebx
                   call    set_control


      .ELSEIF  ax == 4BE0h                ; arrow left
                   mov   color,0ch
	           xor     ebx,ebx
	           call    set_control
                   sub   controlling,1
                   jnl @F
                     mov   controlling,0
               @@: mov   color,0fh
	           xor     ebx,ebx
                   call    set_control
      .ELSEIF  ah== 01                       ; ESC key to exit
        jmp exit_loop

      .ENDIF
        jmp update_Voice_frequency_loop

exit_loop:
        sti
        mov cursor_y,24
        mov cursor_x,0
        writeln ' do you want to stop the sounds ? ',0bh
         mov ah,0
         dosint  16h
         cmp ah,15h
         jnz @f
        call    Ultrasound_init
@@:
        jmp @f
exit:
        writeln ' Press any key to exit. ',9
       mov  ah,0
        dosint  16h
@@:        mov byte ptr fs:[0b8f01h],7
	mov ah,4ch		; Termiate the program
        int 21h


Set_control PROC
local Start_address   :dword
local End_address   :dword

          movzx   ecx,Current_Voice
          outp    GF1_Voice_select,  CL  ; select voice to operate with
          mov     cursor_y,cl
          add     cursor_y,1
          mov     cursor_x,2
          dec_byte  cl,04h

           mov   eax,Zero_Addr
           test   byte ptr [eax+417h],3
           jz @f
                shl     ebx,4
           @@:


          .IF     controlling == Frequency_on
                outp    GF1_Reg_Select,01h          ; set Frequencey
                shl     ebx,3
                add     Frequency[ecx*4],EBX
                and     Frequency[ecx*4],07FFFh
                mov     edi,Frequency[ecx*4]
                mov     cursor_x,12
                dec_word  DI,byte ptr color
                shl     di,1
                outpW   GF1_data_low,di

          .ELSEIF   controlling == Volume_on
                outp    GF1_Reg_Select,09h          ; set Volume
                shl     ebx,3
                add     Volume[ecx*2],BX
                .if  Volume[ecx*2] > 4095
                     mov  Volume[ecx*2],4095
                .endif
                mov     di,Volume[ecx*2]
                mov     cursor_x,24
                dec_word   DI,byte ptr color
                shl     di,4
                outpW   GF1_data_low,di
          .ELSEIF   controlling == Panning_on
                outp    GF1_Reg_Select,0Ch          ; set Pan postion
                add     Panning[ecx],bl
                .if  Panning[ecx] > 15
                     mov  Panning[ecx],15
                .elseif  Panning[ecx] < 0
                     mov  Panning[ecx],0
                .endif
                mov     al,Panning[ecx]
                mov     cursor_x,34
                dec_byte   al,byte ptr color
                outp   GF1_data_high,al
          .ELSEIF   controlling == Waveform_on

                add    WaveType[ecx],bl
                .if  WaveType[ecx] > Number_of_waves
                     mov  WaveType[ecx], Number_of_waves
                .elseif  WaveType[ecx] < 0
                     mov  WaveType[ecx], 0
                .endif
                mov     cursor_x,68
                outp    GF1_Reg_Select,000h         ;  Voice control
	        outp    GF1_data_high,00001100b  ; 16bit, loop on, IRQ off, Inc


            .IF      WaveType[ecx] == Sine_on
                       mov  Start_Address, Sine_WaveStart
                       mov  End_Address, Sine_WaveStart + Sine_WaveSize
                       write 'Sine     ',<byte ptr color>

            .ELSEIF  WaveType[ecx] == pulse_on
                       mov  Start_Address, pulse_WaveStart
                       mov  End_Address, pulse_WaveStart + pulse_WaveSize
                       write 'Pulse     ',<byte ptr color>

            .ELSEIF  WaveType[ecx] == Triangle_on
                       mov  Start_Address, Triangle_WaveStart
                       mov  End_Address, Triangle_WaveStart + Triangle_WaveSize
                       write 'Triangle   ',<byte ptr color>

            .ELSEIF  WaveType[ecx] == Noise_on
                       mov  Start_Address, Noise_WaveStart
                       mov  End_Address, Noise_WaveStart + Noise_WaveSize
                       write 'Noise LPF  ',<byte ptr color>

            .ELSEIF  WaveType[ecx] == Noise1_on
                       mov  Start_Address, Noise1_WaveStart
                       mov  End_Address, Noise1_WaveStart + Noise1_WaveSize
                       write 'White noise',<byte ptr color>


            .ELSEIF  WaveType[ecx] == Noise2_on
                       mov  Start_Address, Noise2_WaveStart
                       mov  End_Address, Noise2_WaveStart + Noise2_WaveSize
                       write 'all DRAM   ',<byte ptr color>
                   outp    GF1_Reg_Select,000h         ;  Voice control
                   outp    GF1_data_high,00001000b  ; 8bit, loop on, IRQ off, Inc

            .ELSEIF  WaveType[ecx] == Sawtooth_on
                       mov  Start_Address, Sawtooth_WaveStart
                       mov  End_Address, Sawtooth_WaveStart + Sawtooth_WaveSize
                       write 'Sawtooth   ',<byte ptr color>

            .ELSEIF  WaveType[ecx] == nothing_on
                outp    GF1_Reg_Select,000h         ;  Voice control
                outp    GF1_data_high,00001110b  ; 16bit, stoped
                       mov  Start_Address,0
                  write 'nothing   ',<byte ptr color>


            .ENDIF

                dec     End_address
                shl     Start_address,4
                shl     End_address,4

                outp    GF1_Reg_Select,03h        ; set Starting Location LOW
                MOV     EDI,Start_address
                SHL     EDI,5
                outpW   GF1_data_low,DI
                outp    GF1_Reg_Select,02h        ; set Starting Location High
                MOV     EDI,Start_address
                SHR     EDI,11
                outpW   GF1_data_low,DI


                outp    GF1_Reg_Select,05h        ; set Ending Location LOW
                MOV     EDI,End_address
                SHL     EDI,5
                outpW   GF1_data_low,DI
                outp    GF1_Reg_Select,04h        ; set Ending Location High
                MOV     EDI,End_address
                SHR     EDI,11
                outpW   GF1_data_low,DI




                outp    GF1_Reg_Select,0Bh       ; set Current Location LOW
                MOV     EDI,Start_address
                SHL     EDI,5
                outpW   GF1_data_low,DI
                outp    GF1_Reg_Select,0Ah       ; set Current Location High
                MOV     EDI,Start_address
                SHR     EDI,11
                outpW   GF1_data_low,DI




          .ENDIF
          ret
set_control ENDP



; send a word to the DRAM:   edi = address,   ax = value
Send_word_to_DRAM PROC
local   value   : word
local   address : dword

;    send low byte
        pushad

        mov     value,ax
        shl     edi,1
        mov    address,edi

        mov     ecx,edi
        outp    GF1_Reg_Select,43h          ; DRAM I/O Address ( LOW )
        outpW   GF1_data_low,cx

        shr	ecx,16
        outp    GF1_Reg_Select,44h          ; DRAM I/O Address ( HIGH )
        outp    GF1_data_high,cl

        mov     dx,GF1_DRAM
        mov     al,byte ptr value
        out	dx,al

;    send high byte
        mov     ecx,address
        inc     ecx
        outp    GF1_Reg_Select,43h          ; DRAM I/O Address ( LOW )
        outpW   GF1_data_low,cx

        shr	ecx,16
        outp    GF1_Reg_Select,44h          ; DRAM I/O Address ( HIGH )
        outp    GF1_data_high,cl

	mov	dx,GF1_DRAM
        mov     al,byte ptr value+1
        out     dx,al

        popad
        ret
Send_word_to_DRAM ENDP

; waits ECX retraces
Wait_ret PROC

waite:
        ;-- wait vertical retrace --
        mov  dx,3DAh
@@:     in al,dx
        test al,8
        jnz @b
@@:     in al,dx
        test al,8
        jz @b
        loop waite
        ret
Wait_ret ENDP

CODE32 ENDS
END
