DISPLAY "ASSEMBLYING INTRO PART..."

_Code4  Segment Para Public 'Code'

ASSUME CS:_Code4,DS:_DATA1

MAP_MASK      equ    02h     ;index in SC of Map Mask register
SC_INDEX      equ  03c4h     ;Sequence Controller Index
GC_INDEX      equ  03ceh     ; Graphics controller Index
READ_MAP      equ    04h     ;index in GC of the Read Map register

Proc   Set_Virtual_Page_Size Far
       mov   dx,03d4h
       mov   al,13h
       out   dx,al
       inc   dx

       mov   ax,Word ptr Virtual_Width
       shr   ax,3
       out   dx,al

       Retf
Endp   Set_Virtual_Page_Size

Proc   Scroll_Virtual_Page Far
       push si
       push bx
       mov  si,Scroll_X
       mov  cx,Scroll_Y         ; Calculate Y offset
       mov  ax,virtual_width
       shr  ax,2
       Mul  cx

       mov  cx,si
       shr  cx,2
       add  ax,cx                          ; add the column offset for X
       add  ax,page_offset
       mov  bh,al                          ; setup CRTC start addr regs and
					   ; values in word registers for
       mov  ch,ah                          ; fast word outs

 StartAddrEntry:
       mov  bl,0dh
       mov  cl,0ch


       mov  dx,03dah    ;Wait for trailing edge of Vsync pulse

 @@WaitDE:                       ; Wait for Horizontal retrace
       in   al,dx
       test al,01h
       jnz  @@WaitDE             ;display enable is active low (0 = active)

       mov  dx,03d4h
       mov  ax,bx
       out  dx,ax               ;start address low
       mov  ax,cx
       out  dx,ax               ;start address high

       mov  dx,03c0h
       mov  al,13h+20h           ; Point the attribute controller to pel pan
       out  dx,al                ; reg. Bit 5 also set to prevent blanking

       and  si,0003h             ; select pel pan register value for the
       mov  al,PelPanMask[si]    ; required x coordinate
       out  dx,al                ; load new Pel Pan setting.

       pop  bx
       pop  si
       retf
EndP   Scroll_Virtual_Page

Proc   Write_Pop_up Near                    ; DS:BX => The Message to write
       Push DS
       ASSUME DS:_DATA1
       Mov AX,_DATA1
       Mov DS,AX
       Mov AX,0A000h
       Mov ES,AX

_Next_Char_To_Write512:
       Lea SI,CharSet                 ; CharSet
       Xor AH,AH
       Mov AL,[BX]
       Shl AX,4
       Add SI,AX
       Mov DH,16
_next_row512:
       Mov CX,8
       Mov DL,[SI]
       Push SI
_next_point512:
       Xor AX,AX                        ; Frg att nolla med
       Rcl DL,1
       Jnc _plotted512
       Mov AX,plane
_plotted512:
       Push BX
       Push CX
       Push DX

       Push AX
       mov  ax,Virtual_Width               ; Logical screen width in bytes
       shr  ax,2
       mul  Y_point
       mov  bx,X_point
       shr  bx,2                 ;X/4 = offset of pixel in scan line
       add  bx,ax                ;offset of pixel in page

       mov  ah,byte ptr X_Point
       and  ah,011b              ;AH = pixel's plane
       mov  al,READ_MAP          ;AL = index in GC of the Read Map reg
       mov  dx,GC_INDEX          ;set the Read Map to read the pixel's
       out  dx,ax	          ; plane

       mov  al,es:[bx]           ;read the pixel's color

       Mov DI,AX

       mov  cl,byte ptr X_Point
       and  cl,011b              ;CL = pixel's plane
       mov  ax,0100h + MAP_MASK  ;AL = index in SC of Map Mask reg
       shl  ah,cl                ;set only the bit for the pixel's
				 ; plane to 1
       mov  dx,SC_INDEX          ;set the Map Mask to enable only the
       out  dx,ax		  ; pixel's plane

       Pop AX
       Mov DX,DI
       Mov AH,DL
       Mov DX,plane
       Xor DL,255
       And AH,DL
       Or AL,AH
       Mov  es:[bx],al           ;draw the pixel in the desired color

       Pop DX
       Pop CX
       Pop BX
       Inc x_point
       Loop _next_point512
       Pop SI
       Inc SI
       Sub Word ptr x_point,8
       Inc y_point
       Dec DH
       Jne _next_row512
       Sub Word ptr y_point,16
       Add Word ptr x_point,8
       Inc BX
       Mov AX,Pop_Up_Pointer
       Cmp BX,AX
       Je _not_Next_Char_To_Write512
       Jmp _Next_Char_To_Write512
_not_Next_Char_To_Write512:
       Add Word ptr Pop_Up_Pointer,45
       ASSUME DS:_DATA
       Pop DS
       Ret
EndP   Write_Pop_Up

Proc   _Plot_Girl Near
       xor  al,al
       out  21h,al

       ASSUME DS:_DATA1
       Push BX
       Mov AX,3D00h
       Lea DX,mist
       Int 21h
       Mov handler,AX

       Lea DX,palette
       Mov BX,handler
       Mov CX,128
       Mov AH,3Fh
       Int 21h

       Mov AX,Word ptr palette+12
       Mov Picture_Width,AX
       Mov AX,Word ptr palette+14
       Mov Picture_Height,AX
       Mov Word ptr picture_y,40
       Mov Word ptr picture_x,0

       Mov CX,0FFFFh
       Xor DX,DX
       Sub DX,756
       Mov AX,4202h
       Mov BX,handler
       Int 21h

       Lea DX,palette
       Mov AH,3Fh
       Mov CX,756
       Mov BX,handler
       Int 21h
       Mov CX,252
       Mov DX,03C8h
       Mov AL,4
       Out DX,AL
       Inc DX
       Lea BX,palette
_new_color_on_picture:
       Mov AL,[BX]
       Inc BX
       Shr AL,2
       Out DX,AL
       Mov AL,[BX]
       Inc BX
       Shr AL,2
       Out DX,AL
       Mov AL,[BX]
       Inc BX
       Shr AL,2
       Out DX,AL
       Loop _new_color_on_picture

       Xor CX,CX
       Mov DX,128
       Mov AX,4200h
       Mov BX,handler
       Int 21h

_next_byte:
       Lea DX,reler
       Mov BX,handler
       Mov CX,1
       Mov AH,3Fh
       Int 21h
       Mov CX,1
       Mov AL,reler
       Cmp AL,192
       Jb _not_more_then_one
       Lea DX,colr
       Mov BX,handler
       Mov CX,1
       Mov AH,3Fh
       Int 21h
       Mov CL,reler
       Sub CL,192
       Mov AL,colr
_not_more_then_one:
       Cmp AL,0
       Je _no_change
       Cmp AL,3
       Ja _no_change
       Add AL,20
_no_change:
       Push CX
       Push AX

       mov  ax,Virtual_Width               ; Logical screen width in bytes
       shr  ax,2
       mul  picture_Y
       mov  bx,picture_X
       shr  bx,2                 ;X/4 = offset of pixel in scan line
       add  bx,ax                ;offset of pixel in page
       mov  cl,byte ptr picture_X
       and  cl,011b              ;CL = pixel's plane
       mov  ax,0100h + MAP_MASK  ;AL = index in SC of Map Mask reg
       shl  ah,cl                ;set only the bit for the pixel's
				 ; plane to 1
       mov  dx,SC_INDEX          ;set the Map Mask to enable only the
       out  dx,ax		 ; pixel's plane
       Pop AX
       mov es:[bx],al
       Inc picture_x
       Pop CX
       Loop _not_more_then_one
       Mov AX,picture_width
       Cmp picture_x,AX
       Jb _not_next_byte
       Mov Word ptr picture_X,0
       Inc picture_Y
       Dec picture_height
       Jne _not_next_byte
       Jmp _forbi
_not_next_byte:
       Jmp _next_byte
_forbi:
       Mov AH,3Eh
       Int 21h

       Push DS
       Pop ES
       Lea SI,dpalette
       Lea DI,palette
       Mov CX,384
       Rep Movsw

       Pop BX
       mov  al,01111010b         ; Mask off all unneccesary interrupts.
       out  21h,al
       Ret
EndP   _Plot_Girl

Proc   Intro  Far
       Lea DI,virtual_width
       Mov AX,_DATA1
       Mov ES,AX


       push ds
       ASSUME ds:_data
       mov  ax,_data
       mov  ds,ax

       Mov AX,ES:[DI]
       Mov CX,3
       Push AX
       Push CX
       Call _X_Set_Mode
       Pop CX
       Pop AX


       Mov DX,03C8h
       Mov AL,1
       Out DX,AL
       Inc DX
       Xor AL,AL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Out DX,AL

       Mov AX,200
       Push AX
       Call _X_Set_SplitScreen
       Pop AX
       Call _X_Show_Splitscreen

       ASSUME ds:_data1
       pop ds

       Push DS
       ASSUME DS:_DATA1
       Mov AX,_DATA1
       Mov DS,AX
       Mov AX,virtual_Width
       Mov BX,AX
       Shl AX,3
       Shl BX,1
       Add BX,AX
       Mov page_offset,BX
       Mov DX,03D4h
       Mov AL,0Dh
       Mov AH,BL
       Out DX,AX
       Mov AL,0Ch
       Mov AH,BH
       Out DX,AX

       Mov Word ptr x_point,0
       Mov Word ptr y_point,10
       Lea BX,Pop_up_text
       Call Write_Pop_Up
       Mov Word ptr plane,2
       Mov Word ptr x_Point,0
       Mov Word ptr y_point,10
       Call Write_Pop_Up
       Mov Word ptr plane,1

       Call _Plot_Girl              ; Plot nice picture

       Lea DX,tentan
       Call LoadModule

       Call StartPlaying         ; Roll it !

       Mov  Al,01111010b         ; Mask off all unneccesary interrupts.
       Out  21h,Al


       Push BX
       Xor BX,BX
_loopla:
       Mov DX,03C8h
       Mov AL,1
       Out DX,AL
       Inc DX
       Mov AL,BL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Xor AL,AL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Mov AL,BL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Mov CX,3
       Mov DX,03DAh
_vertel:
       In AL,DX
       Test AL,8
       Je _vertel
_vertel2:
       In AL,DX
       Test AL,8
       Jne _vertel2
       Loop _Vertel
       Inc BL
       Cmp BL,64
       Jne _loopla

       Pop BX
_loooooop:
       Mov DX,03DAh
       In AL,DX
       Test AL,8
       Je _loooooop
_vertical_r:
       In AL,DX
       Test AL,8
       Jne _vertical_r

       Dec tuner_delay
       Je _not_not_new_text
       Jmp _not_new_text
_not_not_new_text:
       Mov byte ptr tuner_delay,3
       Mov DX,03C8h
       Mov AL,1
       Out DX,AL
       Inc DX
       Cmp Word ptr plane,1
       Jne _second_up
       Mov AL,63
       Sub AL,col_number
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Mov AL,col_number
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Inc col_number
       Jmp _Keyboard
_second_up:
       Mov AL,col_number
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Mov AL,63
       Sub AL,col_number
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Inc col_number
_keyboard:
       Cmp Byte ptr col_number,63
       Jne _not_new_text
       Mov Byte ptr col_number,0
       Mov Word ptr x_point,0
       Mov Word ptr y_point,10
       Call Write_Pop_Up
       Mov CX,35
_vertical_r2:
       Mov DX,03DAh
       In AL,DX
       Test AL,8
       Je _vertical_r2
_vertical_r3:
       In AL,DX
       Test AL,8
       Jne _vertical_r3
       Loop _vertical_r2
       Lea AX,pop_up_text_ends
       Cmp BX,AX
       Jnb _slut_i_rutan

_not_finne:
       Cmp Word ptr plane,2
       Jne _plane_1
       Mov Word ptr plane,1
       Jmp _not_new_text
_plane_1:
       Mov Word ptr plane,2
_not_new_text:
       In AL,60h
       Cmp AL,28
       Je _slut_i_rutan
       Jmp _loooooop
_slut_i_rutan:

       Mov BX,63
_looopla:
       Mov DX,03C8h
       Mov AL,1
       Out DX,AL
       Inc DX
       Mov AL,BL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Xor AL,AL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Mov AL,BL
       Out DX,AL
       Out DX,AL
       Out DX,AL
       Mov CX,3
       Mov DX,03DAh
_verti_el:
       In AL,DX
       Test AL,8
       Je _verti_el
_verti_el2:
       In AL,DX
       Test AL,8
       Jne _verti_el2
       Loop _Verti_el
       Dec BL
       Jne _looopla


       Call _X_Hide_SplitScreen
       Mov DX,03D4h
       Mov AX,000dh
       Out DX,AX
       Mov AX,000Ch
       Out DX,AX
       Mov AX,0003h
       Int 10h
       ASSUME DS:_DATA
       Pop DS
       RetF
EndP   Intro

DISPLAY "ASSEMBLED"

_Code4  EndS


include test6.asm