.TH REF 1
.SH NAME
ref - Display a C function header
.SH SYNOPSIS
\fBref\fR [-t] [-x] [-c \fIclass\fR]... [-f \fIfile\fR]... \fItag\fR
.SH DESCRIPTION
\fIref\fP quickly locates and displays the header of a function.
To do this, \fIref\fR
looks in the "tags" file for the line that describes the function, and then 
scans the source file for the function.
When it locates the function, it displays an introductory comment
(if there is one), the function's declaration, and the declarations of all
arguments.
.SH "SEARCH METHOD"
.PP
\fIref\fR uses a fairly sophisticated tag look-up algorithm.
If you supply a filename via \fB-f\fR \fIfile\fR, then elvis first scans
the tags file for a static tag from that file.
This search is limited to the tags file in the current directory.
.PP
If you supply a classname via \fB-c\fR \fIclass\fR, then elvis searches
for a tag from that class.
This search is not limited to the current directory;
You can supply a list of directories in the environment variable \fITAGPATH\fR,
and \fIref\fR will search through the "tags" file in each directory until it finds
a tag in the desired class.
.PP
If that fails, \fIref\fR will then try to look up an ordinary global tag.
This search checks all of the directories listed in \fITAGPATH\fR, too.
If the tag being sought doesn't contain any colons, and you haven't given
a -x flag, then any static tags in a tags file will be treated as global
tags.
.PP
If you've given the \fB-t\fR flag, then \fIref\fR will simply output the tag line that
it found, and then exit.
Without \fB-t\fR, though, \fIref\fR will search for the tag line.
It will try to open the source file, which should be in the same directory
as the tags file where the tag was discovered.
If the source file doesn't exist, or is unreadable, then \fIref\fR will try to open
a file called "\fIrefs\fR" in that directory.
Either way, \fIref\fR will try to locate the tag, and display whatever it finds.
.SH "INTERACTION WITH ELVIS"
.PP
\fIref\fP is used by \fIelvis\fR' shift-K command.
If the cursor is located on a word such as "splat", in the file "foo.c",
then \fIelvis\fR will invoke \fIref\fR with the command "ref -f foo.c splat".
.PP
If \fIelvis\fR has been compiled with the -DEXTERNAL_TAGS flag, then \fIelvis\fR will
use \fIref\fR \fB\fRto scan the tags files.
This is slower than the built-in tag searching, but it allows \fIelvis\fR to access
the more sophisticated tag lookup provided by \fIref\fR.
Other than that, external tags should act exactly like internal tags.
.SH OPTIONS
.IP \fB-t\fR
Output tag info, instead of the function header.
.IP "\fB-f\fR \fIfile\fR"
The tag might be a static function in \fIfile\fR.
You can use several -f flags to have \fIref\fR consider static tags from more than one file.
.IP "\fB-c\fR \fIclass\fR"
The tag might be a member of class \fIclass\fR.
You can use several -c flags to have \fIref\fR consider tags from more than one class.
.SH FILES
.IP \fBtags\fR
List of function names and their locations, generated by \fIctags\fR.
.IP \fBrefs\fR
Function headers extracted from source files (optional).
.SH ENVIRONMENT
.IP \fBTAGPATH\fR
List of directories to be searched.
The elements in the list are separated by either
semicolons (for MS-DOS, Atari TOS, and AmigaDos), or
by colons (every other operating system).
For each operating system, \fIref\fR has a built-in default which is probably
adequate.
.SH NOTES
.PP
You might want to generate a "tags" file the directory that contains the
source code for standard C library on your system.
If licensing restrictions prevent you from making the library source readable
by everybody, then you can have \fIctags\fR generate a "refs" file,
and make "refs" readable by everybody.
.PP
If your system doesn't come with the library source code, then perhaps you
can produce something workable from the \fIlint\fR libraries.
.SH "SEE ALSO"
elvis(1), ctags(1)
.SH AUTHOR
.nf
Steve Kirkendall
kirkenda@cs.pdx.edu
.fi
