#
# Makefile for tde 4.0 in the Linux environment.
# June 5, 1994, Frank Davis
#
#  make -f linuxtde.mak
#
#  manually put the tde executable in /usr/bin or /usr/local/bin
#
# works with gcc 2.4.5 and ncurses 1.8.5
#
#

CFLAGS  = -O2 -m486 -D__UNIX__ -DNDEBUG -Wall
#CFLAGS = -g -D__UNIX__ -DNDEBUG -Wall
#CFLAGS = -g -D__UNIX__  -Wall
MO_LIBS = -lncurses


OBJS = bj_ctype.o block.o capslock.o config.o console.o criterr.o diff.o \
       dirlist.o ed.o file.o findrep.o hwind.o main.o macro.o port.o pull.o \
       regx.o sort.o tab.o tdeasm.o utils.o window.o wordwrap.o


tde: $(OBJS)
	$(CC) -o tde $(OBJS) $(MO_LIBS)


bj_ctype.o:  bj_ctype.c tdestr.h common.h tdefunc.h define.h

block.o:     block.c tdestr.h common.h tdefunc.h define.h

capslock.o:  capslock.c tdestr.h common.h tdefunc.h define.h

config.o:    config.c tdestr.h common.h tdefunc.h define.h cfgfile.h

console.o:   console.c tdestr.h common.h tdefunc.h define.h

criterr.o:   criterr.c tdestr.h common.h tdefunc.h define.h criterr.h

diff.o:      diff.c tdestr.h common.h tdefunc.h define.h

dirlist.o:   dirlist.c tdestr.h common.h define.h tdefunc.h

ed.o:        ed.c tdestr.h global.h tdefunc.h define.h default.h prompts.h

file.o:      file.c tdestr.h common.h tdefunc.h define.h

findrep.o:   findrep.c tdestr.h common.h tdefunc.h define.h

hwind.o:     hwind.c tdestr.h common.h tdefunc.h define.h

macro.o:     macro.c tdestr.h common.h tdefunc.h define.h

main.o:      main.c tdestr.h common.h tdefunc.h define.h default.h help.h

port.o:      port.c tdestr.h common.h tdefunc.h define.h

pull.o:      pull.c tdestr.h common.h tdefunc.h define.h

regx.o:      regx.c tdestr.h common.h tdefunc.h define.h

sort.o:      sort.c tdestr.h common.h tdefunc.h define.h

tab.o:       tab.c tdestr.h common.h tdefunc.h define.h

tdeasm.o:    tdeasm.c tdestr.h common.h tdefunc.h define.h

utils.o:     utils.c tdestr.h common.h tdefunc.h define.h

window.o:    window.c tdestr.h common.h tdefunc.h define.h

wordwrap.o:  wordwrap.c tdestr.h common.h tdefunc.h define.h
