#include "\apps\bc\doom\dmcheck.hpp"
FILE *stream;
unsigned a_date,a_time;
struct text_info cur_mode;
int err_code = 0;
int quiet = FALSE;
int list_ver = FALSE;
int get_help = FALSE;
int debug_on = FALSE;
int min_switch = FALSE;
int move_up = FALSE;
int do_bells = TRUE;
int i,j,k,l;
long wadsize,exesize = 0;
long today,creation;
int days_old;
char *waddate,*exedate = "00/00/00";
char *wadtime,*exetime = "00:00:00";
int wadnum,exenum = 0;
int more_than_one = 0;
char c,d,e;
char *p,*q,*s,*t,*u;
int argc;
int hour,minute,second,year,month,day;
char *argpass[20];
struct find_t aDir[5];
struct dfree aFreeSpace;
struct dosdate_t current_date;
long filesize = 0;
char *filedate = "";
char *filetime = "";

/*************************************************************************
*** r_error terminates program displays message with returned          ***
*** errorlevel code and exits program to DOS                           ***
*************************************************************************/

void r_error()
{
    if (debug_on)
        printf("\nReturning ERRORLEVEL code of %i.",err_code);
    _setcursortype(_NORMALCURSOR);
    if (quiet || min_switch) printf("\n");
    exit(err_code);
}




/*************************************************************************
*** error_messsage displays an error and exits.                        ***
*************************************************************************/

void error_message(char *str)
{
    err_code = 255;
    s = "this is only a long string to hold the string passed to this function";
    strcpy(s,str);
    str[0] = strlwr(s)[0];
    if (!quiet) printf("\n\n*** ERROR, %s! ***",str);
    if (do_bells) printf("\a");
    r_error();
}



/*************************************************************************
*** prnt_mess displays the initial information lines about DMCHECK.    ***
*************************************************************************/

void prnt_mess()
{
    if (!min_switch)
    {
        printf("DMCHECK ver %s %s by Jean-Serge Gagnon <az589@freenet.carleton.ca>",
            VERSION_NUM,VERSION_DATE);
        printf("\nCheck DOOM version, disk space, change/check file date/time & ask question.");
    }
    return;
}

/*************************************************************************
*** prnt_usage will inform the user of the usage when type /h alone    ***
*** or no parameters at all.                                           ***
*************************************************************************/

void prnt_usage()
{
    printf("\n\nUsage is as follows:\n\n");
    printf("DMCHECK [/H | /Q] [/D] [/B] [/M] [/U] [[function [parameters]] | /L]\n\n");
    printf("function is Ask, Date, File, Space, Version or Which as below:\n\n");
    printf("DMCHECK [/H] [/D] [/B] [/M] [/U] /L\n");
    printf("DMCHECK [/H | /Q] [/D] [/B] [/M] [/U] A[sk] [[question] replies]]\n");
    printf("DMCHECK [/H | /Q] [/D] [/B] [/M] [/U] D[ate] filename [[NOW] | [date time]]\n");
    printf("DMCHECK [/H | /Q] [/D] [/B] [/M] [/U] F[ile] filename [size [date [time]]]\n");
    printf("DMCHECK [/H | /Q] [/D] [/B] [/M] [/U] S[pace] [Drive] NeededSpace\n");
    printf("DMCHECK [/H | /Q] [/D] [/B] [/M] [/U] V[ersion] DOOMversion\n");
    printf("DMCHECK [/H | /Q] [/D] [/B] [/M] [/U] W[hich]");
    return;
}


/*************************************************************************
*** usage tells user of the usage and exits.                           ***
*************************************************************************/

void usage()
{
    min_switch = FALSE;
    if (quiet) prnt_mess();
    prnt_usage();
    printf("\n\nUse \"DMCHECK /H\" for general help.");
    err_code = 0;
    r_error();
}


/*************************************************************************
*** strcommas retunrs a string with commas in the thousands and        ***
*** millions position of a long integer.                               ***
*************************************************************************/

char *strcommas(long value)
{
    s = "123456789123456789";
    s = ltoa(value,s,10);
    i = strlen(s);
    if (i < 4) return s;
    s[i+1] = s[i];
    s[i] = s[i-1];
    s[i-1] = s[i-2];
    s[i-2] = s[i-3];
    s[i-3] = ',';
    if (i < 7) return s;
    s[i+2] = s[i+1];
    s[i+1] = s[i];
    s[i] = s[i-1];
    s[i-1] = s[i-2];
    s[i-2] = s[i-3];
    s[i-3] = s[i-4];
    s[i-4] = s[i-5];
    s[i-5] = s[i-6];
    s[i-6] = ',';
    if (i < 10) return s;
    s[i+3] = s[i+2];
    s[i+2] = s[i+1];
    s[i+1] = s[i];
    s[i] = s[i-1];
    s[i-1] = s[i-2];
    s[i-2] = s[i-3];
    s[i-3] = s[i-4];
    s[i-4] = s[i-5];
    s[i-5] = s[i-6];
    s[i-6] = s[i-7];
    s[i-7] = s[i-8];
    s[i-8] = s[i-9];
    s[i-9] = ',';
    if (i < 13) return s;
    s[i+4] = s[i+3];
    s[i+3] = s[i+2];
    s[i+2] = s[i+1];
    s[i+1] = s[i];
    s[i] = s[i-1];
    s[i-1] = s[i-2];
    s[i-2] = s[i-3];
    s[i-3] = s[i-4];
    s[i-4] = s[i-5];
    s[i-5] = s[i-6];
    s[i-6] = s[i-7];
    s[i-7] = s[i-8];
    s[i-8] = s[i-9];
    s[i+9] = s[i+10];
    s[i+10] = s[i+11];
    s[i+11] = s[i+12];
    s[i+12] = ',';
    return s;
}







/*************************************************************************
*** strdosdate returns a string containing a date in format 'MM-DD-YY' ***
*** and requires a dos file stream to get it.                          ***
*************************************************************************/

char *strdosdate(unsigned dosdate)
{
    s = "00-00-00";
    sprintf(s,"%#02u-%#02u-%#02u",(_DOSMONTHBITS & dosdate)/32,(_DOSDAYBITS & dosdate),
        (_DOSYEARBITS & dosdate)/512+80);
    return s;
}


/*************************************************************************
*** strdostime returns a string containing a date in format 'HH:MM:DD' ***
*** and requires a dos file stream to get it.                          ***
*************************************************************************/

char *strdostime(unsigned dostime)
{
    s = "00:00:00";
    sprintf(s,"%#02u:%#02u:%#02u",(_DOSHOURBITS & dostime)/2048,
        (_DOSMINUTEBITS & dostime)/32,(_DOSSECONDBITS & dostime)*2);
    return s;
}




/*************************************************************************
*** todosdate returns an unsigned integer representing the date based  ***
*** on the DOS format.                                                 ***
*************************************************************************/

unsigned todosdate(char *str)
{
    return ((unsigned) (atoi(str+6)-80)*512 + (unsigned) atoi(str)*32 +
        (unsigned) atoi(str+3));
}



/*************************************************************************
*** todostime returns an unsigned integer representing the time based  ***
*** on the DOS format.                                                 ***
*************************************************************************/

unsigned todostime(char *str)
{
    return ((unsigned) atoi(str)*2048 + (unsigned) atoi(str+3)*32 +
        (unsigned) atoi(str+6)/2);
}





/*************************************************************************
*** show_where simply displays where a new version of DMCHECK can be   ***
*** found.                                                             ***
*************************************************************************/

void show_where()
{
    if (days_old>120 && !quiet)
    {
        printf("\n\nSince this version of DMCHECK is older than 120 days, you may want to check\n");
        printf("for a more recent version of DMCHECK on the DOOM  utility FTP archive site\n");
        printf("\"ftp.cdrom.com\" (or any  of it's mirrors) or check the  offical\n");
        printf("BBS for DMCHECK; Synapse at (819) 246-2344.");
    }
    return;
}



/*************************************************************************
*** wrong_paramter informs user of a faulty parameter in the           ***
*** invocation of the program and exits.                               ***
*************************************************************************/

void wrong_parameter(char *str)
{
    if (quiet) prnt_mess();
    min_switch = FALSE;
    s = "this is only a long string to hold the string passed to this function";
    strcpy(s,str);
    str[0] = strupr(s)[0];
    printf("\n\n*** ERROR *** Invalid Parameter! %s! ",str);
    if (strlen(s) > 23 && !quiet) printf("\n");
    printf("Use /H alone for help!");
    if (do_bells) printf("\a");
    err_code = 255;
    r_error();
}


/*************************************************************************
*** Ver_listing displays all the DOOM versions data.                   ***
*************************************************************************/

void ver_listing()
{
    int i;
    if (quiet)
    {
        prnt_mess();
        wrong_parameter("Don't use /Q with /L");
    }
    if (argpass[1][0] != '\0') wrong_parameter("Use \"/L\" alone");
    printf("\n\n      DOOM                  DOOM.WAD                  DOOM.EXE      returned\n");
    printf("    version          size     date     time     size    date     time     error\n");
    printf(" 1.0 shareware     ");
    printf("%10s %s %s",strcommas(D10SHA_WADSIZE),D10SHA_WADDATE,D10SHA_WADTIME);
    printf("%8s %s %s  1\n",strcommas(D10SHA_EXESIZE),D10SHA_EXEDATE,D10SHA_EXETIME);
    printf(" 1.1 shareware     ");
    printf("%10s %s %s",strcommas(D11SHA_WADSIZE),D11SHA_WADDATE,D11SHA_WADTIME);
    printf("%8s %s %s  2\n",strcommas(D11SHA_EXESIZE),D11SHA_EXEDATE,D11SHA_EXETIME);
    printf(" 1.1 registered    ");
    printf("%10s %s %s",strcommas(D11REG_WADSIZE),D11REG_WADDATE,D11REG_WADTIME);
    printf("%8s %s %s  2\n",strcommas(D11REG_EXESIZE),D11REG_EXEDATE,D11REG_EXETIME);
    printf(" 1.2 shareware     ");
    printf("%10s %s %s",strcommas(D12SHA_WADSIZE),D12SHA_WADDATE,D12SHA_WADTIME);
    printf("%8s %s %s  3\n",strcommas(D12SHA_EXESIZE),D12SHA_EXEDATE,D12SHA_EXETIME);
    printf(" 1.2 registered    ");
    printf("%10s %s %s",strcommas(D12REG_WADSIZE),D12REG_WADDATE,D12REG_WADTIME);
    printf("%8s %s %s  3\n",strcommas(D12REG_EXESIZE),D12REG_EXEDATE,D12REG_EXETIME);
    printf(" 1.2 ZONE          ");
    printf("%10s %s %s",strcommas(DPCZON_WADSIZE),DPCZON_WADDATE,DPCZON_WADTIME);
    printf("%8s %s %s 30\n",strcommas(DPCZON_EXESIZE),DPCZON_EXEDATE,DPCZON_EXETIME);
    printf(" 1.25 Sybex        ");
    printf("%10s %s %s",strcommas(DSYBEX_WADSIZE),DSYBEX_WADDATE,DSYBEX_WADTIME);
    printf("%8s %s %s 31\n",strcommas(DSYBEX_EXESIZE),DSYBEX_EXEDATE,DSYBEX_EXETIME);
    printf(" 1.4 beta shar.    ");
    printf("%10s %s %s",strcommas(D14BET_WADSIZE),D14BET_WADDATE,D14BET_WADTIME);
    printf("%8s %s %s  4\n",strcommas(D14BET_EXESIZE),D14BET_EXEDATE,D14BET_EXETIME);
    printf(" 1.5 beta shar.    ");
    printf("%10s %s %s",strcommas(D15BET_WADSIZE),D15BET_WADDATE,D15BET_WADTIME);
    printf("%8s %s %s  5\n",strcommas(D15BET_EXESIZE),D15BET_EXEDATE,D15BET_EXETIME);
    printf(" 1.6 beta shar.    ");
    printf("%10s %s %s",strcommas(D16BET_WADSIZE),D16BET_WADDATE,D16BET_WADTIME);
    printf("%8s %s %s  6\n",strcommas(D16BET_EXESIZE),D16BET_EXEDATE,D16BET_EXETIME);
    printf(" 1.666 shareware   ");
    printf("%10s %s %s",strcommas(D166SH_WADSIZE),D166SH_WADDATE,D166SH_WADTIME);
    printf("%8s %s %s  7\n",strcommas(D166SH_EXESIZE),D166SH_EXEDATE,D166SH_EXETIME);
    printf(" 1.666 registered  ");
    printf("%10s %s %s",strcommas(D166RE_WADSIZE),D166RE_WADDATE,D166RE_WADTIME);
    printf("%8s %s %s  7\n",strcommas(D166RE_EXESIZE),D166RE_EXEDATE,D166RE_EXETIME);
    printf(" 1.7 shareware     ");
    printf("(Data unavailable for now. Let me know if you have it!)\n");
/*
    printf("%10s %s %s",strcommas(D17SHA_WADSIZE),D17SHA_WADDATE,D17SHA_WADTIME);
    printf("%8s %s %s  8\n",strcommas(D17SHA_EXESIZE),D17SHA_EXEDATE,D17SHA_EXETIME);
*/
    printf(" 1.7 registered    ");
    printf("(Data unavailable for now. Let me know if you have it!)\n");
/*
    printf("%10s %s %s",strcommas(D17REG_WADSIZE),D17REG_WADDATE,D17REG_WADTIME);
    printf("%8s %s %s  8\n",strcommas(D17REG_EXESIZE),D17REG_EXEDATE,D17REG_EXETIME);
*/
    printf(" 1.7a shareware    ");
    printf("%10s %s %s",strcommas(D17ASH_WADSIZE),D17ASH_WADDATE,D17ASH_WADTIME);
    printf("%8s %s %s  9\n",strcommas(D17ASH_EXESIZE),D17ASH_EXEDATE,D17ASH_EXETIME);
    printf(" 1.7a registered   ");
    printf("%10s %s %s",strcommas(D17ARE_WADSIZE),D17ARE_WADDATE,D17ARE_WADTIME);
    printf("%8s %s %s  9\n",strcommas(D17ARE_EXESIZE),D17ARE_EXEDATE,D17ARE_EXETIME);
    printf(" 1.8 shareware     ");
    printf("%10s %s %s",strcommas(D18SHA_WADSIZE),D18SHA_WADDATE,D18SHA_WADTIME);
    printf("%8s %s %s 10\n",strcommas(D18SHA_EXESIZE),D18SHA_EXEDATE,D18SHA_EXETIME);
    printf(" 1.8 registered    ");
    printf("%10s %s %s",strcommas(D18REG_WADSIZE),D18REG_WADDATE,D18REG_WADTIME);
    printf("%8s %s %s 10\n",strcommas(D18REG_EXESIZE),D18REG_EXEDATE,D18REG_EXETIME);
    if (cur_mode.screenheight < 26)
    {
        printf("(-More-)");
        while (i!=13 && i!='Y' && i!='y' && i!='Q'
            && i!='q' && i!='N' &&i!='n' && i!=' ')
            i = getch();
        printf("\n");
    }
    else
        i = 'Y';
    if (i!='n' && i!='N' && i!='q' && i!='Q')
    {
        printf(" 1.9 shareware     ");
        printf("%10s %s %s",strcommas(D19SHA_WADSIZE),D19SHA_WADDATE,D19SHA_WADTIME);
        printf("%8s %s %s 11\n",strcommas(D19SHA_EXESIZE),D19SHA_EXEDATE,D19SHA_EXETIME);
        printf(" 1.9 registered    ");
        printf("%10s %s %s",strcommas(D19REG_WADSIZE),D19REG_WADDATE,D19REG_WADTIME);
        printf("%8s %s %s 11\n",strcommas(D19REG_EXESIZE),D19REG_EXEDATE,D19REG_EXETIME);
        printf(" ][ pirate copy    ");
        printf("%10s %s %s",strcommas(D2_PIR_WADSIZE),D2_PIR_WADDATE,D2_PIR_WADTIME);
        printf("%8s %s %s 19\n",strcommas(D2_PIR_EXESIZE),D2_PIR_EXEDATE,D2_PIR_EXETIME);
        printf(" ][ v1.666         ");
        printf("%10s %s %s",strcommas(D2_166_WADSIZE),D2_166_WADDATE,D2_166_WADTIME);
        printf("%8s %s %s 20\n",strcommas(D2_166_EXESIZE),D2_166_EXEDATE,D2_166_EXETIME);
        printf(" ][ v1.7           ");
        printf("%10s %s %s",strcommas(D2_17C_WADSIZE),D2_17C_WADDATE,D2_17C_WADTIME);
        printf("%8s %s %s 21\n",strcommas(D2_17C_EXESIZE),D2_17C_EXEDATE,D2_17C_EXETIME);
        printf(" ][ v1.7a          ");
        printf("%10s %s %s",strcommas(D2_17A_WADSIZE),D2_17A_WADDATE,D2_17A_WADTIME);
        printf("%8s %s %s 22\n",strcommas(D2_17A_EXESIZE),D2_17A_EXEDATE,D2_17A_EXETIME);
        printf(" ][ v1.8           ");
        printf("%10s %s %s",strcommas(D2_18C_WADSIZE),D2_18C_WADDATE,D2_18C_WADTIME);
        printf("%8s %s %s 23\n",strcommas(D2_18C_EXESIZE),D2_18C_EXEDATE,D2_18C_EXETIME);
        printf(" ][ v1.9           ");
        printf("%10s %s %s",strcommas(D2_19C_WADSIZE),D2_19C_WADDATE,D2_19C_WADTIME);
        printf("%8s %s %s 24",strcommas(D2_19C_EXESIZE),D2_19C_EXEDATE,D2_19C_EXETIME);
    }
    err_code = 0;
    r_error();
}






/*************************************************************************
*** help_screen displays any help the user wants to see.               ***
*************************************************************************/

void help_screen()
{
    i = strlen(argpass[1]);
    err_code = 0;
    if (((quiet || list_ver) && i != 0) || (quiet && list_ver))
        wrong_parameter("Too many parameters");
    if (quiet) prnt_mess();
    if (min_switch)
    {
        min_switch = FALSE;
        prnt_mess();
        min_switch = TRUE;
    }
    argpass[1] = strupr(argpass[1]);
    if (debug_on && i == 0 && !list_ver && !quiet && !move_up && !min_switch
        && do_bells)
    {
        printf("\n\nDMCHECK /D [...]\n\n");
        printf("    Debug switch is used to display certain  information like the ERRORLEVEL\n");
        printf("    code being  returned. It has  no really useful  reason for  being except\n");
        printf("    maybe for me.");
    } else
    {
        if ((move_up && min_switch) || (move_up && !do_bells) ||
            (move_up && list_ver) || (!do_bells && list_ver) || 
            (list_ver && min_switch))
            wrong_parameter("You want help on what");
        if (move_up)
        {
            printf("\n\nDMCHECK /U [...]\n\n");
            printf("    This switch  will simply make DMCHECK not print a blank line after running\n");
            printf("    itself. This is normally caused by DOS, so in a batch file there will be a\n");
            printf("    blank line between each commands unless you use this switch.");
        } else
        {
            if (min_switch)
            {
                printf("\n\nDMCHECK /M [/H] [/D]\n\n");
                printf("    The Minimum  switch is used to suppress some information from the output\n");
                printf("    that DMCHECK would normally  generate. It is similar  to Quiet, but some\n");
                printf("    of  the  information is  diplayed. It  is  most usefull  for  the  WHICH\n");
                printf("    function so  that  the batch  file  can actually  display  the installed\n");
                printf("    without having to test the ERRORLEVEL code returned by it.");
            } else
                {
                if (list_ver)
                {
                    printf("\n\nDMCHECK /L [/H] [/D]\n\n");
                    printf("    Is used to display all  of the data  relating to  the different versions\n");
                    printf("    of DOOM. Use it to know the  exact size of all the DOOM.WAD and DOOM.EXE\n");
                    printf("    files as well as their date and time of creation for all the versions of\n");
                    printf("    DOOM that DMCHECK can test for.");
                } else
                {
                  if (!do_bells)
                  {
                    printf("\n\nDMCHECK /B [...]\n\n");
                    printf("    This switch  will simply prevent the  bell to  be ringed when  an error is\n");
                    printf("    encountered.\n");
                  } else
                  {
                    if (quiet)
                    {
                        printf("\n\nDMCHECK /Q [...]\n\n");
                        printf("    This  parameter is simply used  to suppress  the output  of the  DMCHECK\n");
                        printf("    command when it is used within batch files.");
                    } else
                    {
                      if (i == 0)
                      {
                          printf("\n\n");
                          if (days_old < 120)
                          {
                            printf("Get the latest version of DMCHECK from the Synapse BBS at (819)246-2344\n");
                            printf("    or from the offical DOOM FTP site; ftp.cdrom.com\n\n");
                        }
                        printf("DMCHECK [/H | /Q] [/D] [/B] [/M] [/U] [[function [parameters]] | /L]\n\n");
                        printf("[none]  Use no parameters to get complete usage message.\n");
                        printf("/Q      Do not display output (except for help and syntax errors).\n");
                        printf("/H      Display this help screen or additional help on any other\n");
                        printf("        function if used at the same time as that function.\n");
                        printf("/D      Debugging that permits certain messages.\n");
                        printf("/L      List all data used by DMCHECK of all DOOM versions.\n\n");
                        printf("/B      The bell switch disables the speaker for errors.\n");
                        printf("/M      The Minimum switch displays less information.\n");
                        printf("/U      Move up command prevents DOS from adding a blank line.\n");
                        printf("Ask     Display a question and wait for a key press.\n");
                        printf("Date    Change or display date and time of one or more files.\n");
                        printf("File    Permits testing file size, date and time.\n");
                        printf("Space   Check if there is enough free bytes on a drive.\n");
                        printf("Version Test for existance of a particular version of DOOM.\n");
                        printf("Which   Returns the DOOM version as an ERRORLEVEL code.");
                    } else
                    {
                      if ((i == 1 && !strcmp(argpass[1],"S")) || !strcmp(argpass[1],"SPACE"))
                      {
                          printf("\n\nDMCHECK [/Q | /H] [/D] S[pace] [Drive] NeededSpace\n\n");
                          printf("    Used to determins if there is  enough free disk space on  a specified or\n");
                          printf("    on the  current  drive. \"DMCHECK S 1000\" will  tell  you if there  is at\n");
                          printf("    least 1000 bytes free on the current drive or \"DMCHECK S L: 10,000\" will\n");
                          printf("    test drive L:  instead. Additionally, you  may have noticed  that commas\n");
                          printf("    are permited in the [NeededSpace] field. When using batch files, DMCHECK\n");
                          printf("    will return an ERRORLEVEL of 1 if there is less than [NeededSpace] bytes\n");
                          printf("    on the specified (or current) drive or 0 if there is  at least that much\n");
                          printf("    free space. In the case of an error accessing the drive, the  ERRORLEVEL\n");
                          printf("    code returned will be 255.");
                      } else
                      {
                        if ((i == 1 && !strcmp(argpass[1],"V")) || !strcmp(argpass[1],"VERSION"))
                        {
                            printf("\n\nDMCHECK [/Q | /H] [/D] V[ersion] DOOMversion\n\n");
                            printf("    This will permit  you to  test if  the  installed  copy of  DOOM is  the\n");
                            printf("    version you need. You can also use this feature to test for a registered\n");
                            printf("    or a shareware version. You may  test for these  version: 1.0, 1.1, 1.2,\n");
                            printf("    1.2ZONE  (from the  PC-ZONE  magazine CD),  1.4Beta,  1.5Beta,  1.6Beta,\n");
                            printf("    1.666 or  a version of DOOM ][  using the same versions  but with the ][\n");
                            printf("    in front. For example,  by using \"DMCHECK V 1.666\"  an  ERRORLEVEL  of 0\n");
                            printf("    would be returned if the installed version of DOOM was 1.666, 1 if it is\n");
                            printf("    a not 1.666, or 2 if it is only the  shareware version of 1.666. On  the\n");
                            printf("    other  hand, if there is no  valid  DOOM.WAD  file, then the  ERRORLEVEL\n");
                            printf("    code returned would be 255.");
                        } else
                        {
                          if ((i == 1 && !strcmp(argpass[1],"D")) || !strcmp(argpass[1],"DATE"))
                          {
                              printf("\n\nDMCHECK [/Q | /H] [/D] D[ate] filename [NOW | [date time]]\n\n");
                              printf("    This can be used to display the date and time of any file, but is mostly\n");
                              printf("    useful to  change the  date and time  of a file. It can  be used on  any\n");
                              printf("    file, but  it's  main use  would  be to  reset the date  and time of the\n");
                              printf("    DOOM.EXE or DOOM.WAD file to their original when a patch would otherwise\n");
                              printf("    have changed the date and time of those files. An ERRORLEVEL code of 255\n");
                              printf("    is returned if  the function  was unsuccessful. The  NOW parameter  will\n");
                              printf("    permit  you to  set the  date and  time of  the selected  file(s) to the\n");
                              printf("    current system date and time.");
                          } else
                          {
                            if ((i == 1 && !strcmp(argpass[1],"W")) || !strcmp(argpass[1],"WHAT") || !strcmp(argpass[1],"WHICH"))
                            {
                                printf("\n\nDMCHECK [/Q | /H] [/D] W[hich]\n\n");
                                printf("    If you need to know what version is installed  and don't want to use the\n");
                                printf("    V[ersion] function, then you can use  this. It's mostly useful  to check\n");
                                printf("    the existance of a version independantly of the fact that it is a regis-\n");
                                printf("    tered version. It  would mostly be  useful  if  you want to  run DMCHECK\n");
                                printf("    only once and then have a  bunch of \"IF\"s in your batch  file instead of\n");
                                printf("    running DMCHECK with  the V[ersion]  function many  times, which is more\n");
                                printf("    time consuming.  Please note  that if more than one version  of DOOM are\n");
                                printf("    installed in the  same directory, DMCHECK  will return  the code for the\n");
                                printf("    registered  version of DOOM 1.x,  then the shareware version of DOOM 1.x\n");
                                printf("    before reporting on the version of DOOM 2.x\n\n");
                                printf("    Ver 1.0       -> 1    Ver 1.1       -> 2    Ver 1.2       -> 3\n");
                                printf("    Ver 1.4Beta   -> 4    Ver 1.5Beta   -> 5    Ver 1.6Beta   -> 6\n");
                                printf("    Ver 1.666     -> 7\n");
                                printf("    DOOM ][ pirated copy   -> 19        PC-ZONE 1.2 CD-ROM    -> 30\n");
                                printf("    DOOM ][ first release  -> 20        SYBEX 1.25            -> 31\n");
                                printf("    DOOM ][ second release -> 21\n");
                                printf("    No valid DOOM[1 | 2].WAD and/or DOOM[2].EXE file present  ->255");
                            } else
                            {
                              if ((i == 1 && !strcmp(argpass[1],"A")) || !strcmp(argpass[1],"ASK"))
                              {
                                  printf("\n\nDMCHECK [/Q | /H] [/D] A[sk] [ [question] replies]\n\n");
                                  printf("    This is very similar to many other batch file enhancers and was included\n");
                                  printf("    for functionality. You may use it to prompt the user for a question like\n");
                                  printf("    \"Do you wish to keep a backup of DOOM.WAD?\" and wait for a Yes/No answer\n");
                                  printf("    and continue the batch  file accordingly. It may also be  used to create\n");
                                  printf("    simple menus  by  preceeding the  DMCHECK  command with  multiple \"ECHO\"\n");
                                  printf("    statements  and  then  having the  DMCHECK command  with more  than  two\n");
                                  printf("    replies possible, you may  create a quick and simple menu  system. It is\n");
                                  printf("    also  possible  for the  user to  press  the [ESC] key.  The  ERRORLEVEL\n");
                                  printf("    returned will be 255  for [ESC] or the position of  the character in the\n");
                                  printf("    [replies] parameter.\n\n");
                                  printf("    DON'T FORGET TO USE DOUBLE QUOTES (\") FOR THE QUESTION DELIMITER!");
                              } else
                              {
                                if ((i == 1 && !strcmp(argpass[1],"F")) || !strcmp(argpass[1],"FILE"))
                                {
                                  printf("\n\nDMCHECK [/Q | /H] [/D] F[ile] filename [size [date [time]]]\n\n");
                                  printf("    This function is used to verify if a file matches  a series of criteria.\n");
                                  printf("    You may test only for  the file size, both  the size and date or for the\n");
                                    printf("    size, date and time of  a single  file. The ERRORLEVEL  returned will be\n");
                                    printf("    0 if there is a match, 1 if there isn't a match and 255 if the  file was\n");
                                    printf("    not available or non existant.");
                                  } else
                                  {
                                    printf("\n\n*** ERROR *** I don't understand this help request, please use \"DMCHECK /H\"\n");
                                    printf("              for general help or \"DMCHECK\" for a general usage message.");
                                    if (do_bells) printf("\a");
                                    prnt_usage();
                                    err_code = 255;
                                  }
                                }
                              }
                            }
                          }
                        }
                      }
                   }
                }
              }
           }
        }
    }
r_error();
}




/*************************************************************************
*** get_version returns a possible version string based on exe and wad ***
*** file sizes.                                                        ***
*************************************************************************/

char *get_version()
{
    char *ver_str = " ERROR";
    if (wadsize == D2_PIR_WADSIZE && exesize == D2_PIR_EXESIZE)
        return "][P";
    if (wadsize == D2_166_WADSIZE && exesize == D2_166_EXESIZE)
        return "][1.666";
    if (wadsize == D2_17A_WADSIZE && exesize == D2_17A_EXESIZE)
        return "][1.7A";
    if (wadsize == D2_17C_WADSIZE && exesize == D2_17C_EXESIZE)
        return "][1.7";
    if (wadsize == D2_18C_WADSIZE && exesize == D2_18C_EXESIZE)
        return "][1.8";
    if (wadsize == D2_19C_WADSIZE && exesize == D2_19C_EXESIZE)
        return "][1.9";
    if (wadsize == DSYBEX_WADSIZE && exesize == DSYBEX_EXESIZE)
        return "1.25";
    if (wadsize == DPCZON_WADSIZE && exesize == DPCZON_EXESIZE)
        return "1.2Z";
    if ((wadsize == D19SHA_WADSIZE || wadsize == D19REG_WADSIZE ||
        exesize == D19SHA_EXESIZE || exesize == D19REG_EXESIZE) &&
        strcmp(waddate,D19SHA_WADDATE) == 0)
        return "1.9";
    if ((wadsize == D18SHA_WADSIZE || wadsize == D18REG_WADSIZE ||
        exesize == D18SHA_EXESIZE || exesize == D18REG_EXESIZE) &&
        strcmp(waddate,D18SHA_WADDATE) == 0)
        return "1.8";
    if ((wadsize == D17ASH_WADSIZE || wadsize == D17ARE_WADSIZE ||
        exesize == D17ASH_EXESIZE || exesize == D17ARE_EXESIZE) &&
        strcmp(waddate,D17ASH_WADDATE) == 0)
        return "1.7A";
    if ((wadsize == D17SHA_WADSIZE || wadsize == D17REG_WADSIZE ||
        exesize == D17SHA_EXESIZE || exesize == D17REG_EXESIZE) &&
        strcmp(waddate,D17SHA_WADDATE) == 0)
        return "1.7";
    if ((wadsize == D166SH_WADSIZE || wadsize == D166RE_WADSIZE ||
        exesize == D166SH_EXESIZE || exesize == D166RE_EXESIZE) &&
        strcmp(waddate,D166SH_WADDATE) == 0)
        return "1.666";
    if (wadsize == D16BET_WADSIZE || exesize == D16BET_EXESIZE)
        return "1.6";
    if (wadsize == D15BET_WADSIZE || exesize == D15BET_EXESIZE)
        return "1.5";
    if (wadsize == D14BET_WADSIZE || exesize == D14BET_EXESIZE)
        return "1.4";
    if (wadsize == D12SHA_WADSIZE || wadsize == D12REG_WADSIZE ||
        exesize == D12SHA_EXESIZE || exesize == D12REG_EXESIZE)
        return "1.2";
    if (wadsize == D11SHA_WADSIZE || wadsize == D11REG_WADSIZE ||
        exesize == D11SHA_EXESIZE || exesize == D11REG_EXESIZE)
        return "1.1";
    if (wadsize == D10SHA_WADSIZE || exesize == D10SHA_EXESIZE)
        return "1.0";
    if (wadsize == 0) return "NOWAD";
    if (exesize == 0) return "NOEXE";
    return ver_str;
}




/*************************************************************************
*** valid_version simply verifies the validity on the version string.  ***
*************************************************************************/

int valid_version(char *str)
{
    str = strupr(str);
    if (strcmp(str,"1.4BETA") == 0 || strcmp(str,"1.4B") == 0 ||
        strcmp(str,"1.4BT") == 0)
        str = "1.4";
    if (strcmp(str,"1.5BETA") == 0 || strcmp(str,"1.5B") == 0 ||
        strcmp(str,"1.5BT") == 0)
        str = "1.5";
    if (strcmp(str,"1.6BETA") == 0 || strcmp(str,"1.6B") == 0 ||
        strcmp(str,"1.6BT") == 0)
        str = "1.6";
    if (strcmp(str,"][S") == 0     || strcmp(str,"2S") == 0 ||
        strcmp(str,"2S") == 0      || strcmp(str,"2SECOND")==0 ||
        strcmp(str,"2.0S") == 0)
        str = "][1.666";
    if (strcmp(str,"][P") == 0     || strcmp(str,"2P") == 0 ||
        strcmp(str,"2PIR") == 0    || strcmp(str,"2PIRATE")==0 ||
        strcmp(str,"2.0P") == 0)
        str = "][P";
    if (strcmp(str,"1.2ZONE") == 0 || strcmp(str,"PCZONE") == 0 ||
        strcmp(str,"ZONE") == 0    || strcmp(str,"1.2PCZONE") == 0)
        str = "1.2Z";
    if (strcmp(str,"0.9") == 0) str = "1.0";
    if (strcmp(str,"1.0") == 0 || strcmp(str,"1.1") == 0 ||
        strcmp(str,"1.2") == 0 || strcmp(str,"1.4") == 0 ||
        strcmp(str,"1.5") == 0 || strcmp(str,"1.6") == 0 ||
        strcmp(str,"1.666") == 0 || strcmp(str,"1.7") == 0 ||
        strcmp(str,"1.7A") == 0 || strcmp(str,"1.8") == 0 ||
        strcmp(str,"1.9") == 0 || strcmp(str,"][P") == 0 ||
        strcmp(str,"][1.666") == 0 || strcmp(str,"][1.7") == 0 ||
        strcmp(str,"][1.7A") == 0 || strcmp(str,"][1.8") == 0 ||
        strcmp(str,"][1.9") == 0 || strcmp(str,"1.25") == 0 ||
        strcmp(str,"1.2Z") == 0)
        return TRUE;
    else
        return FALSE;
}





/*************************************************************************
***  isitver will return a booleen based on the check of the actual    ***
***  version installed.                                                ***
*************************************************************************/

int isitver(char *str)
{
    str = strupr(str);
    if (strcmp(str,"1.0") == 0)
        if (wadsize==D10SHA_WADSIZE && exesize==D10SHA_EXESIZE &&
            strcmp(waddate,D10SHA_WADDATE) == 0 &&
            strcmp(exedate,D10SHA_EXEDATE) == 0 &&
            strcmp(wadtime,D10SHA_WADTIME) == 0 &&
            strcmp(exetime,D10SHA_EXETIME) == 0)
            return TRUE;
    if (strcmp(str,"1.1") == 0)
        if ((wadsize==D11SHA_WADSIZE || wadsize==D11REG_WADSIZE) &&
            (exesize==D11SHA_EXESIZE || exesize==D11REG_EXESIZE) &&
            (strcmp(waddate,D11SHA_WADDATE) == 0 || strcmp(waddate,D11REG_WADDATE) == 0) &&
            (strcmp(exedate,D11SHA_EXEDATE) == 0 || strcmp(exedate,D11REG_EXEDATE) == 0) &&
            (strcmp(wadtime,D11SHA_WADTIME) == 0 || strcmp(wadtime,D11REG_WADTIME) == 0) &&
            (strcmp(exetime,D11SHA_EXETIME) == 0 || strcmp(exetime,D11REG_EXETIME) == 0))
            return TRUE;
    if (strcmp(str,"1.2") == 0)
        if ((wadsize==D12SHA_WADSIZE || wadsize==D12REG_WADSIZE) &&
            (exesize==D12SHA_EXESIZE || exesize==D12REG_EXESIZE) &&
            (strcmp(waddate,D12SHA_WADDATE) == 0 || strcmp(waddate,D12REG_WADDATE) == 0) &&
            (strcmp(exedate,D12SHA_EXEDATE) == 0 || strcmp(exedate,D12REG_EXEDATE) == 0) &&
            (strcmp(wadtime,D12SHA_WADTIME) == 0 || strcmp(wadtime,D12REG_WADTIME) == 0) &&
            (strcmp(exetime,D12SHA_EXETIME) == 0 || strcmp(exetime,D12REG_EXETIME) == 0))
            return TRUE;
    if (strcmp(str,"1.25") == 0)
        if (wadsize==DSYBEX_WADSIZE && exesize==DSYBEX_EXESIZE &&
            strcmp(waddate,DSYBEX_WADDATE) == 0 && strcmp(exedate,DSYBEX_EXEDATE) == 0 &&
            strcmp(wadtime,DSYBEX_WADTIME) == 0 && strcmp(exetime,DSYBEX_EXETIME) == 0)
            return TRUE;
    if (strcmp(str,"1.2Z") == 0)
        if (wadsize==DPCZON_WADSIZE && exesize==DPCZON_EXESIZE &&
            strcmp(waddate,DPCZON_WADDATE) == 0 && strcmp(exedate,DPCZON_EXEDATE) == 0 &&
            strcmp(wadtime,DPCZON_WADTIME) == 0 && strcmp(exetime,DPCZON_EXETIME) == 0)
            return TRUE;
    if (strcmp(str,"1.4") == 0)
        if (wadsize==D14BET_WADSIZE && exesize==D14BET_EXESIZE &&
            strcmp(waddate,D14BET_WADDATE) == 0 && strcmp(exedate,D14BET_EXEDATE) == 0 &&
            strcmp(wadtime,D14BET_WADTIME) == 0 && strcmp(exetime,D14BET_EXETIME) == 0)
            return TRUE;
    if (strcmp(str,"1.5") == 0)
        if (wadsize==D15BET_WADSIZE && exesize==D15BET_EXESIZE &&
            strcmp(waddate,D15BET_WADDATE) == 0 && strcmp(exedate,D15BET_EXEDATE) == 0 &&
            strcmp(wadtime,D15BET_WADTIME) == 0 && strcmp(exetime,D15BET_EXETIME) == 0)
            return TRUE;
    if (strcmp(str,"1.6") == 0)
        if (wadsize==D16BET_WADSIZE && exesize==D16BET_EXESIZE &&
            strcmp(waddate,D16BET_WADDATE) == 0 && strcmp(exedate,D16BET_EXEDATE) == 0 &&
            strcmp(wadtime,D16BET_WADTIME) == 0 && strcmp(exetime,D16BET_EXETIME) == 0)
            return TRUE;
    if (strcmp(str,"1.666") == 0)
        if ((wadsize==D166SH_WADSIZE || wadsize==D166RE_WADSIZE || wadsize==D166S2_WADSIZE) &&
            (exesize==D166SH_EXESIZE || exesize==D166RE_EXESIZE || exesize==D166S2_EXESIZE) &&
            (strcmp(waddate,D166SH_WADDATE) == 0 || strcmp(waddate,D166RE_WADDATE) == 0 ||
             strcmp(waddate,D166S2_WADDATE) == 0) &&
            (strcmp(exedate,D166SH_EXEDATE) == 0 || strcmp(exedate,D166RE_EXEDATE) == 0 ||
             strcmp(exedate,D166S2_EXEDATE) == 0) &&
            (strcmp(wadtime,D166SH_WADTIME) == 0 || strcmp(wadtime,D166RE_WADTIME) == 0 ||
             strcmp(wadtime,D166S2_WADTIME) == 0) &&
            (strcmp(exetime,D166SH_EXETIME) == 0 || strcmp(exetime,D166RE_EXETIME) == 0 ||
             strcmp(exetime,D166S2_EXETIME) == 0))
            return TRUE;
    if (strcmp(str,"1.7") == 0)
        if ((wadsize==D17SHA_WADSIZE || wadsize==D17REG_WADSIZE) &&
            (exesize==D17SHA_EXESIZE || exesize==D17REG_EXESIZE) &&
            (strcmp(waddate,D17SHA_WADDATE) == 0 || strcmp(waddate,D17REG_WADDATE) == 0) &&
            (strcmp(exedate,D17SHA_EXEDATE) == 0 || strcmp(exedate,D17REG_EXEDATE) == 0) &&
            (strcmp(wadtime,D17SHA_WADTIME) == 0 || strcmp(wadtime,D17REG_WADTIME) == 0) &&
            (strcmp(exetime,D17SHA_EXETIME) == 0 || strcmp(exetime,D17REG_EXETIME) == 0))
            return TRUE;
    if (strcmp(str,"1.7A") == 0)
        if ((wadsize==D17ASH_WADSIZE || wadsize==D17ARE_WADSIZE) &&
            (exesize==D17ASH_EXESIZE || exesize==D17ARE_EXESIZE) &&
            (strcmp(waddate,D17ASH_WADDATE) == 0 || strcmp(waddate,D17ARE_WADDATE) == 0) &&
            (strcmp(exedate,D17ASH_EXEDATE) == 0 || strcmp(exedate,D17ARE_EXEDATE) == 0) &&
            (strcmp(wadtime,D17ASH_WADTIME) == 0 || strcmp(wadtime,D17ARE_WADTIME) == 0) &&
            (strcmp(exetime,D17ASH_EXETIME) == 0 || strcmp(exetime,D17ARE_EXETIME) == 0))
            return TRUE;
    if (strcmp(str,"1.8") == 0)
        if ((wadsize==D18SHA_WADSIZE || wadsize==D18REG_WADSIZE) &&
            (exesize==D18SHA_EXESIZE || exesize==D18REG_EXESIZE) &&
            (strcmp(waddate,D18SHA_WADDATE) == 0 || strcmp(waddate,D18REG_WADDATE) == 0) &&
            (strcmp(exedate,D18SHA_EXEDATE) == 0 || strcmp(exedate,D18REG_EXEDATE) == 0) &&
            (strcmp(wadtime,D18SHA_WADTIME) == 0 || strcmp(wadtime,D18REG_WADTIME) == 0) &&
            (strcmp(exetime,D18SHA_EXETIME) == 0 || strcmp(exetime,D18REG_EXETIME) == 0))
            return TRUE;
    if (strcmp(str,"1.9") == 0)
        if ((wadsize==D19SHA_WADSIZE || wadsize==D19REG_WADSIZE) &&
            (exesize==D19SHA_EXESIZE || exesize==D19REG_EXESIZE) &&
            (strcmp(waddate,D19SHA_WADDATE) == 0 || strcmp(waddate,D19REG_WADDATE) == 0) &&
            (strcmp(exedate,D19SHA_EXEDATE) == 0 || strcmp(exedate,D19REG_EXEDATE) == 0) &&
            (strcmp(wadtime,D19SHA_WADTIME) == 0 || strcmp(wadtime,D19REG_WADTIME) == 0) &&
            (strcmp(exetime,D19SHA_EXETIME) == 0 || strcmp(exetime,D19REG_EXETIME) == 0))
            return TRUE;
    if (strcmp(str,"][P") == 0 || strcmp(str,"2.0P") == 0)
        if (wadsize==D2_PIR_WADSIZE && exesize==D2_PIR_EXESIZE &&
            strcmp(waddate,D2_PIR_WADDATE) == 0 && strcmp(exedate,D2_PIR_EXEDATE) == 0 &&
            strcmp(wadtime,D2_PIR_WADTIME) == 0 && strcmp(exetime,D2_PIR_EXETIME) == 0)
            return TRUE;
    if (strcmp(str,"][1.666") == 0 || strcmp(str,"2.0S") == 0)
        if (wadsize==D2_166_WADSIZE && exesize==D2_166_EXESIZE &&
            strcmp(waddate,D2_166_WADDATE) == 0 && strcmp(exedate,D2_166_EXEDATE) == 0 &&
            strcmp(wadtime,D2_166_WADTIME) == 0 && strcmp(exetime,D2_166_EXETIME) == 0)
            return TRUE;
    if (strcmp(str,"][1.7") == 0)
        if (wadsize==D2_17C_WADSIZE && exesize==D2_17C_EXESIZE &&
            strcmp(waddate,D2_17C_WADDATE) == 0 && strcmp(exedate,D2_17C_EXEDATE) == 0 &&
            strcmp(wadtime,D2_17C_WADTIME) == 0 && strcmp(exetime,D2_17C_EXETIME) == 0)
            return TRUE;
    if (strcmp(str,"][1.7A") == 0)
        if (wadsize==D2_17A_WADSIZE && exesize==D2_17A_EXESIZE &&
            strcmp(waddate,D2_17A_WADDATE) == 0 && strcmp(exedate,D2_17A_EXEDATE) == 0 &&
            strcmp(wadtime,D2_17A_WADTIME) == 0 && strcmp(exetime,D2_17A_EXETIME) == 0)
            return TRUE;
    if (strcmp(str,"][1.8") == 0)
        if (wadsize==D2_18C_WADSIZE && exesize==D2_18C_EXESIZE &&
            strcmp(waddate,D2_18C_WADDATE) == 0 && strcmp(exedate,D2_18C_EXEDATE) == 0 &&
            strcmp(wadtime,D2_18C_WADTIME) == 0 && strcmp(exetime,D2_18C_EXETIME) == 0)
            return TRUE;
    if (strcmp(str,"][1.9") == 0)
        if (wadsize==D2_19C_WADSIZE && exesize==D2_19C_EXESIZE &&
            strcmp(waddate,D2_19C_WADDATE) == 0 && strcmp(exedate,D2_19C_EXEDATE) == 0 &&
            strcmp(wadtime,D2_19C_WADTIME) == 0 && strcmp(exetime,D2_19C_EXETIME) == 0)
            return TRUE;
    return FALSE;
}




/*************************************************************************
***                               Main                                 ***
*************************************************************************/

void main(int argc, char *argv[])
{
    int done;
    int drive;
    long avail;
    long NeededSpace;
    static char command[128];
    char far *cp;
    char *today_date = "01-01-94";
    char *today_time = "10:10:10";
    _setcursortype(_NOCURSOR);
    _dos_getdate(&current_date);
    today = ((long) (current_date.year-1980)*365 +
             (long) current_date.month*31 +
             (long) current_date.day);
    today_date = _strdate(today_date);
    today_time = _strtime(today_time);
    s = "  ";
    s[0] = VERSION_DATE[0];
    s[1] = VERSION_DATE[1];
    t = "  ";
    t[0] = VERSION_DATE[3];
    t[1] = VERSION_DATE[4];
    u = "  ";
    u[0] = VERSION_DATE[6];
    u[1] = VERSION_DATE[7];
    creation = ((long) (atoi(s)-80)*365 +
                (long) atoi(t)*31 + (long) atoi(u));
    days_old = today - creation;
    cp = (char _seg *) _psp + (char near *) 0x80;
    j = cp[0];
    for (i=0; i < j; i++)
        command[i] = cp[i+1];
    i = 1;
    while (i < argc)
    {
        argpass[i] = argv[i];
        if (strlen(argpass[i]) == 0) strcpy(argpass[i],"");
        i++;
    }
    while (i < 10)
    {
        argpass[i] = "";
        i++;
    }
    i = 1;
    k = 0;
    while (i < argc)
    {
        if (argpass[i][0] == '?')
        {
            argpass[i][0] = '\0';
            get_help = TRUE;
        }
        if (strchr(argpass[i],' ') == NULL)
        {
            s = strchr(argpass[i]+k,'/');
            if (s == NULL)
                s = strchr(argpass[i]+k,'-');
            if (s != NULL)
            {
                j = s - (argpass[i]+k);
                if (strupr(argpass[i])[j+1+k] == 'H' || argpass[i][j+1+k] == '?')
                {
                    get_help = TRUE;
                    argpass[i][j+k] = '\0';
                }
                if (strupr(argpass[i])[j+1+k] == 'D')
                {
                    debug_on = TRUE;
                    argpass[i][j+k] = '\0';
                }
                if (strupr(argpass[i])[j+1+k] == 'L')
                {
                    list_ver = TRUE;
                    argpass[i][j+k] = '\0';
                }
                if (strupr(argpass[i])[j+1+k] == 'U')
                {
                    move_up = TRUE;
                    argpass[i][j+k] = '\0';
                }
                if (strupr(argpass[i])[j+1+k] == 'Q')
                {

                    quiet = TRUE;
                    argpass[i][j+k] = '\0';
                }
                if (strupr(argpass[i])[j+1+k] == 'B')
                {

                    do_bells = FALSE;
                    argpass[i][j+k] = '\0';
                }
                if (strupr(argpass[i])[j+1+k] == 'M')
                {
                    min_switch = TRUE;
                    argpass[i][j+k] = '\0';
                }
                k = k + j + 1;
            } else
            {
                i++;
                k = 0;
            }
        } else
        {
            i++;
            k = 0;
        }
    }
    k = 1;
    while (k < 10)
    {
	i = 1;
        while (i < argc)
        {
            if (strlen(argpass[i]) == 0)
            {
                j = i;
                while (j < argc - 1)
                {
                    argpass[j] = argpass[j+1];
                    j++;
                }
                argpass[j] = "";
            }
            i++;
        }
        k++;
    }
    if (move_up) gotoxy(wherex(),wherey()-1);
    if (debug_on) printf("\nDMCHECK%s\n\n",command);
    if (!quiet) prnt_mess();
    show_where();
    if (get_help) help_screen();
    if (debug_on && quiet) wrong_parameter("can't use /Q with /D");
    if (quiet && list_ver) wrong_parameter("can't use /Q with /L");
    if (argpass[1][0] == '\0' && quiet) wrong_parameter("don't use /Q alone");
    if (list_ver) ver_listing();
    if (strlen(argpass[1]) == 0) usage();
    _dos_findfirst("DOOM.WAD",_ATTRIBUTES_,&aDir[DOOMWAD]);
    _dos_findfirst("DOOM.EXE",_ATTRIBUTES_,&aDir[DOOMEXE]);
    _dos_findfirst("DOOM1.WAD",_ATTRIBUTES_,&aDir[DOOM1WAD]);
    _dos_findfirst("DOOM2.EXE",_ATTRIBUTES_,&aDir[DOOM2EXE]);
    _dos_findfirst("DOOM2.WAD",_ATTRIBUTES_,&aDir[DOOM2WAD]);
    more_than_one = FALSE;
    i = 0;
    while (i < 5)
    {
        s = aDir[i].name;
        if (strcmp("DOOM.WAD",s)==0 || strcmp("DOOM1.WAD",s)==0 ||
            strcmp("DOOM2.WAD",s)==0)
        {
            if (wadsize > 0)
                more_than_one = TRUE;
            else
            {
                wadsize = aDir[i].size;
                waddate = strdosdate(aDir[i].wr_date);
                wadtime = strdostime(aDir[i].wr_time);
                wadnum = i;
            }
        }
        if (strcmp("DOOM.EXE",s)==0 || strcmp("DOOM2.EXE",s)==0)
        {
            if (exesize > 0)
                more_than_one = TRUE;
            else
            {
                exesize = aDir[i].size;
                exedate = strdosdate(aDir[i].wr_date);
                exetime = strdostime(aDir[i].wr_time);
                exenum = i;
            }
        }
        i++;
    }
    argpass[1] = strupr(argpass[1]);
    s = argpass[1];
    i = s[0];
    if (strlen(s)>1 && strcmp(s,"ASK")!=0 && strcmp(s,"SPACE")!=0 &&
        strcmp(s,"DATE")!=0 && strcmp(s,"WHAT")!=0 && strcmp(s,"WHICH")!=0 &&
        strcmp(s,"VERSION")!=0 && strcmp(s,"FILE")!=0)
        wrong_parameter(strcat("Unknown function ",s));
    switch (i)
    {
        case 'S':
            i = 2;
            while (i < 4)
            {
                p = strchr(argpass[i],',');
                if (p==0)
                    j = 0;
                else
                    j = p - argpass[i];
                while (j > 0)
                {
                    s = strncpy(argpass[i],argpass[i],j);
                    s[j] = '\0';
                    argpass[i] = strcat(s,argpass[i]+j+1);
                    p = strchr(argpass[i],',');
                    if (p==0)
                        j = 0;
                    else
                        j = p - argpass[i];
                }
                i++;
            }
            if (strlen(argpass[3]) == 0)
            {
                drive = getdisk();
                s = argpass[2];
            } else
            {
                drive = strupr(argpass[2])[0]-'A';
                s = argpass[3];
                if ((strlen(argpass[2]) > 2) || (drive < 0 || drive > 25)
                    || (argpass[2][1] != ':' && argpass[2][1] != '\0'))
                    wrong_parameter("Check drive");
            }
            NeededSpace = strtol(s,&t,0);
            if (NeededSpace < 0) wrong_parameter("Can't check negative bytes");
            if (NeededSpace == 0) wrong_parameter("Check NeededSpace");
            getdfree(drive+1,&aFreeSpace);
            if (aFreeSpace.df_sclus == 0xFFFF)
            {
                s = " :";
                s[0] = 'A'+drive;
                error_message(strcat("couldn't access drive ",s));
            } else
            {
                avail = (long) aFreeSpace.df_avail * (long) aFreeSpace.df_bsec
                    * (long) aFreeSpace.df_sclus;
                if (!quiet) printf("\n");
                if (debug_on)
                    printf("\nFree space on drive %c: is %s bytes.",drive+'A',strcommas(avail));
                if (NeededSpace < avail)
                {
                    err_code = 0;
                    if (!quiet)
                        printf("\nThere is at least %s bytes free on drive %c:.",
                            strcommas(NeededSpace),drive+'A');
                } else
                {
                    err_code = 1;
                    if (!quiet)
                        printf("\nThere is less than %s bytes free on drive %c:.",
                            strcommas(NeededSpace),drive+'A');
                }
            }
            break;
        case 'A':
            s = strchr(argpass[3],' ');
            if (s != 0)
            {
                i = s - argpass[3];
                s = strrchr(argpass[3],' ');
                if (s != 0)
                {
                    j = s - argpass[3];
                    if (j > i) wrong_parameter("Can't use only question");
                }
            }
            if (strlen(argpass[3]) == 0)
            {
                argpass[3] = argpass[2];
                if (strlen(argpass[3]) != 0)
                {
                    char *s1;
                    s1 = "Press a key? [                                    ";
                    i = 0;
                    while (i < strlen(argpass[3]))
                    {
                        s1[i+14] = strupr(argpass[3])[i];
                        i++;
                    }
                    s1[i+14] = ']';
                    s1[i+15] = '\0';
                    argpass[2] = s1;
                } else
                {
                    argpass[2] = "Press any key to continue";
                }
            }
            _setcursortype(_NOCURSOR);
            if (strlen(argpass[2]) > 0)
            {
                _setcursortype(_NORMALCURSOR);
                if (!quiet) printf("\n");
                printf("\n%s",argpass[2]);
            }
            if (strlen(argpass[3]) == 0)
            {
                j = getch();
                while (j == 0)
                    j = getch();
                err_code = 0;
            } else
            {
                s = strupr(argpass[3]);
                s = strcat(s,"\x1b");
                i = 0;
                u = "12345";
                while (i == 0)
                {
                    j = getch();
                    u[0] = j;
                    u[1] = '\0';
                    u = strupr(u);
                    j = u[0];
                    t = strchr(s,j);
                    if (t != NULL) i = t - s + 1;
                    if (i==0 && do_bells) printf("\a");
                }
                err_code = i;
            }
            if (j == 27) err_code = 255;
            if (j > ' ' && strlen(argpass[2]) != 0) printf("%c",j);
            if (strlen(argpass[2]) > 0 && quiet) printf("\n");
            if (debug_on)
            {
                printf("\n\nThe key pressed was code %i",j);
                if (j > 32 && j < 128) printf(" or text \"%c\".",j);
                else printf(".");
            }
            _setcursortype(_NOCURSOR);
            break;
        case 'W':
            char *ver_str = get_version();
            if (strcmp(ver_str,"NOWAD") == 0)
            {
              if (aDir[DOOM2EXE].size == 0)
                  error_message("no DOOM.WAD or DOOM1.WAD file");
              else
                  error_message("no DOOM2.WAD file");
            }
            else
            {
              if (strcmp(ver_str,"NOEXE") == 0)
              {
                if (aDir[DOOM2WAD].size == 0)
                  error_message("no DOOM.EXE file");
                else
                  error_message("no DOOM2.EXE file");
              }
              else
              {
                int is_it = isitver(ver_str);
                if (!is_it && more_than_one)
                {
                  if (strlen(aDir[DOOM1WAD].name) != 0)
                  {
                    if (debug_on)
                    {
                      if (ver_str[0] != ' ')
                      {
                        printf("\n\nYou have a DOOM.WAD and a DOOM1.WAD! You don't have an un-modified copy of\n");
                        printf("the registered version %s of DOOM, so I am now checking if it is a copy of\n",ver_str);
                        printf("the shareware version...");
                      } else
                      {
                        printf("\n\nYou have a DOOM.WAD and a DOOM1.WAD! The DOOM.WAD doesn't seam to be a\n");
                        printf("valid DOOM version, so I will check if the DOOM1.WAD is...");
                      }
                    }
                    wadsize = aDir[DOOM1WAD].size;
                    waddate = strdosdate(aDir[DOOM1WAD].wr_date);
                    wadtime = strdostime(aDir[DOOM1WAD].wr_time);
                  } else
                  {
                    if (debug_on)
                    {
                      if (ver_str[0] != ' ')
                      {
                        printf("\n\nYou have a copy of DOOM 1 and a copy of DOOM ][! You don't have an un-modified copy of\n");
                        printf("the registered version %s of DOOM, so I am now checking if it is a copy of\n",ver_str);
                        printf("the DOOM ][...");
                      } else
                      {
                        printf("\n\nYou have a copy of DOOM 1 and a copy of DOOM ][! Since the copy of DOOM 1\n");
                        printf("isn't any valid version, I will check if DOOM ][ is...");
                      }
                    }
                    wadsize = aDir[DOOM2WAD].size;
                    waddate = strdosdate(aDir[DOOM2WAD].wr_date);
                    wadtime = strdostime(aDir[DOOM2WAD].wr_time);
                    exesize = aDir[DOOM2EXE].size;
                    exedate = strdosdate(aDir[DOOM2EXE].wr_date);
                    exetime = strdostime(aDir[DOOM2EXE].wr_time);
                  }
                  ver_str = get_version();
                  is_it = isitver(ver_str);
                }
                if ((is_it && wadsize < 6000000L &&
                  aDir[DOOMWAD].size != 0) ||
                  (is_it && wadsize > 6000000L &&
                  aDir[DOOMWAD].size == 0L && aDir[DOOM2WAD].size == 0L))
                  is_it = FALSE;
                if (!is_it)
                {
                  if (!quiet)
                  {
                    if (ver_str[0] != ' ')
                    {
                      if (ver_str[0] == ']')
                      {
                        printf("\n\nYou appear to have a modified ");
                        printf("version %s of DOOM ][!",ver_str+3);
                      } else
                      {
                        printf("\n\nYou appear to have a modified ");
                        if (wadsize > 6000000) printf("registered ");
                        else printf("shareware ");
                        printf("version %s of DOOM!",ver_str);
                      }
                    } else
                    {
                      if (!min_switch) printf("\n\nYou have a");
                      else printf("\nA");
                      printf("n unrecognized DOOM version!");
                    }
                    if (wadsize < 6000000L && aDir[DOOM1WAD].size == 0L &&
                      aDir[DOOM2WAD].size == 0L)
                      error_message("The WAD file should be DOOM1.WAD");
                    if (wadsize > 6000000L && aDir[DOOMWAD].size == 0L &&
                      aDir[DOOM2WAD].size == 0L)
                      error_message("The WAD file should be DOOM.WAD");
                  }
                  err_code = 255;
                } else
                {
                  if (strcmp(ver_str,"1.0") == 0) err_code = 1;
                  if (strcmp(ver_str,"1.1") == 0) err_code = 2;
                  if (strcmp(ver_str,"1.2") == 0) err_code = 3;
                  if (strcmp(ver_str,"1.4") == 0) err_code = 4;
                  if (strcmp(ver_str,"1.5") == 0) err_code = 5;
                  if (strcmp(ver_str,"1.6") == 0) err_code = 6;
                  if (strcmp(ver_str,"1.666") == 0) err_code = 7;
                  if (strcmp(ver_str,"1.7") == 0) err_code = 8;
                  if (strcmp(ver_str,"1.7A") == 0) err_code = 9;
                  if (strcmp(ver_str,"1.8") == 0) err_code = 10;
                  if (strcmp(ver_str,"1.9") == 0) err_code = 11;
                  if (strcmp(ver_str,"1.25") == 0) err_code = 31;
                  if (strcmp(ver_str,"1.2Z") == 0) err_code = 30;
                  if (strcmp(ver_str,"][P") == 0) err_code = 19;
                  if (strcmp(ver_str,"][1.666") == 0) err_code = 21;
                  if (strcmp(ver_str,"][1.7") == 0) err_code = 22;
                  if (strcmp(ver_str,"][1.7A") == 0) err_code = 23;
                  if (strcmp(ver_str,"][1.8") == 0) err_code = 24;
                  if (strcmp(ver_str,"][1.9") == 0) err_code = 25;
                  if (!quiet)
                  {
                    if (ver_str[0] == '1')
                    {
                      if (!min_switch) printf("\n\nYou have t");
                      else printf("\nT");
                      printf("he ");
                      if (wadsize > 6000000) printf("registered");
                      else printf("shareware");
                      printf(" version %s of DOOM.",ver_str);
                    } else
                    {
                      if (!min_switch) printf("\n\nYou have v");
                      else printf("\nV");
                      if (ver_str[2] == 'P' || ver_str[2] == 'p')
                          printf("ersion 1.666 of DOOM ][ pirated!");
                      else
                          printf("ersion %s of DOOM ][.",ver_str+2);
                    }
                  }
                }
              }
            }
            break;
        case 'V':
            argpass[2] = strupr(argpass[2]);
            if (!valid_version(argpass[2]))
            {
                if (!quiet)
                {
                    printf("\n\n*** ERROR, Please use one of the following for the DOOMVersion number:");
                    printf("\n***        1.0, 1.1, 1.2, 1.4, 1.5, 1.6, 1.666, 1.7, 1.7a, 1.8, 1.9");
                    printf("\n***        ][P, ][1.666, ][1.7, ][1.7a, ][1.8, ][1.9, 1.25, or 1.2Z!");
                    if (do_bells) printf("\a");
                    err_code = 255;
                    r_error();
                }
            }
            if (argpass[2][0] == ']' || argpass[2][0] == '2')
            {
                wadsize = aDir[DOOM2WAD].size;
                waddate = strdosdate(aDir[DOOM2WAD].wr_date);
                wadtime = strdostime(aDir[DOOM2WAD].wr_time);
                wadnum = DOOM2WAD;
                exesize = aDir[DOOM2EXE].size;
                exedate = strdosdate(aDir[DOOM2EXE].wr_date);
                exetime = strdostime(aDir[DOOM2EXE].wr_time);
                exenum = DOOM2EXE;
                if (wadsize == 0) error_message("no DOOM2.WAD file");
                if (exesize == 0) error_message("no DOOM2.EXE file");
            } else
            {
                if (more_than_one && wadsize == 0)
                {
                    wadsize = aDir[DOOM1WAD].size;
                    waddate = strdosdate(aDir[DOOM1WAD].wr_date);
                    wadtime = strdostime(aDir[DOOM1WAD].wr_time);
                    wadnum = DOOM1WAD;
                }
                if (wadsize == 0) error_message("no DOOM[1].WAD file");
                if (exesize == 0) error_message("no DOOM.EXE file");
            }
            int is_it = isitver(argpass[2]);
            if (!is_it && more_than_one && argpass[2][0]=='1' &&
                aDir[DOOM1WAD].size > 0)
            {
                if (debug_on)
                {
                    printf("\n\nThere is a DOOM.WAD and a DOOM1.WAD! Since it isn't the registered version");
                    printf("\nof %s, I will now check the shareware version.",argpass[2]);
                }
                wadsize = aDir[DOOM1WAD].size;
                waddate = strdosdate(aDir[DOOM1WAD].wr_date);
                wadtime = strdostime(aDir[DOOM1WAD].wr_time);
                wadnum = DOOM1WAD;
                is_it = isitver(argpass[2]);
            }
            t = argpass[2];
            if (is_it)
            {
                if (!quiet)
                {
                    if (t[0] == ']')
                    {
                        if (t[2] == 'P')
                            printf("\n\nIt is the pirate copy of DOOM ][");
                        else
                            printf("\n\nIt is DOOM ][ version %s",t+2);
                    }
                    else
                        printf("\n\nIt is DOOM 1 version %s",t);
                }
                if (wadsize < 6000000L) err_code = 2;
            } else
            {
                if (!quiet)
                {
                    if (t[0] == ']')
                    {
                        if (t[2] == 'P')
                            printf("\n\nIt isn't the pirate copy of DOOM ][");
                        else
                            printf("\n\nIt isn't DOOM ][ version %s",t+2);
                    }
                    else
                        printf("\n\nIt isn't DOOM 1 version %s",t);
                }
                err_code = 255;
            }
            if (!quiet)
            {
                if (argpass[2][0] != ']')
                {
                    if (wadsize > 6000000L)
                        printf(" registered.");
                    else
                        printf(" shareware.");
                } else
                    printf(".");
            }
            break;
        case 'D':
            err_code = 0;
            if (strlen(argpass[2]) == 0) wrong_parameter("No file name given");
            s = argpass[3];
            if (stricmp(s,"NOW")==0)
            {
                if (debug_on) printf("\n\nSetting date to %s and time to %s...",
                    today_date,today_time);
                argpass[3] = today_date;
                argpass[3][2] = '-';
                argpass[3][5] = '-';
                if ((today_time[7]/2)*2 != today_time[7])
                {
                    today_time[7] = today_time[7]+1;
                    if (today_time[7]>'9')
                        today_time[7] = '8';
                    if (debug_on) printf(
                        "\nSeconds were odd, ressetting time to %s...",
                        today_time);
                }
                argpass[4] = today_time;
            }
            if (strlen(argpass[4]) == 0 && strlen(argpass[3]) != 0)
                wrong_parameter("No time given");
            if (atoi(argpass[4]) == 0 && argpass[4][2] != ':' &&
                strlen(argpass[3]) != 0)
                wrong_parameter("Time must be in HH:MM:SS format");
            if (atoi(argpass[3]) == 0 && strlen(argpass[4]) != 0)
                wrong_parameter("Date must be in MM-DD-YY format");
            struct find_t files;
            int found_file = (_dos_findfirst(argpass[2],_ATTRIBUTES_,&files) == 0);
            char *last_file = "filename.ext";
            strcpy(last_file,files.name);
            if (!found_file) error_message(strcat("couldn't find file(s) matching ",argpass[2]));
            int first_line = TRUE;
            int cant_change = FALSE;
            int cant_open = FALSE;
            char *new_date = argpass[3];
            char *new_time = argpass[4];
            struct ftime ftd;
            while (found_file)
            {
                stream = fopen(last_file,"r");
                if (stream == NULL)
                {
                    cant_change = TRUE;
                    cant_open = TRUE;
                    err_code = 255;
                } else
                {
                    stream = fopen(last_file,"r+b");
                    if (stream == NULL)
                        cant_change = TRUE;
                }
                if (strlen(argpass[3]) == 0)
                {
                    if (cant_open)
                    {
                        new_date = "01/01/94";
                        new_time = "00:00:00";
                    } else
                    {
                        new_date = strdosdate(files.wr_date);
                        new_time = strdostime(files.wr_time);
                    }
                } else
                {
                    new_date = argpass[3];
                    new_time = argpass[4];
                }
                if (((new_date[2] != '-' && new_date[2] != '/') ||
                    (new_date[5] != '-' && new_date[5] != '/')) &&
                    !cant_change)
                    error_message("invalid date, use MM-DD-YY");
                if ((new_time[2] != ':' || new_time[5] != ':') &&
                    !cant_change)
                    error_message("invalid time, use HH:MM:SS");
                month = atoi(new_date);
                day = atoi(new_date+3);
                year = atoi(new_date+6);
                hour = atoi(new_time);
                minute = atoi(new_time+3);
                second = atoi(new_time+6);
                if ((!isdigit(new_date[0]) || !isdigit(new_date[1]) ||
                    !isdigit(new_date[3]) || !isdigit(new_date[4]) ||
                    !isdigit(new_date[6]) || !isdigit(new_date[7]) ||
                    strlen(new_date)!=8) && !cant_change)
                    error_message("invalid date, use MM-DD-YY");
                if ((!isdigit(new_time[0]) || !isdigit(new_time[1]) ||
                    !isdigit(new_time[3]) || !isdigit(new_time[4]) ||
                    !isdigit(new_time[6]) || !isdigit(new_time[7]) ||
                    strlen(new_time)!=8) && !cant_change)
                    error_message("invalid time, use HH:MM:SS");
                s = strdosdate(files.wr_date);
                if ((month < 1 || month >12) && !cant_change)
                    error_message("invalid month");
                if ((day < 1 || day > 31) && !cant_change)
                    error_message("invalid day");
                if ((hour < 0 || hour > 23) && !cant_change)
                    error_message("invalid hours");
                if ((minute < 0 || minute > 59) && !cant_change)
                    error_message("invalid minutes");
                if ((second < 0 || second > 59) && !cant_change)
                    error_message("invalid seconds");
                if (second != (second/2)*2)
                    error_message("can't set time to odd seconds");
                if (!quiet && first_line)
                {
                    printf("\n");
                    first_line = FALSE;
                }
                if (!quiet) printf("\nFile:%12s   ",files.name);
                if ((strcmp(s,new_date) != 0) ||
                    strcmp(strdostime(files.wr_time),new_time) != 0)
                {
                    if (!cant_change)
                        _dos_setftime(fileno(stream),todosdate(new_date),
                        todostime(new_time));
                }
                if (!quiet)
                {
                    if (cant_change && !cant_open &&
                        (strcmp(strdosdate(files.wr_date),new_date) != 0 ||
                        strcmp(strdostime(files.wr_time),new_time) != 0))
                    {
                        printf("date:%s *Read only!* time:%s *Can't change!*",
                            strdosdate(files.wr_date),strdostime(files.wr_time));
                        err_code = 255;
                    } else if (!cant_open)
                    {
                        if (strcmp(strdosdate(files.wr_date),new_date))
                            printf("date:%s->%s    time:",strdosdate(files.wr_date),new_date);
                        else
                            printf("date:%s              time:",new_date);
                        if (strcmp(strdostime(files.wr_time),new_time))
                        {
                            printf("%s->%s.",strdostime(files.wr_time),new_time);
                        }
                        else
                            printf("%s.",new_time);
                    } else
                    {
                        printf("date: *Can't open file!*   time: *Unknown!*");
                    }
                }
                fcloseall();
                found_file = (_dos_findnext(&files) == 0);
                strcpy(last_file,files.name);
                s = files.name;
                cant_change = FALSE;
                cant_open = FALSE;
            }
            break;
        case 'F':
            if (strlen(argpass[2]) == 0) wrong_parameter("no filename given");
            stream = fopen(argpass[2],"r");
            fcloseall();
            if (stream == NULL)
                error_message(strcat("problem accessing file ",argpass[2]));
            struct find_t fileblock;
            _dos_findfirst(argpass[2],_ATTRIBUTES_,&fileblock);
            if (strlen(argpass[3]) != 0)
            {
                p = strchr(argpass[3],',');
                if (p==0)
                    j = 0;
                else
                    j = p - argpass[3];
                while (j > 0)
                {
                    s = strncpy(argpass[3],argpass[3],j);
                    s[j] = '\0';
                    argpass[3] = strcat(s,argpass[3]+j+1);
                    p = strchr(argpass[3],',');
                    if (p==0)
                        j = 0;
                    else
                        j = p - argpass[3];
                }
                filesize = atol(argpass[3]);
                s = "12345678901234567890";
                if (strlen(argpass[3]) != sprintf(s,"%li",filesize))
                    wrong_parameter("invalid file size");
            }
            filedate = argpass[4];
            filetime = argpass[5];
            if (filesize < 0) wrong_parameter("can't check negative bytes");
            if (strlen(filedate) == 0)
                filedate = strdosdate(fileblock.wr_date);
            if (strlen(filetime) == 0)
                filetime = strdostime(fileblock.wr_time);
            if (filesize == 0)
                filesize = fileblock.size;
            if ((filedate[2] != '-' && filedate[2] != '/') ||
                (filedate[5] != '-' && filedate[5] != '/'))
                error_message("invalid date, use MM-DD-YY");
            if (filetime[2] != ':' || filetime[5] != ':')
                error_message("invalid time, use HH:MM:SS");
            month = atoi(filedate);
            day = atoi(filedate+3);
            year = atoi(filedate+6);
            hour = atoi(filetime);
            minute = atoi(filetime+3);
            second = atoi(filetime+6);
            if (!isdigit(filedate[0]) || !isdigit(filedate[1]) ||
                !isdigit(filedate[3]) || !isdigit(filedate[4]) ||
                !isdigit(filedate[6]) || !isdigit(filedate[7]) ||
                strlen(filedate)!=8)
                error_message("invalid date, use MM-DD-YY");
            if (!isdigit(filetime[0]) || !isdigit(filetime[1]) ||
                !isdigit(filetime[3]) || !isdigit(filetime[4]) ||
                !isdigit(filetime[6]) || !isdigit(filetime[7]) ||
                strlen(filetime)!=8)
                error_message("invalid time, use HH:MM:SS");
            if (month < 1 || month >12)
                error_message("invalid month");
            if (day < 1 || day > 31)
                error_message("invalid day");
            if (hour < 0 || hour > 23)
                error_message("invalid hours");
            if (minute < 0 || minute > 59)
                error_message("invalid minutes");
            if (second < 0 || second > 59)
                error_message("invalid seconds");
            if (second != (second/2)*2)
                error_message("files can't have odd seconds");
            if (debug_on)
                printf("\n\nFile:%13s   size:%s   date:%s   time:%s",
                    fileblock.name,
                    strcommas(fileblock.size),
                    strdosdate(fileblock.wr_date),
                    strdostime(fileblock.wr_time));
            else
            {
                if (!quiet)
                    printf("\n");
            }
            if (filesize == fileblock.size &&
                strcmp(filedate,strdosdate(fileblock.wr_date)) == 0 &&
                strcmp(filetime,strdostime(fileblock.wr_time)) == 0)
            {
                if (!quiet) printf("\nFile %s matches criteria.",argpass[2]);
                err_code = 0;
            }
            else
            {
                if (!quiet) printf("\nFile %s does not match criteria!",argpass[2]);
                err_code = 1;
            }
            break;
        default:
            s = " ";
            s[0] = i;
            wrong_parameter(strcat("Unknown function ",s));
    }
    r_error();
}
