
#define LOADABLE_DRIVERS 1 // Conditional compilation, set to true if
 			   // Supporting loadable drivers.

int far CheckMidiIn(void); // Returns 1 if MIDPAK is installed, 0 if not.

int far DigPakAvailable(void);	// Returns 1 if DIGPAK is installed, 0 if not.

/****************************************************************************/
/* These flags are returned by the XMIDI registration call. 		    */
/****************************************************************************/
#define FAILURE_TO_REGISTER 0 	// Xmidi file registration failed.

#define REGISTERED_RESIDENT 1   // Resident driver holds midi file now.
				// The application can throw away the memory
				// if it wants to.

#define REGISTERED_APPLICATION 2  // Driver didn't have a big enough buffer
				  // area reserved to hold the audio data
				  // so the application is responsible for
				  // keeping the memory for this sequence
				  // while it is registered.

int far PlaySequence(int seqnum); // Play a particular sequence number from
				  // the currently registered xmidi file.

#define NEXT_CALLBACK -1	// Activation on next callback.
int far SegueSequence(int seqnum,int activate);
				// Switch sequence to this sequence when next
				// callback trigger event is hit with the
				// event number equal to activate.	If activate
				// is set to -1 then the next event causes the
				// segue to occur.

int far RegisterXmidi(char far *xmidi,long int size);
				// Registers an extended midi file for playback.
				// This call will register all sequences.

int far MidiStop(void); 	// Stop playing current sequence.

void far RemapChannel(unsigned int sequence_channel,unsigned int physical_channel);
				// Remap a particular sequence channel to a
				// particular physical channel.

long int far ReportCallbackTrigger(void); // Low word is trigger count.
					  // High word is last event ID.

void far ResetCallbackCounter(void);	// Reset callback counter to zero.

void far MidiSleep(void); 	// Put MIDI driver and hardware to sleep.

void far MidiAwake(void); 	// Wake MIDI driver and hardware back up.

void far ResumePlaying(void); 	// Resume playing last sequence.

#define SEQ_STOPPED 0 		// equates for SequenceStatus()
#define SEQ_PLAYING 1
#define SEQ_DONE 2
int  far SequenceStatus(void); 	// Report current sequence play status.

int  far RelativeVolume(int vol); // Report current volume.

void far SetRelativeVolume(int vol,int time); // Set volume, over time period.

#define NOBUFFER 1		// No resident buffer available.
#define FILENOTFOUND 2		// The file was not found.
#define FILETOBIG 3 		// The file exceeds the reserved buffer size.
#define REGISTRATIONERROR 4 	// Error registering the XMI file.

int  far RegisterXmidiFile(char far *fname); // Register by filename.

void far PollMidPak(void); // Poll MidPak for music processing.

long int far MidPakClock(void); // Return MIDPAK heartbeat count (120hz)

long int far * far MidPakClockAddress(void); // Return address of midpak clock.

int far * far TriggerCountAddress(void); // Report address of trigger count.

int far * far EventIDAddress(void); // Report address of event id.

int far ReportSequenceNumber(void);

/******************************************************************************/
/* Warning, it you enable LOADABLE_DRIVERS you must prodivde memory allocation*/
/* functions, and access to DOSCALLS.OBJ. 	  			      */
/******************************************************************************/
#if LOADABLE_DRIVERS
int  far InitMP(int segment,int advseg,char far *ad); // Init MIDI driver.
// Return code of 0 means SUCCESS!!!!!!!!!!!!!! Failure is
// return code
void far DeInitMP(int segment); // Unload a previously loaded sound driver.
#endif
