#include <stdio.h>
#include <stdlib.h>
#include <process.h>
#include <conio.h>
#include <alloc.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include <ctype.h>
#include <fcntl.h>
#include <sys/stat.h>

#include "window.h"
#include "copy.h"

#include "doscalls.h"
#include "sbdetect.h"
#include "loader.h"
#include "digplay.h"
#include "midpak.h"


#define SOUNDCANVAS 1900
#define SOUNDBLASTER 1901
#define GENERALMIDI 1902

#define QUICKFIRE 0 // True if compiling quick fire version.
#define EA 0
#define SEAWOLF 0
// This is true if compiling for John Ratcliff's
// Electronic Arts game Seawolf.	Notice that with this conditional true
// I copy different music files over, according to the driver selection.
#define KSONIC 0
// This is true if compiling for John & Rob's Multimedia KSONIC

#define ANYKEY 0
#define SKIP	 1

void		main(int argc,char **argv);
int 		exists(char *path);
char 		error_message(void);
extern void interrupt critical_error(void);
void    Copy(char *srcname,char *dstname);
int 		SelectSound(int x1,int y1,int x2,int y2,int mx,int cur);
int 		GetSoundFiles(void);
void		ErrorOut(char *msg);
int 		sortcmp(const void *a, const void *b);
unsigned char far * far memalloc(long int siz);
void far memfree(char far *memory);
void		ConfigDriver(int driver);
int 		GetBaseAddr(int driver);
int 		GetIRQ(int driver);
int 		GetOther(int driver);
int     gethex(int x,int y,unsigned* startvalue);
int 		ErrorMsg(char *str);
int 		TestDriver(void);
int 		LoadTestDriver(void);
void center(char *str);

#if QUICKFIRE
void QFGM(void);
void QFMT(void);
void QFFM(void);
#endif

int lineno;

extern int _wscroll;

#define MIDIDESC 41
typedef struct
{
	char		title[MIDIDESC];
	char		file[13];
	char		addfile[13];
	unsigned BaseAddr;
	unsigned IRQ;
	unsigned Other;
} MIDIDRIVERS;

MIDIDRIVERS md[100];

#if KSONIC
void CopyGM(void);
void CopyMT32(void);
void CopySCC(void);
#endif

int 		SpecialCritError,Aborted,Sound;

char savedir[128];
char Directory[128];

char		*savebffr;
struct text_info saveti;

// If Adlib Selected, copy the following files:
// Copy OPL General MIDI file 		FAT.OPL -> MIDPAK.AD
//			CMIDPAK.COM -> MIDPAK.COM
//			plus driver.

// If Roland MT-32 selected, copy the following files:
//	 MT-32 general MIDI patch bank file 	FAT.MT -> MIDPAK.AD
//			SMIDPAK.COM -> MIDPAK.COM (ONLY FOR SEAWOLF!!!)
//			plus sound driver.

// If Roland Sound Canvas selected, copy.
//			FAT.OPL -> MIDPAK.AD (not actually used)
//			RMIDPAK.COM -> MIDPAK.COM (ONLY FOR SEAWOLF)
//			plus sound driver.

// If a general MIDI device selected, copy.
//	Inludes MPU401 general MIDI, aria card, ASC audio-master, and Gravis Ultrasound
//			FAT.OPL -> MIDPAK.AD
//			RMIDPAK.COM -> MIDPAK.COM (ONLY FOR SEAWOLF)
//			plus sound driver.

// If a Turtle Beach Multisound selected.
//			FAT.OPL -> MIDPAK.AD
//			RMIDPAK.COM -> MIDPAK.COM (ONLY FOR SEAWOLF)
//			plus sound driver.

int 		AskBlast(void);

int OnSoundBlaster=0;
int OnTurtleBeach=0;
int SoundBlaster=0;
int SoundBlasterIRQ,SoundBlasterBaseAddress;

char scratch[80];

void		main(int argc,char **argv)
{
	FILE *fh;
	int driver,ret,MusicID;
	int 		numsounds,x1,y1,x2,y2,Roland=0;
	int Proteus=0,NoSound=0;


	numsounds = GetSoundFiles();
	if ( !numsounds )
	{
		printf("No MIDPAK drivers found.\n");
		exit(1);
	}

	gettextinfo(&saveti);
	savebffr = malloc(4000);
	gettext(1,1,80,25,savebffr);

	mdelete("MIDPAK.XMI"); // Delete the default MIDPAK.XMI file.
	mdelete("MIDPAK.AD");  // Delete the midpak bank file.
	mdelete("MIDPAK.ADV"); // Delete the MIDPAK.ADV file.
	mdelete("MIDPAK.COM"); // Delete the MIDPAK.COM file.

	setvect(0x24,critical_error); 	// Handle Critical Error's
	SpecialCritError = 0;
	_setcursortype(_NOCURSOR);

	do
	{
#if EA
		NewWindow(1,1,80,25,BLUE,WHITE,"MIDPAK Setup - Copyright (c) 1993 - Electronic Arts",SINGLE);
#else
		NewWindow(1,1,80,25,BLUE,WHITE,"MIDPAK Setup - Copyright (c) 1993 - John W. Ratcliff",SINGLE);
#endif
		gotoxy(40,3);
		CenterString("Midi Driver Selection Menu");
		gotoxy(40,24);
		CenterString(" Locate driver. Enter to select. ESC to cancel.");
		Aborted = 0;
		if ( Aborted )
		{
			SoundBlaster = DetectBlaster(&SoundBlasterBaseAddress,&SoundBlasterIRQ);
		}
		Aborted = 0;

		NewWindow(16,4,63,12,LIGHTGRAY,BLACK,"Midi Drivers Available",DOUBLE);
		Sound = driver = SelectSound(17,5,62,11,numsounds,0); //new
		if (Sound == -1) Aborted = 1;
		clearbox(16,4,63,12,BLUE,WHITE);
		clearbox(5,14,75,21,BLUE,WHITE);

		if ( !Aborted )
		{
			textcolor(WHITE);
			textbackground(BLUE);
			gotoxy(40,24);
			CenterString("           Press ESC to select another driver.           ");
			gotoxy(40,23);
			CenterString("                                  ");
			if (!strcmp(md[Sound].file,"MT32MPU.ADV")) Roland = 1; // If MT-32/LAPC
			if (!strcmp(md[Sound].file,"SC32MPU.ADV")) Roland = 2; // If Sound Canvas
			if (!strcmp(md[Sound].file,"GENMID.ADV")) Roland = 3; // If MPU401 General MIDI
			if (!strcmp(md[Sound].file,"ARIAXMID.ADV")) Roland = 3; // If Aria
			if (!strcmp(md[Sound].file,"MMSYNTH.ADV")) Roland = 3; // If Audiomaster
			if (!strcmp(md[Sound].file,"GF1MIDI.ADV")) Roland = 3; // If Gravis Ultrasound
			if (!strcmp(md[Sound].file,"MULTISND.ADV")) Proteus = 1; // If Turtle Beach Multisound
	#if SEAWOLF || KSONIC
			if (!strcmp(md[Sound].file,"PCSPKR.ADV")) NoSound = 1;
			// Neither seawolf or the kaleidosonics plays any music in the case
			// there is no sound card.
	#endif
			if ( NoSound )
			{
				ErrorMsg("Installing without music.");
			}
			else
			{
				Copy(md[Sound].file,"MIDPAK.ADV"); // Create the MIDPAK.ADV file.
				if ( Proteus )
				{
		#if SEAWOLF
					 MusicID = GENERALMIDI;
		#endif
					 Copy("FAT.OPL","MIDPAK.AD");  // Copy dummy instrument file.
					 Copy("RMIDPAK.COM","MIDPAK.COM"); // Copy the version of MIDPAK
					// that doesn't support timbre loading.  Just uses defaults
					// for this instrument.
		#if QUICKFIRE
					 QFGM(); // Copy general MIDI.
		#endif
		#if KSONIC
					 CopyGM();	// For Kaleidosonics copy the general midi music files.
		#endif
				}
				else
				{
					switch ( Roland )
					{
							case 0:
		#if SEAWOLF
								Copy("FAT.AD","MIDPAK.AD");  // For Seawolf use this MT-32 patch bank
								// For Adlib and compatibles.
								MusicID = SOUNDBLASTER;
		#else
								Copy("FAT.OPL","MIDPAK.AD");
								// Default copy general MIDI patch bank assignments for Adlib
								// and compatibles.
		#endif
								Copy("CMIDPAK.COM","MIDPAK.COM");
								// Copy the CMOS version of MIDPAK.
		#if KSONIC
								CopyGM();
		#endif
		#if QUICKFIRE
								QFFM();
		#endif
								break;
							case 1:
		#if SEAWOLF || KSONIC
								MusicID = SOUNDCANVAS;
								Copy("ORCHPERC.XMI","MIDPAK.XMI"); // Copy orchestral percussions file.
								Copy("FAT.MT","MIDPAK.AD"); // Copy MT-32 custom patch bank.
								Copy("SMIDPAK.COM","MIDPAK.COM"); // Copy 'small' timbre version of MIDPAK
		#else
								Copy("FAT.OPL","MIDPAK.AD"); // standard.
								Copy("CMIDPAK.COM","MIDPAK.COM"); // Copy regular timbre version of MIDPAK
		#endif
		#if QUICKFIRE
								QFMT(); // Copy quickfire MT-32 versions.
		#endif
		#if KSONIC
								CopyMT32();
		#endif
								break;
							case 2:
		#if SEAWOLF
								MusicID = SOUNDCANVAS;
								Copy("RMIDPAK.COM","MIDPAK.COM"); // Small version of MIDPAK
		#else
								Copy("CMIDPAK.COM","MIDPAK.COM"); // Small version of MIDPAK
		#endif
								Copy("FAT.OPL","MIDPAK.AD"); // Dummy instruments.
		#if KSONIC
								CopySCC();
		#endif
		#if QUICKFIRE
								QFGM();
		#endif
								break;
							case 3:
		#if SEAWOLF
								MusicID = SOUNDCANVAS;
								Copy("RMIDPAK.COM","MIDPAK.COM");
		#else
								Copy("CMIDPAK.COM","MIDPAK.COM");
		#endif
								Copy("FAT.OPL","MIDPAK.AD");
		#if QUICKFIRE
								QFGM();
		#endif
		#if KSONIC
								CopyGM();
		#endif
								break;
					}
				}
				fh = fopen("midpak.com","r+b");
				fseek(fh,0x106,SEEK_SET);
				fwrite(&md[driver].BaseAddr,sizeof(int),1,fh);
				fwrite(&md[driver].IRQ,sizeof(int),1,fh);
				fwrite(&md[driver].Other,sizeof(int),1,fh);
				fclose(fh);
				fh = fopen(md[driver].addfile,"w");
				fprintf(fh,"%s\n",md[driver].title);
				fprintf(fh,"%X,%X,%X\n",md[driver].BaseAddr,md[driver].IRQ,md[driver].Other);
				fclose(fh);

				if ( TestDriver() )
				{
					ret = LoadTestDriver();
					if ( ret == -1 ) Aborted = 2;
					if ( ret == 0 ) Aborted = 2; // If failure loading and testing midpak.
				}
				else
					Aborted = 1;
			}
		}
IQUIT:
	} while ( Aborted == 2 );

	_setcursortype(_NORMALCURSOR);
	puttext(1,1,80,25,savebffr);
	puttextinfo(&saveti);

	if ( Aborted )
	{
		mdelete("MIDPAK.XMI"); // Delete the default MIDPAK.XMI file.
		mdelete("MIDPAK.AD");  // Delete the midpak bank file.
		mdelete("MIDPAK.ADV"); // Delete the MIDPAK.ADV file.
		mdelete("MIDPAK.COM"); // Delete the MIDPAK.COM file.
		printf("No music driver configued.\n");
		exit(1);
	}
	else
	{
		printf("Music driver successfully configured.\n");
		#if KSONIC
		printf("Type KS to run the KaleidoSonics.\n");
		printf("Use the KS.PIF and KS.ICO if you want to launch from Windows\n");
		#endif
		#if SEAWOLF
		fh = fopen("MUSIC.ID", "wb");
		fwrite(&MusicID, 2, 1, fh);
		fclose(fh);
		#endif
		exit(0);
	}
}


int 		exists(char *path)
{
	FILE		*fh;

	fh = fopen(path,"r");
	if (fh == NULL) return (0);
	fclose(fh);
	return (1);
}


char 		error_message(void)
{
	int 		xcon,ret;
	char    *bffr,ch;
	struct text_info ti;

	if (SpecialCritError)
		return (0);

	gettextinfo(&ti);
	bffr = malloc(730);

	xcon = 0;
	do
	{
		gettext(15,10,66,16,bffr);

		NewWindow(15,10,66,16,RED,WHITE,"",SINGLE);
		gotoxy(40,11);
		CenterString("A disk error has occured!");
		gotoxy(40,14);
		CenterString("Press 'R' to retry.");
		gotoxy(40,15);
		CenterString("Press ESC to terminate Install Program.");

		ch = toupper(getkey());
		puttext(15,10,66,16,bffr);
		if (ch == 27) 				// Abort installation
		{
			free(bffr);
			window(1,1,80,25);
			textcolor(WHITE);
			textbackground(BLACK);
			clrscr();
			cprintf("Installation terminated!\r\n");
			chdir("\\");
			_setcursortype(_NORMALCURSOR);
			ret = 2;
			xcon = 1;
		}
		if (ch == 'R')
		{
			ret = 1;
			xcon = 1;
		}
	} while (!xcon);

	free(bffr);

	puttextinfo(&ti);
	return (ret);
}


void		Copy(char *src,char *dst)
{
	struct ffblk fb;
	int 		xcon;
	char		srcname[80],dstname[80],tfname[15];
	char    srcpath[80],dstpath[80];
	char 		drive[MAXDRIVE];
	char 		dir[MAXDIR];
	char 		file[MAXFILE];
	char 		ext[MAXEXT];
	int 		flags;

//	printf("Copying file '%s' to file '%s'. Press a key to continue.\n",src,dst);
//	getch();

	flags = fnsplit(src,drive,dir,file,ext);

	srcpath[0] = 0;
	if (flags & DRIVE) strcat(srcpath,drive);
	if (flags & DIRECTORY) strcat(srcpath,dir);

	flags = fnsplit(dst,drive,dir,file,ext);

	dstpath[0] = 0;
	if (flags & DRIVE) strcat(dstpath,drive);
	if (flags & DIRECTORY) strcat(dstpath,dir);
	if (flags & FILENAME) strcpy(tfname,file);
	if (flags & EXTENSION) strcat(tfname,ext);


	xcon = 0;
	xcon = findfirst(src,&fb,0);
	strcpy(srcname,srcpath);
	strcat(srcname,fb.ff_name);
	strcpy(dstname,dstpath);
	if (dst != NULL)
		strcat(dstname,tfname);
	else
		strcat(dstname,fb.ff_name);
	while (!xcon)
	{
		FileCopy(srcname,dstname);
		xcon = findnext(&fb);
		strcpy(srcname,srcpath);
		strcat(srcname,fb.ff_name);
		strcpy(dstname,dstpath);
		if (dst != NULL)
			strcat(dstname,tfname);
		else
			strcat(dstname,fb.ff_name);
	}
}

//1
int 		SelectSound(int x1,int y1,int x2,int y2,int mx,int cur)
{
	int attention;
	int 		AskConfig=0,Configurable;
	char		bffr[160];
	char		scrl[4096];
	char		curattr;
	int 		i,h,top,j,hl,xcon,ch,sel,ol,ot;
	int			Sound;

	struct text_info saveti;
	char		savebffr[4000];

	gettext(x1,y1-1,x1,y1-1,bffr);
	curattr = bffr[1];

	h = y2 - y1 + 1;
	top = 0;
	sel = cur;

	if (sel < h/2+1) hl = sel;
	if (sel > mx-(h/2+1)) hl = sel - (mx-h);
	if (sel > h/2 && sel < mx-(h/2)) top = sel - h/2;

	for (i=top,j=0; i<h+top; i++,j++)
	{
		gotoxy(40,y1+j);
		CenterString(md[i].title);
	}

	gettext(x1,hl+y1,x2,hl+y1,bffr);
	for (i=1; i<160; i+=2) bffr[i] = BLACK*16+WHITE;
	puttext(x1,hl+y1,x2,hl+y1,bffr);

	xcon = 0;
	do
	{
		Sound = sel;
		gotoxy(x1+2,y1-1);
		if (top)
		{
			textcolor(WHITE);
			textbackground(RED);
			cputs(" MORE ");
			textattr(curattr);
		}
		else
		{
			textattr(curattr);
			cputs("");
		}
		gotoxy(x1+2,y2+1);
		if (top+h < mx)
		{
			textcolor(WHITE);
			textbackground(RED);
			cputs(" MORE ");
			textattr(curattr);
		}
		else
		{
			textattr(curattr);
			cputs("");
		}

		attention = 0;

		if (!strcmp(md[sel].file,"ARIAXMID.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Aria Based Sound Cards",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you have any of the popular");
			center("sound cards based on the Aria chipset from Sierra");
			center("Semiconductor. This includes the MidiMaestro from Computer");
			center("Peripherals and the Sonic Sound from Diamond computer systems.");
			center("MIDI driver written by Kerchen Heller at Sierra.  REQUIRES");
			center("the SET ARIA= variable in your AUTOEXEC.BAT..");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"WSS.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Microsoft Sound System",DOUBLE);
			lineno = 15;
			center("Select this driver if you have the Microsoft Windows");
			center("Sound System, from Microsoft.");
			center("");
			center("OPL3 MIDI driver written by John Miles, Miles Design Inc.");
			center(" General MIDI patches (c) 1994 The Fat Man and K. Weston Phelan ");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"MULTISND.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Turtle Beach Multisound",DOUBLE);
			lineno = 15;
      center("Select this sound driver if you own the Turtle Beach Multisound.");
			center("Currently this driver will only work if you have installed your");
			center("Turtle at the default manufacturer settings.  This driver will");
			center("not work unless you have run the PRESETS program provided by");
			center("Turtle Beach Systems prior to using MIDPAK.  Special thanks");
			center("to Roy Smith and Richard Mazzerese for creating this driver.");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"SBFM.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Creative Labs Sound Blaster",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you own a SoundBlaster card from");
			center("Creative Labs or any basic SoundBlaster compatible.");
			center("");
			center("OPL2 MIDI driver written by John Miles, Miles Design Inc.");
			center(" General MIDI patches (c) 1994 The Fat Man and K. Weston Phelan ");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"SBP1FM.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Creative Labs SoundBlaster Pro - OPL2",DOUBLE);
			lineno = 15;
			center("Select this driver if you have an original SoundBlaster Pro from");
			center("Creative Labs which uses the OPL2 chip set.");
			center("");
			center("OPL2 MIDI driver written by John Miles, Miles Design Inc.");
			center(" General MIDI patches (c) 1994 The Fat Man and K. Weston Phelan ");
			attention = 1;
		}

		if (!strcmp(md[sel].file,"SBP2FM.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Creative Labs SoundBlaster Pro - OPL3",DOUBLE);
			lineno = 15;
			center("Select this driver if you have a SoundBlaster Pro from");
			center("Creative Labs which uses the OPL3 chip set or the");
			center("SoundBlaster 16.  However, if you have the WaveBlaster");
			center("daughter board, you want to select the MPU401 driver instead.");
			center("OPL3 MIDI driver written by John Miles, Miles Design Inc.");
			center(" General MIDI patches (c) 1994 The Fat Man and K. Weston Phelan ");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"PASOPL.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"MediaVision ProAudio Spectrum 16",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you have a ProAudio Spectrum 16");
			center("from MediaVision or a Logitech SoundMan 16 from Logitech.");
			center("This driver requires the presence of MVSOUND.SYS in your");
			center("CONFIG.SYS to run (availabe during manufacturer's install)");
			center("OPL3 MIDI driver written by John Miles, Miles Design Inc.");
			center(" General MIDI patches (c) 1994 The Fat Man and K. Weston Phelan ");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"ADLIBG.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Adlib Gold",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you own an Adlib Gold sound card.");
			center("");
			center("OPL3 MIDI driver written by John Miles, Miles Design Inc.");
			center(" General MIDI patches (c) 1994 The Fat Man and K. Weston Phelan ");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"PASFM.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"MediaVision ProAudio Spectrum 8",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you have one of the original");
			center("MediaVision ProAudio Spectrum 8 digital sound cards.");
			center("This driver requires the presence of MVSOUND.SYS in your");
			center("CONFIG.SYS to run (availabe during manufacturer's install)");
			center("OPL2 MIDI driver written by John Miles, Miles Design Inc.");
			center(" General MIDI patches (c) 1994 The Fat Man and K. Weston Phelan ");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"PCSPKR.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"PC Speaker",DOUBLE);
			lineno = 15;
	#if SEAWOLF || KSONIC
			center("Select this driver if you do not own any third party");
			center("audio device.  This selection will allow you to");
			center("install without music, which hsa the side benefit of");
			center("making more memory available to the product.");
			center("");
	#else
			center("Select this driver if you do not own any third party");
			center("audio device and wish to hear music out of your");
			center("PC internal speaker.  This driver only plays once channel");
			center("of music at a time.");
			center("");
			center("Written by John Miles, Miles Design Inc.");
#endif
			attention = 1;
		}
		if (!strcmp(md[sel].file,"ADLIB.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Adlib Personal Music System",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you own the original Adlib Personal");
			center("Music system or compatible.");
			center("");
			center("OPL2 MIDI driver written by John Miles, Miles Design Inc.");
			center(" General MIDI patches (c) 1994 The Fat Man and K. Weston Phelan ");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"TANDY.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Tandy EX/TX",DOUBLE);
			lineno = 15;
			center("Select this sound driver only if you own one of the very");
			center("old Tandy 3 voice systems.  This includes the Tandy EX,");
			center("TX,HX,SX, and even the original IBM PCjr.  The quality of");
			center("the music is limited on this system.");
			center("");
			center("Written by John Miles, Miles Design, Inc.");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"SENSAT.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Tandy Sensation",DOUBLE);
			lineno = 15;
			center("Select this sound driver if you own a Tandy Sensation");
			center("");
			center("OPL3 MIDI driver written by John Miles, Miles Design Inc.");
			center(" General MIDI patches (c) 1994 The Fat Man and K. Weston Phelan ");
			center("");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"GF1MIDI.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Gravis Ultrasound",DOUBLE);
			lineno = 15;
			center("Select this driver if you own the Gravis Ultrasound from");
			center("Gravis.  This driver REQUIRES the presence of the manufacturer");
			center("provided ULTRAMID driver.  You can get ULTRAMID from Gravis.");
			center("ULTRAMID provides high quality digital sound on your Ultrasound and");
			center("stunning quality music.  Thanks to Brad Craig of Gravis, and very");
			center("special thanks to Mike Leibow of Forte for creating these drivers.");
			attention = 1;
		}

		if (!strcmp(md[sel].file,"MT32MPU.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Roland LAPC/MT32",DOUBLE);
			lineno = 15;
			center("Select this sound card if you have an original Roland LAPC");
			center("or Roland MT-32 in your machine connected via an MPU401");
			center("interface.");
			center("");
			center("MIDI driver written by John Miles, Miles Design Inc.");
			attention = 1;
		}


		if (!strcmp(md[sel].file,"GENMID.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"MPU401 General MIDI",DOUBLE);
			lineno = 15;
			center("Select this driver if you have a General MIDI synthesizer");
			center("connected via an MPU401 interface.  This includes the Ensoniq");
			center("SoundScape, Turtle Beach Maui card, Creative Labs WaveBlaster");
			center("and others.");
			center("");
			center("MIDI driver written by John Miles, Miles Design Inc.");
			attention = 1;
		}
		if (!strcmp(md[sel].file,"SC32MPU.ADV"))
		{
			NewWindow(5,14,75,21,GREEN,WHITE,"Roland Sound Canvas",DOUBLE);
			lineno = 15;
			center("Select this driver if you have a Roland Sound Canvas, either");
			center("the SC55 or the SCC1, or the Roland RAP10.");
			center("");
			center("MIDI driver written by John Miles, Miles Design Inc.");
			attention = 1;
		}

		if (!attention ) clearbox(5,14,75,21,BLUE,WHITE);


		if ( strcmp(md[sel].file,"MULTISND.ADV") == 0 )
			OnTurtleBeach = 1;
		else
			OnTurtleBeach = 0;

		if (	strcmp(md[sel].file,"SBFM.ADV") == 0 ||
					strcmp(md[sel].file,"SBP1FM.ADV") == 0 ||
					strcmp(md[sel].file,"SBP2FM.ADV") == 0 )
		{
			OnSoundBlaster = 1;
			if ( SoundBlaster ) md[sel].BaseAddr = SoundBlasterBaseAddress;
			Configurable = 1;
		}
		else
		{
			OnSoundBlaster = 0;
			Configurable = 0;
		}

		textcolor(WHITE);
		textbackground(BLUE);
		if ( Configurable )
		{
			AskConfig = 1;
			gotoxy(40,23);
			CenterString("Press 'C' to reconfigure hardware.");
		}
		else
		{
			AskConfig = 0;
			gotoxy(40,23);
			CenterString("                                  ");
		}


	// ***??? Print Sb info?
		if ( SoundBlaster && OnSoundBlaster )
		{
			textcolor(WHITE);
			textbackground(RED);
			sprintf(scratch,"SoundBlaster or compatible detected at base address: %X.",SoundBlasterBaseAddress);
			gotoxy(40,22);
			CenterString(scratch);
		}
		else
		{
			textcolor(BLUE);
			textbackground(BLUE);
			gotoxy(40,22);
			CenterString("                                                                        ");
		}

		textcolor(BLACK);
		textbackground(WHITE);

		ch = getkey();
		ol = hl;
		ot = top;
		switch (ch)
		{
			case 328: 	// Up Arrow
			case 331: 	// Right Arrow
				if (sel > 0) sel--;
				break;
			case 336: 	// Down Arrow
			case 333: 	// Left Arrow
				if (sel < mx-1) sel++;
				break;
			case 'c':
			case 'C':
				gettextinfo(&saveti);
				gettext(1,1,80,25,savebffr);
				ConfigDriver(Sound);
				puttext(1,1,80,25,savebffr);
				puttextinfo(&saveti);
				break;
			case 13:		// Enter
				xcon = 1;
				break;
			case 27:		// Esc
				xcon = 1;
				sel = -1;
				break;
		}

		gettext(x1,ol+y1,x2,ol+y1,bffr);
		for (i=1; i<160; i+=2) bffr[i] = LIGHTGRAY*16+BLACK;
		puttext(x1,ol+y1,x2,ol+y1,bffr);

		if (!xcon)
		{
			if (sel < h/2+1) hl = sel;
			if (sel >= mx-(h/2+1)) hl = sel - (mx-h);
			if (sel >= h/2 && sel < mx-(h/2)) top = sel - h/2;

			if (top > ot)
			{
				gettext(x1,y1+1,x2,y2,scrl);
				puttext(x1,y1,x2,y2-1,scrl);
				gotoxy(x1,y2);
				for (i=x1; i<x2; i++) putch(' ');
				gotoxy(40,y2);
				CenterString(md[top+h-1].title);
			}

			if (top < ot)
			{
				gettext(x1,y1,x2,y2-1,scrl);
				puttext(x1,y1+1,x2,y2,scrl);
				gotoxy(x1,y1);
				for (i=x1; i<x2; i++) putch(' ');
				gotoxy(40,y1);
				CenterString(md[top].title);
			}

			gettext(x1,hl+y1,x2,hl+y1,bffr);
			for (i=1; i<160; i+=2) bffr[i] = BLACK*16+WHITE;
			puttext(x1,hl+y1,x2,hl+y1,bffr);
		}
	} while (!xcon);
	return (sel);
}


void		ErrorOut(char *msg)
{
  _setcursortype(_NORMALCURSOR);
	puttext(1,1,80,25,savebffr);
	puttextinfo(&saveti);
	cputs(msg);
	exit(1);
}


int 		GetSoundFiles(void)
{
	FILE	 *fh;
	struct ffblk fb;
	int 		xcon = 0,i=0,l;
	char		name[13];
	unsigned base,irq,other;

	xcon = findfirst("*.add",&fb,0);
	while (!xcon)
	{
		strcpy(md[i].addfile,fb.ff_name);

		strcpy(name,fb.ff_name);
		strcpy(md[i].file,strtok(name,"."));
		strcat(md[i].file,".ADV");

		fh = fopen(fb.ff_name,"r");
		fgets(md[i].title,MIDIDESC,fh);
		l = strlen(md[i].title);
		if (md[i].title[l-1] == '\n')
			md[i].title[l-1] = 0;
		fscanf(fh,"%X,%X,%X\n",&base,&irq,&other);
		fclose(fh);
		md[i].BaseAddr = base;
		md[i].IRQ = irq;
		md[i].Other = other;
		i++;

		xcon = findnext(&fb);
	}

	qsort((void *)md, i, sizeof(md[0]), sortcmp);

	return (i);
}


int			sortcmp(const void *a, const void *b)
{
	return (strcmp((char *)a, (char *)b));
}


// Define memory allocation functions.	If using DOS memory allocation
// functions, provided through DOSCALLS, then set the conditional compilation
// 'DOSALLOC' to true.  If using C compiler library function memory allocation
// set 'DOSALLOC' to zero.

#define DOSALLOC 0
// Redirect memory allocation to either DOS memory allocate functions located
// in DOSCALLS or to C library far memory allocation functions.
unsigned char far * far memalloc(long int siz)
{
	#if DOSALLOC
		return(fmalloc(siz));  // DOS far memory allocation functions
	#else
		return(farmalloc(siz)); // C's far memory allocation functions.
	#endif
}

void far memfree(char far *memory)
{
	#if DOSALLOC
		ffree(memory);
	#else
		farfree(memory);
	#endif
}

void		ConfigDriver(int driver)
{
	FILE *fh;

	NewWindow(13,4,69,22,CYAN,BLACK,"Configure Sound Driver",DOUBLE);
	window(15,6,68,20);

	GetBaseAddr(driver);
	if ( OnTurtleBeach )
	{
		GetIRQ(driver);
		GetOther(driver);
	}

	window(1,1,80,25);
	clearbox(13,4,69,22,BLUE,WHITE);
}


int 		GetBaseAddr(int driver)
{
	int			ix,iy,t;
	struct text_info ti;

	gettextinfo(&ti);
	cprintf("Default Base Address: %4X (hex)\r\n\n",md[driver].BaseAddr);
	cputs("Enter new Base Address: ");
	ix = wherex();
	iy = wherey();

	textcolor(WHITE);
	textbackground(BLUE);
	cputs("    ");
	textattr(ti.attribute);

	cputs("  (hex)");

	cputs("\r\n\n\nThe Base Address of a sound device is the location\r\n");
	cputs("where data is sent and recieved.  If there is a\r\n");
	cputs("conflict with another device, you may experience\r\n");
	cputs("problems with one of the devices, consequently\r\n");
	cputs("a new location will need to be found for\r\n");
	cputs("either device. FFFF means DEFAULT VALUE!");

	if ( SoundBlaster && OnSoundBlaster)
	{
		textcolor(WHITE);
		textbackground(RED);
		sprintf(scratch,"\r\nSoundBlaster or compatible device detected at \r\nbase address: %X\r\n",SoundBlasterBaseAddress);
		cputs(scratch);
	}


	textcolor(WHITE);
	textbackground(BLUE);
	t = gethex(ix,iy,&md[driver].BaseAddr);
	textattr(ti.attribute);
	if (t==-1) return (-1);
	//md[driver].BaseAddr = t;
	return (0);
}


int 		GetIRQ(int driver)
{
	int			ix,iy,t;
	struct text_info ti;

	clrscr();
	gettextinfo(&ti);
	cprintf("Default IRQ: %4X (hex)\r\n\n",md[driver].IRQ);
	cputs("Enter new IRQ: ");
	ix = wherex();
	iy = wherey();

	textcolor(WHITE);
	textbackground(BLUE);
	cputs("    ");
	textattr(ti.attribute);

	cputs("  (hex)");


	cputs("\r\n\nThe IRQ or Interrupt ReQuest line is used to let\r\n");
	cputs("the sound device know that data is ready.\r\n");
	cputs("There are only about 7 of these lines available,\r\n");
	cputs("so there is a lot of potential for conflict.  As\r\n");
	cputs("with the Base Address, if two devices use the same\r\n");
	cputs("IRQ line, one will have to be changed.\r\n");
	cputs("FFFF means DEFAULT value.");

	textcolor(WHITE);
	textbackground(BLUE);
	t = gethex(ix,iy,&md[driver].IRQ);
	textattr(ti.attribute);
	if (t==-1) return (-1);
	//md[driver].IRQ = t;
	return (0);
}


int 		GetOther(int driver)
{
	int			ix,iy,t;
	struct text_info ti;

	clrscr();
	gettextinfo(&ti);
	cprintf("Default Extra value: %4X (hex)\r\n\n",md[driver].Other);
	cputs("Enter new Extra value: ");
	ix = wherex();
	iy = wherey();

	textcolor(WHITE);
	textbackground(BLUE);
	cputs("    ");
	textattr(ti.attribute);

	cputs("  (hex)");

	cputs("\r\n\nThis value is different depending on the sound\r\n");
	cputs("device.  Check your users manual before changing\r\n");
	cputs("the value of this entry. FFFF means use DEFAULT.");

	if ( SoundBlaster )
	{
		textcolor(WHITE);
		textbackground(RED);
		sprintf(scratch,"\r\nSoundBlaster or compatible detected at IRQ: %X.\r\n",SoundBlasterIRQ);
		cputs(scratch);
	}

	textcolor(WHITE);
	textbackground(BLUE);
	t = gethex(ix,iy,&md[driver].Other);
	textattr(ti.attribute);
	if (t==-1) return (-1);
	//md[driver].Other = t;
	return (0);
}


int			gethex(int x,int y,unsigned* startvalue)
{
	int			xcon,gxcon,ip;
	unsigned value;
	char		ch,in[6];

	ip = 0;
	in[0] = 0;

	_setcursortype(_NORMALCURSOR);
	gotoxy(x,y);

	xcon = 0;
	do
	{
		gxcon = 0;
		do
		{
			ch = toupper(getch());
			if (ch == 27 || ch == 13 || ch == 8 || isxdigit(ch)) gxcon = 1;
		} while (!gxcon);
		switch (ch)
		{
			case 27:
				in[0] = 0;
				xcon = 1;
			case 13:
				if (!ip)
					sprintf(in,"%X",*startvalue);
				else
					in[ip] = 0;
				xcon = 1;
				break;
			case 8:
				if (ip)
				{
					putch(8);
					putch(' ');
					putch(8);
					ip--;
				}
				break;
			default:
				if (ip < 4)
				{
					putch(ch);
					in[ip] = ch;
					ip++;
				}
				break;
		}
	} while (!xcon);
	_setcursortype(_NOCURSOR);
	sscanf(in,"%x",&value);
	*startvalue = value;
	if (ch==27)
		return -1;
	else
		return (0);
}


#if KSONIC
void CopyGM(void)
{
	Copy("credits.opl","credits.xmi");
	Copy("desert.opl","desert.xmi");
	Copy("earth.opl","earth.xmi");
	Copy("majesty.opl","majesty.xmi");
	Copy("sea.opl","sea.xmi");
	Copy("sky.opl","sky.xmi");
	Copy("space.opl","space.xmi");
	Copy("title.opl","title.xmi");
}

void CopyMT32(void)
{
	Copy("init-mt.m32","midpak.xmi");
	Copy("credits.m32","credits.xmi");
	Copy("desert.m32","desert.xmi");
	Copy("earth.m32","earth.xmi");
	Copy("majesty.m32","majesty.xmi");
	Copy("sea.m32","sea.xmi");
	Copy("sky.m32","sky.xmi");
	Copy("space.m32","space.xmi");
	Copy("title.m32","title.xmi");
}

void CopySCC(void)
{
	Copy("credits.scc","credits.xmi");
	Copy("desert.scc","desert.xmi");
	Copy("earth.scc","earth.xmi");
	Copy("majesty.scc","majesty.xmi");
	Copy("sea.scc","sea.xmi");
	Copy("sky.scc","sky.xmi");
	Copy("space.scc","space.xmi");
	Copy("title.scc","title.xmi");
}
#endif


// Ask the user if they want to auto-detect for the precense of
// a soundblaster.

#define ASKX1 20
#define ASKY1 7
#define ASKX2 60
#define ASKY2 10

int AskBlast(void)
{
	int 		xcon,ret;
	char    *bffr,ch;
	struct text_info ti;

	gettextinfo(&ti);
	bffr = malloc(4000);
	xcon = 0;
	do
	{
		gettext(ASKX1,ASKY1,ASKX2,ASKY2,bffr);
		NewWindow(ASKX1,ASKY1,ASKX2,ASKY2,RED,WHITE,"",SINGLE);
		gotoxy(40,ASKY1+1);
		CenterString("Do you want to auto-detect for the");
		gotoxy(40,ASKY1+2);
		CenterString("presence of a SoundBlaster? (y/n)");
		ch = toupper(getch());
		puttext(ASKX1,ASKY1,ASKX2,ASKY2,bffr);
		if ( ch == 27 )
		{
			ret = 2;
			xcon = 1;
		}
		if (ch == 'Y' || ch == 'N' )
		{
			if ( ch == 'Y' )
				ret = 1;
			else
				ret = 0;
			xcon = 1;
		}
	} while (!xcon);
	free(bffr);
	puttextinfo(&ti);
	return (ret);
}

#define ERRORX1 20
#define ERRORY1 7
#define ERRORX2 60
#define ERRORY2 10

int ErrorMsg(char *str)
{
	int 		xcon,ret;
	char    *bffr,ch;
	struct text_info ti;

	gettextinfo(&ti);
	bffr = malloc(4000);
	xcon = 0;
	do
	{
		gettext(ERRORX1,ERRORY1,ERRORX2,ERRORY2,bffr);
		NewWindow(ERRORX1,ERRORY1,ERRORX2,ERRORY2,RED,WHITE,"",SINGLE);
		gotoxy(40,ERRORY1+1);
		CenterString(str);
		gotoxy(40,ERRORY1+2);
		CenterString("Press a key to continue.");
		ch = toupper(getch());
		puttext(ERRORX1,ERRORY1,ERRORX2,ERRORY2,bffr);
		xcon = 1;
	} while (!xcon);
	free(bffr);
	puttextinfo(&ti);
	return (ret);
}

#define TESTX1 20
#define TESTY1 7
#define TESTX2 60
#define TESTY2 10

int TestDriver(void)
{
	int 		xcon,ret;
	char    *bffr,ch;
	struct text_info ti;

	gettextinfo(&ti);
	bffr = malloc(4000);
	xcon = 0;
	do
	{
		gettext(TESTX1,TESTY1,TESTX2,TESTY2,bffr);
		NewWindow(TESTX1,TESTY1,TESTX2,TESTY2,RED,WHITE,"",SINGLE);
		gotoxy(40,TESTY1+1);
		CenterString("Are you ready to test the");
		gotoxy(40,TESTY1+2);
		CenterString("sound driver you have selected? (y/n)");
		ch = toupper(getch());
		puttext(TESTX1,TESTY1,TESTX2,TESTY2,bffr);
		if (ch == 'Y' || ch == 'N' || ch == 27 )
		{
			if ( ch == 'Y' )
				ret = 1;
			else
				ret = 0;
			xcon = 1;
		}
	} while (!xcon);
	free(bffr);
	puttextinfo(&ti);
	return (ret);
}


#define LOADX1 20
#define LOADY1 7
#define LOADX2 60
#define LOADY2 16

int LoadTestDriver(void)
{
	char far *music;
	int 		xcon,ret;
	char    *bffr,ch;
	struct text_info ti;
	long int siz;

	ret = LoadMidPak("MIDPAK.COM", "MIDPAK.ADV", "MIDPAK.AD" );
	if (!ret)
	{
		ErrorMsg("Unable to load MIDPAK");
		return(0);
	}

	ret = InitMidPak();
	if ( !ret )
	{
		UnLoadMidPak(); // Unload MIDPAK from memory.
		ErrorMsg("Failed to initialize music driver.");
		return(0);
	}

#if KSONIC
	music = fload("SETUP.MUS", &siz);
#else
	music = fload("SETM.XMI", &siz);
#endif
	if ( !music )
	{
		UnLoadMidPak();
#if KSONIC
		ErrorMsg("Failed to locate test music 'SETUP.MUS'.");
#else
		ErrorMsg("Failed to locate test music 'SETM.XMI'.");
#endif
		return(0);
	}
	RegisterXmidi(music,siz);
	SegueSequence(1,-1);
	PlaySequence(0);
	gettextinfo(&ti);
	bffr = malloc(4000);
	xcon = 0;
	do
	{
		gettext(LOADX1,LOADY1,LOADX2,LOADY2,bffr);
		NewWindow(LOADX1,LOADY1,LOADX2,LOADY2,RED,WHITE,"",SINGLE);
		gotoxy(40,LOADY1+1);
		CenterString("Press 1-4 to Segue Music");
		gotoxy(40,LOADY1+3);
		CenterString("Is the music playing ok? (y/n)");

		gotoxy(40,LOADY1+5);
		CenterString("Configuration music by Rob Wallace");
		gotoxy(40,LOADY1+6);
		CenterString("Copyright (c) 1993");
		gotoxy(40,LOADY1+7);
		CenterString(" Wallace Music & Sound ");

		do
		{
			ch = toupper(getch());
			if ( ch >= '1' && ch <= '4' )
			{
				SegueSequence(ch-'0',-1);
			}
			if (ch == 'Y' || ch == 'N' || ch == 27 )
			{
				if ( ch == 'Y' )
					ret = 1;
				else
					ret = -1;
				xcon = 1;
			}
		} while (!xcon);
		puttext(LOADX1,LOADY1,LOADX2,LOADY2,bffr);
	} while (!xcon);
	free(bffr);
	puttextinfo(&ti);
	DeInitMidPak();
	UnLoadMidPak();
	return (ret);
}

void center(char *str)
{
	gotoxy(40,lineno);
	CenterString(str);
	lineno++;
}


#if QUICKFIRE

void QFGM(void)
{
	Copy("QF1-SCC1.XMI","LAUNCH.XMI");
	Copy("QF2-SCC1.XMI","QF.XMI");
	Copy("QFA-SCC1.XMI","TITLE.XMI");
}

void QFMT(void)
{
	Copy("QF1-MT32.XMI","LAUNCH.XMI");
	Copy("QF2-MT32.XMI","QF.XMI");
	Copy("QFA-MT32.XMI","TITLE.XMI");
}

void QFFM(void)
{
	Copy("QF1-MIDP.XMI","LAUNCH.XMI");
	Copy("QF2-MIDP.XMI","QF.XMI");
	Copy("QFA-MIDP.XMI","TITLE.XMI");
}

#endif
