@echo off
rem --------------------------------------------------------------
rem BUILD.BAT for EdMap v1.25+                (by Jeff Rabenhorst)
rem
rem         Edit this file to use a different NODE-BUILDER
rem
rem   Requires STUFFBUF.EXE to insert keystrokes into the buffer
rem  *and NPXTEST.EXE to test whether a NPX (80x87) is availible*
rem  *and DOOM2WAD.EXE to convert PWAD map entries (DOOM1/DOOM2)*
rem --------------------------------------------------------------
rem passed parameters:
rem 	1=WAD filename, "C:\GAMES\DOOM\PWADS\CITADEL" (no ".WAD")
rem		2="ALTBUILD", not used until v1.32
rem		3=used by EdMap, for DOOM2--DOOM1/HERETIC conversion
rem		4,
rem		5=used by EdMap, for EDMAPCOM
rem --------------------------------------------------------------
	if not "%1"=="" goto ONEPARAM
	ERROR Missing WAD filename.
	goto TEXTDESC
:ONEPARAM
	if "%1"=="/?" goto TEXTDESC
	if "%1"=="-?" goto TEXTDESC
	if exist %1.wad goto OKPARAMS
	ERROR %1.WAD does not exist.
	goto TEXTDESC
:OKPARAMS
	set GO32=emu EMU387
	copy %1.wad backup.wad > nul
	echo Building BSP data...
:BUILDNOW
	if "%2"=="ALTBUILD" goto ALTBUILD
	WARMDOS -z -n -b %1.WAD
	goto DONEBUILD
:ALTBUILD
	WARMDOS -n -b -r %1.WAD
:DONEBUILD
	if errorlevel 1 goto BUILDFAILED

		echo 
		echo Finished building PWAD; %1.WAD is now playable.
		echo 
		if "%5"=="" goto END
			STUFFBUF !
			EDMAPCOM %4 %5 BUILT OK
		goto END
:BUILDFAILED
		copy backup.wad %1.wad > nul
		if "%4"=="" goto FAILTEXT
				EDMAPCOM %4 %5 PLAYMAP=FALSE
				EDMAPCOM %4 %5 ERROR BuildFailed
:FAILTEXT
		echo BUILD FAILED!
		echo PWAD RESTORED
		goto END
:NONPX
		if "%5"=="" goto NONPXTEXT
				EDMAPCOM %4 %5 PLAYMAP=FALSE
				EDMAPCOM %4 %5 ERROR NoNPX
:NONPXTEXT
		echo BUILD FAILED!
		echo No NPX (80x87) present for builder.
		goto END
:TEXTDESC
	echo 
	echo BUILD.BAT        
	echo   PWAD node-builder (builds BSP data for maps)
	echo 
	echo format: BUILD filename
	echo     ex: BUILD C:\DOOM\PWADS\CASTLE
	echo 
	goto END
:END
rem --------------------------------------------------------------
