/* Copyright (C) 1994 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* seexec.c */
/* eexec filters for Ghostscript */
#include "stdio_.h"		/* includes std.h */
#include "strimpl.h"
#include "sfilter.h"
#include "gscrypt1.h"
#include "scanchar.h"

/* ------ eexecEncode ------ */

/* Encoding is much simpler than decoding, because we don't */
/* worry about initial characters or hex vs. binary (the client */
/* has to take care of these aspects). */

private_st_exE_state();

#define ss ((stream_exE_state *)st)

/* Process a buffer */
private int
s_exE_process(stream_state *st, stream_cursor_read *pr,
  stream_cursor_write *pw, bool last)
{	const byte *p = pr->ptr;
	byte *q = pw->ptr;
	uint rcount = pr->limit - p;
	uint wcount = pw->limit - q;
	uint count;
	int status;
	if ( rcount <= wcount )
		count = rcount, status = 0;
	else
		count = wcount, status = 1;
	gs_type1_encrypt(q + 1, p + 1, count, (crypt_state *)&ss->cstate);
	pr->ptr += count;
	pw->ptr += count;
	return status;
}

#undef ss

/* Stream template */
const stream_template s_exE_template =
{	&st_exE_state, NULL, s_exE_process, 1, 2
};

/* ------ eexecDecode ------ */

private_st_exD_state();

#define ss ((stream_exD_state *)st)

/* Initialize the state for reading and decrypting. */
/* Decrypting streams are not positionable. */
private int
s_exD_init(stream_state *st)
{	ss->odd = -1;
	ss->binary = -1;		/* unknown */
	ss->skip = 4;
	return 0;
}

/* Process a buffer. */
private int
s_exD_process(stream_state *st, stream_cursor_read *pr,
  stream_cursor_write *pw, bool last)
{	register const byte *p = pr->ptr;
	register byte *q = pw->ptr;
	int skip = ss->skip;
	int rcount = pr->limit - p;
	int wcount = pw->limit - q;
	int status = 0;
	int count;
	count = (wcount < rcount ? (status = 1, wcount) : rcount);
	if ( ss->binary < 0 )
	{	/* This is the very first time we're filling the buffer. */
		/* Determine whether this is ASCII or hex encoding. */
		register const byte _ds *decoder = scan_char_decoder;
		if ( count < 4 )
			return 0;
		if ( decoder[p[1]] == ctype_space ||
		     (decoder[p[1]] | decoder[p[2]] | decoder[p[3]] |
		      decoder[p[4]]) <= 0xf )
		{	/* Would be invalid if binary, hence must be hex. */
			ss->binary = 0;
		}
		else	
			ss->binary = 1;
	}
	if ( ss->binary )
		pr->ptr = p + count;
	else
	{	status = s_hex_process(pr, pw, &ss->odd, false);
		p = q;
		count = pw->ptr - q;
	}
	if ( skip >= count )
	{	gs_type1_decrypt(q + 1, p + 1, count,
				 (crypt_state *)&ss->cstate);
		ss->skip -= count;
		count = 0;
	}
	else
	{	gs_type1_decrypt(q + 1, p + 1, skip,
				 (crypt_state *)&ss->cstate);
		count -= skip;
		gs_type1_decrypt(q + 1, p + 1 + skip, count,
				 (crypt_state *)&ss->cstate);
		ss->skip = 0;
	}
	pw->ptr = q + count;
	return status;
}

#undef ss

/* Stream template */
/*
 * The specification of eexec decoding requires that it never read more than
 * 512 source bytes ahead.  The only reliable way to ensure this is to
 * limit the size of the output buffer to 256.  We set it a little smaller
 * so that it will stay under the limit even after adding min_in_size
 * for a subsequent filter in a pipeline.  Note that we have to specify
 * a size of at least 128 so that filter_read won't round it up.
 */
const stream_template s_exD_template =
{	&st_exD_state, s_exD_init, s_exD_process, 4, 200
};
