/* Copyright (C) 1991, 1992 Aladdin Enterprises.  All rights reserved.
  
  This file is part of Aladdin Ghostscript.
  
  Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
  or distributor accepts any responsibility for the consequences of using it,
  or for whether it serves any particular purpose or works at all, unless he
  or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
  License (the "License") for full details.
  
  Every copy of Aladdin Ghostscript must include a copy of the License,
  normally in a plain ASCII text file named PUBLIC.  The License grants you
  the right to copy, modify and redistribute Aladdin Ghostscript, but only
  under certain conditions described in the License.  Among other things, the
  License requires that the copyright notice and this notice be preserved on
  all copies.
*/

/* time_.h */
/* Generic substitute for Unix sys/time.h */

/* We must include std.h before any file that includes sys/types.h. */
#include "std.h"

/* The location (or existence) of certain system headers is */
/* environment-dependent. We detect this in the makefile */
/* and conditionally define switches in gconfig_.h. */
#include "gconfig_.h"

/* Some System V environments don't include sys/time.h. */
/* The SYSTIME_H switch in gconfig_.h reflects this. */
#ifdef SYSTIME_H
#  include <sys/time.h>
#else
struct timeval {
	long tv_sec, tv_usec;
};
struct timezone {
	int tz_minuteswest, tz_dsttime;
};
#endif

#if defined(AUX) || defined(_IBMR2) || defined(SYSV) || defined(SVR4)		/* A/UX, IBM RS/6000, AIX 3.n, System V.4 */
#  include <time.h>
#endif

#if defined(ultrix) && defined(mips)
/* Apparently some versions of Ultrix for the DECstation include */
/* time_t in sys/time.h, and some don't.  If you get errors */
/* compiling gp_unix.c, uncomment the next line. */
/*	typedef	int	time_t;	*/
#endif

/* In SVR4 (but not other System V implementations), */
/* gettimeofday doesn't take a timezone argument. */
/* Patch callers of gettimeofday so they call our own routine */
/* (in gp_sysv.c). */
#ifdef SVR4
int gp_gettimeofday(P2(struct timeval *, struct timezone *));
#  define gettimeofday(tvp, tzp) gp_gettimeofday(tvp, tzp)
#  define use_gp_gettimeofday
#endif
