#    Copyright (C) 1989, 1992, 1993, 1994 Aladdin Enterprises.  All rights reserved.
# 
# This file is part of Aladdin Ghostscript.
# 
# Aladdin Ghostscript is distributed with NO WARRANTY OF ANY KIND.  No author
# or distributor accepts any responsibility for the consequences of using it,
# or for whether it serves any particular purpose or works at all, unless he
# or she says so in writing.  Refer to the Aladdin Ghostscript Free Public
# License (the "License") for full details.
# 
# Every copy of Aladdin Ghostscript must include a copy of the License,
# normally in a plain ASCII text file named PUBLIC.  The License grants you
# the right to copy, modify and redistribute Aladdin Ghostscript, but only
# under certain conditions described in the License.  Among other things, the
# License requires that the copyright notice and this notice be preserved on
# all copies.

# Generic makefile, common to all platforms.
# The platform-specific makefiles `include' this file.
# They define the following symbols:
#	GS - the name of the executable (without the extension, if any).
#	GS_LIB_DEFAULT - the default directory/ies for searching for the
#		initialization and font files at run time.
#	GS_DOCDIR - the directory where documentation will be available
#		 at run time.
#	DEVICE_DEVS - the devices to include in the executable.
#		See devs.mak for details.
#	DEVICE_DEVS1...DEVICE_DEVS9 - additional devices, if the definition of
#		DEVICE_DEVS doesn't fit on one line.
#		See devs.mak for details.
#	FEATURE_DEVS - what features to include in the executable.
#	    Normally this is one of:
#		    level1 - a standard Level 1 PostScript language
#			interpreter.
#		    level2 - a standard Level 2 PostScript language
#			interpreter.
#	    The remaining features are of interest primarily to developers
#		who want to "mix and match" features to create custom
#		configurations:
#		    dps - (partial) support for Display PostScript extensions:
#			see language.doc for details.
#		    btoken - support for binary token encodings.
#			Included automatically in the dps and level2 features.
#		    color - support for the Level 1 CMYK color extensions.
#			Included automatically in the dps and level2 features.
#		    compfont - support for composite (type 0) fonts.
#			Included automatically in the level2 feature.
#		    dct - support for DCTEncode/Decode filters.
#			Included automatically in the level2 feature.
#		    filter - support for Level 2 filters (other than eexec,
#			ASCIIHexEncode/Decode, NullEncode, PFBDecode,
#			RLEncode/Decode, and SubFileDecode, which are
#			always included, and DCTEncode/Decode,
#			which are separate).
#			Included automatically in the level2 feature.
#		    type1 - support for Type 1 fonts and eexec;
#			normally included automatically in all configurations.
#		    ccfonts - precompile fonts into C, and link them
#			with the executable.  In the standard makefiles,
#			this is only implemented for a very few fonts:
#			see fonts.doc for details.
#		    ccinit - precompile the initialization files into
#			C data, and link them with the executable.
# It is very unlikely that anyone would want to edit the remaining
#   symbols, but we describe them here for completeness:
#	GS_INIT - the name of the initialization file for the interpreter,
#		normally gs_init.ps.
#	PLATFORM - a "device" name for the platform, so that platforms can
#		add various kinds of resources like devices and features.
#	CMD - the suffix for shell command files (e.g., null or .bat).
#		(This is only needed in a few places.)
#	D - the directory separator character (\ for MS-DOS, / for Unix).
#	O - the string for specifying the output file from the C compiler
#		(-o for MS-DOS, -o ./ for Unix).
#	OBJ - the extension for relocatable object files (e.g., o or obj).
#	XE - the extension for executable files (e.g., null or .exe).
#	BEGINFILES - the list of files that `make begin' should delete.
#	CCAUX - the C invocation for auxiliary programs (ansi2knr, echogs,
#		genarch, genconf).
#	CCBEGIN - the compilation command for `make begin', normally
#		$(CCC) *.c.
#	CCC - the C invocation for normal compilation.
#	CCD - the C invocation for files that store into frame buffers or
#		device registers.  Needed because some optimizing compilers
#		will eliminate necessary stores.
#	CCCF - the C invocation for compiled fonts and other large,
#		self-contained data modules.  Needed because MS-DOS
#		requires using the 'huge' memory model for these.
#	CCINT - the C invocation for compiling the main interpreter module,
#		normally the same as CCC: this is needed because the
#		Borland compiler generates *worse* code for this module
#		(but only this module) when optimization (-O) is turned on.
#	AK - if source files must be converted from ANSI to K&R syntax,
#		this is ansi2knr$(XE); if not, it is null.
#		If a particular platform requires other utility programs
#		to be built, AK must include them too.
#	SHP - the prefix for invoking a shell script in the current directory
#		(null for MS-DOS, $(SH) ./ for Unix).
#	EXPP, EXP - the prefix for invoking an executable program in the
#		current directory (null for MS-DOS, ./ for Unix).
#	SH - the shell for scripts (null on MS-DOS, sh on Unix).
#	CONFILES - the arguments for genconf to generate the appropriate
#		linker control files (various).
# The platform-specific makefiles must also include rules for creating
# certain dynamically generated files:
#	gconfig_.h - this indicates the presence or absence of
#	    certain system header files that are located in different
#	    places on different systems.  (It could be generated by
#	    the GNU `configure' program.)

all default: $(GS)$(XE)

distclean realclean: clean
	rm -f makefile

clean mostlyclean:
	rm -f *.$(OBJ) *.a core gmon.out
	rm -f *.dev *.d_* arch.h devs.tr gconfig*.h j*.h o*.tr l*.tr
	rm -f t _temp_* _temp_*.* *.map *.sym
	rm -f ansi2knr$(XE) echogs$(XE) genarch$(XE) genconf$(XE)
	rm -f $(GS)$(XE) $(BEGINFILES)

# A rule to do a quick and dirty compilation attempt when first installing
# the interpreter.  Many of the compilations will fail:
# follow this with 'make'.

begin:
	rm -f arch.h genarch$(XE) $(GS)$(XE) $(BEGINFILES)
	make arch.h
	- $(CCBEGIN)
	rm -f gconfig.$(OBJ) gdev*.$(OBJ) gp_*.$(OBJ) gsmisc.$(OBJ) gsutil.$(OBJ)
	rm -f iccfont.$(OBJ) iinit.$(OBJ) interp.$(OBJ) ziodev.$(OBJ)

# Auxiliary programs

arch.h: genarch$(XE)
	$(EXPP) $(EXP)genarch arch.h

# Macros for constructing the *.dev files that describe features and
# devices.  We may replace these with echogs variants someday....
SETDEV=$(SHP)gssetdev$(CMD)
SETMOD=$(SHP)gssetmod$(CMD)
ADDMOD=$(SHP)gsaddmod$(CMD)

# Define the subdirectory containing the IJG JPEG code.  This seems
# a little out of place here, but we can't think of a better place.
JPEGSRC=jpeg

# -------------------------------- Library -------------------------------- #

# We want a definition of USE_FPU that works regardless of whether
# FPU_TYPE is actually defined or not.
# We can't use the definition that we would like:
#	USE_FPU=($(FPU_TYPE)0/10)
# because some compilers interpret the `/' as introducing a switch.
# Instead, we must define
USE_FPU=$(FPU_TYPE)0
# which is only usable for <0, =0, and >0 testing.

# Define the inter-dependencies of the .h files.
# Since not all versions of `make' defer expansion of macros,
# we must list these in bottom-to-top order.

# Generic files

arch_h=arch.h
stdpre_h=stdpre.h
std_h=std.h $(arch_h) $(stdpre_h)

# Platform interfaces

gp_h=gp.h
gpcheck_h=gpcheck.h

# C library interfaces

# Because of variations in the "standard" header files between systems, and
# because we must include std.h before any file that includes sys/types.h,
# we define local include files named *_.h to substitute for <*.h>.

# gconfig_.h is generated dynamically.
gconfig__h=gconfig_.h
vmsmath_h=vmsmath.h

dos__h=dos_.h
ctype__h=ctype_.h $(std_h)
dirent__h=dirent_.h $(std_h) $(gconfig__h)
errno__h=errno_.h
malloc__h=malloc_.h $(std_h)
math__h=math_.h $(std_h) $(vmsmath_h)
memory__h=memory_.h $(std_h)
stat__h=stat_.h $(std_h)
stdio__h=stdio_.h $(std_h)
string__h=string_.h $(std_h)
time__h=time_.h $(std_h) $(gconfig__h)
windows__h=windows_.h

# Miscellaneous

gconfig_h=gconfig.h
gdebug_h=gdebug.h
gserror_h=gserror.h
gserrors_h=gserrors.h
gsexit_h=gsexit.h
gsio_h=gsio.h
gsmemory_h=gsmemory.h
gsrefct_h=gsrefct.h
gsstruct_h=gsstruct.h
gstypes_h=gstypes.h
gx_h=gx.h $(stdio__h) $(gdebug_h) $(gserror_h) $(gsio_h) $(gsmemory_h) $(gstypes_h)

GX=$(AK) $(gx_h)
GXERR=$(GX) $(gserrors_h)

###### Low-level facilities and utilities

### Include files

gsccode_h=gsccode.h
gsccolor_h=gsccolor.h $(gsstruct_h)
gschar_h=gschar.h $(gsccode_h)
gscie_h=gscie.h $(gsrefct_h)
gscolor_h=gscolor.h
gscolor1_h=gscolor.h
gscoord_h=gscoord.h
gsdevice_h=gsdevice.h
gsfont_h=gsfont.h
gsht_h=gsht.h
gsimage_h=gsimage.h
gsjconf_h=gsjconf.h $(std_h)
gsline_h=gsline.h
gsmatrix_h=gsmatrix.h
gspaint_h=gspaint.h
gsparam_h=gsparam.h
gspath_h=gspath.h
gspath2_h=gspath2.h
gsstate_h=gsstate.h $(gscolor_h) $(gsdevice_h) $(gsht_h) $(gsline_h)
gsuid_h=gsuid.h
gsutil_h=gsutil.h
gsxfont_h=gsxfont.h
# Out of order
gscolor2_h=gscolor2.h $(gsccolor_h) $(gsuid_h)
gscspace_h=gscspace.h $(gsccolor_h) $(gsstruct_h)

gxarith_h=gxarith.h
gxbitmap_h=gxbitmap.h
gxchar_h=gxchar.h $(gschar_h)
gxclist_h=gxclist.h
# gxcldev is out of order because it includes gxclist.
gxcldev_h=gxcldev.h $(gxclist_h)
gxclip2_h=gxclip2.h
gxcolor2_h=gxcolor2.h $(gscolor2_h) $(gsrefct_h) $(gxbitmap_h)
gxcoord_h=gxcoord.h $(gscoord_h)
gxcpath_h=gxcpath.h
gxdcolor_h=gxdcolor.h $(gsrefct_h) $(gsstruct_h) $(gxbitmap_h)
gxdevice_h=gxdevice.h $(gsmatrix_h) $(gsxfont_h) $(gxbitmap_h) $(gxdcolor_h)
gxdevmem_h=gxdevmem.h
gxdither_h=gxdither.h
gxfarith_h=gxfarith.h $(gxarith_h)
gxfcache_h=gxfcache.h $(gsuid_h) $(gsxfont_h)
gxfixed_h=gxfixed.h
gxfont_h=gxfont.h $(gsfont_h) $(gsuid_h) $(gsstruct_h)
gxfont0_h=gxfont0.h
gxfrac_h=gxfrac.h
gxht_h=gxht.h $(gsht_h)
gximage_h=gximage.h $(gscspace_h) $(gsimage_h)
gxiodev_h=gxiodev.h $(stat__h)
gxlum_h=gxlum.h
gxmatrix_h=gxmatrix.h $(gsmatrix_h)
gxpaint_h=gxpaint.h
gxpath_h=gxpath.h $(gspath_h)
gxpcolor_h=gxpcolor.h
gxxfont_h=gxxfont.h $(gsccode_h) $(gsmatrix_h) $(gsuid_h) $(gsxfont_h)
# The following are out of order because they include other files.
gxdcconv_h=gxdcconv.h $(gxfrac_h) $(gsccolor_h)
gxfmap_h=gxfmap.h $(gsrefct_h) $(gxfrac_h)
gxcmap_h=gxcmap.h $(gxfmap_h)

gzdraw_h=gzdraw.h
gzht_h=gzht.h $(gxht_h)
gzline_h=gzline.h $(gsline_h)
gzpath_h=gzpath.h $(gsstruct_h) $(gxpath_h)
gzstate_h=gzstate.h $(gsstate_h) $(gxdcolor_h) $(gxfixed_h) $(gxmatrix_h) $(gxdevice_h)

### Executable code

gsmemory.$(OBJ): gsmemory.c $(GX) \
  $(gsrefct_h) $(gsstruct_h)

gsmisc.$(OBJ): gsmisc.c $(GX) $(MAKEFILE) \
  $(errno__h) $(malloc__h) $(memory__h) $(gxfixed_h)
	$(CCC) -DUSE_ASM=0$(USE_ASM) -DUSE_FPU=$(USE_FPU) gsmisc.c

gsutil.$(OBJ): gsutil.c $(AK) $(MAKEFILE) \
  $(std_h) $(gsuid_h) $(gsutil_h)
	$(CCC) -DUSE_ASM=0$(USE_ASM) -DUSE_FPU=$(USE_FPU) gsutil.c

gxacpath.$(OBJ): gxacpath.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gxcpath_h) $(gxfixed_h) $(gxpaint_h) $(gzpath_h)

gxccache.$(OBJ): gxccache.c $(GXERR) $(gpcheck_h) \
  $(gscspace_h) $(gsimage_h) $(gsstruct_h) \
  $(gxchar_h) $(gxcpath_h) $(gxdevmem_h) $(gxfcache_h) \
  $(gxfixed_h) $(gxfont_h) $(gxmatrix_h) $(gxxfont_h) \
  $(gzstate_h) $(gzpath_h)

gxccman.$(OBJ): gxccman.c $(GXERR) $(gpcheck_h) \
  $(gsstruct_h) $(gsutil_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gxdevmem_h) $(gxfont_h) $(gxfcache_h) $(gxchar_h) \
  $(gxxfont_h) $(gzstate_h) $(gzpath_h)

gxclist.$(OBJ): gxclist.c $(GXERR) $(gpcheck_h) \
  $(gsmatrix_h) $(gxbitmap_h) $(gxcldev_h) $(gxdevice_h) $(gxdevmem_h) \
  $(srlx_h) $(strimpl_h)

gxclread.$(OBJ): gxclread.c $(GXERR) $(gpcheck_h) \
  $(gsmatrix_h) $(gxbitmap_h) $(gxcldev_h) $(gxdevice_h) $(gxdevmem_h) \
  $(srlx_h) $(strimpl_h)

gxcht.$(OBJ): gxcht.c $(GXERR) \
  $(gxcmap_h) $(gxdevice_h) $(gxfixed_h) $(gxmatrix_h) $(gzht_h) $(gzstate_h)

gxcmap.$(OBJ): gxcmap.c $(GXERR) \
  $(gsccolor_h) $(gscspace_h) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdevice_h) $(gxdither_h) \
  $(gxfarith_h) $(gxfrac_h) $(gxlum_h) $(gzstate_h)
	$(CCC) -DUSE_FPU=$(USE_FPU) gxcmap.c

gxcpath.$(OBJ): gxcpath.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gxfixed_h) $(gzpath_h) $(gxcpath_h)

gxdcconv.$(OBJ): gxdcconv.c $(GX) $(MAKEFILE) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdcolor_h) $(gxdevice_h) \
  $(gxfarith_h) $(gxlum_h) $(gzstate_h)
	$(CCC) -DUSE_FPU=$(USE_FPU) gxdcconv.c

gxdither.$(OBJ): gxdither.c $(GX) \
  $(gxcmap_h) $(gxdither_h) $(gxfixed_h) $(gxlum_h) $(gxmatrix_h) \
  $(gzstate_h) $(gzht_h)

gxdraw.$(OBJ): gxdraw.c $(GXERR) $(gpcheck_h) \
  $(gxfixed_h) $(gxmatrix_h) $(gxbitmap_h) $(gzdraw_h) $(gzht_h) $(gzstate_h)

gxfill.$(OBJ): gxfill.c $(GXERR) \
  $(gsstruct_h) $(gxcpath_h) $(gxdevice_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzdraw_h) $(gzpath_h) $(gzstate_h)

gxht.$(OBJ): gxht.c $(GXERR) \
  $(gsstruct_h) $(gsutil_h) $(gxfixed_h) $(gxdevice_h) $(gzstate_h) $(gzht_h)

gxpath.$(OBJ): gxpath.c $(GXERR) \
  $(gsstruct_h) $(gxfixed_h) $(gzpath_h)

gxpath2.$(OBJ): gxpath2.c $(GXERR) \
  $(gxfixed_h) $(gxarith_h) $(gzpath_h)

gxpcopy.$(OBJ): gxpcopy.c $(GXERR) \
  $(gsmatrix_h) $(gscoord_h) $(gxfixed_h) $(gxarith_h) $(gzline_h) $(gzpath_h)

gxstroke.$(OBJ): gxstroke.c $(GXERR) $(gpcheck_h) \
  $(gscoord_h) $(gxfixed_h) $(gxarith_h) $(gxmatrix_h) $(gxpaint_h) \
  $(gzdraw_h) $(gzline_h) $(gzpath_h) $(gzstate_h)

###### High-level facilities

gschar.$(OBJ): gschar.c $(GXERR) \
  $(gsstruct_h) \
  $(gxfixed_h) $(gxarith_h) $(gxmatrix_h) $(gxcoord_h) $(gxdevmem_h) \
  $(gxfont_h) $(gxfont0_h) $(gxchar_h) $(gxfcache_h) $(gzpath_h) $(gzstate_h)

gscolor.$(OBJ): gscolor.c $(GXERR) \
  $(gsccolor_h) $(gscspace_h) $(gsstruct_h) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdevice_h) \
  $(gzstate_h)

gscoord.$(OBJ): gscoord.c $(GXERR) $(MAKEFILE) \
  $(gsccode_h) $(gxcoord_h) $(gxfarith_h) $(gxfixed_h) $(gxfont_h) \
  $(gxmatrix_h) $(gxpath_h) $(gzstate_h)
	$(CCC) -DUSE_FPU=$(USE_FPU) gscoord.c

gsdevice.$(OBJ): gsdevice.c $(GXERR) \
  $(gscoord_h) $(gsmatrix_h) $(gspaint_h) $(gsparam_h) $(gspath_h) $(gsstruct_h) \
  $(gxarith_h) $(gxbitmap_h) $(gxcmap_h) $(gxdevmem_h) $(gzstate_h)

gsdparam.$(OBJ): gsdparam.c $(GXERR) \
  $(gsparam_h) $(gxdevice_h) $(gxfixed_h)

gsfile.$(OBJ): gsfile.c $(GXERR) \
  $(gsmatrix_h) $(gxdevice_h) $(gxdevmem_h)

gsfont.$(OBJ): gsfont.c $(GXERR) \
  $(gsstruct_h) \
  $(gxdevice_h) $(gxfixed_h) $(gxmatrix_h) $(gxfont_h) $(gxfcache_h) \
  $(gzstate_h)

gsht.$(OBJ): gsht.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gzht_h) $(gzstate_h)

gsht1.$(OBJ): gsht1.c $(GXERR) \
  $(gsstruct_h) $(gxdevice_h) $(gzht_h) $(gzstate_h)

gsimage.$(OBJ): gsimage.c $(GXERR) $(gpcheck_h) \
  $(gsccolor_h) $(gspaint_h) $(gsstruct_h) \
  $(gxfixed_h) $(gxfrac_h) $(gxarith_h) $(gxmatrix_h) \
  $(gxdevice_h) $(gzpath_h) $(gzstate_h) \
  $(gxcpath_h) $(gxdevmem_h) $(gximage_h)

gsimage1.$(OBJ): gsimage1.c $(GXERR) $(gpcheck_h) \
  $(gxfixed_h) $(gxarith_h) $(gxmatrix_h) \
  $(gsccolor_h) $(gscspace_h) $(gspaint_h) \
  $(gzdraw_h) $(gzht_h) $(gzpath_h) $(gzstate_h) \
  $(gxcmap_h) $(gxcpath_h) $(gxdevmem_h) $(gximage_h)

gsimage2.$(OBJ): gsimage2.c $(GXERR) $(gpcheck_h) \
  $(gxfixed_h) $(gxfrac_h) $(gxarith_h) $(gxmatrix_h) \
  $(gsccolor_h) $(gscspace_h) $(gspaint_h) \
  $(gzdraw_h) $(gzpath_h) $(gzstate_h) \
  $(gxcmap_h) $(gxcpath_h) $(gxdevmem_h) $(gximage_h)

gsimpath.$(OBJ): gsimpath.c $(GXERR) \
  $(gsmatrix_h) $(gsstate_h) $(gspath_h)

gsiodev.$(OBJ): gsiodev.c $(GXERR) $(errno__h) $(string__h) \
  $(gp_h) $(gsparam_h) $(gxiodev_h)

gsline.$(OBJ): gsline.c $(GXERR) \
  $(gxfixed_h) $(gxmatrix_h) $(gzstate_h) $(gzline_h)

gsmatrix.$(OBJ): gsmatrix.c $(GXERR) $(MAKEFILE) \
  $(gxfarith_h) $(gxfixed_h) $(gxmatrix_h)
	$(CCC) -DUSE_FPU=$(USE_FPU) gsmatrix.c

gspaint.$(OBJ): gspaint.c $(GXERR) $(gpcheck_h) \
  $(gxfixed_h) $(gxmatrix_h) $(gspaint_h) $(gxpaint_h) \
  $(gzpath_h) $(gzstate_h) $(gxcpath_h) $(gxdevmem_h) $(gximage_h)

gspath.$(OBJ): gspath.c $(GXERR) \
  $(gscoord_h) $(gxfixed_h) $(gxmatrix_h) $(gxpath_h) $(gzstate_h)

gspath2.$(OBJ): gspath2.c $(GXERR) \
  $(gspath_h) $(gsstruct_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzstate_h) $(gzpath_h)

gsstate.$(OBJ): gsstate.c $(GXERR) \
  $(gscie_h) $(gscolor2_h) $(gscoord_h) $(gscspace_h) $(gsstruct_h) \
  $(gxcmap_h) \
  $(gzstate_h) $(gzht_h) $(gzline_h) $(gzpath_h)

###### The internal devices

gdevmem_h=gdevmem.h

gdevmem1.$(OBJ): gdevmem1.c $(AK) \
  $(gx_h) $(gserrors_h) $(gsstruct_h) $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevmem2.$(OBJ): gdevmem2.c $(AK) \
  $(gx_h) $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevmem3.$(OBJ): gdevmem3.c $(AK) \
  $(gx_h) $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

gdevmem4.$(OBJ): gdevmem4.c $(AK) \
  $(gx_h) $(gxdevice_h) $(gxdevmem_h) $(gdevmem_h)

###### Files dependent on the installed devices, features, and platform.
# Generating gconfig.h also generates o*.tr and l*.tr.

# gconfig.h shouldn't have to depend on DEVS_ALL, but that would
# involve rewriting gsconfig to only save the device name, not the
# contents of the <device>.DEV files.
# We have to put gslib.dev last in the list because of problems
# with the Unix linker when gslib is really a library.

DEVS_ALL=gs.dev $(FEATURE_DEVS) $(PLATFORM).dev \
  $(DEVICE_DEVS) $(DEVICE_DEVS1) \
  $(DEVICE_DEVS2) $(DEVICE_DEVS3) $(DEVICE_DEVS4) $(DEVICE_DEVS5) \
  $(DEVICE_DEVS6) $(DEVICE_DEVS7) $(DEVICE_DEVS8) $(DEVICE_DEVS9) \
  gslib.dev

devs.tr: devs.mak $(MAKEFILE) echogs$(XE) $(DEVS_ALL)
	$(EXP)echogs -w devs.tr - gs.dev $(PLATFORM).dev
	$(EXP)echogs -a devs.tr - $(FEATURE_DEVS)
	$(EXP)echogs -a devs.tr - $(DEVICE_DEVS)
	$(EXP)echogs -a devs.tr - $(DEVICE_DEVS1)
	$(EXP)echogs -a devs.tr - $(DEVICE_DEVS2)
	$(EXP)echogs -a devs.tr - $(DEVICE_DEVS3)
	$(EXP)echogs -a devs.tr - $(DEVICE_DEVS4)
	$(EXP)echogs -a devs.tr - $(DEVICE_DEVS5)
	$(EXP)echogs -a devs.tr - $(DEVICE_DEVS6)
	$(EXP)echogs -a devs.tr - $(DEVICE_DEVS7)
	$(EXP)echogs -a devs.tr - $(DEVICE_DEVS8)
	$(EXP)echogs -a devs.tr - $(DEVICE_DEVS9)
	$(EXP)echogs -a devs.tr - gslib.dev

# GCONFIG_EXTRAS can be set on the command line.
# Note that it consists of arguments for echogs, i.e.,
# it isn't just literal text.

gconfig.h obj.tr objw.tr ld.tr lib.tr: \
  $(MAKEFILE) genconf$(XE) echogs$(XE) devs.tr
	$(EXP)genconf @devs.tr -h gconfig.h $(CONFILES)
	$(EXP)echogs -a gconfig.h -x 23 define GS_LIB_DEFAULT -x 2022 $(GS_LIB_DEFAULT) -x 22
	
	$(EXP)echogs -a gconfig.h -x 23 define GS_DOCDIR -x 2022 $(GS_DOCDIR) -x 22
	
	$(EXP)echogs -a gconfig.h -x 23 define GS_INIT -x 2022 $(GS_INIT) -x 22
	$(EXP)echogs -a gconfig.h $(GCONFIG_EXTRAS)

gconfig.$(OBJ): gconfig.c $(AK) $(gconfig_h) $(MAKEFILE)

# Create a pseudo-"feature" for the entire (Level 1 base) library.

LIB1=gschar.$(OBJ) gscolor.$(OBJ) gscoord.$(OBJ) gsdevice.$(OBJ) gsdparam.$(OBJ)
LIB2=gsfile.$(OBJ) gsfont.$(OBJ) gsht.$(OBJ) gsht1.$(OBJ)
LIB3=gsimage.$(OBJ) gsimage1.$(OBJ) gsimage2.$(OBJ) gsimpath.$(OBJ)
LIB4=gsiodev.$(OBJ) gsline.$(OBJ) gsmatrix.$(OBJ) gsmemory.$(OBJ) gsmisc.$(OBJ)
LIB5=gspaint.$(OBJ) gspath.$(OBJ) gspath2.$(OBJ) gsstate.$(OBJ)
LIB6=gsutil.$(OBJ) gxacpath.$(OBJ) gxccache.$(OBJ) gxccman.$(OBJ)
LIB7=gxcht.$(OBJ) gxclist.$(OBJ) gxclread.$(OBJ) gxcmap.$(OBJ) gxcpath.$(OBJ)
LIB8=gxdcconv.$(OBJ) gxdither.$(OBJ) gxdraw.$(OBJ) gxfill.$(OBJ)
LIB9=gxht.$(OBJ) gxpath.$(OBJ) gxpath2.$(OBJ) gxpcopy.$(OBJ) gxstroke.$(OBJ)
LIB10=gdevmem1.$(OBJ) gdevmem2.$(OBJ) gdevmem3.$(OBJ) gdevmem4.$(OBJ)
LIB_ALL=$(LIB1) $(LIB2) $(LIB3) $(LIB4) $(LIB5) $(LIB6) $(LIB7) $(LIB8) \
  $(LIB9) $(LIB10)
gslib.dev: gs.mak echogs$(XE) $(LIB_ALL)
	$(EXP)echogs -w gslib.dev
	$(EXP)echogs -a gslib.dev $(LIB1)
	$(EXP)echogs -a gslib.dev $(LIB2)
	$(EXP)echogs -a gslib.dev $(LIB3)
	$(EXP)echogs -a gslib.dev $(LIB4)
	$(EXP)echogs -a gslib.dev $(LIB5)
	$(EXP)echogs -a gslib.dev $(LIB6)
	$(EXP)echogs -a gslib.dev $(LIB7)
	$(EXP)echogs -a gslib.dev $(LIB8)
	$(EXP)echogs -a gslib.dev $(LIB9)
	$(EXP)echogs -a gslib.dev $(LIB10)

# ------------------------------ Interpreter ------------------------------ #

###### Include files

errors_h=errors.h
files_h=files.h
fname_h=fname.h
ichar_h=ichar.h
idebug_h=idebug.h
idict_h=idict.h
idparam_h=idparam.h
ifont_h=ifont.h $(gsstruct_h)
igc_h=igc.h
igstate_h=igstate.h $(gsstate_h) $(gsstruct_h)
ilevel_h=ilevel.h
imemory_h=imemory.h
iname_h=iname.h
interp_h=interp.h
ipacked_h=ipacked.h
iparray_h=iparray.h
iparam_h=iparam.h $(gsparam_h)
iref_h=iref.h
isave_h=isave.h
iscan_h=iscan.h
iscannum_h=iscannum.h
isstate_h=isstate.h
istream_h=istream.h
istruct_h=istruct.h $(gsstruct_h)
ivmspace_h=ivmspace.h
iutil_h=iutil.h
iutil2_h=iutil2.h
main_h=main.h $(gsexit_h)
opcheck_h=opcheck.h
opdef_h=opdef.h
ostack_h=ostack.h $(istack_h)
overlay_h=overlay.h
sbwbs_h=sbwbs.h
scanchar_h=scanchar.h
scommon_h=scommon.h $(gsmemory_h) $(gsstruct_h)
sdct_h=sdct.h
sdiffx_h=sdiffx.h
sfilter_h=sfilter.h $(gstypes_h)
shc_h=shc.h
sjpeg_h=sjpeg.h
slzwx_h=slzwx.h
srlx_h=srlx.h
stream_h=stream.h $(scommon_h)
strimpl_h=strimpl.h $(scommon_h) $(gstypes_h) $(gsstruct_h)
# Nested include files
bfont_h=bfont.h $(ifont_h)
dstack_h=dstack.h $(istack_h)
estack_h=estack.h $(istack_h)
ghost_h=ghost.h $(gx_h) $(iref_h)
ialloc_h=ialloc.h $(imemory_h)
iastruct_h=iastruct.h $(gxbitmap_h) $(ialloc_h)
iastate_h=iastate.h $(iastruct_h) $(istruct_h)
ifilter_h=ifilter.h $(istream_h) $(ivmspace_h)
isproc_h=isproc.h
istack_h=istack.h
oper_h=oper.h $(iutil_h) $(opcheck_h) $(opdef_h) $(ostack_h)
sbhc_h=sbhc.h $(shc_h)
scf_h=scf.h $(shc_h)
scfx_h=scfx.h $(shc_h)
store_h=store.h $(ialloc_h)
# Include files for optional features
ibnum_h=ibnum.h

gdevprn_h=gdevprn.h $(memory__h) $(string__h) $(gx_h) \
  $(gserrors_h) $(gsmatrix_h) $(gsutil_h) \
  $(gxdevice_h) $(gxdevmem_h) $(gxclist_h)

###### Utilities

GH=$(AK) $(ghost_h)

ialloc.$(OBJ): ialloc.c $(AK) $(gx_h) \
  $(errors_h) $(gsstruct_h) $(gxarith_h) $(iastate_h) $(iref_h) $(store_h)

idebug.$(OBJ): idebug.c $(GH) \
  $(ialloc_h) $(idebug_h) $(idict_h) $(iname_h) $(istack_h) $(iutil_h) \
  $(ostack_h) $(opdef_h) $(ipacked_h) $(store_h)

idict.$(OBJ): idict.c $(GH) \
  $(ialloc_h) $(errors_h) $(ivmspace_h) $(iname_h) $(ipacked_h) \
  $(isave_h) $(store_h) $(iutil_h) $(idict_h) $(dstack_h)

idparam.$(OBJ): idparam.c $(GH) $(errors_h) \
  $(gsmatrix_h) $(gsuid_h) \
  $(idict_h) $(idparam_h) $(ilevel_h) $(imemory_h) $(iname_h) $(iutil_h) \
  $(oper_h) $(store_h)

# igc.c, igcref.c, and igcstr.c should really be in the dpsand2 list,
# but since all the GC enumeration and relocation routines refer to them,
# it's too hard to separate them out from the Level 1 base.
igc.$(OBJ): igc.c $(GH) \
  $(gsstruct_h) $(gsutil_h) \
  $(iastate_h) $(idict_h) $(igc_h) $(iname_h) $(isave_h) $(isstate_h) \
  $(dstack_h) $(errors_h) $(estack_h) $(opdef_h) $(ostack_h) $(ipacked_h) $(store_h)

igcref.$(OBJ): igcref.c $(GH)\
  $(iastate_h) $(idebug_h) $(igc_h) $(iname_h) $(ipacked_h)

igcstr.$(OBJ): igcstr.c $(GH) \
  $(gsstruct_h) $(iastate_h) $(igc_h) $(isave_h) $(isstate_h)

iinit.$(OBJ): iinit.c $(GH) $(gconfig_h) \
  $(gsexit_h) $(gsstruct_h) $(ialloc_h) $(idict_h) $(dstack_h) $(errors_h) \
  $(ilevel_h) $(iname_h) $(interp_h) $(oper_h) $(ipacked_h) $(iparray_h) $(store_h)

iname.$(OBJ): iname.c $(GH) $(gsstruct_h) $(errors_h) $(iname_h) $(store_h)

iparam.$(OBJ): iparam.c $(GH) \
  $(ialloc_h) $(idict_h) $(iname_h) $(imemory_h) $(iparam_h) $(istack_h) $(iutil_h) \
  $(opcheck_h) $(store_h)

isave.$(OBJ): isave.c $(GH) \
  $(errors_h) $(gsstruct_h) \
  $(iastate_h) $(iname_h) $(isave_h) $(isstate_h) $(ivmspace_h) \
  $(ipacked_h) $(store_h)

iscan.$(OBJ): iscan.c $(GH) $(ctype__h) \
  $(ialloc_h) $(idict_h) $(dstack_h) $(errors_h) \
  $(ilevel_h) $(iutil_h) $(iscan_h) $(iscannum_h) $(istruct_h) $(ivmspace_h) \
  $(iname_h) $(ipacked_h) $(iparray_h) $(istream_h) $(ostack_h) $(store_h) \
  $(stream_h) $(strimpl_h) $(sfilter_h) $(scanchar_h)

iscannum.$(OBJ): iscannum.c $(GH) \
  $(errors_h) $(iscannum_h) $(scanchar_h) $(store_h) $(stream_h)

iscantab.$(OBJ): iscantab.c $(AK) \
  $(stdpre_h) $(scommon_h) $(scanchar_h)

istack.$(OBJ): istack.c $(GH) $(memory__h) \
  $(errors_h) $(gsstruct_h) $(gsutil_h) \
  $(ialloc_h) $(istack_h) $(istruct_h) $(iutil_h) $(ivmspace_h) $(store_h)

iutil.$(OBJ): iutil.c $(GH) \
  $(errors_h) $(idict_h) $(imemory_h) $(iutil_h) $(ivmspace_h) \
  $(iname_h) $(ostack_h) $(opcheck_h) $(opdef_h) $(ipacked_h) $(store_h) \
  $(gsmatrix_h) $(gsutil_h)

### Streams

sbasic.$(OBJ): sbasic.c $(AK) $(stdio__h) $(memory__h) \
  $(gdebug_h) $(gpcheck_h) $(gsmemory_h) $(gsstruct_h) $(gstypes_h) $(stream_h)

sbcp.$(OBJ): sbcp.c $(AK) $(stdio__h) \
  $(sfilter_h) $(strimpl_h)

sfilter1.$(OBJ): sfilter1.c $(AK) $(stdio__h) $(memory__h) \
  $(sfilter_h) $(srlx_h) $(strimpl_h)

sstring.$(OBJ): sstring.c $(AK) $(stdio__h) $(memory__h) \
  $(scanchar_h) $(sfilter_h) $(strimpl_h)

stream.$(OBJ): stream.c $(AK) $(stdio__h) $(memory__h) \
  $(gdebug_h) $(gpcheck_h) $(stream_h) $(strimpl_h)

###### Operators

OP=$(GH) $(errors_h) $(oper_h)

### Non-graphics operators

zarith.$(OBJ): zarith.c $(OP) $(store_h)

zarray.$(OBJ): zarray.c $(OP) $(ialloc_h) $(ipacked_h) $(store_h)

zcontrol.$(OBJ): zcontrol.c $(OP) $(estack_h) $(iutil_h) $(store_h)

zdict.$(OBJ): zdict.c $(OP) \
  $(dstack_h) $(idict_h) $(ilevel_h) $(iname_h) $(ipacked_h) $(ivmspace_h) \
  $(store_h)

zfile.$(OBJ): zfile.c $(OP) $(stat__h) $(gp_h) \
  $(gsstruct_h) $(gxiodev_h) \
  $(ialloc_h) $(estack_h) $(files_h) $(fname_h) $(ilevel_h) $(interp_h) $(iutil_h) \
  $(isave_h) $(stream_h) $(strimpl_h) $(store_h)

zfname.$(OBJ): zfname.c $(GH) \
  $(errors_h) $(fname_h) $(gxiodev_h) $(ialloc_h) $(iutil_h) $(opcheck_h) \
  $(stream_h)

zfileio.$(OBJ): zfileio.c $(OP) $(gp_h) \
  $(files_h) $(ifilter_h) $(store_h) $(stream_h) $(strimpl_h) \
  $(gsmatrix_h) $(gxdevice_h) $(gxdevmem_h)

zfilter.$(OBJ): zfilter.c $(OP) \
  $(gsstruct_h) $(files_h) $(ialloc_h) $(ifilter_h) \
  $(sfilter_h) $(srlx_h) $(stream_h) $(strimpl_h)

zfproc.$(OBJ): zfproc.c $(GH) $(errors_h) $(oper_h) \
  $(estack_h) $(files_h) $(gsstruct_h) $(ialloc_h) $(ifilter_h) $(istruct_h) \
  $(store_h) $(stream_h) $(strimpl_h)

zgeneric.$(OBJ): zgeneric.c $(OP) \
  $(idict_h) $(estack_h) $(ivmspace_h) $(iname_h) $(ipacked_h) $(store_h)

ziodev.$(OBJ): ziodev.c $(OP) $(string__h) $(gp_h) $(gpcheck_h) $(gconfig_h) \
  $(gsparam_h) $(gsstruct_h) $(gxiodev_h) \
  $(files_h) $(ialloc_h) $(store_h) $(stream_h)

zmath.$(OBJ): zmath.c $(OP) $(store_h)

zmisc.$(OBJ): zmisc.c $(OP) $(gp_h) $(errno__h) $(memory__h) $(string__h) \
  $(ialloc_h) $(idict_h) $(dstack_h) $(iname_h) $(ivmspace_h) $(ipacked_h) $(store_h)

zpacked.$(OBJ): zpacked.c $(OP) \
  $(ialloc_h) $(idict_h) $(ivmspace_h) $(iname_h) $(ipacked_h) $(iparray_h) \
  $(istack_h) $(store_h)

zrelbit.$(OBJ): zrelbit.c $(OP) $(gsutil_h) $(store_h) $(idict_h)

zstack.$(OBJ): zstack.c $(OP) $(ialloc_h) $(istack_h) $(store_h)

zstring.$(OBJ): zstring.c $(OP) $(gsutil_h) \
  $(ialloc_h) $(iname_h) $(ivmspace_h) $(store_h)

ztoken.$(OBJ): ztoken.c $(OP) \
  $(estack_h) $(files_h) $(gsstruct_h) $(iscan_h) \
  $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)

ztype.$(OBJ): ztype.c $(OP) $(gsstruct_h) \
  $(dstack_h) $(idict_h) $(igstate_h) $(imemory_h) $(iname_h) \
  $(iscannum_h) $(iutil_h) $(store_h)

zvmem.$(OBJ): zvmem.c $(OP) \
  $(ialloc_h) $(idict_h) $(dstack_h) $(estack_h) $(isave_h) $(igstate_h) $(store_h) \
  $(gsmatrix_h) $(gsstate_h) $(gsstruct_h)

### Graphics operators

zchar.$(OBJ): zchar.c $(OP) \
  $(gsstruct_h) $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gschar_h) $(gxdevice_h) $(gxfont_h) $(gzpath_h) $(gzstate_h) \
  $(ialloc_h) $(ichar_h) $(idict_h) $(ifont_h) $(estack_h) $(ilevel_h) $(iname_h) $(igstate_h) $(store_h)

zcolor.$(OBJ): zcolor.c $(OP) \
  $(gxfixed_h) $(gxmatrix_h) $(gzstate_h) $(gxdevice_h) $(gxcmap_h) \
  $(ialloc_h) $(estack_h) $(iutil_h) $(igstate_h) $(store_h)

zdevice.$(OBJ): zdevice.c $(OP) \
  $(ialloc_h) $(idict_h) $(igstate_h) $(iname_h) $(interp_h) $(iparam_h) \
  $(gsmatrix_h) $(gsstate_h) $(gxdevice_h) $(store_h)

zfont.$(OBJ): zfont.c $(OP) \
  $(gsmatrix_h) $(gxdevice_h) $(gxfont_h) $(gxfcache_h) \
  $(ialloc_h) $(idict_h) $(igstate_h) $(iname_h) $(isave_h) $(ivmspace_h) \
  $(bfont_h) $(store_h)

zfont2.$(OBJ): zfont2.c $(OP) \
  $(gsmatrix_h) $(gxdevice_h) $(gschar_h) $(gxfixed_h) $(gxfont_h) \
  $(ialloc_h) $(bfont_h) $(idict_h) $(idparam_h) $(ilevel_h) $(iname_h) $(istruct_h) \
  $(ipacked_h) $(store_h)

zgstate.$(OBJ): zgstate.c $(OP) \
  $(gsmatrix_h) $(ialloc_h) $(igstate_h) $(istruct_h) $(store_h)

zht.$(OBJ): zht.c $(OP) \
  $(gsmatrix_h) $(gsstate_h) $(gsstruct_h) $(gxdevice_h) $(gzht_h) \
  $(ialloc_h) $(estack_h) $(igstate_h) $(store_h)

zmatrix.$(OBJ): zmatrix.c $(OP) $(gsmatrix_h) $(igstate_h) $(gscoord_h) $(store_h)

zpaint.$(OBJ): zpaint.c $(OP) \
  $(ialloc_h) $(estack_h) $(ilevel_h) $(igstate_h) $(store_h) $(stream_h) \
  $(gsimage_h) $(gsmatrix_h) $(gspaint_h) $(gsstruct_h)

zpath.$(OBJ): zpath.c $(OP) $(gsmatrix_h) $(gspath_h) $(igstate_h) $(store_h)

zpath2.$(OBJ): zpath2.c $(OP) \
  $(ialloc_h) $(estack_h) $(gspath_h) $(gsstruct_h) $(igstate_h) $(store_h)

# Create a pseudo-"feature" for the entire (Level 1 base) interpreter.

INT1=ialloc.$(OBJ) idebug.$(OBJ) idict.$(OBJ) idparam.$(OBJ) igc.$(OBJ) igcref.$(OBJ)
INT2=igcstr.$(OBJ) iinit.$(OBJ) iname.$(OBJ) interp.$(OBJ) iparam.$(OBJ)
INT3=isave.$(OBJ) iscan.$(OBJ) iscannum.$(OBJ) iscantab.$(OBJ) istack.$(OBJ) iutil.$(OBJ)
INT4=sbasic.$(OBJ) sbcp.$(OBJ) sfilter1.$(OBJ) sstring.$(OBJ) stream.$(OBJ)
INT5=zarith.$(OBJ) zarray.$(OBJ) zcontrol.$(OBJ) zdict.$(OBJ)
INT6=zfile.$(OBJ) zfileio.$(OBJ) zfilter.$(OBJ) zfname.$(OBJ) zfproc.$(OBJ)
INT7=zgeneric.$(OBJ) ziodev.$(OBJ) zmath.$(OBJ) zmisc.$(OBJ) zpacked.$(OBJ)
INT8=zrelbit.$(OBJ) zstack.$(OBJ) zstring.$(OBJ) ztoken.$(OBJ) ztype.$(OBJ) zvmem.$(OBJ)
INT9=zchar.$(OBJ) zcolor.$(OBJ) zfont.$(OBJ) zfont2.$(OBJ)
INT10=zdevice.$(OBJ) zgstate.$(OBJ) zht.$(OBJ) zmatrix.$(OBJ)
INT11=zpaint.$(OBJ) zpath.$(OBJ) zpath2.$(OBJ)
INT_ALL=gsmain.$(OBJ) gconfig.$(OBJ) \
  $(INT1) $(INT2) $(INT3) $(INT4) $(INT5) $(INT6) \
  $(INT7) $(INT8) $(INT9) $(INT10) $(INT11)
gs.dev: gs.mak echogs$(XE)
	$(EXP)echogs -w gs.dev - -obj gsmain.$(OBJ) gconfig.$(OBJ)
	$(EXP)echogs -a gs.dev $(INT1)
	$(EXP)echogs -a gs.dev $(INT2)
	$(EXP)echogs -a gs.dev $(INT3)
	$(EXP)echogs -a gs.dev $(INT4)
	$(EXP)echogs -a gs.dev $(INT5)
	$(EXP)echogs -a gs.dev $(INT6)
	$(EXP)echogs -a gs.dev $(INT7)
	$(EXP)echogs -a gs.dev $(INT8)
	$(EXP)echogs -a gs.dev $(INT9)
	$(EXP)echogs -a gs.dev $(INT10)
	$(EXP)echogs -a gs.dev $(INT11)
	$(EXP)echogs -a gs.dev - -iodev stdin stdout stderr lineedit statementedit

# -------------------------- Feature definitions ---------------------------- #

### Standard Level 1 interpreter

level1.dev: gs.mak type1.dev
	$(SETMOD) level1
	$(ADDMOD) level1 -include type1

### PostScript Type 1 fonts

type1.dev: gs.mak psf1core.dev psf1read.dev
	$(SETMOD) type1
	$(ADDMOD) type1 -include psf1core psf1read

# Core

psf1core_=gstype1.$(OBJ) gxhint1.$(OBJ) gxhint2.$(OBJ)
psf1core.dev: gs.mak $(psf1core_)
	$(SETMOD) psf1core $(psf1core_)

gscrypt1_h=gscrypt1.h
gstype1_h=gstype1.h
gxfont1_h=gxfont1.h
gxop1_h=gxop1.h
gxtype1_h=gxtype1.h $(gscrypt1_h) $(gstype1_h)

gstype1.$(OBJ): gstype1.c $(GXERR) \
  $(gsstruct_h) \
  $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) $(gxchar_h) $(gxdevmem_h) \
  $(gxfont_h) $(gxfont1_h) $(gxop1_h) $(gxtype1_h) \
  $(gzstate_h) $(gzpath_h)

gxhint1.$(OBJ): gxhint1.c $(GXERR) \
  $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) $(gxdevmem_h) $(gxchar_h) \
  $(gxfont_h) $(gxfont1_h) $(gxtype1_h) \
  $(gzstate_h)

gxhint2.$(OBJ): gxhint2.c $(GXERR) \
  $(gxarith_h) $(gxfixed_h) $(gxmatrix_h) $(gxdevmem_h) $(gxchar_h) \
  $(gxfont_h) $(gxfont1_h) $(gxtype1_h) $(gxop1_h) \
  $(gzstate_h)

# Reader

psf1read_=seexec.$(OBJ) zchar1.$(OBJ) zfont1.$(OBJ) zmisc1.$(OBJ)
psf1read.dev: gs.mak $(psf1read_)
	$(SETMOD) psf1read $(psf1read_)
	$(ADDMOD) psf1read -oper zchar1 zfont1 zmisc1
	$(ADDMOD) psf1read -ps gs_type1

comp1_h=comp1.h $(ghost_h) $(oper_h) $(gserrors_h) $(gxfixed_h) $(gxop1_h)

seexec.$(OBJ): seexec.c $(AK) $(stdio__h) \
  $(gscrypt1_h) $(scanchar_h) $(sfilter_h) $(strimpl_h)

zchar1.$(OBJ): zchar1.c $(OP) \
  $(gsstruct_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gschar_h) $(gxdevice_h) $(gxfont_h) $(gxfont1_h) $(gxtype1_h) \
  $(ialloc_h) $(ichar_h) $(idict_h) $(estack_h) $(ifont_h) $(igstate_h) \
  $(store_h)

zfont1.$(OBJ): zfont1.c $(OP) \
  $(gsmatrix_h) $(gxdevice_h) $(gschar_h) $(gxfixed_h) $(gxfont_h) $(gxfont1_h) \
  $(bfont_h) $(ialloc_h) $(idict_h) $(idparam_h) $(store_h)

zmisc1.$(OBJ): zmisc1.c $(OP) \
  $(gscrypt1_h) $(ifilter_h) $(sfilter_h) $(strimpl_h)

### Level 1 color extensions (CMYK color and colorimage)

color.dev: gs.mak cmykcore.dev cmykread.dev
	$(SETMOD) color
	$(ADDMOD) color -include cmykcore cmykread

# Core

cmykcore_=gscolor1.$(OBJ)
cmykcore.dev: gs.mak $(cmykcore_)
	$(SETMOD) cmykcore $(cmykcore_)

gscolor1.$(OBJ): gscolor1.c $(GXERR) \
  $(gsccolor_h) $(gscolor1_h) $(gscspace_h) $(gsstruct_h) \
  $(gxcmap_h) $(gxdcconv_h) $(gxdevice_h) \
  $(gzstate_h)

# Reader

cmykread_=zcolor1.$(OBJ)
cmykread.dev: gs.mak $(cmykread_)
	$(SETMOD) cmykread $(cmykread_)
	$(ADDMOD) cmykread -oper zcolor1

zcolor1.$(OBJ): zcolor1.c $(OP) \
  $(gscolor1_h) $(gscspace_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzstate_h) $(gxdevice_h) $(gxcmap_h) \
  $(ialloc_h) $(estack_h) $(iutil_h) $(igstate_h) $(store_h)

### Binary tokens

# Reader only

btoken_=iscanbin.$(OBJ) zbseq.$(OBJ)
btoken.dev: gs.mak $(btoken_)
	$(SETMOD) btoken $(btoken_)
	$(ADDMOD) btoken -oper zbseq_l2
	$(ADDMOD) btoken -ps gs_btokn

bseq_h=bseq.h
btoken_h=btoken.h

iscanbin.$(OBJ): iscanbin.c $(GH) $(errors_h) \
  $(gsutil_h) $(ialloc_h) $(ibnum_h) $(idict_h) $(iname_h) \
  $(iscan_h) $(iutil_h) $(ivmspace_h) \
  $(bseq_h) $(btoken_h) $(dstack_h) $(ostack_h) \
  $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)

zbseq.$(OBJ): zbseq.c $(OP) \
  $(ialloc_h) $(idict_h) $(isave_h) $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h) \
  $(iname_h) $(ibnum_h) $(btoken_h) $(bseq_h)

### Additions common to Display PostScript and Level 2

dpsand2a_=gsdps1.$(OBJ) ibnum.$(OBJ) iscanbin.$(OBJ)
dpsand2b_=zbseq.$(OBJ) zchar2.$(OBJ) zdps1.$(OBJ) zupath.$(OBJ) zvmem2.$(OBJ)
dpsand2_=$(dpsand2a_) $(dpsand2b_)
# Note that zvmem2 includes both Level 1 and Level 2 operators.
dpsand2.dev: gs.mak btoken.dev color.dev $(dpsand2_)
	$(SETMOD) dpsand2
	$(ADDMOD) dpsand2 -include btoken color
	$(ADDMOD) dpsand2 -obj $(dpsand2a_)
	$(ADDMOD) dpsand2 -obj $(dpsand2b_)
	$(ADDMOD) dpsand2 -oper zvmem2
	$(ADDMOD) dpsand2 -oper igc_l2 zchar2_l2 zdps1_l2 zupath_l2
	$(ADDMOD) dpsand2 -ps gs_dps1

gsdps1.$(OBJ): gsdps1.c $(GXERR) \
  $(gscoord_h) $(gsmatrix_h) $(gspaint_h) $(gspath_h) $(gspath2_h) \
  $(gxfixed_h) $(gxmatrix_h) $(gzpath_h) $(gzstate_h)

ibnum.$(OBJ): ibnum.c $(GH) $(errors_h) $(stream_h) $(ibnum_h)

zchar2.$(OBJ): zchar2.c $(OP) \
  $(gschar_h) $(gsmatrix_h) $(gsstruct_h) $(gxfixed_h) $(gxfont_h) \
  $(ialloc_h) $(ichar_h) $(estack_h) $(ifont_h) $(iname_h) $(igstate_h) $(store_h) $(stream_h) $(ibnum_h)

zdps1.$(OBJ): zdps1.c $(OP) \
  $(gsmatrix_h) $(gspath_h) $(gspath2_h) $(gsstate_h) $(gsstruct_h) \
  $(ialloc_h) $(ivmspace_h) $(igstate_h) $(store_h) $(stream_h) $(ibnum_h)

zupath.$(OBJ): zupath.c $(OP) \
  $(idict_h) $(dstack_h) $(iutil_h) $(igstate_h) $(store_h) $(stream_h) $(ibnum_h) \
  $(gscoord_h) $(gsmatrix_h) $(gspaint_h) $(gspath_h) $(gsstate_h) \
  $(gxfixed_h) $(gxdevice_h) $(gxpath_h)

zvmem2.$(OBJ): zvmem2.c $(OP) \
  $(estack_h) $(ialloc_h) $(ivmspace_h) $(store_h)

### Display PostScript
# We should include zcontext, but it isn't in good enough shape yet:
#	$(ADDMOD) dps -oper zcontext_l2

dps_=
dps.dev: gs.mak dpsand2.dev $(dps_)
	$(SETMOD) dps
	$(ADDMOD) dps -include dpsand2
	$(ADDMOD) dps -obj $(dps_)

zcontext.$(OBJ): zcontext.c $(OP) \
  $(gsstruct_h) \
  $(idict_h) $(istruct_h) $(dstack_h) $(estack_h) $(igstate_h) $(store_h)

### Composite (PostScript Type 0) font support

compfont.dev: gs.mak psf0core.dev psf0read.dev
	$(SETMOD) compfont
	$(ADDMOD) compfont -include psf0core psf0read

# Core

psf0core_=gschar0.$(OBJ) gsfont0.$(OBJ)
psf0core.dev: gs.mak $(psf0core_)
	$(SETMOD) psf0core $(psf0core_)

gschar0.$(OBJ): gschar0.c $(GXERR) \
  $(gsstruct_h) $(gxfixed_h) $(gxdevice_h) $(gxdevmem_h) \
  $(gxfont_h) $(gxfont0_h) $(gxchar_h)

gsfont0.$(OBJ): gsfont0.c $(GXERR) \
  $(gsmatrix_h) $(gsstruct_h) $(gxfixed_h) $(gxdevmem_h) $(gxfcache_h) \
  $(gxfont_h) $(gxfont0_h) $(gxchar_h) $(gxdevice_h)

# Reader

psf0read_=zchar2.$(OBJ) zfont0.$(OBJ)
psf0read.dev: gs.mak $(psf0read_)
	$(SETMOD) psf0read $(psf0read_)
	$(ADDMOD) psf0read -oper zfont0 zchar2
	$(ADDMOD) psf0read -ps gs_type0

zfont0.$(OBJ): zfont0.c $(OP) \
  $(gsmatrix_h) $(gsstruct_h) $(gxdevice_h) $(gxfont_h) $(gxfont0_h) \
  $(ialloc_h) $(bfont_h) $(idict_h) $(igstate_h) $(store_h)

### PostScript Level 2 additions

#**************** The first ADDMOD line should include dct
level2.dev: gs.mak compfont.dev dct.dev dpsand2.dev filter.dev level1.dev psl2core.dev psl2read.dev
	$(SETMOD) level2
	$(ADDMOD) level2 -include compfont dct dpsand2 filter
	$(ADDMOD) level2 -include level1 psl2core psl2read

# Core

psl2core_=gscie.$(OBJ) gscolor2.$(OBJ) gspcolor.$(OBJ) gxclip2.$(OBJ) gxpcmap.$(OBJ)
psl2core.dev: gs.mak $(psl2core_)
	$(SETMOD) psl2core $(psl2core_)

gscie.$(OBJ): gscie.c $(GXERR) \
  $(gscspace_h) $(gscie_h) $(gscolor2_h) $(gsmatrix_h) $(gsstruct_h) \
  $(gxarith_h) $(gzstate_h)

gscolor2.$(OBJ): gscolor2.c $(GXERR) \
  $(gscie_h) $(gscspace_h) \
  $(gxarith_h) $(gxcolor2_h) $(gxfixed_h) $(gxmatrix_h) \
  $(gzstate_h)

gspcolor.$(OBJ): gspcolor.c $(GXERR) $(math__h) \
  $(gscspace_h) $(gsstruct_h) $(gsutil_h) \
  $(gxarith_h) $(gxcolor2_h) $(gxcoord_h) $(gxclip2_h) $(gxdevice_h) $(gxdevmem_h) \
  $(gxfixed_h) $(gxmatrix_h) $(gxpath_h) $(gxpcolor_h) $(gzstate_h)

gxclip2.$(OBJ): gxclip2.c $(GXERR) $(memory__h) \
  $(gsstruct_h) $(gxclip2_h) $(gxdevice_h) $(gxdevmem_h)

gxpcmap.$(OBJ): gxpcmap.c $(GXERR) \
  $(gsstruct_h) $(gscspace_h) $(gsmatrix_h) $(gsutil_h) \
  $(gxcolor2_h) $(gxdevice_h) $(gxdevmem_h) $(gxfixed_h) $(gxpcolor_h) \
  $(gzstate_h)

# Reader

psl2read1_=iutil2.$(OBJ) zcie.$(OBJ) zcolor2.$(OBJ) zcsindex.$(OBJ) zcspace2.$(OBJ)
psl2read2_=zdevice2.$(OBJ) zht2.$(OBJ) zimage2.$(OBJ) ziodev2.$(OBJ) zmisc2.$(OBJ)
psl2read_=$(psl2read1_) $(psl2read2_)
# Note that zmisc2 includes both Level 1 and Level 2 operators.
psl2read.dev: gs.mak $(psl2read_)
	$(SETMOD) psl2read $(psl2read1_)
	$(ADDMOD) psl2read -obj $(psl2read2_)
	$(ADDMOD) psl2read -oper zmisc2
	$(ADDMOD) psl2read -oper zcie_l2 zcolor2_l2 zcsindex_l2 zcspace2_l2
	$(ADDMOD) psl2read -oper zdevice2_l2 zht2_l2 zimage2_l2 ziodev2_l2
	$(ADDMOD) psl2read -iodev null ram
	$(ADDMOD) psl2read -ps gs_lev2

iutil2.$(OBJ): iutil2.c $(GXERR) $(memory__h) \
  $(gsparam_h) $(opcheck_h) $(idict_h) $(imemory_h) $(iutil_h) $(iutil2_h)

zcie.$(OBJ): zcie.c $(OP) \
  $(gscspace_h) $(gscolor2_h) $(gscie_h) $(gsstruct_h) \
  $(ialloc_h) $(idict_h) $(idparam_h) $(estack_h) $(isave_h) $(igstate_h) $(store_h)

zcolor2.$(OBJ): zcolor2.c $(OP) \
  $(gscolor_h) $(gscspace_h) $(gsmatrix_h) $(gsstruct_h) \
  $(gxcolor2_h) $(gxdevice_h) $(gxdevmem_h) $(gxfixed_h) $(gxpcolor_h) \
  $(estack_h) $(ialloc_h) $(idict_h) $(idparam_h) $(igstate_h) $(istruct_h) \
  $(store_h)

zcsindex.$(OBJ): zcsindex.c $(OP) \
  $(gscolor_h) $(gsstruct_h) $(gxfixed_h) $(gxcolor2_h) $(gscspace_h) \
  $(ialloc_h) $(estack_h) $(igstate_h) $(store_h)

zcspace2.$(OBJ): zcspace2.c $(OP) \
  $(gscolor_h) $(gscolor2_h) $(gscspace_h) $(gsmatrix_h) \
  $(idict_h) $(idparam_h) $(dstack_h) $(estack_h) $(iname_h) $(igstate_h) $(store_h)

zdevice2.$(OBJ): zdevice2.c $(OP) \
  $(dstack_h) $(estack_h) $(idict_h) $(idparam_h) $(igstate_h) $(iname_h) $(store_h) \
  $(gxdevice_h) $(gsstate_h)

zht2.$(OBJ): zht2.c $(OP) \
  $(gsstruct_h) $(gxdevice_h) $(gzht_h) \
  $(estack_h) $(ialloc_h) $(idict_h) $(idparam_h) $(igstate_h) $(store_h)

zimage2.$(OBJ): zimage2.c $(OP) \
  $(gscolor_h) $(gscolor2_h) $(gscspace_h) $(gsmatrix_h) \
  $(idict_h) $(idparam_h) $(ilevel_h) $(igstate_h)

ziodev2.$(OBJ): ziodev2.c $(OP) \
  $(gxiodev_h) $(stream_h) $(files_h) $(iparam_h) $(iutil2_h) $(store_h)

zmisc2.$(OBJ): zmisc2.c $(OP) \
  $(gsfont_h) $(gsutil_h) \
  $(ialloc_h) $(idict_h) $(idparam_h) $(iparam_h) $(dstack_h) $(estack_h) $(ilevel_h) $(iname_h) $(iutil2_h) $(store_h)

### Filters other than the ones in sfilter.c

# Support

sbits.$(OBJ): sbits.c $(AK) $(std_h)

shc.$(OBJ): shc.c $(AK) $(std_h) $(shc_h)

# Filters

sbhc.$(OBJ): sbhc.c $(AK) $(stdio__h) \
  $(gdebug_h) $(sbhc_h) $(strimpl_h)

sbwbs.$(OBJ): sbwbs.c $(AK) $(stdio__h) $(memory__h) \
  $(gdebug_h) $(sbwbs_h) $(sfilter_h) $(strimpl_h)

scfd.$(OBJ): scfd.c $(AK) $(stdio__h) $(gdebug_h)\
  $(scf_h) $(strimpl_h) $(scfx_h)

scfe.$(OBJ): scfe.c $(AK) $(stdio__h) $(gdebug_h)\
  $(scf_h) $(strimpl_h) $(scfx_h)

scfdtab.$(OBJ): scfdtab.c $(AK) $(std_h) $(scommon_h) $(scf_h)

scftab.$(OBJ): scftab.c $(AK) $(std_h) $(scommon_h) $(scf_h)

sdiff.$(OBJ): sdiff.c $(AK) $(stdio__h)\
  $(sdiffx_h) $(strimpl_h)

sfilter2.$(OBJ): sfilter2.c $(AK) $(stdio__h)\
  $(scanchar_h) $(sfilter_h) $(strimpl_h)

slzwce.$(OBJ): slzwce.c $(AK) $(stdio__h) $(gdebug_h)\
  $(slzwx_h) $(strimpl_h)

slzwd.$(OBJ): slzwd.c $(AK) $(stdio__h) $(gdebug_h)\
  $(slzwx_h) $(strimpl_h)

slzwe.$(OBJ): slzwe.c $(AK) $(stdio__h) $(gdebug_h)\
  $(slzwx_h) $(strimpl_h)

zfilter2.$(OBJ): zfilter2.c $(OP) \
  $(gsstruct_h) $(ialloc_h) $(idict_h) $(idparam_h) $(ifilter_h) \
  $(sfilter_h) $(sbhc_h) $(sbwbs_h) $(scfx_h) $(sdiffx_h) $(slzwx_h) $(strimpl_h)

filter_1=zfilter2.$(OBJ) sbits.$(OBJ) shc.$(OBJ)
filter_2=sbhc.$(OBJ) sbwbs.$(OBJ) scfd.$(OBJ) scfe.$(OBJ) scfdtab.$(OBJ) scftab.$(OBJ)
filter_3=sdiff.$(OBJ) sfilter2.$(OBJ) slzwd.$(OBJ) slzwe.$(OBJ)
filter.dev: gs.mak $(filter_1) $(filter_2) $(filter_3)
	$(SETMOD) filter $(filter_1)
	$(ADDMOD) filter -obj $(filter_2)
	$(ADDMOD) filter -obj $(filter_3)
	$(ADDMOD) filter -oper zfilter2

### DCT filters.  The definition for jpeg.dev is in jpeg.mak.

GSDCT=sdct.$(OBJ) sjpeg.$(OBJ) zfdct.$(OBJ)
dct.dev: jpeg.dev gs.mak $(GSDCT)
	$(SETMOD) dct
	$(ADDMOD) dct -include jpeg
	$(ADDMOD) dct -obj $(GSDCT)
	$(ADDMOD) dct -oper zfdct

sdct.$(OBJ): sdct.c $(AK) $(stdio__h) $(gdebug_h)\
  $(sjpeg_h) $(sdct_h) $(strimpl_h) \
  jerror.h jpeglib.h
	$(CCC) -I. -I$(JPEGSRC) sdct.c

sjpeg.$(OBJ): sjpeg.c $(AK) $(stdio__h) $(gx_h)\
  $(gserrors_h) $(sjpeg_h) $(sdct_h) $(strimpl_h) \
  jerror.h jpeglib.h
	$(CCC) -I. -I$(JPEGSRC) sjpeg.c

zfdct.$(OBJ): zfdct.c $(OP) \
  $(gsstruct_h) $(ialloc_h) $(idict_h) $(idparam_h) $(ifilter_h) \
  $(ipacked_h) $(sdct_h) $(sjpeg_h) $(strimpl_h) \
  jpeglib.h
	$(CCC) -I. -I$(JPEGSRC) zfdct.c

### Precompiled fonts.  See fonts.doc for more information.

ccfont_h=ccfont.h $(std_h) $(gsmemory_h) $(iref_h) $(store_h)

CCFONT=$(OP) $(ccfont_h)

# List the fonts we are going to compile.
# Because of intrinsic limitations in `make', we have to list
# the object file names and the font names separately.
ccfonts_ps=gs_ccfnt
ccfonts1_=phvr.$(OBJ)
ccfonts1=Helvetica

# Strictly speaking, ccfonts shouldn't need to include type1,
# since one could choose to precompile only Type 0 fonts,
# but getting this exactly right would be too much work.
ccfonts.dev: $(MAKEFILE) gs.mak iccfont.$(OBJ) \
  $(ccfonts1_) $(ccfonts2_) $(ccfonts3_) $(ccfonts4_) $(ccfonts5_) \
  $(ccfonts6_) $(ccfonts7_) $(ccfonts8_) $(ccfonts9_)
	$(SETMOD) ccfonts
	$(ADDMOD) ccfonts -include type1
	$(ADDMOD) ccfonts -obj iccfont.$(OBJ)
	$(ADDMOD) ccfonts -obj $(ccfonts1_)
	$(ADDMOD) ccfonts -obj $(ccfonts2_)
	$(ADDMOD) ccfonts -obj $(ccfonts3_)
	$(ADDMOD) ccfonts -obj $(ccfonts4_)
	$(ADDMOD) ccfonts -obj $(ccfonts5_)
	$(ADDMOD) ccfonts -obj $(ccfonts6_)
	$(ADDMOD) ccfonts -obj $(ccfonts7_)
	$(ADDMOD) ccfonts -obj $(ccfonts8_)
	$(ADDMOD) ccfonts -obj $(ccfonts9_)
	$(ADDMOD) ccfonts -oper ccfonts
	$(ADDMOD) ccfonts -ps $(ccfonts_ps)

gconfigf.h: $(MAKEFILE) gs.mak genconf$(XE)
	$(SETMOD) ccfonts_
	$(ADDMOD) ccfonts_ -font $(ccfonts1)
	$(ADDMOD) ccfonts_ -font $(ccfonts2)
	$(ADDMOD) ccfonts_ -font $(ccfonts3)
	$(ADDMOD) ccfonts_ -font $(ccfonts4)
	$(ADDMOD) ccfonts_ -font $(ccfonts5)
	$(ADDMOD) ccfonts_ -font $(ccfonts6)
	$(ADDMOD) ccfonts_ -font $(ccfonts7)
	$(ADDMOD) ccfonts_ -font $(ccfonts8)
	$(ADDMOD) ccfonts_ -font $(ccfonts9)
	$(EXP)genconf ccfonts_.dev -f gconfigf.h

iccfont.$(OBJ): iccfont.c $(GH) gconfigf.h \
  $(ghost_h) $(ialloc_h) $(ccfont_h) $(idict_h) $(errors_h) \
  $(ifont_h) $(iutil_h) $(iname_h) $(oper_h) $(isave_h) $(store_h)

ncrr.$(OBJ): ncrr.c $(CCFONT)
	$(CCCF) ncrr.c

pagk.$(OBJ): pagk.c $(CCFONT)
	$(CCCF) pagk.c

phvr.$(OBJ): phvr.c $(CCFONT)
	$(CCCF) phvr.c

psyr.$(OBJ): psyr.c $(CCFONT)
	$(CCCF) psyr.c

ptmr.$(OBJ): ptmr.c $(CCFONT)
	$(CCCF) ptmr.c

pzdr.$(OBJ): pzdr.c $(CCFONT)
	$(CCCF) pzdr.c

### Precompiled initialization code.
# Note that in order to generate this, you have to have a working copy
# of the interpreter already available.

ccinit.dev: gs.mak iccinit.$(OBJ) gs_init.$(OBJ)
	$(SETMOD) ccinit iccinit.$(OBJ) gs_init.$(OBJ)
	$(ADDMOD) ccinit -oper ccinit

iccinit.$(OBJ): iccinit.c $(GH) \
  $(errors_h) $(oper_h) $(store_h) $(stream_h) $(files_h)

# All the gs_*.ps files should be prerequisites of gs_init.c,
# but we don't have any convenient list of them.
# We can't make $(GS)$(XE) a prerequisite, because that would be circular.
gs_init.c: $(GS_INIT) mergeini.ps
	$(EXP)$(GS)$(XE) -dNODISPLAY -sCfile=gs_init.c mergeini.ps

gs_init.$(OBJ): gs_init.c $(stdpre_h)
	$(CCCF) gs_init.c

# ----------------------- Platform-specific modules ----------------------- #
# Platform-specific code doesn't really belong here: this is code that is
# shared among multiple platforms.

# Frame buffer implementations.

gp_nofb.$(OBJ): gp_nofb.c $(AK) \
  $(gx_h) $(gp_h) $(gxdevice_h)

gp_dosfb.$(OBJ): gp_dosfb.c $(AK) $(memory__h) \
  $(gx_h) $(gp_h) $(gserrors_h) $(gxdevice_h)

# MS-DOS file system, also used by Desqview/X.
gp_dosfs.$(OBJ): gp_dosfs.c $(AK) $(dos__h) $(gp_h) $(gx_h)

# MS-DOS file enumeration, *not* used by Desqview/X.
gp_dosfe.$(OBJ): gp_dosfe.c $(AK) $(stdio__h) $(memory__h) $(string__h) \
  $(dos__h) $(gstypes_h) $(gsmemory_h) $(gsstruct_h) $(gp_h) $(gsutil_h)

# Other MS-DOS facilities.
gp_msdos.$(OBJ): gp_msdos.c $(AK) $(dos__h) \
  $(gsmemory_h) $(gstypes_h) $(gp_h)

# Unix(-like) file system, also used by Desqview/X.
gp_unifs.$(OBJ): gp_unifs.c $(AK) $(memory__h) $(string__h) $(gx_h) $(gp_h) \
  $(gsstruct_h) $(gsutil_h) $(stat__h) $(dirent__h)

# Unix(-like) file name syntax, *not* used by Desqview/X.
gp_unifn.$(OBJ): gp_unifn.c $(AK) $(gx_h) $(gp_h)

# ----------------------------- Main program ------------------------------ #

# Interpreter main program

gs.$(OBJ): gs.c $(GH) $(ctype__h) \
  $(gxdevice_h) $(gxdevmem_h) \
  $(errors_h) $(estack_h) $(files_h) \
  $(ialloc_h) $(interp_h) $(iscan_h) $(iutil_h) \
  $(main_h) $(ostack_h) $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)

gsmain.$(OBJ): gsmain.c $(GH) \
  $(gp_h) $(gsmatrix_h) $(gxdevice_h) $(gserrors_h) \
  $(dstack_h) $(estack_h) $(files_h) $(ialloc_h) $(idict_h) $(iname_h) $(iscan_h) \
  $(main_h) $(oper_h) $(ostack_h) $(sfilter_h) $(store_h) $(strimpl_h)

interp.$(OBJ): interp.c $(GH) \
  $(dstack_h) $(errors_h) $(estack_h) $(files_h) $(oper_h) $(ostack_h) \
  $(ialloc_h) $(iastruct_h) $(iname_h) $(idict_h) $(interp_h) $(ipacked_h) \
  $(iscan_h) $(isave_h) $(istack_h) $(iutil_h) $(ostack_h) \
  $(sfilter_h) $(store_h) $(stream_h) $(strimpl_h)
	$(CCINT) interp.c
