/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       dpfstat.c
**     SYSTEM   NAME:       
**     ORIGINAL AUTHOR(S):  
**     VERSION  NUMBER:     
**     CREATION DATE:       1990/10/26
**
** DESCRIPTION: 
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   DPFSTAT.C  $
** LOGINFO:     $Log:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPF/VCS/DPFSTAT.C_V  $
**              
**                 Rev 1.0   26 Oct 1990 13:55:52   etstjan
**              Initial revision.
*************************************************************************/
#if ! defined(PRD)
static char _pvcs_hdr[] =
"$Header:   I:/ETSTJAN/C600/BEHOLDER/NPD/DPF/VCS/DPFSTAT.C_V   1.0   26 Oct 1990 13:55:52   etstjan  $";
#endif
#include <stdio.h>
#include <stdlib.h>                         /* for _MAX_PATH */
#include <malloc.h>                         /* for malloc(), free() */
#include <dnpap.h>                          /* for BYTE */
#include <power3.h>
#include <dp.h>
#include <dpu.h>                            /* for DpuSelectStation() */
#include "dpfinc.h"                         /* main include file */

#define NEXTMENUCOL 20

static int ProcessEvent(DPEVENT Event);

DPFILT DpfStation = { "Station", ProcessEvent, 0 };

BYTE *DpfStationKey;
static int StationElem = 0;

static int   filtcmp(BYTE far *buf);
static int   Filter(void);
static int   Init(void);
static void  End(void);
static int   Start(void);
static void  Stop(void);

static int ProcessEvent(DPEVENT Event)
{
    int ret = 0;

    switch (Event)
    {
    case DPE_RECEIVEPKT: ret = Filter();        break;
    case DPE_START:      ret = Start();         break;
    case DPE_STOP:             Stop();          break;
    case DPE_INIT:       ret = Init();          break;
    case DPE_END:              End();           break;
    }
    return ret;
}

static int filtcmp(BYTE far *buf)
{
    return ((buf[0] == DpfStationKey[0]) &&
            (buf[1] == DpfStationKey[1]) &&
            (buf[2] == DpfStationKey[2]) &&
            (buf[3] == DpfStationKey[3]) &&
            (buf[4] == DpfStationKey[4]) &&
            (buf[5] == DpfStationKey[5]));
}

/*************************************************************************
** NAME:        Filter
** SYNOPSIS:    int Filter(frp)
**              FRAME *frp              Pointer to frame struct
** DESCRIPTION: This function filters a frame through all filter elements
**                build up by a previous call to Start().
** RETURNS:      0: Frame did NOT pass filter
**              -1: Frame passed all filter elements
** EXAMPLE:     if (frp = FrRbMalloc(framelength))
**              {
**                  frp->hdrlen = hdrinfo->hdrlen;
**                  frp->datlen = framelength - frp->hdrlen;
**                  frp->hdrptr = (BYTE *)frp + sizeof(FRAME);
**                  frp->datptr = frp->hdrptr + frp->hdrlen;
**                  readframe(frp)
**                  if (!(frp))
**                      FrRbUnMalloc();
**              }
**              else
**                  ... ring buffer full ...
*************************************************************************/
static int Filter(void)
{
    DPBUF *pBuf = DpReceivePkt();

    return (filtcmp(pBuf->pBuf+hdrinfo->DestOff) ||
            filtcmp(pBuf->pBuf+hdrinfo->SrcOff));
}

static int Init(void)
{
    int i;

    int StationElem = 0;
    DpfStationKey = malloc(hdrinfo->AddrLen);
    for (i=0; i<hdrinfo->AddrLen; i++)      /* default station = broadcasts */
        DpfStationKey[i] = 0xff;
    return DpuIniInit("DP.INI");
}

static void End(void)
{
    DpuIniEnd();
    free(DpfStationKey);
}

/*************************************************************************
** NAME:        Start
** SYNOPSIS:    int Start(DpfFilterFile)
**              char *DpfFilterFile         File name of filter file
** DESCRIPTION: This function reads the filter file 'DpfFilterFile' and
**                builds up a linked list of filter elements.
**              Subsequent calls to the filter function 'Filter'
**                will use this filter list as the filter criteria
**                for th frames.
**              If the filter file does not exist in the current
**                directory, it assumes an empty filter list
**                (all frames will pass the filter).
**              The function Stop() frees the filter elements
**                previously allocated by a call to Start().
** RETURNS:      0: Successful call
**              -9: Not enough memory
** SEE ALSO:    Filter, Stop
*************************************************************************/
static int Start(void)
{
    DpuSelectStation(4, NEXTMENUCOL+18, 10, DpfStationKey, &StationElem);
    return 0;
}

/*************************************************************************
** NAME:        Stop
** SYNOPSIS:    void Stop(void)
** DESCRIPTION: This function frees the filter elements
**                previously allocated by a call to Start().
** RETURNS:     void
** SEE ALSO:    Start
*************************************************************************/
static void Stop(void)
{
}

