/************************************************************************
** MODULE INFORMATION*
**********************
**     FILE     NAME:       SOCKET.H
**     SYSTEM   NAME:       IP
**     ORIGINAL AUTHOR(S):  Wim van Campen
**     VERSION  NUMBER:     1.0
**     CREATION DATE:       1990/6/27
**
** DESCRIPTION: Header file for the socket library.
**              
*************************************************************************
** CHANGES INFORMATION **
*************************
** REVISION:    $Revision:   1.0  $
** WORKFILE:    $Workfile:   SOCKET.H  $
** LOGINFO:     $Log:   I:/ETSTJAN/CPROG/BEHOLDER/UDPIP/INCLUDE/VCS/SOCKET.H_V  $
**              
**                 Rev 1.0   01 Feb 1991 11:41:04   etstjan
**              No explicit note
*************************************************************************/

#ifndef SOCK_DEF
#define SOCK_DEF
#ifndef LITTLE_ENDIAN
#  define LITTLE_ENDIAN         /* define machine byte order */
#endif
 
#ifndef u_short
#  define  u_short        USHORT 
#endif

#ifndef u_long
#  define  u_long         ULONG 
#endif

/* define return codes */
#define   NOERR          0      /* everything ok                           */
#define   NOSOCKLEFT     -200   /* no non reserved socket port left        */
#define   SOCKINUSE      -201   /* this local <port, address> is used      */ 
#define   ILLFAMILY      -202   /* illegal adressing family specified      */
#define   ILLADDSIZE     -203   /* address size not Internet size          */
#define   ILLADD         -204   /* illegal address specification           */
#define   NOBUFS         -205   /* no buffer space left                    */
#define   NOTBOUND       -206   /* socket not bound                        */
#define   NOTCONNECT     -207   /* socket not connected                    */
#define   NOMESSAGE      -210   /* no message available                    */
/* get/set socket options */
#define   ILLPROTOC      -220   /* illegal protocol level specified        */
#define   ILLOPTNAME     -221   /* not supported option name               */
#define   ILLOPTVAL      -222   /* illegal option value supplied           */

/* socket error codes */
#define   EPARAMPROB     -250   /* parameter problem message received      */
/* keep the unreachable codes in descending order!! */
#define   ENETUNREACH    -251   /* network unreachable received            */
#define   EHOSTUNREACH   -252   /* host unreachable received               */
#define   EPROTUNREACH   -253   /* protocol unreachable                    */
#define   EPORTUNREACH   -254   /* port unreachable                        */
#define   EDFSET         -255   /* fragmentation needed and DF flag set    */
#define   ETRACEROUTE    -256   /* trace route fail                        */
#define   ESRCQUENCH     -257   /* source quench received                  */
/* keep the time exceeded codes in descending order */
#define   ETTLEXC        -258   /* time to live exceeded                   */
#define   EREASSEXC      -259   /* fragment reassembly exceeded            */


/* defines for protocol families */
#define AF_UNSPEC        0      /* unspecified address family              */
#define AF_INET          2      /* internet protocol                       */

/* defines for protocol types */
#define IP               0      /* dummy for IP protocol */
#define ICMP             1      /* ICMP protocol */
#define UDP              17     /* UDP protocol */

/* define socket option level  */
#define SOL_SOCKET       -1     /* socket level option processing          */
#define IP_OPTIONS       1      /* IP level option processing              */
      
/* defines for socket types */
#define SOCK_STREAM      1      /* stream oriented socket                  */
#define SOCK_DGRAM       2      /* datagram socket                         */
#define SOCK_RAW         3      /* raw socket                              */

/* defines for receive flags */
#define MSG_OOB          0x1    /* process out-of-band data                */
#define MSG_PEEK         0x2    /* peek at incoming message                */

/* defines for optnames of get/set socketoptions */
#define SO_ERROR         0x1    /* get and clear socket error status       */


#ifdef SOCKET
#  undef SOCKET
#endif
#define SOCKET           void *

#ifndef INADDR_ANY       
  #define	INADDR_ANY   (ULONG)0x00000000
#endif

#ifndef INADDR_NONE       
  #define	INADDR_NONE  (ULONG)0xffffffff
#endif

/*
 * Internet address (a structure for historical reasons)
 */
struct in_addr {
	ULONG s_addr;
};

/*
 * Socket address, internet style.
 */
struct sockaddr_in {
	int     sin_family;
	USHORT  sin_port;
	struct	in_addr sin_addr;
	char	sin_zero[8];
};

struct sockaddr {
	USHORT  sa_family;          /* address family */
	char    sa_data[14];        /* up to 14 bytes of direct address */
    };


/* prototypes */
SOCKET        socket(int Domain, int Type, int Protocol);
int           bind(SOCKET s, struct sockaddr *name, int namelen);
int           connect(SOCKET s, struct sockaddr *name, int namelen);
int           send(SOCKET s, char *msg, int len, int flags);
int           sendto(SOCKET s, char *msg, int len, int flags,
                     struct sockaddr *to, int tolen);
int           recv(SOCKET s, char *buf, int len, int flags);
int           recvfrom(SOCKET s, char *buf, int len, int flags,
                       struct sockaddr *from, int *fromlen);
int           shutdown(SOCKET s, int howto);
int           closesocket(SOCKET thissocket);

int           getsockopt(SOCKET s, int level, int optname,
                         char *optval, int *optlen);
int           setsockopt(SOCKET s, int level, int optname,
                         char *optval, int optlen);

int           getsockname(SOCKET s, struct sockaddr *name, int *namelen);

unsigned long inet_addr(char *cp);
char          *inet_ntoa(unsigned long cp);

#ifdef BIG_ENDIAN
  #define    htonl(x)  x
  #define    htons(x)  x
  #define    ntohl(x)  x
  #define    ntohs(x)  x
#endif

#ifdef LITTLE_ENDIAN
  u_long   htonl(u_long hostlong);
  u_short  htons(u_short hostshort);
  u_long   ntohl(u_long netlong);
  u_short  ntohs(u_short netshort);
#endif

#endif
