//	Copyright (c) 1994, University of Kansas, All Rights Reserved
//
//	Class:		TTempName
//	Include File:	ttempnam.h
//	Purpose:	Provide a standard way of naming temporary files.
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-15-94	created
#include"ttempnam.h"
#include"tcapture.h"
#include<stdio.h>
#include<errno.h>

void TTempName::unlink() const	{
//	Purpose:	Deletes the file associated with the temporary
//			file name.
//	Arguments:	void
//	Return Value:	void
//	Remarks/Portability/Dependencies/Restrictions:
//	Revision History:
//		02-15-94	created

	//	Do we have a file name?
	if(cp_TempName == NULL)	{
		doslynxmessage("No temporary file name to delete.");
		return;
	}

	//	Delete the file and check for error codes.
	if(::unlink(cp_TempName) == -1)	{
		doslynxmessage("Unable to delete " << cp_TempName);
		doslynxmessage(::sys_errlist[::errno]);
	}
}