;		bufs.asm
;========================================================================

; Copyright (C) 1991-94 by Jan.Engvald@ldc.lu.se, see file COPYING.

;************************************************************************
;*		BufAlloc
;*	Output: 	if OK: non-zero and DS:BX = buffer addr
;*					    DS:DI = pkt addr
;*					    ES = DS
;*	Destroys:	DS, BX, SI, DI, ES, flags
;*			or just DI and flags if the list was empty
;************************************************************************

BufAlloc	proc	near
if DEBUG ge 2
                mov     di,cs:FreeBufs.lBufsAvail
                cmp     di,cs:MinAvail
                ja      BufAlNotMin
                mov     cs:MinAvail,di
  BufAlNotMin:
endif ; DEBUG ge 2
		mov	di,offset FreeBufs	; free buffer chain

ifdef SMALLBUFS
		jmp	short BufAl

BufAlSml:
		mov	di,offset FreeSmal
endif ; SMALLBUFS

  BufAl:
		call	GetFromList
		jz	BufAllocRet

		mov	[bx].dPtrDes,bx 	; fill in descriptor ptrs
		lea	di,[bx+DESCRLEN]
		mov	[bx].dPtrPhys,di	; must be di return value
  BufAllocRet:
		ret
BufAlloc	endp



;************************************************************************
;*		GetFromList
;*	Input:		CS:DI = listhead address
;*	Output: 	if OK: non-zero and DS:BX = buffer addr
;*					    ES = DS
;*	Destroys:	DS, BX, SI, DI, ES, flags
;*			or just flags if the list was empty
;************************************************************************

GetFromList	proc	near
		PushfDI
		dec	cs:[di].lBufsAvail  	; one less available bufs
		js	GetFromEmpty		; empty?

		lds	bx,cs:[di].lNext	; - no, unlink first buf
		les	si,[bx].dNext
		mov	cs:[di].lNext.offs,si
		mov	cs:[di].lNext.segm,es
		mov	es:[si].dPrev.offs,di
		mov	es:[si].dPrev.segm,cs
		mov	si,ds
		mov	es,si
if DEBUG
		mov	[bx].dPrev.offs,0
endif ; DEBUG
		PopfEI
		or	sp,sp			; non-zero (OK) return
		ret

  GetFromEmpty:
		inc	cs:[di].lBufsAvail  	; restore available bufs
		PopfEI
		cmp	bx,bx			; ensure zero flag
		ret
GetFromList	endp



;************************************************************************
;*		BufRelease
;*	Input:		DS:BX = buffer addr
;*			CS:SI = List to add to (AddToList only)
;*	Destroys:	SI, DI, ES (but all flags are saved)
;************************************************************************

BufRelease	proc	near
		mov	si,[bx].dHomeList	; free buffer chain
if DEBUG ge 2
		pushf
		cmp	si,offset FreeBufs	; did DS:BX point to a descriptor?
		je	BufRelOK
ifdef SMALLBUFS
		cmp	si,offset FreeSmal
		je	BufRelOK
endif ; SMALLBUFS
  BufRelErr:
		mov	al,'Z'-'0'
		call	Terminate
  BufRelOK:
		popf
endif ; DEBUG ge 2

if DEBUG ge 3
		.386
		pushf
		push	ds
		pop	es
		push	eax
		push	cx
		mov	cx,(dHwDst-dPtrIp)/4

if DEBUG ge 7
		mov	cx,((dHwDst-dPtrIp)+(BUFSIZESML-DESCRLEN))/4
		cmp	si,offset FreeBufs
		jne	BufRelSml
		mov	cx,((dHwDst-dPtrIp)+(BUFSIZE-DESCRLEN))/4
  BufRelSml:
endif ; DEBUG ge 7

		lea	di,[bx].dPtrPhys
		mov	eax,0aaaaaaaah		; trash old contents
		stosw
		rep	stosd

		pop	cx
		pop	eax
		popf
		.8086
endif ; DEBUG ge 3


AddToList:
		pushf
if DEBUG ge 2
		cmp	[bx].dPrev.offs,0	; already on a list?
		jne	BufRelErr
		mov	di,ds
		cmp	di,cs:MySegm		; reasonable segment?
		jb	BufRelErr
endif ; DEBUG ge 2
		cli
		inc	cs:[si].lBufsAvail 	; one more buf is now available

		les	di,cs:[si].lPrev	; link in buffer
		mov	cs:[si].lPrev.offs,bx
		mov	cs:[si].lPrev.segm,ds
		mov	es:[di].dNext.offs,bx	;   at end of chain
		mov	es:[di].dNext.segm,ds
		mov	[bx].dPrev.offs,di
		mov	[bx].dPrev.segm,es
		mov	[bx].dNext.offs,si
		mov	[bx].dNext.segm,cs

		popf
		ret
BufRelease	endp



;************************************************************************
;*		BufInit
;************************************************************************

BufInit 	proc	near
		mov	ax,cs
		mov	ds,ax
		assume	ds:code_s
		mov	es,ax
		mov	MySegm,ax

		mov	cx,LINKHEADS
		mov	di,offset SendToDo.lNext.segm
  BufSegmLoop:
		stosw				; lNext.segm = cs
		scasw				; skip over lPrev.offs
		stosw				; lPrev.segm = cs
		add	di,LINKHEADLEN-6
		loop	BufSegmLoop

                test    ArgFlags,TR_GIANT	; Ethernet or Token Ring size?
                jz      BufStandard
                mov     MyNbufs,NBUFSTR
                mov     MyGiant,GIANTTR
                mov     MyBufSize,BUFSIZETR
  BufStandard:
		mov	ax,MyBufSize		; initialize cs segm buffers
		mov	cx,MyNbufs
		mov	bx,offset BufStart
  BufInitLoop:
		mov	[bx].dHomeList,offset FreeBufs
if DEBUG ge 2
		mov	[bx].dPrev.offs,0
endif ; DEBUG ge 2
		call	BufRelease
		add	bx,ax
		loop	BufInitLoop

ifdef SMALLBUFS
		mov	cx,NBUFSMALL
  BufSmlLoop:
		mov	[bx].dHomeList,offset FreeSmal
		mov	[bx].dPrev.offs,0
		call	BufRelease
		add	bx,BUFSIZESML
		loop	BufSmlLoop
endif ; SMALLBUFS

if TBLBUILD or PINGCLIENT
if DEBUG
		test	ArgFlags,NOT_ALL_MEM
		jnz	BufInitRet
endif ; DEBUG
		mov	dx,ArgFlags
		and	dx,TERM_WAIT+MAKE_TABLE
		or	dx,EchoTarget
		jz	BufInitRet

		mov	dx,cs			; use all free memory as buffers
		add	dx,1000h
if TBLBUILD
		test	ArgFlags,MAKE_TABLE
		jz	BufInNoTbl

		add	dx,1000h*TableSegs
if HOPCHK
		test	MoreFlags,HOP_CHK
		jz	BufInNoHop
		and	ArgFlags,not MAKE_TABLE
  BufInNoHop:
endif ; HOPCHK
  BufInNoTbl:
endif ; TBLBUILD
		assume	ds:nothing
  BufHeapL1:
		mov	bx,4			; don't want offset 0
		mov	ds,dx
		add	dx,1000h
  BufHeapL2:
		lea	si,[bx+15]		; convert addr to paragrafs
		add	si,ax
		mov	cl,4
		shr	si,cl
		mov	cx,ds
		add	cx,si
		add	cx,0c00h		; room for COMMAND.COM
		cmp	cx,cs:PspTopMem		; above the top?
		ja	BufInitRet
		
		mov	[bx].dHomeList,offset FreeBufs
if DEBUG ge 2
		mov	[bx].dPrev.offs,0
endif ; DEBUG ge 2
		call	BufRelease
                add     bx,ax
                add     bx,ax
                jc      BufHeapL1		; next 64k segment
                sub     bx,ax
		jmp	BufHeapL2
		
  BufInitRet:
endif ; TBLBUILD or PINGCLIENT

		push	cs
		push	cs
		pop	ds
		pop	es
if DEBUG
		mov	ax,FreeBufs.lBufsAvail
		mov	MaxAvail,ax
endif ; DEBUG
		ret
BufInit 	endp

;========================================================================
;		endinclude
