.TH PPRD 1 "15 March 1995" "DOS network application"
.SH NAME
pprd \- LPD (network printer daemon) for DOS
.SH SYNOPSIS
.B pprd
[\fB\-p\fIport\fR] [\fB\-n\fI#\fR] [\fB\-t\fR] [\fB\-i\fR]
[\fB\-s\fR] [\fB\-b\fI#\fR] [\fB\-\fI#\fR]
[\fB\-a\fIhostlist\fR] [\fB\-d\fIhostlist\fR] [\fB\-l\fIhost\fR]
[\fB\-j\fI[port]\fR]
.SH DESCRIPTION
.I pprd
is a small program that turns an XT or AT running DOS into a dedicated
LPD printer server. You can send jobs to the printers from any
machine running LPR.  It can handle up to 3 parallel printer ports.
Serial printers can be handled by running the interrupt I/O driver
TSRCOMM, which is in LPTCOM.ZIP and diverting LPTn to COMn.
.LP
.I pprd
supports an alternate protocol to LPD, called the Direct protocol here.
It is invoked by specifying the \fB\-j\fP flag. The job is sent as a
TCP data stream ended by closing the connection.  The advantage of this
protocol is that the size of the job does not need to be known in
advance, which could be used to advantage in a print redirector. It is
more efficient because there are fewer transactions than in the LPD
protocol.
.SH INSTALLATION
.I pprd
requires:  Parallel or serial printer ports connected to
printers,  a network interface card and a FTP Software specification
Packet Driver for it, and a valid WATTCP configuration file, WATTCP.CFG.
.LP
To install, edit the file WATTCP.CFG, filling in the entries. Then edit
your autoexec.bat file to load the packet driver, then
.IR pprd .
Something like this:
.sp
.nf
a:\\pprd\\ni5210 0x60 2 0x300 0xcc00
rem If you wish to put your wattcp.cfg in a particular directory
set wattcp_cfg=a:\\pprd\\wattcp.cfg
a:\\pprd\\pprd
.fi
.LP
Turn your printers on before starting
.I pprd
or it will not detect the printers. Alternatively, use the \fB\-n\fP
flag in
.IR pprd .
.LP
.I pprd
outputs tones (C,D,E) for as many printers as detected.
.I pprd
displays status on console, including changes in printer status. It
responds to LPQ queries, returning status reports to the client.
.LP
You can now send jobs from clients with LPR. The printers served are
called lpt1 through lpt3, in any mixture of case. You can also set the
printer names in WATTCP.CFG by assigning to PRINTER[123]NAME.
.I pprd
is multithreaded and can have as many connections as printers active.
Control-F1 through F3 can be used to abort jobs on the corresponding
printers.
.LP
It's probably best to install
.I pprd
in a Berkeley LPD environment as a printer accessed via a ifilter, rather
than as a remote host. That way you can queue up jobs and implement any
LPD filters on the client.  A couple of Perl scripts for Berkeley LPD
system are provided. Edit lpr.pl to configure and install it as
ifilter. Banner.pl should be installed as ofilter.  You should provide
a dummy file for the lp attribute because LPD expects to be able to
open and lock it. This file will not be printed to.
.LP
You may wish to restrict access to
.I pprd
to certain machines only. The \fB\-a\fP and \fB\-d\fP options are for
this.
.I pprd
allows connections only from machines on the same subnet (as determined
from the subnet mask) by default; this can be disabled by the \fB\-s\fP
option.
.SH OPTIONS
.TP
.BI \-p port
listen on
.I port
instead of the default 515.
.TP
.BI \- xy
disable printers
.I x
and
.I y
(numbers between 1 and 3)
.TP
.BI \-n #
.I #
printers, no matter what BIOS claims
.TP
.B \-t
don't indicate available printers with tones
.TP
.B \-i
reinitialise printer via hardware line on job abort
.TP
.BI \-b xy
Print directly to hardware port of printers
.I x
and
.I y
instead of using the BIOS print service. This only works on real
parallel ports, i.e. not redirected to serial ports, files or network
connections, and is only likely to improve things with fast printer
interfaces, in particular those with memory buffers, such as laser
printers.  On low speed printers, it isn't likely to make things faster
since the bottleneck is the printer.
.TP
.B \-s
bypass subnet match
.TP
.BI \-a list
comma separated list of up to 20 domain names allowed connection
.TP
.BI \-d list
comma separated list of up to 20 domain names denied connection
.sp
.br
\fB\-a\fP and \fB\-d\fP are mutually exclusive and independent of
subnet check
.TP
.BI \-l host
log diagnostics via SYSLOG protocol to
.I host
.TP
.BI \-j [port]
use Direct protocol to
.I port
(defaults to 9100) instead of LPD protocol
.SH "CONFIGURATION FILE SETTINGS"
Assigning to PRINTER1NAME, PRINTER2NAME, and PRINTER3NAME in WATTCP.CFG
will give names other than the default lpt[123] to the printers.
.SH "OTHER FILES"
Two auxiliary programs are provided, jd.pl and jd.exe, written in
Perl and C respectively. These are sample clients that use the Direct
protocol.
.LP
Jd.exe reads additional configuration entries in WATTCP.CFG, see jd
documentation.
.LP
Another Perl script called jdlprd.pl is provided. If this is run on a
BSD Unix host, it provides a gateway from jd jobs to the lpr system on
Unix.
.SH "SEE ALSO (on Unix)"
lpr(1), lpq(1), lpc(8), lpd(8)
.SH FILES
WATTCP.CFG, LPTCOM.ZIP
.SH DIAGNOSTICS
Hopefully self explanatory.
.SH COPYRIGHT
.I pprd
is under the GNU Copyright, which allows you to freely distribute
the program provided the sources accompany, or are made available on
request. See COPYING for details.
.SH AUTHOR
Ken Yap (ken@syd.dit.csiro.au)
.SH DATE
March 1995
