/* @(#)clnt_udp.c	2.2 88/08/01 4.0 RPCSRC */
/*
 * Sun RPC is a product of Sun Microsystems, Inc. and is provided for
 * unrestricted use provided that this legend is included on all tape
 * media and as a part of the software program in whole or part.  Users
 * may copy or modify Sun RPC without charge, but are not authorized
 * to license or distribute it to anyone else except as part of a product or
 * program developed by the user.
 * 
 * SUN RPC IS PROVIDED AS IS WITH NO WARRANTIES OF ANY KIND INCLUDING THE
 * WARRANTIES OF DESIGN, MERCHANTIBILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE, OR ARISING FROM A COURSE OF DEALING, USAGE OR TRADE PRACTICE.
 * 
 * Sun RPC is provided with no support and without any obligation on the
 * part of Sun Microsystems, Inc. to assist in its use, correction,
 * modification or enhancement.
 * 
 * SUN MICROSYSTEMS, INC. SHALL HAVE NO LIABILITY WITH RESPECT TO THE
 * INFRINGEMENT OF COPYRIGHTS, TRADE SECRETS OR ANY PATENTS BY SUN RPC
 * OR ANY PART THEREOF.
 * 
 * In no event will Sun Microsystems, Inc. be liable for any lost revenue
 * or profits or other special, indirect and consequential damages, even if
 * Sun has been advised of the possibility of such damages.
 * 
 * Sun Microsystems, Inc.
 * 2550 Garcia Avenue
 * Mountain View, California  94043
 */
#if !defined(lint) && defined(SCCSIDS)
static char sccsid[] = "@(#)clnt_udp.c 1.39 87/08/11 Copyr 1984 Sun Micro";
#endif

/*
 * clnt_udp.c, Implements a UDP/IP based, client side RPC.
 *
 * Copyright (C) 1984, Sun Microsystems, Inc.
 */

#include <stdio.h>
#include <rpc/rpc.h>
#if !defined(__MSDOS__)
#include <sys/socket.h>
#include <sys/ioctl.h>
#include <netdb.h>
#endif
#include <errno.h>
#if defined(__MSDOS__)
#include <rpc/pmap_cln.h>
#else
#include <rpc/pmap_clnt.h>
#endif

#if defined(__MSDOS__)
#include <rpc/dos_rpc.h>
#endif

extern int errno;

/*
 * UDP bases client side rpc operations
 */
static enum clnt_stat	clntudp_call();
static void		clntudp_abort();
static void		clntudp_geterr();
static bool_t		clntudp_freeres();
static bool_t           clntudp_control();
static void		clntudp_destroy();

static struct clnt_ops udp_ops = {
	clntudp_call,
	clntudp_abort,
	clntudp_geterr,
	clntudp_freeres,
	clntudp_destroy,
	clntudp_control
};

/* 
 * Private data kept per client handle
 */
struct cu_data {
#if defined(__MSDOS__)
   udp_Socket *cu_sock;
#else
	int		   cu_sock;
#endif
	bool_t		   cu_closeit;
#if defined(__MSDOS__)
   struct sockaddr cu_raddr;
#else
	struct sockaddr_in cu_raddr;
#endif
	int		   cu_rlen;
	struct timeval	   cu_wait;
	struct timeval     cu_total;
	struct rpc_err	   cu_error;
	XDR		   cu_outxdrs;
	u_int		   cu_xdrpos;
	u_int		   cu_sendsz;
	char		   *cu_outbuf;
	u_int		   cu_recvsz;
	char		   cu_inbuf[1];
};

/*
 * Create a UDP based client handle.
 * If *sockp<0, *sockp is set to a newly created UPD socket.
 * If raddr->sin_port is 0 a binder on the remote machine
 * is consulted for the correct port number.
 * NB: It is the clients responsibility to close *sockp.
 * NB: The rpch->cl_auth is initialized to null authentication.
 *     Caller may wish to set this something more useful.
 *
 * wait is the amount of time used between retransmitting a call if
 * no response has been heard;  retransmition occurs until the actual
 * rpc call times out.
 *
 * sendsz and recvsz are the maximum allowable packet sizes that can be
 * sent and received.
 */
CLIENT *
clntudp_bufcreate(raddr, program, version, wait, sockp, sendsz, recvsz)
#if defined(__MSDOS__)
	struct sockaddr *raddr;
#else
	struct sockaddr_in *raddr;
#endif
	u_long program;
	u_long version;
	struct timeval wait;
#if defined(__MSDOS__)
	udp_Socket **sockp;     /* optional socket */
#else
	register int *sockp;
#endif
	u_int sendsz;
	u_int recvsz;
{
#if defined(__MSDOS__)
	CLIENT *cl = NULL;
	register struct cu_data *cu = NULL;
#else
	CLIENT *cl;
	register struct cu_data *cu;
#endif
	struct timeval now;
	struct rpc_msg call_msg;
#if defined(__MSDOS__)  /* a few more util vars */
   struct sockaddr *addr;
   udp_Socket *s;
   int status;
#endif

	cl = (CLIENT *)mem_alloc(sizeof(CLIENT));
	if (cl == NULL) {
#if defined(__MSDOS__)
#ifdef DEBUG
		outs("clntudp_create: out of memory\n\r");
#endif
#else
		(void) fprintf(stderr, "clntudp_create: out of memory\n");
#endif
		rpc_createerr.cf_stat = RPC_SYSTEMERROR;
		rpc_createerr.cf_error.re_errno = errno;
		goto fooy;
	}
	sendsz = ((sendsz + 3) / 4) * 4;
	recvsz = ((recvsz + 3) / 4) * 4;
	cu = (struct cu_data *)mem_alloc(sizeof(*cu) + sendsz + recvsz);
	if (cu == NULL) {
#if defined(__MSDOS__)
#ifdef DEBUG
		outs("clntudp_create: out of memory\n\r");
#endif
#else
		(void) fprintf(stderr, "clntudp_create: out of memory\n");
#endif
		rpc_createerr.cf_stat = RPC_SYSTEMERROR;
		rpc_createerr.cf_error.re_errno = errno;
		goto fooy;
	}
	cu->cu_outbuf = &cu->cu_inbuf[recvsz];

#if defined(__MSDOS__)
	if (raddr->s_port == 0) {
#else
	(void)gettimeofday(&now, (struct timezone *)0);
	if (raddr->sin_port == 0) {
#endif
		u_short port;
		if ((port =
		    pmap_getport(raddr, program, version, IPPROTO_UDP)) == 0) {
			goto fooy;
		}
#if defined(__MSDOS__)
		raddr->s_port = port;
#else
		raddr->sin_port = htons(port);
#endif
	}

#if defined(__MSDOS__)
  /*
   * Initialize the WATTCP socket connection.
   */
   addr = &(cu->cu_raddr);
   *addr = *raddr;
   
  /*
   * If we were passed an open socket, store it.
   */   
   if(sockp && *sockp)
   {
      cu->cu_sock = *sockp;
      cu->cu_closeit = FALSE;
   }
   else  /* otherwise open one */
   {
    /*
     * Should check if mem_alloc fails.
     */
      cu->cu_sock = (udp_Socket *)mem_alloc(sizeof(udp_Socket));
      if( cu->cu_sock == 0 )
      {
#ifdef DEBUG
         outs("clntudp_create: out of memory\n\r");
#endif
         goto err_return;
      }
      if(sockp) *sockp = cu->cu_sock;
/*      printf("sock = %p, port = %d, ip = %lx\n", cu->cu_sock, addr->s_port, addr->s_ip); */
      if( !udp_open( cu->cu_sock, 0, addr->s_ip, addr->s_port, NULL )) {
#ifdef DEBUG
            outs("clntudp: can't create socket to remote!\n\r");
#endif
err_return:
            if(cu) mem_free(cu, sizeof(*cu));
            if(cl) mem_free(cl, sizeof(*cl));
            return ((CLIENT *)NULL);
         }
      if(!sockp) cu->cu_closeit = TRUE;  /* close it when done */
      else cu->cu_closeit = FALSE;       /* don't close when done ??? */
   }
   s = cu->cu_sock;
   sock_wait_established(s, sock_delay, NULL, &status);
   /*
    * Client connection is created.
    */
#endif

	cl->cl_ops = &udp_ops;
	cl->cl_private = (caddr_t)cu;
	cu->cu_raddr = *raddr;
	cu->cu_rlen = sizeof (cu->cu_raddr);
	cu->cu_wait = wait;
	cu->cu_total.tv_sec = -1;
	cu->cu_total.tv_usec = -1;
	cu->cu_sendsz = sendsz;
	cu->cu_recvsz = recvsz;
#if defined(__MSDOS__)
	call_msg.rm_xid = (u_long)32767L;   /* should be a random number! */
#else
	call_msg.rm_xid = getpid() ^ now.tv_sec ^ now.tv_usec;
#endif
	call_msg.rm_direction = CALL;
	call_msg.rm_call.cb_rpcvers = RPC_MSG_VERSION;
	call_msg.rm_call.cb_prog = program;
	call_msg.rm_call.cb_vers = version;
	xdrmem_create(&(cu->cu_outxdrs), cu->cu_outbuf,
	    sendsz, XDR_ENCODE);
	if (! xdr_callhdr(&(cu->cu_outxdrs), &call_msg)) {
#if defined(__MSDOS__)
   	if (cu->cu_closeit) {
        /* ???? more or less to do */
			sock_close(s);
		}
#endif
      goto fooy;
	}
	cu->cu_xdrpos = XDR_GETPOS(&(cu->cu_outxdrs));

#if !defined(__MSDOS__)
	if (*sockp < 0) {
		int dontblock = 1;

		*sockp = socket(AF_INET, SOCK_DGRAM, IPPROTO_UDP);
		if (*sockp < 0) {
			rpc_createerr.cf_stat = RPC_SYSTEMERROR;
			rpc_createerr.cf_error.re_errno = errno;
			goto fooy;
		}
		/* attempt to bind to prov port */
		(void)bindresvport(*sockp, (struct sockaddr_in *)0);
		/* the sockets rpc controls are non-blocking */
		(void)ioctl(*sockp, FIONBIO, (char *) &dontblock);
		cu->cu_closeit = TRUE;
	} else {
		cu->cu_closeit = FALSE;
	}
#endif /* ndef __MSDOS__ */

#if !defined(__MSDOS__)
	cu->cu_sock = *sockp;
#endif
	cl->cl_auth = authnone_create();
	return (cl);

#if defined(__MSDOS__)
   /*
    * Error establishing socket connection.
    */
sock_err:
#endif
fooy:
	if (cu)
		mem_free((caddr_t)cu, sizeof(*cu) + sendsz + recvsz);
	if (cl)
		mem_free((caddr_t)cl, sizeof(CLIENT));
	return ((CLIENT *)NULL);
}

CLIENT *
clntudp_create(raddr, program, version, wait, sockp)
#if defined(__MSDOS__)
	struct sockaddr *raddr;
#else
	struct sockaddr_in *raddr;
#endif
	u_long program;
	u_long version;
	struct timeval wait;
#if defined(__MSDOS__)
   udp_Socket **sockp;
#else
	register int *sockp;
#endif
{

	return(clntudp_bufcreate(raddr, program, version, wait, sockp,
	    UDPMSGSIZE, UDPMSGSIZE));
}

static enum clnt_stat 
clntudp_call(cl, proc, xargs, argsp, xresults, resultsp, utimeout)
	register CLIENT	*cl;		/* client handle */
	u_long		proc;		/* procedure number */
	xdrproc_t	xargs;		/* xdr routine for args */
	caddr_t		argsp;		/* pointer to args */
	xdrproc_t	xresults;	/* xdr routine for results */
	caddr_t		resultsp;	/* pointer to results */
	struct timeval	utimeout;	/* seconds to wait before giving up */
{
	register struct cu_data *cu = (struct cu_data *)cl->cl_private;
	register XDR *xdrs;
	register int outlen;
	register int inlen;
#if !defined(__MSDOS__)
	int fromlen;
#ifdef FD_SETSIZE
	fd_set readfds;
	fd_set mask;
#else
	int readfds;
	register int mask;
#endif /* def FD_SETSIZE */
	struct sockaddr_in from;
#endif /* ndef __MSDOS__ */
	struct rpc_msg reply_msg;
	XDR reply_xdrs;
	struct timeval time_waited;
	bool_t ok;
	int nrefreshes = 2;	/* number of times to refresh cred */
	struct timeval timeout;

	if (cu->cu_total.tv_usec == -1) {
		timeout = utimeout;     /* use supplied timeout */
	} else {
		timeout = cu->cu_total; /* use default timeout */
	}

	time_waited.tv_sec = 0;
	time_waited.tv_usec = 0;
call_again:
	xdrs = &(cu->cu_outxdrs);
	xdrs->x_op = XDR_ENCODE;
	XDR_SETPOS(xdrs, cu->cu_xdrpos);
	/*
	 * the transaction is the first thing in the out buffer
	 */
#if defined(__MSDOS__)  /* needed?? */
   (*(u_long *)(cu->cu_outbuf))++;
#else
	(*(u_short *)(cu->cu_outbuf))++;
#endif
	if ((! XDR_PUTLONG(xdrs, (long *)&proc)) ||
	    (! AUTH_MARSHALL(cl->cl_auth, xdrs)) ||
	    (! (*xargs)(xdrs, argsp)))
		return (cu->cu_error.re_status = RPC_CANTENCODEARGS);
	outlen = (int)XDR_GETPOS(xdrs);

send_again:
#if defined(__MSDOS__)
   if( dos_writesock(cu, cu->cu_outbuf, outlen, 5)
#else
	if (sendto(cu->cu_sock, cu->cu_outbuf, outlen, 0,
	    (struct sockaddr *)&(cu->cu_raddr), cu->cu_rlen)
#endif
	    != outlen) {
		cu->cu_error.re_errno = errno;
		return (cu->cu_error.re_status = RPC_CANTSEND);
	}

	/*
	 * Hack to provide rpc-based message passing
	 */
	if (timeout.tv_sec == 0 && timeout.tv_usec == 0) {
		return (cu->cu_error.re_status = RPC_TIMEDOUT);
	}
	/*
	 * sub-optimal code appears here because we have
	 * some clock time to spare while the packets are in flight.
	 * (We assume that this is actually only executed once.)
	 */
	reply_msg.acpted_rply.ar_verf = _null_auth;
	reply_msg.acpted_rply.ar_results.where = resultsp;
	reply_msg.acpted_rply.ar_results.proc = xresults;
#if !defined(__MSDOS__)
#ifdef FD_SETSIZE
	FD_ZERO(&mask);
	FD_SET(cu->cu_sock, &mask);
#else
	mask = 1 << cu->cu_sock;
#endif /* def FD_SETSIZE */
#endif
	for (;;) {
#if !defined(__MSDOS__)
		readfds = mask;
		switch (select(_rpc_dtablesize(), &readfds, (int *)NULL, 
			       (int *)NULL, &(cu->cu_wait))) {

		case 0:
			time_waited.tv_sec += cu->cu_wait.tv_sec;
			time_waited.tv_usec += cu->cu_wait.tv_usec;
			while (time_waited.tv_usec >= 1000000) {
				time_waited.tv_sec++;
				time_waited.tv_usec -= 1000000;
			}
			if ((time_waited.tv_sec < timeout.tv_sec) ||
				((time_waited.tv_sec == timeout.tv_sec) &&
				(time_waited.tv_usec < timeout.tv_usec)))
				goto send_again;	
			return (cu->cu_error.re_status = RPC_TIMEDOUT);

		/*
		 * buggy in other cases because time_waited is not being
		 * updated.
		 */
		case -1:
			if (errno == EINTR)
				continue;	
			cu->cu_error.re_errno = errno;
			return (cu->cu_error.re_status = RPC_CANTRECV);
		}
#endif
		do {
#if defined(__MSDOS__)
         inlen = dos_readsock(cu, cu->cu_inbuf, (int) cu->cu_recvsz, 5);
         if( inlen < 0 )
         {
            time_waited.tv_sec += 5; /* see timeout in dos_readsock() call */
         }
		} while ( !(time_waited.tv_sec >= timeout.tv_sec )
                                  && (inlen < 0 && errno == EINTR));
#else
			fromlen = sizeof(struct sockaddr);
			inlen = recvfrom(cu->cu_sock, cu->cu_inbuf, 
				(int) cu->cu_recvsz, 0,
				(struct sockaddr *)&from, &fromlen);
		} while (inlen < 0 && errno == EINTR);
#endif
		if (inlen < 0) {
#if !defined(__MSDOS__)
			if (errno == EWOULDBLOCK)
				continue;	
#endif
			cu->cu_error.re_errno = errno;
			return (cu->cu_error.re_status = RPC_CANTRECV);
		}
		if (inlen < sizeof(u_long))
			continue;	
		/* see if reply transaction id matches sent id */
		if (*((u_long *)(cu->cu_inbuf)) != *((u_long *)(cu->cu_outbuf)))
			continue;	
		/* we now assume we have the proper reply */
		break;
	}

	/*
	 * now decode and validate the response
	 */
	xdrmem_create(&reply_xdrs, cu->cu_inbuf, (u_int)inlen, XDR_DECODE);
	ok = xdr_replymsg(&reply_xdrs, &reply_msg);
	/* XDR_DESTROY(&reply_xdrs);  save a few cycles on noop destroy */
	if (ok) {
		_seterr_reply(&reply_msg, &(cu->cu_error));
		if (cu->cu_error.re_status == RPC_SUCCESS) {
			if (! AUTH_VALIDATE(cl->cl_auth,
				&reply_msg.acpted_rply.ar_verf)) {
				cu->cu_error.re_status = RPC_AUTHERROR;
				cu->cu_error.re_why = AUTH_INVALIDRESP;
			}
			if (reply_msg.acpted_rply.ar_verf.oa_base != NULL) {
				xdrs->x_op = XDR_FREE;
				(void)xdr_opaque_auth(xdrs,
				    &(reply_msg.acpted_rply.ar_verf));
			} 
		}  /* end successful completion */
		else {
			/* maybe our credentials need to be refreshed ... */
			if (nrefreshes > 0 && AUTH_REFRESH(cl->cl_auth)) {
				nrefreshes--;
				goto call_again;
			}
		}  /* end of unsuccessful completion */
	}  /* end of valid reply message */
	else {
		cu->cu_error.re_status = RPC_CANTDECODERES;
	}
	return (cu->cu_error.re_status);
}

static void
clntudp_geterr(cl, errp)
	CLIENT *cl;
	struct rpc_err *errp;
{
	register struct cu_data *cu = (struct cu_data *)cl->cl_private;

	*errp = cu->cu_error;
}


static bool_t
clntudp_freeres(cl, xdr_res, res_ptr)
	CLIENT *cl;
	xdrproc_t xdr_res;
	caddr_t res_ptr;
{
	register struct cu_data *cu = (struct cu_data *)cl->cl_private;
	register XDR *xdrs = &(cu->cu_outxdrs);

	xdrs->x_op = XDR_FREE;
	return ((*xdr_res)(xdrs, res_ptr));
}

static void 
clntudp_abort(/*h*/)
	/*CLIENT *h;*/
{
}

static bool_t
clntudp_control(cl, request, info)
	CLIENT *cl;
	int request;
	char *info;
{
	register struct cu_data *cu = (struct cu_data *)cl->cl_private;

	switch (request) {
	case CLSET_TIMEOUT:
		cu->cu_total = *(struct timeval *)info;
		break;
	case CLGET_TIMEOUT:
		*(struct timeval *)info = cu->cu_total;
		break;
	case CLSET_RETRY_TIMEOUT:
		cu->cu_wait = *(struct timeval *)info;
		break;
	case CLGET_RETRY_TIMEOUT:
		*(struct timeval *)info = cu->cu_wait;
		break;
	case CLGET_SERVER_ADDR:
#if defined(__MSDOS__)
      *(struct sockaddr *)info = cu->cu_raddr;
#else
		*(struct sockaddr_in *)info = cu->cu_raddr;
#endif
		break;
	default:
		return (FALSE);
	}
	return (TRUE);
}
	
static void
clntudp_destroy(cl)
	CLIENT *cl;
{
	register struct cu_data *cu = (struct cu_data *)cl->cl_private;

	if (cu->cu_closeit) {
#if defined(__MSDOS__)
		(void)sock_close(cu->cu_sock);
      mem_free(cu->cu_sock, sizeof(*cu->cu_sock)); /* size too big? */  /* 02/15/93 */
#else
		(void)close(cu->cu_sock);
#endif
	}
	XDR_DESTROY(&(cu->cu_outxdrs));
	mem_free((caddr_t)cu, (sizeof(*cu) + cu->cu_sendsz + cu->cu_recvsz));
	mem_free((caddr_t)cl, sizeof(CLIENT));
}

/*******
 * read/write are almost good for both TCP and UDP with wattcp.
 * should be generalized and moved to another file.
 */



/*
 * Interface between xdr serializer and tcp connection.
 * Behaves like the system calls, read & write, but keeps some error state
 * around for the rpc level.
 */
static int dos_readsock(cu, buf, len, timeout)
	register struct cu_data *cu;
	caddr_t buf;
	register int len;
   int timeout;
{
   int cnt, status;
char str[64];
#if 0
printf("readudp() called... len = %d\n", len);   
printf("(before) sock_dataready() = %d\n", sock_dataready( cu->cu_sock ));
#endif

   sock_wait_input( cu->cu_sock, timeout, NULL, &status );  /* timeout set here */
 	cnt = sock_fastread( cu->cu_sock, buf, len );

   switch(cnt)
   {
	case 0:
		/* premature eof */
		cu->cu_error.re_errno = RPC_NOSUPPORT;  /* ECONNRESET; */
		cu->cu_error.re_status = RPC_CANTRECV;
		cnt = -1;  /* it's really an error */
		break;

	case -1:
		cu->cu_error.re_errno = errno;
		cu->cu_error.re_status = RPC_CANTRECV;
		break;
   }
#if 0
sprintf(str, "readudp len = %d\n\r", len-getlen);
outs(str);
#endif
   return len;  /* return total gotten */

sock_err:
    switch (status) {
	case 1 : /* foreign host closed */
            cu->cu_error.re_status = RPC_CANTRECV;
            cu->cu_error.re_errno = errno;
            return (-1);
	case -1: /* timeout */
             cu->cu_error.re_status = RPC_TIMEDOUT;
             return (-1);
    }
   return (-1);
}

static int dos_writesock(cu, buf, len, timeout)
	struct cu_data *cu;
	caddr_t buf;
	int len;
   int timeout;
{
   int cnt;

   cnt = sock_write( cu->cu_sock, buf, len);
   return (cnt);     /* was return(len);  93.02.26 */
}
