/* This file is CDOSX32.C
**
** contains :
**
**              - int21 handler
**
** Copyright (c) Rainer Schnitker 92 93
*/

#ifdef _DJGPP_
#include <stdio.h>
#include <io.h>
#endif

#include <errno.h>
#include "DPMI.H"
#include "PROCESS.H"
#include "START32.H"
#include "CDOSX32.H"
#include "COPY32.H"
#include "TERMIO.H"

static char iobuffer[IOBUF_SIZE+3]; /* I/O buffer for real-mode operations */
char *iobuf = iobuffer;
TRANSLATION tr; 		    /* registers set for mode-switching */
static POINTER16_32 user_dta;	    /* prot-mode DTA address */
extern WORD _psp;		    /* PSP after protected mode switch */

void align_iobuf(void)
{
iobuf = (char *) ((unsigned)(iobuf + 3) & ~3);
}

static void put_regs(void)
{
    tr.eax = EAX;
    tr.ebx = EBX;
    tr.ecx = ECX;
    tr.edx = EDX;
    tr.flags = FLAGS & ~1;
}

static void get_regs(void)
{
    EAX = tr.eax;
    EBX = tr.ebx;
    ECX = tr.ecx;
    EDX = tr.edx;
    FLAGS = tr.flags;
}

/* call Real-Mode INT0x21 */
int realdos(void)
{
    int rsp;

    tr.eax &= 0xFFFF;
    tr.cs = cs16real;
    tr.ds = tr.ss = tr.es = tr.fs = tr.gs = ds16real;
    tr.sp = (WORD) & rsp - 40;

    /* DPMI-Call to Real-Mode DOS */
    SimulateRMint(0x21, 0, 0, &tr);

    /* return Carry-bit */
    return (tr.flags & 1);
}

/*
** INT 0x21 handler returns:
**
** CARRY_ON :	error, set carry-bit, errno in eax
** CARRY_OFF:	no error, clear carry-bit
** CARRY_NON:	carry-bit set by realdos -> dos error code in ax,
**				translate ax to errno
*/
int int21normal(void)
{
    int i;
    char rAH, rAL;

    rAH = (BYTE) (AX >> 8);
    rAL = (BYTE) EAX;

    switch (rAH) {

/************ register based functions ***************/
/* no changes needed - only ax,dx,flags (bx,cx) used */

    case 0x01:			/* read char */
    case 0x02:			/* write char */
    case 0x03:			/* read char stdaux */
    case 0x04:			/* write char stdaux */
    case 0x05:			/* read char prn */
    case 0x06:			/* con output&input */
    case 0x07:			/* char input & echo */
    case 0x08:			/* char output & echo */
    case 0x0b:			/* get stdin stat */
    case 0x0c:			/* flush buffer & read std input */
    case 0x0d:			/* disk reset */
    case 0x0e:			/* select drive */
    case 0x19:			/* get drive */
    case 0x2a:			/* get system date (cx) */
    case 0x2b:			/* set system date (cx) */
    case 0x2c:			/* get time (cx) */
    case 0x2d:			/* set time (cx) */
    case 0x2e:			/* set verify */
    case 0x30:			/* get DOS version (bx) */
    case 0x33:			/* extended break check */
    case 0x36:			/* get free disk space (bx,cx) */
    case 0x37:			/* get&set switch char */
    case 0x3e:			/* close file (bx) */
#ifndef _EMX_
    case 0x42:			/* lseek file, emx use other format */
#endif
    case 0x45:			/* dup file (bx) */
    case 0x46:			/* dup2 file */
    case 0x54:			/* get verify flag */
    case 0x57:			/* get file state (bx,cx) */
    case 0x5c:			/* un-&lock file */
    case 0x66:			/* code page */
    case 0x68:			/* fflush file */
#ifdef _DJGPP_
	if (rAH == 0x3e && BX <= 2)
	    return CARRY_OFF;
#endif
	put_regs();
	realdos();
	get_regs();
	return CARRY_NON;

#ifdef _EMX_
    case 0x42:			/* lseek file: EMX use EDX (dos CX:DX) */
	put_regs();
	tr.ecx = tr.edx >> 16;	/* convert edx to cx:dx */
	tr.edx &= 0xffff;
	if (realdos())
	    EAX = tr.eax;	/* dos error code */
	else			/* convert dx:ax to eax */
	    EAX = (tr.edx << 16) | (WORD) tr.eax;
	FLAGS = tr.flags;	/* get carry flag */
	return CARRY_NON;
#endif

    case 0x44:			/* IOCTL */
	switch (rAL) {
	case 0x00:		/* get device info */
	case 0x01:		/* set device info */
	case 0x06:		/* get input status */
	case 0x07:		/* get output status */
	case 0x08:		/* check block device remove */
	case 0x09:		/* check block device remote */
	case 0x0a:		/* check handle remote */
	case 0x0b:		/* set sharing */
	case 0x0e:		/* get log drive map */
	case 0x0f:		/* set log drive map */
	case 0x10:		/* query ioctl handle */
	case 0x11:		/* query ioctl drive */
	    put_regs();
	    realdos();
	    get_regs();
	    return CARRY_NON;
	default:
	    EAX = EIO;
	    return CARRY_ON;
	}

/*****	some special handling *****/

    case 0x1a:			/* SET DTA */
	user_dta.sel = DS;
	user_dta.off = EDX;
	tr.eax = 0x1a00;
	tr.edx = (DWORD) (WORD) iobuf;
	realdos();
	return CARRY_OFF;

    case 0x2f:			/* GET DTA */
	EBX = user_dta.off;
	return CARRY_OFF;

    case 0x62:			/* GET PSP */
	EBX = (DWORD) _psp;
	return CARRY_OFF;

/*********** ASCiiZero functions ***********/
/* copy name -> real_buffer , call realdos */

    case 0x09:			/* string to output */
    case 0x39:			/* MKDIR name */
    case 0x3a:			/* RMDIR name */
    case 0x3b:			/* CHDIR name */
    case 0x3c:			/* CREATE name */
    case 0x3d:			/* OPEN name */
    case 0x41:			/* UNLINK name */
    case 0x43:			/* ATTRIB name */
    case 0x5b:			/* CREATE New file */
	put_regs();
	if (rAH == 0x09)
	    cpy32_16(DS, EDX, iobuf, 240);
	else
	    strcpy32_16(DS, EDX, iobuf);

	tr.edx = (DWORD) (WORD) iobuf;
	realdos();
	get_regs();
	return CARRY_NON;

    case 0x56:			/* RENAME oldname name (strlen < 512) */
	put_regs();
	strcpy32_16(DS, EDX, iobuf);
	strcpy32_16(DS, ESI, iobuf + 512);
	tr.edx = (DWORD) (WORD) iobuf;
	tr.edi = (DWORD) ((WORD)iobuf + 512);
	realdos();
	get_regs();
	return CARRY_NON;

    case 0x5a:			/* CREATE TEMP name */
	put_regs();
	strcpy32_16(DS, EDX, iobuf);
	tr.edx = (DWORD) (WORD) iobuf;
	if (!realdos())
	    strcpy16_32(DS, EDX, iobuf);
	get_regs();
	return CARRY_NON;

    case 0x6c:			/* EXTENDED OPEN/CREATE file */
	put_regs();
	strcpy32_16(DS, EDX, iobuf);
	tr.esi = (DWORD) (WORD) iobuf;
	realdos();
	get_regs();
	return CARRY_NON;

/********** buffer functions *********/
/* copy data before or after realdos */

    case 0x0a:			/* BUFFERED INPUT */
	put_regs();
	*(DWORD *) iobuf = read32(DS, EDX);
	tr.edx = (DWORD) (WORD) iobuf;
	if (!realdos())		/* byte 1:n ,other bytes */
	    strcpy16_32(DS, EDX, iobuf);
	return CARRY_NON;

    case 0x3f:			/* READ from file */
	{
	    long count;
	    DWORD off_edx;

	    if (ECX == 0) {	/* some prgs(ld) use 0 */
		EAX = 0;
		return CARRY_OFF;
	    }
	    if (npz->p_flags & PF_TERMIO && EBX == 0) {	/* termio */
		if ((i = termio_read(DS, EDX, CX)) < 0) {
		    EAX = (long) -i;
		    return CARRY_ON;
		} else {
		    EAX = (DWORD) i;
		    return CARRY_OFF;
		}
	    }
	    count = ECX;
	    off_edx = EDX;
	    (WORD) tr.ebx = BX;
	    (WORD) tr.edx = (WORD) iobuf;
	    tr.flags = FLAGS & ~1;
	    while (count > 0) {	/* bytes left */
		(WORD) tr.eax = 0x3f00;
		tr.ecx = (count <= IOBUF_SIZE) ? count : (DWORD) IOBUF_SIZE;
#ifdef _DJGPP_
		if (BX == 0) {	/* stdin: "\r\n"->"\r" */
		    if ((tr.eax = (long) read(0, iobuf, (WORD) tr.ecx)) == -1) {
			EAX = (DWORD) errno;
			return CARRY_ON;
		    }
		} else
#endif
		if (realdos()) {
		    EAX = tr.eax;
		    FLAGS = tr.flags;
		    return CARRY_NON;
		}
		cpy16_32(DS, off_edx, iobuf, tr.eax);
		count -= tr.eax;/* sub read bytes */
		if ((WORD) tr.ecx != (WORD) tr.eax)	/* read end */
		    break;
		off_edx += tr.eax;	/* seek user32_buf */
	    }
	    EAX = ECX - count;
	    return CARRY_OFF;
	}

    case 0x40:			/* WRITE to file */
	{
	    long count;
	    DWORD off_edx;

	    count = ECX;
	    off_edx = EDX;
	    (WORD) tr.ebx = BX;
	    (WORD) tr.edx = (WORD) iobuf;
	    tr.flags = FLAGS & ~1;
	    while (count > 0) {
		(WORD) tr.eax = 0x4000;
		tr.ecx = (count <= IOBUF_SIZE) ? count : (DWORD) IOBUF_SIZE;
		cpy32_16(DS, off_edx, iobuf, tr.ecx);
#ifdef _DJGPP_
		if (BX >= 1 && BX <= 2) {	/* stdout: "\n"->"\r\n" */
		    if ((tr.eax = (long) write((WORD) tr.ebx, iobuf, (WORD) tr.ecx)) == -1) {
			EAX = (DWORD) errno;
			return CARRY_ON;
		    }
		} else
#endif
		if (realdos()) {
		    EAX = tr.eax;
		    FLAGS = tr.flags;
		    return CARRY_NON;
		}
		count -= tr.eax;
		if ((WORD) tr.ecx != (WORD) tr.eax)	/* write end */
		    break;
		off_edx += tr.ecx;	/* seek user32_buf */
	    }
	    EAX = ECX - count;
	    return CARRY_OFF;
	}

    case 0x47:			/* GET CURR DIRECTORY */
	put_regs();
	tr.esi = (WORD) iobuf;
	if (!realdos())
	    cpy16_32(DS, ESI, iobuf, 64L);
	get_regs();
	return CARRY_NON;

    case 0x4e:			/* FINDFIRST */
	/* DTA: iobuf byte 0-42 , wild _string: iobuf + 64 */
#ifdef _EMX_
	/* set dta address to iobuf */
        user_dta.off = ESI;
	tr.edx = (DWORD) (WORD) iobuf;
	tr.eax = 0x1a00;
	realdos();
#endif
	strcpy32_16(DS, EDX, iobuf + 64);
	tr.eax = EAX;
	tr.ecx = ECX;
	tr.edx = (DWORD) ((WORD) iobuf + 64);
	tr.flags = FLAGS & ~1;
	if (realdos())
	    EAX = tr.eax;
	else
	    cpy16_32(DS, user_dta.off, iobuf, 43);
	FLAGS = tr.flags;
	return CARRY_NON;

    case 0x4f:			/* FINDNEXT */
	/* DTA: iobuf byte 0-42 */
#ifdef _EMX_
        user_dta.off = ESI;
	tr.edx = (DWORD) (WORD) iobuf;
	tr.eax = 0x1a00;
	realdos();		/* set dta address */
#endif
	/* put user dta in iobuf */
	cpy32_16(DS, user_dta.off, iobuf, 43);
	tr.eax = EAX;
	tr.flags = FLAGS & ~1;
	if (realdos())
	    EAX = tr.eax;
	else
	    cpy16_32(DS, user_dta.off, iobuf, 43);
	FLAGS = tr.flags;
	return CARRY_NON;

/***** functions complete changed *****/
/***** need to call DPMI-functions ****/

    case 0x25:			/* SET INTERRUPT NR */
	if (SetProtModeVector32(rAL, CS, EDX)) {
	    EAX = 0 ;
	    return CARRY_ON;
	}
	else {
	    EAX = -1 ;
	    return CARRY_OFF;
	    }
    case 0x35:			/* GET INTERRUPT NR */
	ECX = 0;
	if (GetProtModeVector32(rAL, &CX, &EBX)) {
	    EAX = 0 ;
	    return CARRY_ON;
	}
	else {
	    EAX = -1 ;
	    return CARRY_OFF;
	}

    case 0x48:			/* ALLOC MEM */
    case 0x49:			/* FREE MEM */
	return CARRY_ON;

    case 0x4a:			/* RESIZE MEM */
#ifndef _DJGPP_
	return CARRY_ON;
#else
	if (EAX & 0xff)
	    EAX = getmem(EBX, npz);
	else
	    EAX = npz->brk_value;
	if (EAX == -1)
	    EAX = 0;
	return CARRY_OFF;	/* sbrk.s didn't check carry */
#endif

    case 0x4c:
	return do_exit4c(0);

    default:
	EAX = EIO;
	return CARRY_ON;

    }				/* switch R_AH */
}
