#include <stdlib.h>
#include <string.h>
#include <process.h>
#include <errno.h>

struct _new_proc {
    unsigned long arg_off;
    unsigned long env_off;
    unsigned long fname_off;
    unsigned short arg_sel;
    unsigned short env_sel;
    unsigned short fname_sel;
    unsigned short arg_count;
    unsigned short arg_size;
    unsigned short env_count;
    unsigned short env_size;
    unsigned short mode;
};

int __spawnve(struct _new_proc * np)
{
    int ret_v;

    __asm__("movl   %1, %%edx \n\t"
	    "movw   $0x7F06, %%ax \n\t"
	    "int    $0x21 \n\t"
	    "jc     1f \n\t"
	    "xorl   %0,%0 \n\t"
	    "jmp    2f \n\t"
	    "1: \n\t"
	    "movl   %0, _errno \n\t"
	    "movl   $-1, %0 \n\t"
	    "2:\n\t"
	    : "=a"(ret_v):"m"(np));
    return ret_v;
}

int spawnve(int mode, const char *name, const char *const * argv,
	     const char *const * envp)
{
    struct _new_proc np;
    int i, size, n;
    const char *const * p;
    char *d;
    char exe[512];

    np.mode = mode;
    strcpy(exe, name);
    np.fname_off = (unsigned long) exe;

    if (envp == NULL)
	envp = (const char *const *) environ;

    size = 1;
    n = 0;
    for (p = envp; *p != NULL; ++p) {
	++n;
	size += 1 + strlen(*p);
    }

    d = alloca(size);
    np.env_count = n;
    np.env_size = size;
    np.env_off = (unsigned long) d;

    for (p = envp; *p != NULL; ++p) {
	i = strlen(*p);
	(void) memcpy(d, *p, i + 1);
	d += i + 1;
    }

    *d = 0;
    size = 0;
    n = 0;
    for (p = argv; *p != NULL; ++p) {
	++n;
	size += 2 + strlen(*p);
    }
    d = alloca(size);

    np.arg_count = n;
    np.arg_size = size;
    np.arg_off = (unsigned long) d;

    for (p = argv; *p != NULL; ++p) {
	i = strlen(*p);
	*d++ = 0xff;
	(void) memcpy(d, *p, i + 1);
	d += i + 1;
    }

    i = __spawnve(&np);
    return (i);
}
