/* Copyright    Rainer Schnitker 92,93 */

/* manage different statements in dos.h */

#include <dos.h>

#ifndef _DPMI_TYPES
#define _DPMI_TYPES

typedef unsigned char   BYTE;
typedef BYTE far        *LPBYTE;
typedef unsigned int    WORD;
typedef WORD far        *LPWORD;
typedef unsigned long   DWORD;
typedef DWORD far       *LPDWORD;
#endif

/* makros FP_SEG,FP_OFF only LVALUE in MS-C */
typedef void far *FP ;
#define FP_HI(a) ((WORD)((DWORD)(FP)(a)>>16))
#define FP_LO(a) ((WORD)(a))

#ifdef __TURBOC__


#else /* MS-C or others */

#define asm _asm
#define MK_FP(seg,ofs)  ((FP)(DWORD)(((DWORD)(seg)<<16) | (WORD)(ofs)))

#define peek(a,b)       (*((int  far*)MK_FP((a),(b))))
#define peekb(a,b)      (*((char far*)MK_FP((a),(b))))
#define poke(a,b,c)     (*((int  far*)MK_FP((a),(b))) = (int)(c))
#define pokeb(a,b,c)    (*((char far*)MK_FP((a),(b))) = (char)(c))

#endif /* MS-C or others */
