#include <stdio.h>
#include <stdlib.h>

typedef unsigned long DWORD;

typedef struct {
    DWORD LargestFree;
    DWORD MaxUnlockedPages;
    DWORD MaxLockedPages;
    DWORD AddressSpacePages;
    DWORD UnlockedPages;
    DWORD UnusedPages;
    DWORD PhysicalPages;
    DWORD FreeAddressSpacePages;
    DWORD PagingFilePages;	/* or partition size */
    DWORD reserved[3];
} FREEMEMINFO;

int GetFreeMemInfo(FREEMEMINFO *);
void PrintFreeMemInfo(FREEMEMINFO *);

void PrintFreeMemInfo(FREEMEMINFO * fm)
{
    printf("Largest available block in Bytes  : %8lu = %8lu KB\n",
	   fm->LargestFree, fm->LargestFree >> 10);
    printf("Number free pages                 : %8lu = %8lu KB\n"
	   ,fm->MaxUnlockedPages, fm->MaxUnlockedPages * 4);
    printf("Number free pages to lock         : %8lu = %8lu KB\n"
	   ,fm->MaxLockedPages, fm->MaxLockedPages * 4);
    printf("Number pages of linear addr space : %8lu = %8lu KB\n"
	   ,fm->AddressSpacePages, fm->AddressSpacePages * 4);
    printf("Number pages not locked           : %8lu = %8lu KB\n"
	   ,fm->UnlockedPages, fm->UnlockedPages * 4);
    printf("Number pages not used             : %8lu = %8lu KB\n"
	   ,fm->UnusedPages, fm->UnusedPages * 4);
    printf("Number pages managed by the Dpmi  : %8lu = %8lu KB\n"
	   ,fm->PhysicalPages, fm->PhysicalPages * 4);
    printf("Number pages free addr space      : %8lu = %8lu KB\n"
	   ,fm->FreeAddressSpacePages, fm->FreeAddressSpacePages * 4);

    if (fm->PagingFilePages <= 0xFFFFFL)
	printf("Number pages in swapfile          : %8lu = %8lu KB\n"
	       ,fm->PagingFilePages, fm->PagingFilePages * 4);
    else
	printf("DPMI host paging partition        : %8lu Bytes = %8lu MB\n"
	       ,fm->PagingFilePages, fm->PagingFilePages >> 20);
}


FREEMEMINFO fm;
main(void)
{

    if (GetFreeMemInfo(&fm))
	printf("error freemem\n");
    PrintFreeMemInfo(&fm);
    return 0;
}
