#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>

static void do_wait (void)
{
  int p, t;

    p = wait (&t);
  if (p == -1)
    perror ("wait");
  else
    {
      if ((t & 0xff) == 0)
        fprintf (stderr, "Process %d terminated normally, rc=%d\n",
                 p, t >> 8);
      else if ((t & 0xff) == 127)
        fprintf (stderr, "Process %d stopped by signal %d\n",
                 p, t >> 8);
      else
        fprintf (stderr, "Process %d terminated by signal %d\n",
                 p, t & 0xff);
    }
}

static void handler (int sig)
{
  if (sig == SIGCLD)
    {
      fprintf (stderr, "SIGCLD: "); fflush (stderr);
      do_wait ();
      fflush (stderr);
      signal (SIGCLD, SIG_ACK);
    }
  else
    {
      printf ("Signal %d received. Process stopped.\n", sig);
      exit (1);
    }
}

char cmdline[250];

main(void)
{
    int i;

    signal (SIGINT, handler);
    signal (SIGCLD, handler);

    while (1) {
	printf("cmd:");
	fflush(stdout);
	gets(cmdline);

	if (strchr (cmdline, '=') != NULL)
	    if (putenv (cmdline) != 0)
		perror ("putenv");
	else if (strcmp(cmdline,"quit") == 0)
	    break;

	i=system(cmdline);

	if (i==-1)
	    perror(cmdline);
	else
	    printf("system(%s) ok, return val 0x%X\n",cmdline,i);
	fflush(stdout);
    }

    return 0;
}
