/*
** siggp: test signal handler return for SIGINT,SIGSEGV
*/

#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

char exit_flag = 0;

void signal_handler(int sig_no)
{
    /* called from extender with far call */

    printf("signal handler %s reached\n",
	   (sig_no == SIGINT) ? "SIGINT" : "SIGSEGV");

    if (exit_flag)
	exit(1);

    /* ret near */
    /* cause a gp-fault, restart if SIGINT */
    /* print exception if SIGSEGV */
}

int main(int argc, char **argv, char **env)
{
    int *i = (int *) -1;
    char c;

    if (argc > 1 && strcmp(argv[1], "-exit") == 0)
	exit_flag = 1;

    if (signal(SIGSEGV, signal_handler) == SIG_ERR) {
	printf("signal(SIGSEGV) failed\n");
	return (1);
    }
    if (signal(SIGINT, signal_handler) == SIG_ERR) {
	printf("signal(SIGINT) failed\n");
	return (1);
    }
    printf("do fault ?\n");
    c = getchar();

    if (c == 'y' || c == 'j')
	printf("%d", *i);
    else
	printf("char %d", c);

    return 0;
}
