#include <stdio.h>
#include <stdlib.h>
#include <signal.h>

void signal_handler(int sig_no)
{
    printf("signal handler SIGFPE reached no=%d \n", sig_no);
}

#ifndef SignalBad
#define SignalBad ((SignalHandler)-1)
#endif

int main(int argc, char **argv, char **env)
{
    int prevh;
    int ret;

    if ((prevh = signal(SIGFPE, signal_handler)) == -1) {
	perror("SIGNAL:");
	return (1);
    }
    printf("prev handler %X\n", prevh);

    printf("raise SIGFPE ...\n");
    if (ret = raise(SIGFPE)) {
	perror("RAISE:");
	return (1);
    }
    printf("... after raise, return value raise() = %d\n", ret);
    return 0;
}
