/* This file is START32.C
**
** contains :
**
**              - DPMI-switches for DPMI 0.9
**		- init some protected mode interrupts
**		- init exception handlers
**		- clean up for exit
**
** Copyright (c) Rainer Schnitker 91,92,93
*/

#include <stdio.h>
#include "DPMI.H"
#include "DPMIDOS.H"
#include "PROCESS.H"
#include "RSX.H"
#include "ADOSX32.H"
#include "CDOSX32.H"
#include "EXCEP32.H"
#include "START32.H"

/* global extender segments,selectors */
WORD cs16real, ds16real;	/* 16-bit segments for extender */
WORD code16sel, data16sel;	/* 16-bit cs,ds for extender */
WORD stack16sel;		/* 16-bit stack sel */
DWORD stackp16;			/* 16-bit stack offset */
WORD sel_incr;			/* increment to next selector */

/* private functions */
static int set_fpu(WORD);	/* dpmi 1.0 fpu (include in most 0.9 server) */
static int unset_fpu(void);	/* dpmi 1.0 fpu */

/* private vars */
static WORD DPMIstack_para;
static WORD DPMIstack_segment;

extern WORD _psp;		/* new psp after switch to protmode */

/*
** back to real-mode, terminate ( int0x21 must set to orginal )
*/
void protected_to_real(WORD errorlevel)
{
    if (copro)
	unset_fpu();

    _asm {
	mov ax, errorlevel;
	mov ah, 0x4C;
	int 0x21;
    }
    /* program ends here */
}

int real_to_protected(WORD cpu)
{
    WORD rax,rbx, jump_seg, jump_off;
    DWORD PM_jump;			/* switch to protmode jump */

    _asm {
	mov cs16real, cs;		/* save real mode segments */
	mov ds16real, ds;		/* for real mode calls */
    }

    _asm {
	mov ax, 0x1687; 		/* DMPI supported ? */
	int 0x2f;
	mov rax, ax;			/* ax!=0 no dpmi */
	mov rbx, bx;
	mov jump_off, di;
	mov jump_seg, es;
	mov DPMIstack_para, si;
    }

    if (rax) {
	puts("No DPMI-host found!");
	return -1;
    }

    if (cpu == 1 && !(rbx & 1)) {
	puts("32bit programs not supported\n");
	return -1;
    }

    PM_jump = ((DWORD) jump_seg << 16) | (DWORD) jump_off;

    if (DPMIstack_para) 		/* get DPMI ring 0 stack */
	_asm {
	    mov bx, DPMIstack_para;
	    mov ah, 0x48;
	    int 0x21;
	    jc	NOMEM ;
	    mov DPMIstack_segment, ax
	    mov es, ax;
	}

    _asm {				/* enter PMode */
	mov ax, cpu;
	call DWORD PTR PM_jump;
	jnc PMOK;
    }

    puts("can't switch to Protected Mode");
    return -1;
  NOMEM:
    puts("Can't alloc memory for the DPMI-host-stack");
    return -1;

    /* Now we are in Protected Mode */

  PMOK:
    _asm {
	mov code16sel, cs;		/* store new selectors */
	mov data16sel, ds;
	mov _psp, es;
	mov stack16sel, ss;
	mov rax, sp;
    }
    stackp16 = (DWORD) rax;

    clearregs();

    sel_incr=SelInc();

    if (set_fpu(copro)) {
	puts("No DPMI-server 387 support");
	puts("use -e option");
	protected_to_real(1);
    }

    /* lock all program memory and memory for locked DPMI-stack */
    LockLinRegion((DWORD) cs16real << 4,
	    ((DWORD) (ds16real - cs16real) << 4) + 0x10000L);
    LockLinRegion((DWORD) DPMIstack_segment << 4,
	    (DWORD) DPMIstack_para << 4);

    if (opt_printall) {
	printf("16bit real_seg: cs=%04X ds=%04X\n"
	       ,cs16real, ds16real);
	printf("16bit prot_sel: cs=%04X ds=%04X ss=%04X\n"
	       ,code16sel, data16sel, stack16sel);
	printf("DPMI stack: segment=%04X size=%04X\n"
	       ,DPMIstack_segment, DPMIstack_para << 4);
	printf("sel increment: %d\n",sel_incr);
    }
    return 0;
}

static POINTER16_32 int21v;	/* old int21h handler address */
static POINTER16_32 ctrlcv;	/* old control-c handler */
static POINTER16_32 timerv;	/* old timer handler */

typedef struct {
    DWORD off;
    WORD sel;
} PWORD;
PWORD criterrv;			/* old critical error handler */

static POINTER16_32 excep0v, excep1v, excep2v, excep3v, excep4v, excep5v,
 excep6v, excep7v, excep8v, excep9v, excep10v, excep11v, excep12v, excep13v,
 excep14v;

int hangin_extender(void)
{
    WORD alias_cs;		/* alias sel for codesel */
    WORD far *write_cs_word;	/* writing in code */
    DWORD far *write_cs_dword;

    /* store ds-sel in code for some interrupt handler */
    if (CreatAlias(code16sel, &alias_cs))	/* get alias for cs */
	return -1;

    /* store 16bit data selector in load_ds function */
    write_cs_word = MK_FP(alias_cs, (WORD) load_ds + 2);
    *write_cs_word = data16sel;

    /* hang in int 0x21 */
    if (GetProtModeVector32(0x21, &int21v.sel, &int21v.off) == -1) {
	puts("error:can't get int21");
	return -1;
    }
    if (SetProtModeVector32(0x21, code16sel, (DWORD) (WORD) doscall) == -1) {
	puts("error:can't SET int21");
	return -1;
    }
    align_iobuf();

    /* if we want to chain to default int 0x21 */
    write_cs_dword = MK_FP(alias_cs, (WORD) int21vsel);
    *write_cs_dword = int21v.sel;
    write_cs_dword = MK_FP(alias_cs, (WORD) int21voff);
    *write_cs_dword = int21v.off;

    FreeLDT(alias_cs);

    GetExceptionVector32(0, &excep0v.sel, &excep0v.off);
    GetExceptionVector32(1, &excep1v.sel, &excep1v.off);
    GetExceptionVector32(2, &excep2v.sel, &excep2v.off);
    GetExceptionVector32(3, &excep3v.sel, &excep3v.off);
    GetExceptionVector32(4, &excep4v.sel, &excep4v.off);
    GetExceptionVector32(5, &excep5v.sel, &excep5v.off);
    GetExceptionVector32(6, &excep6v.sel, &excep6v.off);
    GetExceptionVector32(7, &excep7v.sel, &excep7v.off);
    GetExceptionVector32(8, &excep8v.sel, &excep8v.off);
    GetExceptionVector32(9, &excep9v.sel, &excep9v.off);
    GetExceptionVector32(10, &excep10v.sel, &excep10v.off);
    GetExceptionVector32(11, &excep11v.sel, &excep11v.off);
    GetExceptionVector32(12, &excep12v.sel, &excep12v.off);
    GetExceptionVector32(13, &excep13v.sel, &excep13v.off);
    GetExceptionVector32(14, &excep14v.sel, &excep14v.off);

    SetExceptionVector32(0, code16sel, FP_LO(excep0_386));
    SetExceptionVector32(1, code16sel, FP_LO(excep1_386));
    SetExceptionVector32(2, code16sel, FP_LO(excep2_386));
    SetExceptionVector32(3, code16sel, FP_LO(excep3_386));
    SetExceptionVector32(4, code16sel, FP_LO(excep4_386));
    SetExceptionVector32(5, code16sel, FP_LO(excep5_386));
    SetExceptionVector32(6, code16sel, FP_LO(excep6_386));
    SetExceptionVector32(7, code16sel, FP_LO(excep7_386));
    SetExceptionVector32(8, code16sel, FP_LO(excep8_386));
    SetExceptionVector32(9, code16sel, FP_LO(excep9_386));
    SetExceptionVector32(10, code16sel, FP_LO(excep10_386));
    SetExceptionVector32(11, code16sel, FP_LO(excep11_386));
    SetExceptionVector32(12, code16sel, FP_LO(excep12_386));
    SetExceptionVector32(13, code16sel, FP_LO(excep13_386));
    SetExceptionVector32(14, code16sel, FP_LO(excep14_386));

    /* TIMER */
    GetProtModeVector32(0x1C, &timerv.sel, &timerv.off);
    SetProtModeVector32(0x1C, code16sel, (DWORD) (WORD) timer_handler);

    /* CTRL-C */
    GetProtModeVector32(0x23, &ctrlcv.sel, &ctrlcv.off);
    SetProtModeVector32(0x23, code16sel, (DWORD) (WORD) prot_cbrk);

    return 0;
}

/* clean up interrupt handlers, exceptions, memory ... */
void clean_up(void)
{
    clearregs();

    if (opt_printall)
	puts("cleanup now");

    UnlockLinRegion((DWORD) cs16real << 4,
		((DWORD) (ds16real - cs16real) << 4) + 0x10000L);
    UnlockLinRegion((DWORD) DPMIstack_segment << 4,
		(DWORD) DPMIstack_para << 4);

    /* unset 387-usage (otherwise: crash) */
    if (copro) {
	unset_fpu();
    }

    /* free 387 emulator */
    if (copro == 3) {
	UnlockLinRegion(RSX_PROCESS.memaddress, RSX_PROCESS.membytes);
	FreeMem(RSX_PROCESS.memhandle);
	FreeLDT(RSX_PROCESS.code32sel);
	FreeLDT(RSX_PROCESS.data32sel);
    }
    copro = 0;

    SetProtModeVector32(0x21, int21v.sel, int21v.off);
    SetProtModeVector32(0x1C, timerv.sel, timerv.off);
    SetProtModeVector32(0x23, ctrlcv.sel, ctrlcv.off);

    SetExceptionVector32(0, excep0v.sel, excep0v.off);
    SetExceptionVector32(1, excep1v.sel, excep1v.off);
    SetExceptionVector32(2, excep2v.sel, excep2v.off);
    SetExceptionVector32(3, excep3v.sel, excep3v.off);
    SetExceptionVector32(4, excep4v.sel, excep4v.off);
    SetExceptionVector32(5, excep5v.sel, excep5v.off);
    SetExceptionVector32(6, excep6v.sel, excep6v.off);
    SetExceptionVector32(7, excep7v.sel, excep7v.off);
    SetExceptionVector32(8, excep8v.sel, excep8v.off);
    SetExceptionVector32(9, excep9v.sel, excep9v.off);
    SetExceptionVector32(10, excep10v.sel, excep10v.off);
    SetExceptionVector32(11, excep11v.sel, excep11v.off);
    SetExceptionVector32(12, excep12v.sel, excep12v.off);
    SetExceptionVector32(13, excep13v.sel, excep13v.off);
    SetExceptionVector32(14, excep14v.sel, excep14v.off);
}

/* dpmi 1.0 387-futures (supported most 0.9 server) */
static int set_fpu(WORD bits)
{
    _asm {
	mov ax, 0xe01;
	mov bx, bits;
	int 0x31;
	jnc set_ok;
    }
    return -1;
  set_ok:
    return 0;
}

static int unset_fpu()
{
    _asm {
	mov ax, 0xe01;
	mov bx, 0;
	int 0x31;
	jnc unset_ok;
    }
    return -1;
  unset_ok:
    return 0;
}
