/* This file is SYSDJ.c
** contains :
**
**		- int21 djgpp syscall handler
**		- int21 rsx/emx extentions (signals,ptrace,etc)
**
** Copyright (c) Rainer Schnitker 92 93
*/

int i_21_ff(void);

#include "SYSEMX.C"
#include <fcntl.h>

struct time32 {
    DWORD secs, usecs;
};

struct tz32 {
    DWORD offset, dst;
};

struct stat32 {
    short st_dev, st_ino, st_mode, st_nlink, st_uid, st_gid, st_rdev,
     st_align_for_DWORD;
    long st_size, st_atime, st_mtime, st_ctime, st_blksize;
};

static int dev_count = 1;
extern int daylight;
extern long timezone;

int i_21_ff(void)
{
    DWORD p1, p2, p3;
    int r;
    int i;

    p1 = EBX;
    p2 = ECX;
    p3 = EDX;

    /* syscall handler */

    switch (AX & 0xff) {	/* al=? */
    case 1:
	strcpy32_16(DS, p1, iobuf);	/* p1 -> iobuf */
	r = open(iobuf, O_CREAT | O_TEXT | O_RDWR, S_IREAD | S_IWRITE);
	break;

    case 2:
	strcpy32_16(DS, p1, iobuf);	/* p1 -> iobuf */
	r = open(iobuf, (int) p2, S_IREAD | O_RDWR | S_IWRITE);
	break;

    case 3:			/* fstat */
	{
	    struct stat32 statbuf32;
	    struct stat statbuf;


	    memset(&statbuf, 0, sizeof(statbuf));
	    if ((r = fstat((int) p1, &statbuf)) == -1)
		break;
	    statbuf32.st_dev = dev_count++;
	    statbuf32.st_ino = statbuf.st_ino;
	    statbuf32.st_mode = statbuf.st_mode;
	    statbuf32.st_nlink = statbuf.st_nlink;
	    statbuf32.st_uid = statbuf.st_uid;
	    statbuf32.st_gid = statbuf.st_gid;
	    statbuf32.st_rdev = statbuf.st_rdev;
	    statbuf32.st_size = statbuf.st_size;
	    statbuf32.st_atime = statbuf.st_atime;
	    statbuf32.st_mtime = statbuf.st_mtime;
	    statbuf32.st_ctime = statbuf.st_ctime;
	    statbuf32.st_blksize = 512;
	    /* stat -> p2 */
	    cpy16_32(DS, p2, &statbuf32, (DWORD) sizeof(statbuf32));
	    break;
	}

    case 4:			/* get time & day */
	{
	    struct time32 time32;
	    struct tz32 tz32;
	    struct timeb timeb_str;

	    if (p2) {
		tz32.offset = timezone;
		tz32.dst = daylight;
		/* tz -> p2 */
		cpy16_32(DS, p2, &tz32, (DWORD) sizeof(tz32));
	    }
	    if (p1) {
		ftime(&timeb_str);
		time32.secs = timeb_str.time;
		time32.usecs = (DWORD) timeb_str.millitm;
		/* time -> p1 */
		cpy16_32(DS, p1, &time32, (DWORD) sizeof(time32));
	    }
	    r = 0;
	    break;
	}

    case 5:			/* set time & day */
	{
	    struct time32 time32;
	    struct tz32 tz32;

	    if (p2) {
		/* p2 -> tz */
		cpy32_16(DS, p2, &tz32, (DWORD) sizeof(tz32));
		timezone = tz32.offset;
		daylight = (WORD) tz32.dst;
	    }
	    if (p1) {
		/* p1 -> time */
		cpy32_16(DS, p1, &time32, (DWORD) sizeof(time32));
		/* stime(&(time32.secs)); */
	    }
	    r = 0;
	    break;
	}

    case 6:			/* stat */
	{
	    struct stat32 statbuf32;
	    struct stat statbuf;

	    memset(&statbuf, 0, sizeof(statbuf));
	    /* p1 -> buffer */
	    strcpy32_16(DS, p1, iobuf);
	    r = stat(iobuf, &statbuf);
	    if (r == -1)
		break;
	    statbuf32.st_dev = dev_count++;
	    statbuf32.st_ino = statbuf.st_ino;
	    statbuf32.st_mode = statbuf.st_mode;
	    statbuf32.st_nlink = statbuf.st_nlink;
	    statbuf32.st_uid = statbuf.st_uid;
	    statbuf32.st_gid = statbuf.st_gid;
	    statbuf32.st_rdev = statbuf.st_rdev;
	    statbuf32.st_size = statbuf.st_size;
	    statbuf32.st_atime = statbuf.st_atime;
	    statbuf32.st_mtime = statbuf.st_mtime;
	    statbuf32.st_ctime = statbuf.st_ctime;
	    statbuf32.st_blksize = 512;
	    /* stat -> p2 */
	    cpy16_32(DS, p2, &statbuf32, (DWORD) sizeof(statbuf32));
	    break;
	}

    case 7:
	{
	    char argmem[250];
	    char *argp[40];
	    int args = 1;

	    strcpy32_16(DS, p1, argmem);

	    argp[0] = argmem;
	    for (i = 0; *(argmem + i) != 0; i++)	/* make strings */
		if (*(argmem + i) == ' ') {
		    argp[args++] = (argmem + i + 1);	/* build argv */
		    *(argmem + i) = 0;
		}
	    argp[--args] = 0;

	    r = exec32(P_WAIT, argmem, args, argp, org_envc, org_env);

	    /* if error, try a real-mode prg */
	    if (r == ENOEXEC)
		r = realmode_prg(argmem, &(argp[0]), org_env);

	    if (r) {
		errno = r;
		r = -1;
	    }
	    break;
	}

    case 8:
	r = setmode((int) p1, (int) p2);
	break;

    case 9:
	strcpy32_16(DS, p1, iobuf);	/* p1 -> iobuf */
	r = chmod(iobuf, (int) p2);
	break;

    }				/* switch */

    if (r == -1) {
	EAX = (DWORD) errno;
	return CARRY_ON;
    } else {
	EAX = (DWORD) r;
	return CARRY_OFF;
    }
}
