IMPLEMENTATION MODULE Lists;

(* (C) Copyright 1992 Fitted Software Tools. All rights reserved. *)

FROM Objects IMPORT
    ALLOCATEOBJECT,     (* for NEW *)
    DEALLOCATEOBJECT;   (* for DISPOSE *)


(* IMPLEMENTATION *) CLASS LinkedListItem;

    next    :LinkedListItem;    (* linked list prev and next pointers *)
    prev    :LinkedListItem;

    INIT                        (* prev & next = NIL means that we are  *)
		next := NIL;            (* not in any list                      *)
		prev := NIL;

END LinkedListItem;



(* IMPLEMENTATION *) CLASS LinkedList;

    first       :LinkedListItem;    (* first item in list                *)
    curpos      :LinkedListItem;    (* item returned by getfirst/getnext *)
    nextiscur   :BOOLEAN;           (* next getnext must return curpos   *)
                                    (* nextiscur may be set by delete    *)

	PROCEDURE append( item :LinkedListItem );
	VAR p :LinkedListItem;
	BEGIN
	    IF (item.next <> NIL) OR (item.prev <> NIL) THEN
	        (* item is already in some list! *)
	        HALT;
        END;
		p := first;
		IF p = NIL THEN
			first := item
		ELSE
			WHILE p.next <> NIL DO
				p := p.next;
			END;
			item.prev := p;
			p.next := item;
		END;
	END append;

	PROCEDURE getfirst( VAR item :LinkedListItem ) :BOOLEAN;
	BEGIN
		item := first;
		curpos := first;
		RETURN first <> NIL;
	END getfirst;

	PROCEDURE getnext( VAR item :LinkedListItem ) :BOOLEAN;
	BEGIN
	    IF nextiscur THEN
	        item := curpos;
	        nextiscur := FALSE;
		ELSIF curpos <> NIL THEN
			item := curpos.next;
			curpos := item;
		ELSE
			item := NIL;
		END;
		RETURN item <> NIL;
	END getnext;

	PROCEDURE delete( item :LinkedListItem );
	BEGIN
		IF item.next = NIL THEN
			IF item.prev = NIL THEN
				first := NIL
			ELSE
				item.prev.next := NIL
			END
		ELSE
			IF item.prev = NIL THEN
				first := item.next;
				item.next.prev := NIL;
			ELSE
				item.prev.next := item.next;
				item.next.prev := item.prev;
			END;
		END;
		IF curpos = item THEN
			IF item.prev <> NIL THEN
			    curpos := item.prev
			ELSE
			    curpos := first;
			    nextiscur := TRUE;
			END;
		END;
		item.next := NIL;
		item.prev := NIL;
	END delete;

    PROCEDURE destroyList;
    (*
        We coded destroyList as a separate method (it is a static method)
        instead of doing the work in DESTROY because we needed a work
        variable 'anItem'. If we made anItem an attribute of the class,
        we would be wasting space in every object of this class.
    *)
    VAR
        anItem :LinkedListItem;
    BEGIN
        WHILE getfirst(anItem) DO
			delete( anItem );
			DISPOSE( anItem );
		END;
    END destroyList;

    INIT
		first := NIL;           (* initialize all our attributes *)
		curpos := NIL;
		nextiscur := FALSE;

    DESTROY
        destroyList;


END LinkedList;


END Lists.