MODULE errto;

(* (C) Copyright 1988 Fitted Software Tools *)

(* exec command w/ stderr redirected to file *)

FROM System     IMPORT GetArg, ErrorMessage;
FROM Loader     IMPORT Execute;
FROM Files      IMPORT NORMAL, Create, Close, Dup, Dup2;
FROM Paths      IMPORT Locate;
FROM Strings    IMPORT Assign, Concat;

VAR
    file        :ARRAY [0..65] OF CHAR;
    cmd,
    cmd1,
    cmdpath     :ARRAY [0..65] OF CHAR;
    arg, args   :ARRAY [0..128] OF CHAR;
    fd, saverr  :INTEGER;
    oc          :CARDINAL;
    ok          :BOOLEAN;
    space       :ARRAY [0..1] OF CHAR;
    n           :CARDINAL;

BEGIN
    space[0] := ' '; space[1] := 0C;
    GetArg( file, n );
    GetArg( cmd, n );
    IF n > 0 THEN
        args := "";
        LOOP
            GetArg( arg, n );
            IF n = 0 THEN EXIT END;
            Concat( args, arg, args );
            Concat( args, space, args );
        END;
        Create( fd, file, NORMAL );
        IF fd <> -1 THEN
            Assign( cmd, cmd1 );
            Concat( cmd, ".COM", cmd );
            Locate( cmd, "PATH", cmdpath, ok );
            IF NOT ok THEN
                Concat( cmd1, ".EXE", cmd );
                Locate( cmd, "PATH", cmdpath, ok );
            END;
            IF ok THEN
                Dup( 2, saverr );
                Dup2( fd, 2 );
                Execute( cmdpath, args, oc );
                IF oc < 256 THEN
                    ErrorMessage( "--- exec failed" )
                END;
                Dup2( saverr, 2 );
                Close( saverr );
                Close( fd );
            ELSE
                ErrorMessage( "--- could not locate command" );
            END;
        END;
    ELSE
        ErrorMessage( " usage: errto file command [args]" );
    END;

END errto.