oBExamples.Mod                    #   Syntax10.Scn.Fnt       MODULE Examples; (* jm 24.2.93 File: Examples.Mod*)

IMPORT Objects, Display, Gadgets, Attributes, Oberon, BasicGadgets, Out;
	
VAR
	tmp: Objects.Object;
	
(* Display information about an object *)

PROCEDURE Info(obj: Objects.Object);
VAR M: Objects.AttrMsg;
BEGIN
	IF obj # NIL THEN
		M.id := Objects.get; M.name := "Gen"; M.s := ""; M.res := -1; M.class := Objects.Inval;
		obj.handle(obj, M); (* Retrieve its new procedure *)
		IF M.s # "" THEN Out.String("  "); Out.String(M.s)
		ELSE Out.String(" Unknown generator? ");
		END;
		IF obj IS Display.Frame THEN Out.String("  displayable")
		ELSE Out.String("  abstract")
		END;
		Out.Ln
	END
END Info;

(* Display information about the currently selected objects *)
PROCEDURE GetSelection*;
VAR M: Display.SelectMsg; obj: Objects.Object;
BEGIN
	Out.String("Examples.GetSelection"); Out.Ln;
	M.id := Display.get; M.F := NIL; M.obj := NIL; M.time := -1;
	Display.Broadcast(M);
	IF (M.time > 0) & (M.obj # NIL) THEN
		obj := M.obj;
		WHILE obj # NIL DO
			Info(obj);
			obj := obj.slink
		END
	END
END GetSelection;

(* Delete selected gadgets *)
PROCEDURE DeleteSelection*;
VAR M: Display.SelectMsg; D: Display.ControlMsg;
BEGIN
	Out.String("Examples.DeleteSelection"); Out.Ln;
	M.id := Display.get; M.F := NIL; M.obj := NIL; M.time := -1;
	Display.Broadcast(M);
	IF (M.time > 0) & (M.obj # NIL) THEN
		D.id := Display.remove; D.F := M.obj(Display.Frame); Display.Broadcast(D)
	END
END DeleteSelection;

(* Move selected gadgets to the caret *)
PROCEDURE MoveSelection*;
VAR M: Display.SelectMsg; D: Display.ControlMsg; obj: Objects.Object;
BEGIN
	Out.String("Examples.MoveSelection"); Out.Ln;
	M.id := Display.get; M.F := NIL; M.obj := NIL; M.time := -1;
	Display.Broadcast(M);
	IF (M.time > 0) & (M.obj # NIL) THEN
		obj := M.obj;
		D.id := Display.remove; D.F := obj(Display.Frame); Display.Broadcast(D);
		Gadgets.Integrate(obj)
	END
END MoveSelection;

(* Show the attributes of the selected gadgets *)

PROCEDURE* enum(name: ARRAY OF CHAR);
VAR A: Objects.AttrMsg;
BEGIN
	Out.String("    "); Out.String(name); 
	A.id := Objects.get; COPY(name, A.name); A.res := -1; Objects.Stamp(A); tmp.handle(tmp, A);
	IF A.res >= 0 THEN (* attr exists *)
		IF A.class = Objects.Bool THEN Out.String(" is boolean");
		ELSIF A.class = Objects.String THEN Out.String(" is string = "); Out.String(A.s)
		ELSIF A.class = Objects.Int THEN Out.String(" is integer = "); Out.Int(A.i, 5)
		ELSIF A.class = Objects.Real THEN Out.String(" is real = "); Out.Real(A.x, 5)
		ELSIF A.class = Objects.LongReal THEN Out.String(" is real = "); Out.LongReal(A.y, 5)
		ELSIF A.class = Objects.Char THEN Out.String(" is char = "); Out.Char(A.c)
		END
	END;
	Out.Ln;
END enum;

PROCEDURE ShowAttr*;
VAR M: Display.SelectMsg; obj: Objects.Object; A: Objects.AttrMsg;
BEGIN
	Out.String("Examples.ShowAttr"); Out.Ln;
	M.id := Display.get; M.F := NIL; M.obj := NIL; M.time := -1;
	Display.Broadcast(M);
	IF (M.time > 0) & (M.obj # NIL) THEN
		obj := M.obj;
		WHILE obj # NIL DO
			tmp := obj;
			Info(obj);
			A.id := Objects.enum; A.Enum := enum; A.res := -1; Objects.Stamp(A); obj.handle(obj, A);
			obj := obj.slink
		END
	END
END ShowAttr;

(* Resize selected gadgets *)
PROCEDURE Resize*;
VAR S: Attributes.Scanner; W, H: INTEGER; M: Display.SelectMsg; obj: Objects.Object; F: Display.Frame; A: Display.ModifyMsg;
BEGIN
	Out.String("Examples.Resize"); Out.Ln;
	Attributes.OpenScanner(S, Oberon.Par.text, Oberon.Par.pos);
	Attributes.Scan(S);
	IF S.class = Attributes.Int THEN
		W := SHORT(S.i); Attributes.Scan(S);
		IF S.class = Attributes.Int THEN
			H := SHORT(S.i);
			M.id := Display.get; M.F := NIL; M.obj := NIL; M.time := -1;
			Display.Broadcast(M);
			IF (M.time > 0) & (M.obj # NIL) THEN
				obj := M.obj;
				WHILE obj # NIL DO
					F := obj(Display.Frame);
					A.id := Display.extend; (* OR Display.reduce: means change size for gadgets *)
					A.mode := Display.display; (* display changes immediately *)
					A.F := F;
					A.X := F.X; A.Y := F.Y; A.W := W; A.H := H;
					A.dX := 0; A.dY := 0; A.dW := A.W - F.W; A.dH := A.H - F.H; (* deltas *)
					Display.Broadcast(A);
					obj := obj.slink
				END
			END
		END
	END
END Resize;

(* Shows the current message path. This command must be executed from a gadget *)
PROCEDURE ShowThread*;
VAR obj: Objects.Object;
BEGIN
	Out.String("Examples.ShowThread"); Out.Ln;
	obj := Oberon.Par.obj;
	WHILE obj # NIL DO
		Info(obj);
		obj := obj.dlink
	END
END ShowThread;

(* Consume command. Delete the object thrown into the executor of this command *)
PROCEDURE Delete*;
VAR M: Display.ControlMsg;
BEGIN
	Out.String("Examples.Delete"); Out.Ln;
	IF Gadgets.senderObj # NIL THEN
		M.id := Display.remove; M.F := Gadgets.senderObj(Display.Frame); Display.Broadcast(M)
	END
END Delete;

(* Create a textfield linked to a integer and insert it at the caret position *)
PROCEDURE Build*;
VAR F: Display.Frame;
BEGIN
	F := Gadgets.CreateViewModel("TextFields.NewTextField", "BasicGadgets.NewInteger");
	Gadgets.NameObj(F(Gadgets.Frame).obj, "Test");
	Gadgets.Integrate(F);
END Build;

(* Look for an integer object called Test in the current context, and increment its value. Command
	must be executed from a gadget. *)
PROCEDURE Inc*;
VAR obj: Objects.Object;
BEGIN
	obj := Gadgets.FindObj(".Test");
	IF (obj # NIL) & (obj IS BasicGadgets.Integer) THEN
		WITH obj: BasicGadgets.Integer DO
			INC(obj.val);
			BasicGadgets.SetValue(obj)
		END
	END
END Inc;

(* Look for an integer object called Test in the current context, build a slider and link them together, and
	insert the slider at the caret position. Command must be executed from a gadget. *)
PROCEDURE AddSlider*;
VAR obj: Objects.Object; F: Objects.Object;
BEGIN
	obj := Gadgets.FindObj(".Test");
	IF (obj # NIL) & (obj IS BasicGadgets.Integer) THEN
		F := Gadgets.CreateObject("BasicGadgets.NewSlider");
		WITH F: Gadgets.Frame DO
			F.obj := obj; (* Link slider to the integer object *)
			Gadgets.Integrate(F);
			Gadgets.Update(obj)
		END
	END
END AddSlider;

END Examples.

Some commands to test out the above module:

Out.Open

Examples.GetSelection
Examples.DeleteSelection
Examples.MoveSelection
Examples.ShowAttr
Examples.Resize 100 25

Gadgets.ChangeAttr Cmd Examples.ShowThread ~
Gadgets.ChangeAttr ConsumeCmd Examples.Delete ~

Examples.Build

Gadgets.ChangeAttr Cmd Examples.Inc ~
Gadgets.ChangeAttr Cmd Examples.AddSlider ~

