{
  Demonstrationsprogramm fr die Unit LISTFILE.PAS
  Programmiert von: Marko Tietz
  Universitt Halle-Wittenberg / Auenstelle Merseburg
  Version: Turbo-Pascal 7.0
  E-Mail: tietz@mailserv.hrz.th-merseburg.de
          tietz@fserv.hrz.th-merseburg.de
}




program ListDemo; {single linked list}
{$N+,X+}
uses Crt, ListFile;

var
  FileName  : string[79]; {ASCII-File: [xi] [yi] zum Aufbauen der Liste}
  QuitCmd,
  GotCmd    : boolean;
  Ch        : char;
  NewElement: PXYList; {Zeiger auf Liste, fr neueinzufgendes Element}

{H A U P T P R O G R A M M}
begin
  if ParamCount = 0 then {Falls kein Dateiname als Parameter angegeben wurde}
  begin
    WriteLn('File as Parameter expected!');
    Halt(0);
  end;
  QuitCmd := false;
  Init(ParamStr(1)); {Initialisiert die Liste, mit den Werten aus der Datei}
  ListIndex := 1; {Indexzhler auf erstes Element}
  repeat
    Write('(A)usgabe (E)infgen (L)schen (Q)uit: ');
    ReadLn(Ch);
    GotCmd := true;
    case UpCase(Ch) of
      'A': begin
             {Zugriff auf ein bestimmtes Listenelement:}
             Write('Welches Listenelement soll ausgegeben werden?: ');
             ReadLn(ListIndex); {lese Indexzhler ein}
             RangeCheck(ListIndex, GetData); {Prft ob Index im definierten Bereich}
             xy := GetElement(ListIndex); {Liest Element mit Indexzhler}
             WriteLn(ListIndex, '-tes Element: ', xy^.Points.x:3:2, '   ', xy^.Points.y:3:2);
           end;
      'E': begin
             Write('Eingabe x: '); ReadLn(NewElement^.Points.x); {Liest Felder}
             Write('Eingabe y: '); ReadLn(NewElement^.Points.y); {fr neues Element}
             Write('Eingabe Position: '); ReadLn(ListIndex); {und Index ein}
             RangeCheck(ListIndex, InsertData);
             InsertElement(ListIndex, NewElement); {fgt Element zur Liste}
           end;
      'L': begin
             Write('Eingabe Position: '); ReadLn(ListIndex); {Liest Index fr}
             RangeCheck(ListIndex, DeleteData);
             DeleteElement(ListIndex); {das zu lschende Element}
           end;
      'Q': begin
             GotCmd := false;
             QuitCmd := true;
           end;
      else GotCmd := false;
    end;
    if GotCmd then
    begin {Ausgabe der Liste}
      {Zugriff auf alle Listenelemente:}
      xy := Root; {Setzt Zeiger auf den Anfang der Liste}
      while xy <> nil do {Solange bis Ende der Liste erreicht}
      begin
        WriteLn(xy^.Points.x:3:2, '   ', xy^.Points.y:3:2); {gezielter Zugriff}
        Inc(ListIndex); {automatische Indexbehandlung}
        RangeCheck(ListIndex, GetData);
        xy := xy^.Next; {Setzt Zeiger auf nchstes Listenelement}
      end;
      WriteLn;
    end;
  until QuitCmd;
  Done; {Zurcksetzen der Liste und freigeben des Speichers}
end.
