program GSDMO_VU;
{------------------------------------------------------------------------------
                                 DBase Viewer

       Copyright (c)  Richard F. Griffin

       14 January 1993

       102 Molded Stone Pl
       Warner Robins, GA  31088

       -------------------------------------------------------------
       This program demonstrates how to view a dBase memo file using
       Griffin Solutions units.

       If the GSDMO_07.DBF file does not exist, the program will display a
       a message that the file was not found and to run GSDMO_07 to make
       the file.

-------------------------------------------------------------------------------}
{$N+,E+}          {Required for floating point number handling}

uses
   CRT,
   GSOB_EDT,
   GSOB_DSK,
   GSOBShel;
var
   MyEdit  : GSO_ShowView;
   Ch      : char;

procedure ShowTheMemo;
var
   b    : boolean;
   ml   : integer;
begin
   MemoGet('COMMENTS');
   ml := MemoLines;
   if ml <> 0 then
   begin
      window(1,2,80,25);
      MyEdit.Init(DBFActive^.MemoFile^.MemoCollect);
      b := MyEdit.WorkView;
      window(1,1,80,25);
   end;
end;

begin
   ClrScr;
   if not GS_FileExists('GSDMO_07.DBF') then
   begin
      Writeln('File GSDMO_07.DBF is unavailable. Run GSDMO_07.PAS');
      halt;
   end;
   Select(1);
   Use('GSDMO_07');
   MemoWidth(75);     {sets width of the memo line.  Default is 50}
   GoTop;
   while not dEOF do
   begin
      ClrScr;
      writeln(FieldGet('LASTNAME'),', ',
              FieldGet('FIRSTNAME'));
      ShowTheMemo;
      Skip(1);
   end;
   CloseDataBases;
end.
