program TestBrow;
{------------------------------------------------------------------------------
                              DBase Browser

       TESTBROW.PAS Copyright (c)  Richard F. Griffin

       20 July 1993

       102 Molded Stone Pl
       Warner Robins, GA  31088

       -------------------------------------------------------------
       This program demonstrates how dBase files may be browsed using
       Griffin Solutions units.

       If the GSDMO_01.DBF file does not exist, the program will display a
       a message that the file was not found and to run GSDMO_01 to make
       the file.

       The program opens a dBase file and proceeds to browse the file.
       Pressing F1 displays a list of commands available.

-------------------------------------------------------------------------------}

uses
   GSXT_Bro,
   GSOB_Var,
   GSOBShel,
   SmplStuf,
   CRT,
   DOS;

var
   lnStart,
   lnEnd    : word;
   broCmd   : longint;
   broLines : integer;
   validcmd : boolean;
   i : integer;
   t : string;
   th: string;
   ch: char;

Procedure ShoBrowse;
begin
   GoToXY(1,1);
   writeln(GetBrowseHeader(lnStart));
   writeln(GetBrowseBar(lnStart));
   for i := 1 to 23 do
   begin
      t := GetBrowseLine(i, lnStart);
      gotoxy(1,i+2);
      if t <> '' then write(t) else ClrEOL;
   end;
   ch := GetKey;
   if (not GS_KeyI_Fuc) and (GS_KeyI_Chr >= #32) then
            GS_KeyI_Chr := Kbd_Ret;

   case GS_KeyI_Chr of

      Kbd_F1   : begin
                    ClrScr;
                    gotoxy(22,7);
                    writeln('The following commands are available:');
                    writeln;
                    writeln('':25,
                            'Cursor Keys  - PgUp, PgDn, Up, Down,');
                    writeln('':25,'               Right, Left');
                    writeLn('':25,'Next Field   - Tab');
                    writeLn('':25,'Prev Field   - Shift-Tab');
                    writeLn('':25,'Record Start - Home');
                    writeLn('':25,'Record End   - End');
                    writeLn('':25,'Top of File  - Ctrl-Home');
                    writeln('':25,'End of File  - Ctrl-End');
                    writeln('':25,'Quit         - F10, Escape');
                    WaitForKey;
                    ClrScr;
                 end;
      Kbd_Home : begin
                    lnStart := 1;
                 end;
      Kbd_End  : begin
                    lnStart := 16384;         {beyond max record size}
                    MoveBrowseRight(lnStart);
                 end;
      Kbd_CHom : begin
                    UpdateBrowse(broTop);
                 end;
      Kbd_CEnd : begin
                    UpdateBrowse(broBttm);
                 end;
      Kbd_PgUp : begin
                    UpdateBrowse(broPgUp);
                 end;
      Kbd_PgDn : begin
                    UpdateBrowse(broPgDn);
                 end;
      Kbd_UpAr : begin
                    UpdateBrowse(broLnUp);
                 end;
      Kbd_DnAr : begin
                    UpdateBrowse(broLnDn);
                 end;
      Kbd_RtAr : begin
                    MoveBrowseRight(lnStart);
                 end;
      Kbd_LfAr : begin
                    MoveBrowseLeft(lnStart);
                 end;
      Kbd_Tab  : begin
                    TabBrowseRight(lnStart);
                 end;
      Kbd_RTb  : begin
                    TabBrowseLeft(lnStart);
                 end;
      Kbd_Esc,
      Kbd_F10  : validcmd := false;
   end;
end;

begin
   ClrScr;
   if not FileExist('GSDMO_01.DBF') then   {Check for the file}
   begin
      writeln('File GSDMO_01.DBF not found.  Run GSDMO_01 to create.');
      halt;
   end;
                       {The 'Real' example starts here}

   Select(1);                     {Use record area 1 (the default)}
   Use('GSDMO_01');               {Assign the dBase III file GSDMO_01}
   SetDBFCacheOn;
   lnStart := 1;
   lnEnd := 79;
   validCmd := true;
   broCmd := broTop;
   broLines := 23;
   ClrScr;
   StartBrowse(broLines, lnEnd);
   UpdateBrowse(broCmd);
   repeat
      ShoBrowse;
   until not validCmd;
   ResetBrowse;
   CloseDataBases;                {Close the file}
end.
