program TestSch1;
{------------------------------------------------------------------------------
                              DBase Key Field Locator

       TESTSCH1.PAS Copyright (c)  Richard F. Griffin

       14 July 1993

       102 Molded Stone Pl
       Warner Robins, GA  31088

       -------------------------------------------------------------
       This program demonstrates how key strings may be located in dBase
       files.

       If the GSDMO_01.DBF file does not exist, the program will display a
       a message that the file was not found and to run GSDMO_01 to make
       the file.

       Upon execution, the program sets the size of the cache file to a
       maximum of 64512 bytes.  It will then ask for a LASTNAME field key to
       find.  Enter any portion of the string.

-------------------------------------------------------------------------------}

uses
   GSXT_Sch,
   GSOB_Var,
   GSOB_DBS,
   GSOBShel,
   SmplStuf,
   CRT,
   DOS;

var
   St    : string;
   posn : word;
   fnum : word;

   h,m,s,c,h1,m1,s1,c1:word;
   rt : real;

begin
   DBFCacheSize := 64512;
   ClrScr;
   if not FileExist('GSDMO_01.DBF') then   {Check for the file}
   begin
      writeln('File GSDMO_01.DBF not found.  Run GSDMO_01 to create.');
      halt;
   end;
                       {The 'Real' example starts here}

   Select(1);                     {Use record area 1 (the default)}
   Use('GSDMO_01');               {Assign the dBase III file GSDMO_01}
   REPEAT
      write('LASTNAME to search for:');
      readln(St);
      if St <> '' then
      begin
         gettime(h,m,s,c);                {Test the time it takes}

         fnum := FieldNo('LASTNAME');
         posn := SearchDBF(St,fnum,true);
         if posn > 0 then                 {Posn = starting position in string}
         begin
            writeln(RecNo,'  ',
                    FieldGet('LASTNAME'),' ',       {Get field images}
                    FieldGet('FIRSTNAME'),'  ',
                    FieldGet('UNIQUEID'));
            writeln(RecNo,' records were searched');
         end
         else
         begin
            writeln('No Match!  ',RecCount,' records were searched');
         end;

      {  Report elapsed time  }

         gettime(h1,m1,s1,c1);
         if s1 < s then s1 := s1 + 60;
         s := (s*100)+c;
         s1 := (s1*100)+c1;
         rt := s1-s;
         rt := rt/100;
         writeln('Time required to find key was  ',rt:2:2,' seconds.');
      end;

   until st = '';
   CloseDataBases;                {Close the file}
end.
