Program SaveTest;

uses
  Dos, Objects, Drivers, Views, Menus, Dialogs, App, MsgBox, Gadgets, ScrSaver;

const
  cmScrSaveSet      = 1010;

type

  PHeapText = ^THeapText;
  THeapText = object(TStaticText)
    function GetPalette: PPalette; virtual;
  end;

  PSampleApp = ^TSampleApp;
  TSampleApp = object(TApplication)
    Clock: PClockView;
    Heap: PHeapView;
    HeapText: PHeapText;
    CountDown, FixedCountDown, MOld, SOld: Word;
    FreezeCountDown: Boolean;
    constructor Init;
    destructor Done; virtual;
    function GetPalette: PPalette; virtual;
    procedure ScreenSave;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Idle; virtual;
    procedure InitMenuBar; virtual;
    procedure InitStatusLine; virtual;
    procedure OutOfMemory; virtual;
  end;

function THeapText.GetPalette: PPalette;
const
  P: string[1] = #2;
begin
  GetPalette := @P;
end;

constructor TSampleApp.Init;
var R: TRect; H, S100: Word;
begin
  TApplication.Init; GetExtent(R); R.A.X := R.B.X - 9; R.B.Y := R.A.Y + 1;
  Clock := New(PClockView, Init(R)); Insert(Clock);
  GetExtent(R); Dec(R.B.X); R.A.X := R.B.X - 30; R.A.Y := R.B.Y - 1;
  HeapText := New(PHeapText, Init(R,'Available Heap block:')); Insert(HeapText);
  GetExtent(R); Dec(R.B.X); R.A.X := R.B.X - 9; R.A.Y := R.B.Y - 1;
  Heap := New(PHeapView, Init(R)); Insert(Heap);
  CountDown := 0; FixedCountDown := 5; GetTime(H, MOld, SOld, S100);
  FreezeCountDown := False;
end;

destructor TSampleApp.Done;
begin
  if Clock <> nil then Dispose(Clock, Done);
  if Heap <> nil then Dispose(Heap, Done);
  if HeapText <> nil then Dispose(HeapText, Done);
  TApplication.Done;
end;

function TSampleApp.GetPalette: PPalette;
const
  CNewColor = CColor + CScreenSave;
  CNewBlackWhite = CBlackWhite;
  CNewMonochrome = CMonochrome;
  P:array[apColor..apMonochrome] of string[Length(CNewColor)] =
    (CNewColor, CNewBlackWhite, CNewMonochrome);
begin
  GetPalette := @P[AppPalette];
end;

procedure TSampleApp.ScreenSave;
var SS: PScreenSaver;
begin
  SS := New(PScreenSaver, Init);
  if ValidView(SS) <> nil then
  begin
    HideMouse;
    Insert(SS);
    SS^.Run;
    Dispose(SS, Done);
    ShowMouse;
  end;
end;

procedure TSampleApp.HandleEvent(var Event: TEvent);

procedure ScreenSaveSet;
var SSD: PScrDialog;
begin
  SSD := New(PScrDialog, Init(FixedCountDown));
  if ValidView(SSD) <> nil then
  begin
    ExecView(SSD);
    SSD^.GiveTime(FixedCountDown);
    Dispose(SSD, Done)
  end
end;

begin
  TApplication.HandleEvent(Event);
  if Event.what <> evNothing then CountDown := 0;
  case Event.What of
    evCommand:
      begin
        FreezeCountDown := True;
        case Event.Command of
          cmScrSaveSet: ScreenSaveSet;
        else
          Exit;
        end;
        ClearEvent(Event);
        FreezeCountDown := False
      end;
  end;
end;

procedure TSampleApp.Idle;
var H, M, S, S100: Word;
    Event: TEvent;

function IsTileable(P: PView): Boolean; far;
begin
  IsTileable := P^.Options and ofTileable <> 0;
end;

begin
  TApplication.Idle;
  Clock^.Update;
  Heap^.Update;
  GetTime(H, M, S, S100);
  if not FreezeCountDown then
  begin
    Inc(CountDown,((M-MOld)*60 + (S-SOld)));
    if CountDown > FixedCountDown then
    begin
      CountDown := 0;
      ScreenSave
    end
  end;
  MOld := M; SOld := S;
end;

procedure TSampleApp.InitMenuBar;
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := R.A.Y+1;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu('~F~ile', hcNoContext, NewMenu(
      NewItem('E~x~it', 'Alt-X', kbAltX, cmQuit, hcNoContext,
      NewItem('~S~creensaver', '', kbNoKey, cmScrSaveSet, hcNoContext, nil))), nil))));
end;

procedure TSampleApp.InitStatusLine;
var
  R: TRect;
begin
  GetExtent(R);
  R.A.Y := R.B.Y - 1;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKey('~Alt-X~ Exit', kbAltX, cmQuit,
      NewStatusKey('', kbF10, cmMenu, nil)), nil)));
end;

procedure TSampleApp.OutOfMemory;
begin
  MessageBox(^C'Not enough memory available to complete operation.',
    nil, mfError + mfOkButton);
end;

var TVSample: TSampleApp;

begin
  TVSample.Init;
  TVSample.Run;
  TVSample.Done
end.