PROGRAM PlotDemo;


{

                 Zeigt die Anwendung des PLOTTER BGI-Treibers

                           (C) Ullrich von Bassewitz

}



{ nderungsliste:

30.12.92        Uz      Erstellt


}





USES
  CRT,
  Graph,
  I14;





CONST
  GraphIsOn : BOOLEAN = FALSE;          { TRUE wenn Grafik an }
  TempName = 'PLOTDEMO.TMP';            { Name der temporren Ausgabedatei }

  { *** Port-Einstellungen *** }
  PortNr   = 2;
  Baudrate = bd9600;
  Parity   = pNone;
  StopBits = 1;
  DataBits = 8;


VAR
  MaxX : INTEGER;
  MaxY : INTEGER;


{ ---------------------------------------------------------------------------- }




PROCEDURE GraphicsOff;
BEGIN
  IF (GraphIsOn) THEN BEGIN
    { Grafik beenden }
    CloseGraph;
    { Handle 3 schlieen }
    ASM
      mov     bx, 3             { AUX-Handle }
      mov     ah, 3Eh           { Close handle }
      int     21h               { Handle schlieen }
    END;
    GraphIsOn := FALSE;
  END;
END;





PROCEDURE Error (Msg: STRING);
BEGIN
  GraphicsOff;
  Writeln (Msg);
  Halt (1);
END;




PROCEDURE GraphicsOn;

VAR
  GraphDriver : INTEGER;
  GraphMode   : INTEGER;
  Result      : INTEGER;
  F           : FILE;

BEGIN
  { Treiber installieren }
  GraphDriver := InstallUserDriver ('PLOTTER', NIL);
  IF (GraphDriver < 0) THEN BEGIN
    Error ('Fehler beim Installieren von PLOTTER.BGI');
  END;

  { Grafik einschalten, DIN A4 = Modus 0 }
  GraphMode := 0;
  InitGraph (GraphDriver, GraphMode, '');
  Result := GraphResult;
  IF (Result <> 0) THEN BEGIN
    Error ('Fehler bei der Initialisierung: ' + GraphErrorMsg (Result));
  END;

  { Jetzt kommt's - Dateiumleitung in Pascal ! }

  { Beliebige Datei mit bergebenem Namen ffnen }
  Assign (F, TempName);
  ReWrite (F, 1);                { Fehlercheck fehlt hier , $I+ (hoffentlich) }

  { DUP2 ausfhren }
  ASM
    mov     bx, WORD PTR [F]           { Datei-Handle holen }
    mov     cx, 3                      { AUX-Handle }
    mov     ax, 4600h                  { Force duplicate file handle }
    int     21h
    jnc     @@L1                       { Springe wenn kein Fehler }
    mov     [InOutRes], ax             { Fehlercode merken }
@@L1:
  END;
  IF (IOResult <> 0) THEN BEGIN
    { dup2 ging schief }
    Error ('Fehler bei der Umleitung nach ' + TempName);
  END;

  { Orginale Datei kann geschlossen werden (Fehlercheck fehlt hier) }
  Close (F);

  { Noch einige Werte holen }
  MaxX := GetMaxX;
  MaxY := GetMaxY;

  { Merken, da die Grafik an ist }
  GraphIsOn := TRUE;
END;



{ ---------------------------------------------------------------------------- }



PROCEDURE Border (X1, Y1, X2, Y2 : INTEGER);
BEGIN
  SetColor (0);
  SetLineStyle (SolidLn, 0, NormWidth);
  Rectangle (X1, Y1, X2, Y2);
END;





PROCEDURE Demo1;

CONST
  DemoText = 'Demo von PLOTTER.BGI !';
  Dist     = 50;

VAR
  WX1, WY1, WX2, WY2 : INTEGER;
  X, Y               : INTEGER;


  PROCEDURE SetText (Font : WORD; Size : WORD);
  BEGIN
    SetTextStyle (Font, HorizDir, 4);
    SetTextJustify (LeftText, TopText);
    SetUserCharSize ((Size * 50) DIV 10, 10, (Size * 50) DIV 10, 10);
  END;

BEGIN
  WX1 := 0; WY1 := 0;
  WX2 := (MaxX DIV 2) - 50;
  WY2 := (MaxY DIV 2) - 50;

  { Rahmen ziehen }
  Border (WX1, WY1, WX2, WY2);

  SetColor (1);

  X := 200; Y := 100;
  SetText (TriplexFont, 25);
  OutTextXY (X, Y, DemoText);
  Inc (Y, TextHeight (DemoText) + Dist);

  SetText (SansSerifFont, 25);
  OutTextXY (X, Y, DemoText);
  Inc (Y, TextHeight (DemoText) + Dist);

  SetText (GothicFont, 25);
  OutTextXY (X, Y, DemoText);
  Inc (Y, TextHeight (DemoText) + Dist);

  SetText (5, 25);
  OutTextXY (X, Y, DemoText);
  Inc (Y, TextHeight (DemoText) + Dist);

  SetText (6, 25);
  OutTextXY (X, Y, DemoText);
END;






PROCEDURE Demo2;

VAR
  WX1, WY1, WX2, WY2 : INTEGER;
  Y0, YH             : INTEGER;
  XS, XE             : INTEGER;


  PROCEDURE Kurve1 (Perioden : WORD; Sign : INTEGER);
  CONST
    Dist = 2;
  VAR
    X, Y, LastX, LastY : INTEGER;
    G, H               : INTEGER;

  BEGIN
    LastX := MaxInt; LastY := MaxInt;
    FOR G := 0 TO Perioden * 360 DIV Dist DO BEGIN
      H := G * Dist;
      X := Round (((XE - XS) / (Perioden * 360.0)) * H) + XS;
      Y := Y0 - Sign * Round (YH * Cos ((Pi / 180) * H));
      IF ((LastX <> MaxInt) AND (LastY <> MaxInt)) THEN BEGIN
        Line (LastX, LastY, X, Y);
      END;
      LastX := X;
      LastY := Y;
    END;
  END;




  PROCEDURE Kurve2 (Periode1, Periode2 : WORD);
  CONST
    Dist = 2;
  VAR
    X, Y, LastX, LastY : INTEGER;
    G, H               : INTEGER;

  BEGIN
    LastX := MaxInt; LastY := MaxInt;
    FOR G := 0 TO Periode2 * 360 DIV Dist DO BEGIN
      H := G * Dist;
      X := Round (((XE - XS) / (Periode2 * 360.0)) * H) + XS;
      Y := Y0 - Round (YH * Cos ((Pi / 180) * H) * Cos ((Pi / 180) * (H / Periode2) * Periode1));
      IF ((LastX <> MaxInt) AND (LastY <> MaxInt)) THEN BEGIN
        Line (LastX, LastY, X, Y);
      END;
      LastX := X;
      LastY := Y;
    END;
  END;







BEGIN
  WX1 := (MaxX DIV 2) + 50; WY1 := 0;
  WX2 := MaxX; WY2 := (MaxY DIV 2) - 50;

  { Rahmen ziehen }
  Border (WX1, WY1, WX2, WY2);

  Y0 := (WY1 + WY2) DIV 2;
  YH := (Y0 - WY1) - 400;
  XS := WX1 + 600;
  XE := WX2 - 400;

  SetLineStyle (SolidLn, 0, NormWidth);
  Line (XS - 200, Y0, XE, Y0);
  Line (XS, Y0 - YH - 200, XS, Y0 + YH + 200);

  SetColor (1);
  Kurve1 (1, 1);
  Kurve1 (1, -1);
  SetColor (0);
  Kurve2 (1, 20);
END;






PROCEDURE Demo3;

VAR
  WX1, WY1, WX2, WY2 : INTEGER;

BEGIN
  WX1 := 0; WY1 := (MaxY DIV 2) + 50;
  WX2 := (MaxX DIV 2) - 50; WY2 := MaxY;

  { Rahmen ziehen }
  Border (WX1, WY1, WX2, WY2);

  SetColor (0);
  SetFillStyle (SlashFill, 1);
  Sector (WX1 + (WX2 - WX1) DIV 2,
          WY1 + (WY2 - WY1) DIV 2,
          20, 340,
          (WX2 - WX1) DIV 2 - 500,
          (WY2 - WY1) DIV 2 - 500);
END;






PROCEDURE Demo4;

CONST
  Rad = 500;
  Count = 6;
  Styles : ARRAY [0..5] OF WORD = (
    EmptyFill, LineFill, SlashFill, BkSlashFill, HatchFill, XHatchFill
  );

VAR
  WX1, WY1, WX2, WY2 : INTEGER;
  X, Y               : INTEGER;
  I                  : WORD;


  PROCEDURE DoCircle (Num : WORD);
  BEGIN
    PieSlice (WX1 + ((WX2 - WX1) DIV 4) * ((Num MOD 3) + 1),
              WY1 + ((WY2 - WY1) DIV 3) * ((Num DIV 3) + 1),
              0, 360, Rad);
  END;


BEGIN
  WX1 := (MaxX DIV 2) + 50; WY1 := (MaxY DIV 2) + 50;
  WX2 := MaxX; WY2 := MaxY;

  { Rahmen ziehen }
  Border (WX1, WY1, WX2, WY2);

  SetColor (1);
  FOR I := 0 TO Count - 1 DO BEGIN
    SetFilLStyle (Styles [I], 0);
    DoCircle (I);
  END;
END;






PROCEDURE MakeDemo;
{ Erzeugt diverse Ausgaben }

BEGIN
  Demo1;
  Demo2;
  Demo3;
  Demo4;
END;




PROCEDURE Output;
{ Gibt den Inhalt der temporren Datei auf den Plotter aus }
VAR
  Port   : THardWiredPort;
  F      : FILE;
  Result : INTEGER;

BEGIN
  { Seriellen Port initialisieren }
  Port.Init (PortNr, Baudrate, Parity, StopBits, DataBits);

  { Timeout-Zeit hochsetzen }
  Port.SetTimeoutRetries (100);

  { Datei ausgeben }
  Result := Plot (TempName, '', @Port);
  IF (Result <> 0) THEN BEGIN
    Writeln ('Fehler ', Result, ' bei der Ausgabe auf den Plotter.');
  END;

  { Temporre Datei lschen }
  Assign (F, TempName);
  Erase (F);

  { Fehler abholen aber ignorieren }
  IF (IOResult <> 0) THEN ;
END;



{ ---------------------------------------------------------------------------- }
{ Hauptprogramm }




BEGIN
  Writeln ('Dieses Programm demonstriert die Ausgabe von Grafik auf den Plotter.');
  Writeln ('Der Treiber PLOTTER.BGI und die Vektorzeichenstze mssen sich dazu');
  Writeln ('im aktuellen Verzeichnis befinden. Die Ausgabe erfolgt auf COM2 mit');
  Writeln ('9600 Baud und Hardware-Handshake. Fr andere Einstellungen mu das');
  Writeln ('Programm gendert und neu bersetzt werden.');
  Writeln ('Bitte legen Sie ein Blatt Papier (DIN A4) in den Plotter und setzen');
  Writeln ('Sie zwei Stifte (Positionen 1 und 2) ein.');
  Writeln;
  Write   ('Abbruch mit ESC oder weiter mit beliebiger Taste...');
  IF (ReadKey = #27) THEN BEGIN
    Writeln;
    Halt (0);
  END;

  Writeln;
  GraphicsOn;
  Writeln ('Temporre Datei wird erzeugt...');
  MakeDemo;
  GraphicsOff;

  Writeln ('Es wird geplottet...');
  Output;
END.




