/***************************************************************/
/* Demo fr den Drucker-BGI-Treiber.                           */
/*                                                             */
/* (C) Ullrich von Bassewitz,  26.12.1991                      */
/*                                                             */
/* Kompilieren mit Borland C++ 3.10 im Large-Modell            */
/*                                                             */
/* ACHTUNG: Der Druckertreiber und die Vektorfonts mssen sich */
/*          im aktuellen Verzeichnis befinden.                 */
/*                                                             */
/***************************************************************/


#include <stdio.h>
#include <graphics.h>
#include <stdlib.h>
#include <string.h>
#include <io.h>
#include <fcntl.h>
#include <sys\stat.h>





int main (void)
{

    int Driver, Mode;           /* Treibernummer und gewschter Modus */
    int MaxX, MaxY;             /* Maximale X/Y-Auflsung */
    int Result;                 /* Ergebnis von Grafik-Operationen */
    int Handle;                 /* Handle fr Umleitung in eine Datei */
    int Poly [8];               /* Speicher fr Polygonkoordinaten */
    char OutputName [80];       /* Name der Ausgabedatei */
    char Input [80];            /* Benutzereingabe */

    /* Titel ausgeben */
    printf ("BGI-Treiber Demo Copyright (C) Ullrich von Bassewitz 1991-93\n\n");

    /* PRINTER.BGI installieren */
    Driver = installuserdriver ( "PRINTER", NULL);
    if (Driver < 0) {
      printf ("Fehler bei der Installation von PRINTER.BGI.\n");
      exit (1);
    }

    /* Menue fr Druck-Modus bringen und Auswahl holen */
    printf (" 0 -> EPSON  8-Nadel,       240 *  72 DPI\n"
            " 1 -> EPSON  8-Nadel,       240 * 216 DPI\n"
            " 2 -> EPSON 24-Nadel,       180 * 180 DPI\n"
            " 3 -> EPSON 24-Nadel,       360 * 180 DPI\n"
            " 4 -> EPSON 24-Nadel,       360 * 360 DPI\n"
            " 5 -> NEC P6,               360 * 360 DPI\n"
            " 6 -> IBM Proprinter X24,   180 * 180 DPI\n"
            " 7 -> IBM Proprinter X24,   360 * 180 DPI\n"
            "14 -> Benutzermodus 1\n"
            "15 -> Benutzermodus 2\n"
            "16 -> HP-LaserJet            75 * 75  DPI\n"
            "17 -> HP-LaserJet           100 * 100 DPI\n"
            "18 -> HP-LaserJet           150 * 150 DPI\n"
            "19 -> HP-LaserJet           300 * 300 DPI\n"
            "20 -> HP-LaserJet            75 * 75  DPI ohne Kompression\n"
            "21 -> HP-LaserJet           100 * 100 DPI ohne Kompression\n"
            "22 -> HP-LaserJet           150 * 150 DPI ohne Kompression\n"
            "23 -> HP-LaserJet           300 * 300 DPI ohne Kompression\n"
            "24 -> HP-DeskJet 500C,       75 * 75  DPI\n"
            "25 -> HP-DeskJet 500C,      100 * 100 DPI\n"
            "26 -> HP-DeskJet 500C,      150 * 150 DPI\n"
            "27 -> HP-DeskJet 500C,      300 * 300 DPI\n"
            "32 -> HP-LaserJet           600 * 600 DPI\n"
            "\n"
            "Ihre Auswahl: ");

    Mode = 1000;
    gets (Input);
    sscanf (Input, "%u", &Mode);
    if (Mode < 0 || Mode > 32 ||
        (Mode >= 8  && Mode <= 13) ||
        (Mode >= 28 && Mode <= 31)) {
        printf ("Ungltiger Modus.\n");
        exit (2);
    }

    /* Ausgabegert holen */
    printf ("\nDateiname fr Ausgabe (keine Angabe = Gert PRN): ");
    gets (OutputName);
    printf ("\n");

    /* Falls eine Angabe erfolgte, Umleitung vornehmen */
    if (strlen (OutputName) != 0) {

        /* Handle 4 als File ffnen */
        Handle = creat (OutputName, S_IWRITE);
        if (Handle < 0) {
            printf ("Fehler beim Erzeugen von %s.\n", OutputName);
            exit (1);
        }

        /* Achtung: Hier hatten alte Versionen einen Fehler. Wenn das
         * frisch geffnete Handle bereits aus irgendeinem Grund die
         * Nummer 4 trgt (z.B. weil die Routine zur Umleitung in eine
         * Datei zum zweiten Mal aufgerufen wird und dazwischen das
         * Handle mit der Nummer 4 geschlossen wurde), wird von dup2
         * zuerst Handle (== 4) geschlossen und dann der normale dup
         * versucht, was in einem Fehler ("Handle ist nicht offen")
         * endet.
         * Der Fehler kann in diesem Programm nicht auftreten, weil die
         * Umleitung nur einmal durchgefhrt wird, bei der bernahme
         * in andere Programme kann sich das Problem jedoch stellen.
         * Deshalb die folgende Aktion nur ausfhren, wenn das Handle
         * nicht 4 ist.
         */
        if (Handle != 4) {
            (void) dup2 (Handle, 4);
            (void) close (Handle);
        }
    }

    /* Grafik initialisieren */
    initgraph (&Driver, &Mode, "");

    /* Auf Fehler prfen, zur Umgehung des Turbo-Bugs ber Typecast */
    Result = (int) (char) graphresult ();
    if (Result != 0) {
        printf ("Fehler: %s\n", grapherrormsg (Result));
        exit (Result);
    }

    /* Meldung bringen, weil's jetzt eine Weile dauern kann */
    printf ("Bitte etwas Geduld...\n");

    /* Daten des eingestellten Modus holen */
    MaxX  = getmaxx ();
    MaxY  = getmaxy ();

    /* Einige Zeichen-Operationen durchfhren */
    setcolor (getmaxcolor ());                 /* Schwarz auf weiem Grund */
    rectangle (0, 0, MaxX, MaxY);
    setlinestyle (SOLID_LINE, 0, THICK_WIDTH);
    setfillstyle (CLOSE_DOT_FILL, getmaxcolor ());
    circle (300, 300, 50);
    rectangle (100, 100, 200, 200);

    fillellipse (500, 500, 30, 50);

    settextstyle (TRIPLEX_FONT, HORIZ_DIR, 7);
    outtextxy (200, 600, "Aber hallo !");
    settextstyle (7, HORIZ_DIR, 9);
    outtextxy (200, 800, getmodename (Mode));
    settextstyle (5, HORIZ_DIR, 8);
    outtextxy (200, 1000, "Aber hallo !");
    settextstyle (6, HORIZ_DIR, 8);
    outtextxy (200, 1100, "Aber hallo !");
    settextstyle (GOTHIC_FONT, HORIZ_DIR, 8);
    outtextxy (200, 1200, "Aber hallo !");
    settextstyle (DEFAULT_FONT, HORIZ_DIR, 3);
    outtextxy (200, 900, "Default-Font, Gre 3");
    settextstyle (DEFAULT_FONT, VERT_DIR, 3);
    outtextxy (150, 900, "Default-Font, Gre 3");

    setlinestyle (SOLID_LINE, 0, THICK_WIDTH);
    line (900, 1000, 1000, 1100);
    setlinestyle (DASHED_LINE, 0, THICK_WIDTH);
    line (800, 400, 1100, 100);

    setfillstyle (CLOSE_DOT_FILL, 1);
    bar (100, 500, 300, 700);

    setfillstyle (BKSLASH_FILL, 1);
    setlinestyle (SOLID_LINE, 0, THICK_WIDTH);
    bar3d (1100, 300, 1300, 500, 100, 1);

    Poly [0] = (MaxX / 2) - 50;  /* 1. */
    Poly [1] = (MaxY / 2) + 50;

    Poly [2] = MaxX - 150;       /* 2. */
    Poly [3] = MaxY - 150;

    Poly [4] = MaxX - 400;       /* 3. */
    Poly [5] = MaxY - 400;

    Poly [6] = MaxX / 2;         /* 4. */
    Poly [7] = MaxY / 2;

    setfillstyle (BKSLASH_FILL, 1);

    fillpoly (4, Poly);

    sector (1500, 1000, 0, 290, 150, 80);


    /* Bild wurde im Speicher aufgebaut, Ausdruck erfolgt bei closegraph */
    printf ("Drucke...\n");
    closegraph ();

    /* Handle 4 schlieen */
    (void) close (4);

    /* Und Ende */
    return 0;
}


