PROGRAM Demo;

{ ********************************************************************** }
{ Demo fr den Drucker-BGI-Treiber.                                      }
{                                                                        }
{ (C) Ullrich von Bassewitz,  26.12.1991                                 }
{                                                                        }
{ ACHTUNG: Der Druckertreiber und die Vektorfonts mssen sich im         }
{          aktuellen Verzeichnis befinden !                              }
{                                                                        }
{                                                                        }
{ nderungen:                                                            }
{                                                                        }
{ 30.07.92 (Uz)                                                          }
{ Angepasst an Version 2.1 des Druckertreibers.                          }
{                                                                        }
{ 04.10.93 (Uz)                                                          }
{ Angepasst an Version 3.0 des Treibers.                                 }
{                                                                        }
{ ********************************************************************** }




USES
  DOS,
  Graph;




VAR
  MaxX, MaxY        : INTEGER;    { Maximale X/Y-Auflsung }
  Driver, Mode      : INTEGER;
  Poly              : ARRAY [1..8] OF INTEGER;
  Result            : INTEGER;
  FileName          : PathStr;
  F                 : FILE;



CONST
  P                 : PaletteType = (
    Size            : 8;
    Colors          : (
      -1,                      { Reserved }
      0,                       { Quality = keypad setting }
      -1,                      { Reserviert }
      -1,                      { Reserviert }
      -1, -1, -1, -1, -1, -1,  { Unbenutzte Eintrge }
      -1, -1, -1, -1, -1, -1   { Unbenutzte Eintrge }
    )
  );




FUNCTION FileHandle (VAR F: FILE): INTEGER; ASSEMBLER;
{ Gibt das Handle zurck, das eine Dateivariable benutzt }
ASM
  les     di, [F]
  mov     ax, es:[di]           { Handle nach ax }
END;




PROCEDURE CloseHandle (Handle: INTEGER); ASSEMBLER;
{ Schliet das Handle mit der bergebenen Nummer }
ASM
  mov     bx, [Handle]
  mov     ah, 3Eh
  int     21h
  jc      @@L1                  { Springe wenn Fehler }
  xor     ax, ax                { Kein Fehler, Code = 0 }
@@L1:
  mov     [InOutRes], ax        { Fehler merken }
END;







BEGIN
  { Titel ausgeben }
  Writeln ('BGI-Treiber Demo  Copyright (C) Ullrich von Bassewitz 1991-93');
  Writeln;

  { PRINTER.BGI installieren }
  Driver := InstallUserDriver ('PRINTER', NIL);
  IF (Driver < 0) THEN BEGIN
    Writeln ('Fehler bei der Installation von PRINTER.BGI.');
    Halt (1);
  END;

  { Menue fr Druck-Modus bringen und Auswahl holen }
  Writeln (' 0 -> EPSON  8-Nadel,       240 *  72 DPI');
  Writeln (' 1 -> EPSON  8-Nadel,       240 * 216 DPI');
  Writeln (' 2 -> EPSON 24-Nadel,       180 * 180 DPI');
  Writeln (' 3 -> EPSON 24-Nadel,       360 * 180 DPI');
  Writeln (' 4 -> EPSON 24-Nadel,       360 * 360 DPI');
  Writeln (' 5 -> NEC P6,               360 * 360 DPI');
  Writeln (' 6 -> IBM Proprinter X24,   180 * 180 DPI');
  Writeln (' 7 -> IBM Proprinter X24,   360 * 180 DPI');
  Writeln ('14 -> Benutzermodus 1');
  Writeln ('15 -> Benutzermodus 2');
  Writeln ('16 -> HP-LaserJet            75 * 75  DPI');
  Writeln ('17 -> HP-LaserJet           100 * 100 DPI');
  Writeln ('18 -> HP-LaserJet           150 * 150 DPI');
  Writeln ('19 -> HP-LaserJet           300 * 300 DPI');
  Writeln ('20 -> HP-LaserJet            75 * 75  DPI ohne Kompression');
  Writeln ('21 -> HP-LaserJet           100 * 100 DPI ohne Kompression');
  Writeln ('22 -> HP-LaserJet           150 * 150 DPI ohne Kompression');
  Writeln ('23 -> HP-LaserJet           300 * 300 DPI ohne Kompression');
  Writeln ('24 -> HP-DeskJet 500C,       75 * 75  DPI');
  Writeln ('25 -> HP-DeskJet 500C,      100 * 100 DPI');
  Writeln ('26 -> HP-DeskJet 500C,      150 * 150 DPI');
  Writeln ('27 -> HP-DeskJet 500C,      300 * 300 DPI');
  Writeln ('32 -> HP-LaserJet           600 * 600 DPI');
  Writeln;
  Write   ('Ihre Auswahl: ');
  Readln (Mode);

  IF (Mode < 0) OR (Mode > 32) OR
     ((Mode >= 8) AND (Mode <= 13)) OR
     ((Mode >= 28) AND (Mode <= 31)) THEN BEGIN
    Writeln ('Ungltiger Modus.');
    Halt (2);
  END;

  { Ausgabegert holen }
  Writeln;
  Write ('Dateiname fr Ausgabe (keine Angabe = Gert PRN): ');
  FileName := '';
  ReadLn (FileName);

  IF (FileName <> '') THEN BEGIN
    { Jetzt kommt's - Dateiumleitung in Pascal ! }

    { Beliebige Datei mit bergebenem Namen ffnen }
    Assign (F, FileName);
    ReWrite (F, 1);                { Fehlercheck fehlt hier , $I+ (hoffentlich) }

    { Achtung: Es darf nur ein dup ausgefhrt werden, wenn das Handle nicht
      bereits den gewnschten Wert hat. Das ist zwar hier korrekt, weil bei
      Programmstart das Handle 4 immer offen ist, das von F verwendete Handle
      also immer ungleich 4 ist, das mu jedoch nicht immer so sein (z.B.
      wenn der Code in eine Funktion gepackt wird, die mehrfach aufgerufen
      wird).
    }
    IF (FileHandle (F) <> 4) THEN BEGIN

      { DUP2 ausfhren }
      ASM
        mov     bx, WORD PTR [F]           { Datei-Handle holen }
        mov     cx, 4                      { Drucker-Handle }
        mov     ax, 4600h                  { Force duplicate file handle }
        int     21h
        jnc     @@L1                       { Springe wenn kein Fehler }
        mov     [InOutRes], ax             { Fehlercode merken }
      @@L1:
      END;
      IF (IOResult <> 0) THEN BEGIN
        { dup2 ging schief }
        Writeln ('Fehler bei der Umleitung nach ', Filename);
        Halt (1);
      END;

      { Orginale Datei kann geschlossen werden (Fehlercheck fehlt hier) }
      Close (F);

    END;

  END;

  { Druckerport setzen und Grafik initialisieren }
  InitGraph (Driver, Mode, '');

  { Auf Fehler prfen, zur Umgehung des Turbo-Bugs ber Typecast }
  Result := SHORTINT (GraphResult);
  IF (Result <> 0) THEN BEGIN
    Writeln ('Fehler: ', GraphErrorMsg (Result));
    Halt (Result);
  END;

  { Meldung bringen, weil's jetzt eine Weile dauern kann }
  Writeln ('Bitte Geduld...');

  { Einstellungen setzen }
  SetAllPalette (P);

  { Daten des eingestellten Modus holen }
  MaxX  := GetMaxX;
  MaxY  := GetMaxY;

  { Einige Zeichen-Operationen durchfhren }
  SetColor (GetMaxColor);                    { Schwarz auf weiem Grund }
  SetLineStyle (SolidLn, 0, ThickWidth);
  SetFillStyle (CloseDotFill, GetMaxColor);
  Circle (300, 300, 50);
  Rectangle (100, 200, 200, 300);

  FillEllipse (500, 500, 30, 50);

  Rectangle (0, 0, GetMaxX, GetMaxY);
  SetTextStyle (SmallFont, HorizDir, 5);
  OutTextXY (10, 30, 'abcdefghijklmnopqrstuvwxyz');
  OutTextXY (10, 45, 'abcdefghijklmnopqrstuvwxyz');
  OutTextXY (10, 60, 'abcdefghijklmnopqrstuvwxyz');
  OutTextXY (10, 75, 'abcdefghijklmnopqrstuvwxyz');
  OutTextXY (10, 90, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ');
  OutTextXY (10, 105, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ');
  OutTextXY (10, 120, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ');
  OutTextXY (10, 135, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ');

  SetTextStyle (SmallFont, HorizDir, 10);
  OutTextXY (10, 200, 'ikpqt AXYP');

  SetTextStyle (TriplexFont, HorizDir, 7);
  OutTextXY (200, 600, 'Aber hallo !');
  SetTextStyle (7, HorizDir, 9);
  OutTextXY (200, 800, GetModeName (Mode));
  SetTextStyle (5, HorizDir, 8);
  OutTextXY (200, 1000, 'Aber hallo !');
  SetTextStyle (6, HorizDir, 8);
  OutTextXY (200, 1100, 'Aber hallo !');
  SetTextStyle (GothicFont, HorizDir, 8);
  OutTextXY (200, 1200, 'Aber hallo !');
  SetTextStyle (DefaultFont, HorizDir, 3);
  OutTextXY (200, 900, 'Default-Font, Gre 3');
  SetTextStyle (DefaultFont, VertDir, 3);
  OutTextXY (150, 900, 'Default-Font, Gre 3');

  SetLineStyle (SolidLn, 0, ThickWidth);
  Line (900, 1000, 1000, 1100);
  SetLineStyle (DashedLn, 0, ThickWidth);
  Line (800, 400, 1100, 100);

  SetFillStyle (CloseDotFill, 1);
  Bar (100, 500, 300, 700);

  SetFillStyle (BkSlashFill, 1);
  SetLineStyle (SolidLn, 0, ThickWidth);
  Bar3D (1100, 300, 1300, 500, 100, TRUE);

  Poly [1] := (MaxX DIV 2) - 50;  { 1. }
  Poly [2] := (MaxY DIV 2) + 50;

  Poly [3] := MaxX - 150;         { 2. }
  Poly [4] := MaxY - 150;

  Poly [5] := MaxX - 400;         { 3. }
  Poly [6] := MaxY - 400;

  Poly [7] := MaxX DIV 2;         { 4. }
  Poly [8] := MaxY DIV 2;

  SetFillStyle (BkSlashFill, 1);

  FillPoly (4, Poly);

  Sector (1500, 1000, 0, 290, 150, 80);

  { Bild wurde im Speicher aufgebaut, Ausdruck erfolgt bei closegraph }
  Writeln ('Drucke...');
  CloseGraph;

  { Sicherheitshalber offenes Dateihandle schlieen }
  CloseHandle (4);
END.


