%* RECUR.SW
%************************************************************************
%*									*
%*		PC Scheme/Geneva 4.00 Scheme support code		*
%*									*
%* (c) 1985-1988 by Texas Instruments, Inc. See COPYRIGHT.TXT		*
%* (c) 1992 by L. Bartholdi & M. Vuilleumier, University of Geneva	*
%*									*
%*----------------------------------------------------------------------*
%*									*
%*		A few fun demos of recursive functions			*
%*									*
%*----------------------------------------------------------------------*
%*									*
%* Created by: L. Bartholdi		Date: 1992			*
%* Revision history:							*
%* -  1 Oct 92:	Renaissance (Borland Compilers, ...)			*
%*									*
%*					``In nomine omnipotentii dei''	*
%************************************************************************

\documentstyle[astyped,a4,12pt]{article}
\author{Larry Bartholdi \& his gang}
\title{Recursive samples}
\date{\today}
\setlength{\textheight}{240mm}

\newcommand{\pcs}{{\sc PcScheme}}
\newcommand{\scheme}{\verb}

\begin{document}
\maketitle

This is the {\em only} true definition of factorial over $\cal Z$.
Note \scheme+(fact -1)+ is $\Gamma(0)$, and $\Gamma(0)\cdot 0$ must be
$\Gamma(1)$ or $1$, so \scheme+(fact -1)+ is $\infty$
 (so is \scheme+(gamma -n)+ for integral $n$).
(define (fact n)
  (if (<= n 0)
      (if (= n 0) 1 (/ 1 0))
      (* n (fact (-1+ n)))))

This code expect is intended as a provocation\ldots
Notice the speed improvements are marginal, the arguments are not tested
as cleanly as above, without memtioning poor portability (the one thing
us Scheme guys should be proud of).
(define fastfact (inline-lambda 1 '(pcs-code-block 0 25 ()
	(0 12 4				;	mov.r	r3, r1
	2 4 1				;	mov.i	r1, \#1
	2 8 1				;	mov.i	r2, \#1
	83 4 8				;@@loop:mul.r	r1, r2
	81 8 1				;	add.i	r2, \#1
	0 16 8				;	mov.i	r4, r2
	95 16 12			;	gt.r	r4, r3
	34 16 241			;	jnil.s	r4, @@loop
           59))))				;	ret

All these examples are extracted from
``G\"oedel, Escher, Bach: an Eternal Golden Braid''
by Doug Hofstadter, chapter V, pages 136 ff. Their behaviour is
deterministic, but can be felt as chaotic, a fact expressed by the
absence of closed form and the 'ruggedness' of their graph.
(define (g n)
  (if (= n 0)
      0
      (- n (g (g (-1+ n))))))
(define (h n)
  (if (= n 0)
      0
      (- n (h (h (h (-1+ n)))))))
(define (female n)
  (if (= n 0)
      1
      (- n (male (female (-1+ n))))))
(define (male n)
  (if (= n 0)
      0
      (- n (female (male (-1+ n))))))
(define (q n)
  (if (<= n 2)
      1
      (+ (q (- n (q (- n 1))))
         (q (- n (q (- n 2)))))))
(define (fibo n)
  (if (<= n 2)
      1
      (+ (fibo (- n 1))
         (fibo (- n 2)))))

Now comes a code that isn't precisely recursive. As you certainly know,
\scheme+do+--loops are hanging offenses; but on the other side, \pcs\
is kind enough to translate the loops in tail-recursive code, so\ldots
The algorithm is based on a fast series for $4\arctan(1)$ (see Abramowitz
\& Stegun, formula 4.4.42):
$$\arctan z = \frac{z}{1+z^2}\big\{1+\frac{2}{3}\frac{z^2}{1+z^2}\big[1+\frac{4}{5}
	\frac{z^2}{1+z^2}\big(1+\ldots\big)\big]\big\}.$$
(define (pi n)
  (let ((unity (do ((i 0 (1+ i))
                      (r 1 (* r 10)))
                     ((>= i n) r)))
        (iter (round (+ (/ n (log 2 10)) 50))))
    (do ((num iter (-1+ num))
         (denom (+ iter iter 1) (- denom 2))
         (pi 0 (+ unity unity (quotient (* pi num) denom))))
        ((= num 0) (newline) pi)
        (when (= (remainder num 10) 0)
              (princ #\return)
	      (princ "[") (princ num) (princ "] ")))))

(writeln '(fact fastfact g h female male q fibo pi))
\end{document}
