# Abschlu im Fach Assemblerprogrammierung
#
#			Taschenrechner mit + - * / ( ), Memory
#				und Vorrangautomatik
#
# Andreas Westfeld, 92/08/02
# ___________________________________________________________________________
#
#
	.text	
main:
	la	$4, start_text
	li	$2, 4
	syscall				# Ausgabe
	jal	atof_i			# atof() initialisieren
	la	$16, buffer
mainret:
	la	$4, AClabel
	li	$2, 4
	syscall				# Ausgabe
	mov.d	$f12, $f20		# AC
	li	$2, 3
	syscall				# Ausgabe
	la	$4, Mlabel
	li	$2, 4
	syscall				# Ausgabe
	mov.d	$f12, $f16		# M
	li	$2, 3
	syscall				# Ausgabe
	la	$4, nl
	li	$2, 4
	syscall				# Ausgabe
	la	$25, lower_stack
	la	$26, upper_stack
	move	$24, $25
	la	$4, prompt
	li	$2, 4
	syscall				# Ausgabe
	move	$4, $16			# &buffer
	li	$5, 0x1000	
	li	$2, 8
	syscall				# Eingabe
	move	$17, $16		# Start festlegen
	jal	scan			# Eingabezeile auswerten
	j	mainret
mainend:li	$2, 10
	syscall
#
# Scanner und Parser
#
# Register:  $17 .. Zeiger auf aktuelles Zeichen
# ___________________________________________________________________________
#
scan:	sw	$ra, ($sp)
	addiu	$sp, $sp, -4
	move	$20, $zero
	move	$19, $zero
	move	$18, $zero
	j	scan_
scan_help:
	la	$4, start_text		# Hilfe-Text
	li	$2, 4
	syscall				# Ausgabe
	j	scan_0
scan_0:	addiu	$17, $17, 1
scan_:	lbu	$2, ($17)		# ein Zeichen holen
	beqz	$2, scan_w		# Zeichenkettenende
	beq	$2, 0xa, scan_w		# Eingabeende
	beq	$2, 0x20, scan_0		# Leerzeichen
	beq	$2, 0x2b, scan_i		# "+"
	beq	$2, 0x2d, scan_i		# "-"
	beq	$2, 0x2a, scan_e		# "*"
	beq	$2, 0x2f, scan_e		# "/"
	beq	$2, 0x28, scan_open		# "("
	beq	$2, 0x29, scan_close		# ")"
	beq	$2, 0x2e, scan_1		# "."
	beq	$2, 0x4d, scan_n		# "M"
	beq	$2, 0x6d, scan_n		# "m"
	beq	$2, 0x51, scan_quit		# "q"
	beq	$2, 0x71, scan_quit		# "Q"
	beq	$2, 0x3f, scan_help		# "?"
	blt	$2, 0x30, syntax_error
	bgt	$2, 0x39, syntax_error
	 # Zahl einlesen
scan_1:	beq	$19, 2, syntax_error
	beq	$19, 1, scan_3		# normale Operation
	bnez	$19, err_4		# error Programmfehler
	jal	atof_r			# Zahl einlesen
	mov.d	$f8, $f0		# Zahl in AC
scan_2:	li	$19, 2			# nchstes ist Operation
	move	$18, $zero		# Keine Operation vorgemerkt
	j	scan_			# nchstes Einlesen
scan_3:	 # normale Operation
	jal	atof_r			# Zahl einlesen
	mov.d	$f10, $f0		# Berechungsfeld -> AC2
scan_4:	blt	$18, 3, scan_6		# "+", "-" spter
	beq	$18, 3, scan_5		# "*"
	beq	$18, 5, syntax_error
	bne	$18, 4, err_4		# error Programmfehler
	div.d	$f8, $f8, $f10		# / ausgefhrt
	j	scan_2
scan_5:	mul.d	$f8, $f8, $f10		# * ausgefhrt
	j	scan_2
scan_6:	 # Aufsparen der Strichrechnung
	li	$19, 2			# nchstes ist Operation
	j	scan_	#0
scan_open:	 # Klammer auf
	lbu	$2, 1($17)
scan_8:	beq	$24, $26, err_8		# Stackfehler zu viele Klammern
	beq	$19, 2, syntax_error
	beqz	$19, scan_9		# Erstes allgemeines Zeichen
	bne	$19, 1, err_4		# Error Programmfehler
scan_9:	s.d	$f8, ($24)		# sichere 64 bit AC
	s.d	$f12, 8($24)		# sichere tmp AC
	sw	$18, 0x10($24)		# sichere letzte Operation
	sw	$19, 0x14($24)		# sichere letzten Stand
	sw	$20, 0x18($24)		# sichere vorletzte Operation
	addiu	$24, $24, 0x20
	mov.d	$f8, $f24		# AC = 0
	move	$20, $zero		# keine erw. Operation festgelegt
	move	$19, $zero		# kein Zustand erklrt
	li	$18, 5			# keine Operation festgelegt
	j	scan_0
scan_close:	 # Klammer zu !
	lbu	$2, 1($17)
scan_b:	beq	$24, $25, err_a		# Stackfehler: zu viele ")"
	beq	$19, 1, syntax_error
	beqz	$19, scan_b1
	bne	$19, 2, err_4		# error Programmfehler
scan_b1:beqz	$20, scan_d		# keine Erweiterung
	beq	$20, 1, scan_c
	sub.d	$f8, $f12, $f8
	j	scan_d
scan_c:	add.d	$f8, $f12, $f8
scan_d:	beqz	$18, scan_d4
	beq	$18, 1, scan_d3
	beq	$18, 2, scan_d2
	beq	$18, 3, scan_d1
	beq	$18, 4, scan_d0
	mov.d	$f10, $f24
	j	scan_d4
scan_d0:div.d	$f8, $f8, $f10
	j	scan_d4
scan_d1:mul.d	$f8, $f8, $f10
	j	scan_d4
scan_d2:sub.d	$f8, $f8, $f10
	j	scan_d4
scan_d3:add.d	$f8, $f8, $f10
scan_d4:mov.d	$f10, $f8
	addiu	$24, $24, -32
	l.d	$f8, ($24)
	l.d	$f12, 8($24)
	lw	$18, 0x10($24)
	lw	$19, 0x14($24)
	lw	$20, 0x18($24)
	addiu	$17, $17, 1
	beqz	$18, scan_d6
	bne	$18, 5, scan_d7
	move	$18, $zero
	li	$19, 1
scan_d6:mov.d	$f8, $f10
scan_d7:j	scan_4			# normal weiter
scan_e:	 # *,/
	lbu	$3, 1($17)
scan_f:	beqz	$19, scan_h		# Anfang Zeichenkette
	beq	$19, 1, syntax_error
	bne	$19, 2, err_4		# error Programmfehler
	beqz	$18, scan_g		# keine Weitere Operation
	beq	$18, 5, err_4		# error *, / nach "(" aber bereits Op )
	move	$20, $18
	mov.d	$f12, $f8
	mov.d	$f8, $f10
scan_g:  andi	$18, $2, 3
	addiu	$18, $18, 1
	li	$19, 1
	j	scan_0
scan_h:	beq	$18, 5, syntax_error
	mov.d	$f8, $f20
	j	scan_g
	
scan_i:	# +, -
	lbu	$3, 1($17)
scan_j:	beqz	$19, scan_m		# Anfang Zeichenkette
	beq	$19, 1, syntax_error
	bne	$19, 2, err_4		# error Programmmfehler
	beqz	$20, scan_l		# wenn keine Voroperation
	beq	$20, 1, scan_k
	sub.d	$f8, $f12, $f8
	j	scan_l
scan_k:	add.d	$f8, $f12, $f8
scan_l:	beq	$18, 5, err_4		# error ( ? aber Op bestimmt
	beqz	$18, scan_l3
	beq	$18, 1, scan_l1
	sub.d	$f8, $f8, $f10
	j	scan_l3
scan_l1:add.d	$f8, $f8, $f10
scan_l3:andi	$18, $2, 6
	srl	$18, $18, 1
	li	$19, 1
	j	scan_0
scan_m:	beqz	$18, scan_m1		# normal-Start
	mov.d	$f8, $f24		# "0"
	move	$18, $zero
	j	scan_l
scan_m1:mov.d	$f8, $f20
	j	scan_l
scan_n:	# M
	lbu	$2, 1($17)
	lbu	$3, 2($17)
	beqz	$3, scan_o
scan_o:	addiu	$17, $17, 2
	beq	$2, 0x52, scan_p		# "r"
	beq	$2, 0x72, scan_p		# "R"
	beq	$2, 0x57, scan_r		# "w"
	beq	$2, 0x77, scan_r		# "W"
	beq	$2, 0x2b, scan_s		# "+"
	beq	$2, 0x2d, scan_t		# "-"
	beq	$2, 0x41, scan_u		# "a"
	beq	$2, 0x61, scan_u		# "A"
	j	syntax_error
scan_p:	beq	$19, 2, syntax_error
	beq	$19, 1, scan_q		# normal
	bnez	$19, err_4		# error Programmfehler
	mov.d	$f8, $f16		# M -> AC
	j	scan_2
scan_q:	mov.d	$f10, $f16
	j	scan_4
scan_r:	mov.d	$f16, $f8
	j	scan_0
scan_s:	add.d	$f16, $f16, $f8
	j	scan_0
scan_t:	sub.d	$f16, $f16, $f8
	j	scan_0
scan_u:	beq	$19, 2, syntax_error
	beq	$19, 1, scan_v		# normal
	bnez	$19, err_4		# error Programmfehler
	mov.d	$f8, $f20		# -> AC
	j	scan_2
scan_v:	mov.d	$f10, $f20
	j	scan_4
scan_w:	beq	$19, 1, syntax_error
	bne	$24, $25, err_9		# Klammer offen
	beqz	$20, scan_y
	beq	$20, 1, scan_x
	sub.d	$f8, $f12, $f8
	j	scan_y
scan_x:	add.d	$f8, $f12, $f8
scan_y:	beqz	$18, scan_y4
	beq	$18, 1, scan_y3
	beq	$18, 2, scan_y2
	beq	$18, 3, scan_y1
	div.d	$f8, $f12, $f8
	j	scan_y4
scan_y1:mul.d	$f8, $f8, $f10
	j	scan_y4
scan_y2:sub.d	$f8, $f8, $f10
	j	scan_y4
scan_y3:add.d	$f8, $f8, $f10
scan_y4:mov.d	$f20, $f8
	addiu	$sp, $sp, 4
	lw	$ra, ($sp)
	jr	$ra
scan_quit:	lbu	$2, 1($17)
scan__:	addiu	$sp, $sp, 4
	j	mainend
#
# Einlesen einer Zahl in das Register $fp0.
# 
# Aufruf:	atof_r ... Einlesen der Zahl
#		           ( $16 - Startadr. des Strings )
#		           ( $17 - momentane Position im String )
#		           ( atof_i wurde zum Programmstart aufgerufen )
#
#		atof_i ... Initialisieren der Grunddaten im Coprozessor
# ___________________________________________________________________________
#
atof_r:	mov.d	$f0, $f24		# Speicher der Zahl = 0
	mov.d	$f4, $f28		# Merke Startwert fr Nachkommastellen
	move	$3, $zero		# lsche $3
	move	$21, $zero		# lsche $21
	lbu	$2, ($17)		# Zeichen laden
	beq	$2, 0x2d, atof_a	# "-"
	bne	$2, 0x2b, atof_1	# nicht "+"
	addiu	$17, $17, 1
	j	atof_1
atof_a:	li	$21, 1			# setze -
	addiu	$17, $17, 1
atof_1:	lbu	$2, ($17)		# Zeichen laden
	beq	$2, 0x2e, atof_2	# "."
	blt	$2, 0x30, atof_e	# <"0" Ende
	bgt	$2, 0x39, atof_e	# >"9" Ende
	 # hier beginnt die Berechnung der Vorkommastellen
	andi	$2, $2, 0xf		# Zahl extrahieren
	mtc1	$2, $2			# lade Integer in FP2
	cvt.s.w	$f2, $f2		# integer -> single 
	cvt.d.s	$f2, $f2		# single -> double
	mul.d	$f0, $f0, $f26		# Speicher * 10
	add.d	$f0, $f0, $f2		# Speicher + neue Einerstelle
	addiu	$17, $17, 1		# nchste Stelle
	j	atof_1
	# hier beginnt die Nachkommastellen-Ermittlung
atof_2:	addiu	$17, $17, 1		# nchste Stelle
	lbu	$2, ($17)		# Zeichen laden
	blt	$2, 0x30, atof_e	# <"0" Ende
	bgt	$2, 0x39, atof_e	# >"9" Ende
	# hier beginnt die Berechnung der Nachkommastellen
	andi	$2, $2, 0xf		# Zahl extrahieren
	mtc1	$2, $2			# lade Integer in FP2
	cvt.s.w	$f2, $f2		# integer -> single
	cvt.d.s	$f2, $f2		# single -> double
	mul.d	$f2, $f2, $f4		# Realwert ermitteln
	add.d	$f0, $f0, $f2		# Nachkommazahl addieren
	mul.d	$f4, $f4, $f28		# Nchste Nachkommastelle
	j	atof_2
atof_e:	beqz	$21, atof_f		# keine negative Zahl
	mul.d	$f0, $f30, $f0		# Multipliziere mit -1
atof_f:	jr	$ra			# RETURN

atof_i:	l.d	$f24, fp_zero
	l.d	$f26, fp_ten
	l.d	$f28, fp_tenth
	l.d	$f30, fp_minus
	jr	$ra
# Fehlermeldungen
# ___________________________________________________________________________
#
err_cont:
	li	$2, 4
	syscall
syntax_error:
	la	$4, er_s1
err_07:	li	$2, 4
	syscall
	move	$4, $16
	syscall				# Source-Line
	subu	$8, $17, $16
	addiu	$8, $8, 1		# $8 = rel. Pos. + 1
	li	$2, 4
	la	$4, space
err05:	addiu	$8, $8, -1
	syscall
	bnez	$8, err05
err06:	la	$4, cursor
	syscall
	addiu	$sp, $sp, 4
	j	mainret
err_4:	la	$4, er_t4
	j	err07
err_8:	la	$4, er_t8
	j	err07
err_9:	la	$4, er_t9
	j	err_cont
err_a:	la	$4, er_ta
	j	err_cont
	.data
# Gleitkommazahlen fr atof_r
fp_zero:	.double	0.0
fp_ten:		.double 10.0
fp_tenth:	.double 0.1
fp_minus:	.double	-1.0
lower_stack:	.space	0x1000
upper_stack:	.word	0,0,0,0
# Hauptprogrammeldungen
start_text:
	.ascii	"\n\n\t\tAbschluarbeit im Fach Assemblerprogrammierung"
	.ascii	"\n\t\t\t  Andreas Westfeld, 92/08/02"
	.ascii	"\n\nTaschenrechnerprogramm mit Vorrangautomatik, Memory, "
	.ascii	"und Klammerung fr\n"
	.ascii	"die vier Grundrechenarten +, -, *, / mit "
	.ascii	"Zahlen in doppelter Genauigkeit.\n"
	.ascii	"Steht ein Operator am Beginn einer Eingabezeile, "
	.ascii	"dann wird als erster\n"
	.ascii	"Operand der Akkumulator AC verwendet.\n"
	.ascii	"\n\tMW schreibt den Akkumulator-Inhalt AC in das Memory M.\n"
	.ascii	"\n\tMR als Operand steht fr den Memory-Inhalt M.\n"
	.ascii	"\n\tQ  beendet das Programm.\n"
	.ascii	"\n\t?  liefert diese Hilfe.\n"
nl:	.asciiz	"\n"
prompt:	.asciiz	"(calc) "
AClabel:.asciiz	"AC = "
Mlabel:	.asciiz	"\tM = "
er_s1:	.asciiz	"*** Syntaktischer Fehler.\n "
space:	.asciiz	" "
cursor:	.asciiz	"^ hier\n"
er_t8:	.asciiz	"Klammerungstiefe zu gro\n"
er_t9:	.asciiz	"vermisse \"Klammer zu\"\n"
er_ta:	.asciiz	"\"Klammer zu\" ohne zugehrige \"Klammer auf\"\n"
er_t4:	.asciiz	"interner Fehler\n"
# Eingabebereich
buffer: .space	0x1000
# ___________________________________________________________________________
