#define SBCERR_NO_CARD              001

#define SBCERR_DEVICE_NOT_READY     100
#define SBCERR_DEVICE_NOT_OPEN      101
#define SBCERR_DEVICE_BUSY          102

#define SBCERR_NO_MEMORY            200
#define SBCERR_INVALID              201
#define SBCERR_BUFSIZE_TOOSMALL     202

#define SBCERR_INVALID_FORMAT       300
#define SBCERR_CREATE_FILE          301
#define SBCERR_OPEN_FILE            302
#define SBCERR_READ_FILE            303
#define SBCERR_WRITE_FILE           304
#define SBCERR_DISK_FULL            305

#define SBM_CALLBACK                01

#define SBM_VOC_FLAG                20
#define SBM_VOC_REPEAT_COUNT        21
#define SBM_VOC_REPEAT_END          22

#define SBM_MUS_FLAG                40

#define SBM_MIDI_IN                 60

#define VP_PLAY_FILEVOC             1
#define VP_RECORD_FILEVOC           2
#define VP_PLAY_MEMVOC              3
#define VP_RECORD_MEMVOC            4
#define VP_PLAY_MEMUNFMT            5
#define VP_RECORD_MEMUNFMT          6

#define MP_PLAY_MEMMIDI             1

WORD  FAR PASCAL sbcGetDLLVersion   (VOID);
LPSTR FAR PASCAL sbcGetCardName     (VOID);
VOID FAR PASCAL sbcTerminateDLL     (VOID);
DWORD FAR PASCAL sbcCallBack        (DWORD);

WORD FAR PASCAL vocOpenDevice(HWND) ;
WORD FAR PASCAL vocCloseDevice(VOID) ;
DWORD FAR PASCAL vocGetDeviceStatus(VOID) ;
WORD FAR PASCAL vocGetMarker(VOID) ;
DWORD FAR PASCAL vocGetRecordCount(VOID) ;

WORD FAR PASCAL vocStopVoice(VOID) ;
WORD FAR PASCAL vocPauseVoice(VOID) ;
WORD FAR PASCAL vocContinueVoice(VOID) ;
WORD FAR PASCAL vocSetVolume(WORD) ;
WORD FAR PASCAL vocSetDacSpeaker(WORD) ;

WORD FAR PASCAL vocBreakLoop(WORD) ;

WORD FAR PASCAL vocPlayFileVocFormat(LPSTR) ;
WORD FAR PASCAL vocPlayFileWavFormat(LPSTR) ;
WORD FAR PASCAL vocRecordFileVocFormat(LPSTR,WORD) ;
WORD FAR PASCAL vocPlayMemVocFormat(LPSTR) ;
WORD FAR PASCAL vocPlayMemWavFormat(LPSTR) ;
WORD FAR PASCAL vocRecordMemVocFormat(LPSTR,WORD,DWORD) ;
WORD FAR PASCAL vocPlayMemUnFormat(LPSTR,WORD,DWORD) ;
WORD FAR PASCAL vocRecordMemUnFormat(LPSTR,WORD,DWORD) ;

WORD FAR PASCAL musOpenDevice(HWND) ;
WORD FAR PASCAL musCloseDevice(VOID) ;
DWORD FAR PASCAL musGetDeviceStatus(VOID) ;
WORD FAR PASCAL musGetMarker(VOID) ;
WORD FAR PASCAL musStopMusic(VOID) ;
WORD FAR PASCAL musPauseMusic(VOID) ;
WORD FAR PASCAL musContinueMusic(VOID) ;
WORD FAR PASCAL musChangeTempo(WORD) ;
WORD FAR PASCAL musTransposeNote(int) ;
WORD FAR PASCAL musFadeMusic(WORD,WORD,WORD,WORD) ;
WORD FAR PASCAL musSetVolume(WORD) ;
WORD FAR PASCAL musPlayMemMidi(LPSTR) ;
WORD FAR PASCAL musTurnOnNote(WORD, WORD, WORD);
WORD FAR PASCAL musTurnOffNote(WORD, WORD, WORD);
WORD FAR PASCAL musChangeProgram (WORD, WORD);

WORD FAR PASCAL midiOpenInputDevice(HWND) ;
WORD FAR PASCAL midiCloseInputDevice(VOID) ;
WORD FAR PASCAL midiOpenOutputDevice(HWND) ;
WORD FAR PASCAL midiCloseOutputDevice(VOID) ;
WORD FAR PASCAL midiStartInput(VOID) ;
WORD FAR PASCAL midiStopInput(VOID) ;
WORD FAR PASCAL midiOutputShortMessage(WORD,WORD,WORD) ;
WORD FAR PASCAL midiOutputLongMessage(LPSTR,WORD) ;

void FAR PASCAL volSetMaster (WORD);
void FAR PASCAL volSetFM     (WORD);
void FAR PASCAL volSetCD     (WORD);
void FAR PASCAL volSetMic    (WORD);
void FAR PASCAL volSetLineIn (WORD);
void FAR PASCAL volSetVoice  (WORD);
WORD FAR PASCAL volGetMaster (VOID);
WORD FAR PASCAL volGetFM     (VOID);
WORD FAR PASCAL volGetCD     (VOID);
WORD FAR PASCAL volGetMic    (VOID);
WORD FAR PASCAL volGetLineIn (VOID);
WORD FAR PASCAL volGetVoice  (VOID);

typedef struct
{
    BYTE      cID[20] ;
    WORD      wDataOffset ;
    WORD      wVersion ;
    WORD      wID ;
} VOCHEADER ;

typedef struct
{
    char    szRIFF[4];
    DWORD   nRIFFSize;
    char    szWAVE[4];
    char    szfmt[4];
    DWORD   nfmtSize;
    WORD    formatTag;
    WORD    nChannels;
    DWORD   nSamplesPerSec;
    DWORD   nAvgBytesPerSec;
    WORD    nBlockAlign;
    WORD    nBitsPerSample;
    char    szdata[4];
    DWORD   ndataSize;
} PCMWAVEFMT ;

