#include <dos.h>
#include <stdio.h>
#include <conio.h>
#include <stdlib.h>

#define byte unsigned char
#define lword unsigned long int

byte ident[45] = {
       0x00,0x01,0x02,0x03,0x04,0x05,0x06,0x07,
       0x08,0x09,0x0A,0x11,0x14,0x16,0x17,0x40,
       0x50,0x51,0x52,0x56,0x61,0x63,0x64,0x75,
       0x80,0x81,0x82,0x83,0x84,0x85,0x86,0x87,
       0x93,0x94,0xB7,0xB8,0xC6,0xC7,0xDB,0xE1,
       0xE3,0xE4,0xF2,0xFE,0xFF };
char *idents[] ={
	 "nicht belegt",
	 "DOS 12-bit FAT",
	 "XENIX root-fs",
	 "XENIX usr-fs (obsolete)",
	 "DOS 16-bit FAT <32M",
	 "DOS 3.3+ ext. part.",
	 "DOS 16-bit FAT >32M",
	"QNX, OS/2 HPFS",
	"AIX bootable part., SplitDrive",
	"AIX data part.",
	"OPUS, Bootmanager OS/2",
	"DOS 12-bit FAT inaktiv ",
	"DOS 16-bit FAT <32M inaktiv ",
	"DOS 16-bit FAT >32M inaktiv ",
	"QNX, OS/2 HPFS inactiv ",
	"Venix 80286",
	"Disk Manager, read-only part.",
	"Disk Manager, r/w part. / Novell?",
	"CP/M / Microport",
	"GoldenBow VFeature",
	"SpeedStor",
	"SysV/386, 386/ix GNU HURD",
	"Novell NetWare",
	"PC/IX",
	"Old MINIX 1.3",
	 "Linux/MINIX 1.5",
	 "Linux swap",
	 "Linux Ext",
	 "TOS/p startbar",
	 "TOS/p swap",
	 "TOS/p data",
	 "TOS/p ext.",
	 "Amoeba",
	 "Amoeba BBT",
	 "BSDI fs",
	 "BSDI swap",
	 "DR-DOS 6.0 LOGIN.EXE-secured part.",
	 "Syrinx",
	 "CP/M",
	 "SpeedStor 12-FAT ext. part. / DOS access",
	 "DOS readonly",
	 "SpeedStor 16-bit FAT ext. part.",
	 "DOS secondary",
	 "LANstep",
	 "Xenix bad block table"};



struct { char bootstrap[0x1be];
       struct {
	  byte boot_ind;
	  byte s_head;
	  byte s_sector;
	  byte s_track;
	  byte system_ind;
	  byte e_head;
	  byte e_sector;
	  byte e_track;
	  lword relsec;
	  lword sec;
	 } entry[4];
	} Buffer;

union  REGS  Regs;      /* Registerstruktur fr DOS und */
struct SREGS SRegs;     /* BIOS-Rufe                    */
int    i;               /* allgemeiner Zhler           */
int    rc;              /* Rckkehrcode                 */
/*-----------------------------------------------------*/
/* Funktionen zum lesen der Partitionstabelle von der  */
/* Festplatte                                          */
/*-----------------------------------------------------*/
int GetPartTab(int lw)/* 0=C:; 1=D: */
{
  Regs.h.ah = 2; /* lesen */
  Regs.h.al = 1; /* Sectoranzahl */
  Regs.h.ch = 0; /* Cylinder */
  Regs.h.cl = 1; /* Sektor */
  Regs.h.dh = 0; /* Kopf */
  Regs.h.dl = lw | 0x80;
  SRegs.es  = FP_SEG(&Buffer);
  Regs.x.bx = FP_OFF(&Buffer);
  int86x(0x013,&Regs,&Regs,&SRegs);
  return Regs.h.ah;
 };
void disppart(int lw)
{  char s[80];
   int i,j;

   if (lw==0)
       printf("\n\n Partitionstabelle Festplatte 0 = C:");
   else printf("\n\n Partitionstabelle Festplatte 1 = D:");
printf("\nĿ");
printf("\nNrS K  S    Z K  S    Z rel Sek  Sek.Anz");
printf("\nĴ");
for (i=0;i<4;i++)
{ printf("\n%2d",i+1);
  if (Buffer.entry[i].boot_ind) printf("*") ; else printf("-");
  printf("%2d %2d %4d",Buffer.entry[i].s_head,
		 Buffer.entry[i].s_sector & 0x3f,
		 (Buffer.entry[i].s_sector >> 6)*256+Buffer.entry[i].s_track);
  printf("%2d %2d %4d",Buffer.entry[i].e_head,
		 Buffer.entry[i].e_sector & 0x3f,
		 (Buffer.entry[i].e_sector >> 6)*256+Buffer.entry[i].e_track);
  printf("%8lu %8lu",Buffer.entry[i].relsec,
		 Buffer.entry[i].sec);


  strcpy(s,"unbekannt");
  j=0;
  while (j<43)
   { if (ident[j]==Buffer.entry[i].system_ind)
       strcpy(s,idents[j]);
     j++;
   };  printf("%2x  %s",Buffer.entry[i].system_ind,s);
  }
printf("\n");
};
/*-----------------------------------------------*/
/*          M A I N P R O C E D U R E            */
/*        ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~          */
/*-----------------------------------------------*/
void main()
{ int j,k,l;
GetPartTab(0);disppart(0);
if (GetPartTab(1)==0) disppart(1);
};